/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.hdmap.DefaultHDLighting;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.HDShaderState;
import org.dynmap.utils.LightLevels;

public class LightLevelHDLighting
extends DefaultHDLighting {
    private final Color[] lightlevelcolors = new Color[16];
    protected final boolean night_and_day;
    private final boolean night;
    private final Color mincolor = new Color(64, 64, 64);
    private final Color maxcolor = new Color(255, 255, 255);

    public LightLevelHDLighting(DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        this.grayscale = true;
        this.blackandwhite = false;
        for (int i = 0; i < 16; ++i) {
            this.lightlevelcolors[i] = configuration.getColor("color" + i, null);
        }
        this.night = configuration.getBoolean("night", false);
        this.night_and_day = configuration.getBoolean("night-and-day", false);
    }

    @Override
    public void applyLighting(HDPerspectiveState ps, HDShaderState ss, Color incolor, Color[] outcolor) {
        super.applyLighting(ps, ss, incolor, outcolor);
        LightLevels ll = ps.getCachedLightLevels(0);
        ps.getLightLevels(ll);
        if (outcolor.length == 1) {
            int lightlevel;
            outcolor[0].scaleColor(this.mincolor, this.maxcolor);
            int n = lightlevel = this.night ? ll.emitted : Math.max(ll.sky, ll.emitted);
            if (this.lightlevelcolors[lightlevel] != null) {
                outcolor[0].blendColor(this.lightlevelcolors[lightlevel]);
            }
        } else {
            outcolor[0].scaleColor(this.mincolor, this.maxcolor);
            outcolor[1].scaleColor(this.mincolor, this.maxcolor);
            int daylightlevel = Math.max(ll.sky, ll.emitted);
            if (this.lightlevelcolors[ll.emitted] != null) {
                outcolor[0].blendColor(this.lightlevelcolors[ll.emitted]);
            }
            if (this.lightlevelcolors[daylightlevel] != null) {
                outcolor[1].blendColor(this.lightlevelcolors[daylightlevel]);
            }
        }
    }

    @Override
    public boolean isNightAndDayEnabled() {
        return this.night_and_day;
    }

    @Override
    public boolean isSkyLightLevelNeeded() {
        return true;
    }

    @Override
    public boolean isEmittedLightLevelNeeded() {
        return true;
    }

    @Override
    public int[] getBrightnessTable(DynmapWorld world) {
        return null;
    }
}

