/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.permissions;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.dynmap.Log;
import org.dynmap.bukkit.permissions.PermissionProvider;

public class LuckPerms5Permissions
implements PermissionProvider {
    String name;
    LuckPerms luckPerms;

    public static LuckPerms5Permissions create(Server server, String name) {
        try {
            Class.forName("net.luckperms.api.LuckPerms");
        }
        catch (ClassNotFoundException cnfx) {
            return null;
        }
        if (!server.getPluginManager().isPluginEnabled("LuckPerms")) {
            return null;
        }
        LuckPerms luckPerms = (LuckPerms)server.getServicesManager().load(LuckPerms.class);
        if (luckPerms == null) {
            return null;
        }
        Log.info("Using LuckPerms " + luckPerms.getPluginMetadata().getVersion() + " for access control");
        return new LuckPerms5Permissions(name, luckPerms);
    }

    public LuckPerms5Permissions(String name, LuckPerms luckPerms) {
        this.name = name;
        this.luckPerms = luckPerms;
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        return sender.hasPermission(this.name + "." + permission);
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        HashSet<String> result = new HashSet<String>();
        CachedPermissionData user = this.getUser(player);
        if (user != null) {
            for (String p : perms) {
                if (!user.checkPermission(this.name + "." + p).asBoolean()) continue;
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        CachedPermissionData user = this.getUser(player);
        if (user == null) {
            return false;
        }
        return user.checkPermission(this.name + "." + perm).asBoolean();
    }

    private CachedPermissionData getUser(String username) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)username);
        UUID uuid = offlinePlayer != null && offlinePlayer.getUniqueId() != null ? offlinePlayer.getUniqueId() : (UUID)LuckPerms5Permissions.joinFuture(this.luckPerms.getUserManager().lookupUniqueId(username));
        if (uuid == null) {
            return null;
        }
        User user = this.luckPerms.getUserManager().getUser(uuid);
        if (user == null) {
            LuckPerms5Permissions.joinFuture(this.luckPerms.getUserManager().loadUser(uuid));
            user = this.luckPerms.getUserManager().getUser(uuid);
        }
        if (user == null) {
            return null;
        }
        CachedDataManager data = user.getCachedData();
        return this.luckPerms.getContextManager().getQueryOptions(user).map(queryOptions -> data.getPermissionData(queryOptions)).orElse(null);
    }

    private static <T> T joinFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

