/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dynmap.bukkit.helper.AbstractMapChunkCache;
import org.dynmap.utils.DynIntHashMap;

public class SnapshotCache {
    public static SnapshotCache sscache;
    private CacheHashMap snapcache;
    private ReferenceQueue<SnapshotRec> refqueue;
    private long cache_attempts;
    private long cache_success;
    private boolean softref;

    public SnapshotCache(int max_size, boolean softref) {
        this.snapcache = new CacheHashMap(max_size);
        this.refqueue = new ReferenceQueue();
        this.softref = softref;
    }

    private String getKey(String w, int cx, int cz) {
        return w + ":" + cx + ":" + cz;
    }

    public void invalidateSnapshot(String w, int x, int y, int z) {
        String key = this.getKey(w, x >> 4, z >> 4);
        CacheRec rec = (CacheRec)this.snapcache.remove(key);
        if (rec != null) {
            this.snapcache.reverselookup.remove(rec.ref);
            rec.ref.clear();
        }
    }

    public void invalidateSnapshot(String w, int x0, int y0, int z0, int x1, int y1, int z1) {
        for (int xx = x0 >> 4; xx <= x1 >> 4; ++xx) {
            for (int zz = z0 >> 4; zz <= z1 >> 4; ++zz) {
                String key = this.getKey(w, xx, zz);
                CacheRec rec = (CacheRec)this.snapcache.remove(key);
                if (rec == null) continue;
                this.snapcache.reverselookup.remove(rec.ref);
                rec.ref.clear();
            }
        }
    }

    public SnapshotRec getSnapshot(String w, int chunkx, int chunkz, boolean blockdata, boolean biome, boolean biomeraw, boolean highesty) {
        String key = this.getKey(w, chunkx, chunkz);
        this.processRefQueue();
        SnapshotRec ss = null;
        CacheRec rec = (CacheRec)this.snapcache.get(key);
        if (rec != null && (ss = rec.ref.get()) == null) {
            this.snapcache.reverselookup.remove(rec.ref);
            this.snapcache.remove(key);
        }
        if (ss != null && (blockdata && !rec.hasblockdata || biome && !rec.hasbiome || biomeraw && !rec.hasrawbiome || highesty && !rec.hashighesty)) {
            ss = null;
        }
        ++this.cache_attempts;
        if (ss != null) {
            ++this.cache_success;
        }
        return ss;
    }

    public void putSnapshot(String w, int chunkx, int chunkz, SnapshotRec ss, boolean blockdata, boolean biome, boolean biomeraw, boolean highesty) {
        String key = this.getKey(w, chunkx, chunkz);
        this.processRefQueue();
        CacheRec rec = new CacheRec();
        rec.hasblockdata = blockdata;
        rec.hasbiome = biome;
        rec.hasrawbiome = biomeraw;
        rec.hashighesty = highesty;
        rec.ref = this.softref ? new SoftReference<SnapshotRec>(ss, this.refqueue) : new WeakReference<SnapshotRec>(ss, this.refqueue);
        CacheRec prevrec = this.snapcache.put(key, rec);
        if (prevrec != null) {
            this.snapcache.reverselookup.remove(prevrec.ref);
        }
        this.snapcache.reverselookup.put(rec.ref, key);
    }

    private void processRefQueue() {
        Reference<SnapshotRec> ref;
        while ((ref = this.refqueue.poll()) != null) {
            String k = (String)this.snapcache.reverselookup.remove(ref);
            if (k == null) continue;
            this.snapcache.remove(k);
        }
    }

    public double getHitRate() {
        if (this.cache_attempts > 0L) {
            return 100.0 * (double)this.cache_success / (double)this.cache_attempts;
        }
        return 0.0;
    }

    public void resetStats() {
        this.cache_success = 0L;
        this.cache_attempts = 0L;
    }

    public void cleanup() {
        if (this.snapcache != null) {
            this.snapcache.clear();
            this.snapcache.reverselookup.clear();
            this.snapcache.reverselookup = null;
            this.snapcache = null;
        }
    }

    public class CacheHashMap
    extends LinkedHashMap<String, CacheRec> {
        private int limit;
        private IdentityHashMap<Reference<SnapshotRec>, String> reverselookup;

        public CacheHashMap(int lim) {
            super(16, 0.75f, true);
            this.limit = lim;
            this.reverselookup = new IdentityHashMap();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CacheRec> last) {
            boolean remove;
            boolean bl = remove = this.size() >= this.limit;
            if (remove) {
                this.reverselookup.remove(last.getValue().ref);
            }
            return remove;
        }
    }

    private static class CacheRec {
        Reference<SnapshotRec> ref;
        boolean hasbiome;
        boolean hasrawbiome;
        boolean hasblockdata;
        boolean hashighesty;

        private CacheRec() {
        }
    }

    public static class SnapshotRec {
        public AbstractMapChunkCache.Snapshot ss;
        public long inhabitedTicks;
        public DynIntHashMap tileData;
    }
}

