/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.dynmap.DynmapChunk;
import org.dynmap.bukkit.helper.BukkitMaterial;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.MapChunkCacheClassic;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public abstract class BukkitVersionHelper {
    public static BukkitVersionHelper helper = null;
    public static GenericChunkCache gencache;
    public static DynmapBlockState[] stateByID;

    protected boolean isBlockIdNeeded() {
        return true;
    }

    protected boolean isBiomeBaseListNeeded() {
        return true;
    }

    protected BukkitVersionHelper() {
    }

    public abstract Object[] getBiomeBaseList();

    public abstract float getBiomeBaseTemperature(Object var1);

    public abstract float getBiomeBaseHumidity(Object var1);

    public abstract String getBiomeBaseIDString(Object var1);

    public String getBiomeBaseResourceLocsation(Object bb) {
        return null;
    }

    public abstract int getBiomeBaseID(Object var1);

    public abstract Object getUnloadQueue(World var1);

    public abstract boolean isInUnloadQueue(Object var1, int var2, int var3);

    public abstract Object[] getBiomeBaseFromSnapshot(ChunkSnapshot var1);

    public abstract long getInhabitedTicks(Chunk var1);

    public abstract Map<?, ?> getTileEntitiesForChunk(Chunk var1);

    public abstract int getTileEntityX(Object var1);

    public abstract int getTileEntityY(Object var1);

    public abstract int getTileEntityZ(Object var1);

    public abstract Object readTileEntityNBT(Object var1);

    public abstract Object getFieldValue(Object var1, String var2);

    public abstract void unloadChunkNoSave(World var1, Chunk var2, int var3, int var4);

    public abstract String[] getBlockNames();

    public abstract String[] getBiomeNames();

    public abstract Player[] getOnlinePlayers();

    public abstract double getHealth(Player var1);

    public Polygon getWorldBorder(World world) {
        return null;
    }

    public int getWorldMinY(World world) {
        return 0;
    }

    public boolean isUnloadChunkBroken() {
        return false;
    }

    public String getSkinURL(Player player) {
        return null;
    }

    public abstract BukkitMaterial[] getMaterialList();

    public void initializeBlockStates() {
        String[] blkname = this.getBlockNames();
        BukkitMaterial[] blkmat = this.getMaterialList();
        stateByID = new DynmapBlockState[16 * blkname.length];
        Arrays.fill(stateByID, DynmapBlockState.AIR);
        for (int i = 0; i < blkname.length; ++i) {
            if (blkname[i] == null) continue;
            String bn = blkname[i];
            if (bn.indexOf(58) < 0) {
                bn = "minecraft:" + bn;
            }
            if (bn.equals(DynmapBlockState.AIR_BLOCK)) continue;
            BukkitMaterial mat = blkmat[i];
            DynmapBlockState basebs = null;
            for (int m = 0; m < 16; ++m) {
                String sn = helper.getStateStringByCombinedId(i, m);
                DynmapBlockState bs = new DynmapBlockState(basebs, m, bn, sn, mat.name, i);
                if (basebs == null) {
                    basebs = bs;
                }
                BukkitVersionHelper.stateByID[(i << 4) + m] = bs;
                if (mat == null) continue;
                if (mat.name.equals("AIR")) {
                    bs.setAir();
                }
                if (mat.name.equals("LEAVES")) {
                    bs.setLeaves();
                }
                if (mat.name.equals("WOOD")) {
                    bs.setLog();
                }
                if (!mat.isSolid) continue;
                bs.setSolid();
            }
        }
    }

    public MapChunkCache getChunkCache(BukkitWorld dw, List<DynmapChunk> chunks) {
        MapChunkCacheClassic c = new MapChunkCacheClassic();
        c.setChunks(dw, chunks);
        return c;
    }

    public Object[] getBlockIDFieldFromSnapshot(ChunkSnapshot css) {
        return null;
    }

    public int getBiomeBaseWaterMult(Object bb) {
        return -1;
    }

    public abstract String getStateStringByCombinedId(int var1, int var2);

    public void sendTitleText(Player p, String title, String subtitle, int fadeInTicks, int stayTicks, int fadeOutTIcks) {
        if (p != null) {
            if (title != null) {
                p.sendMessage(title);
            }
            if (subtitle != null) {
                p.sendMessage(subtitle);
            }
        }
    }

    public boolean useGenericCache() {
        return false;
    }
}

