/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import org.dynmap.Log;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.ModelBlockModel;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.Vector3D;

public class PatchDefinition
implements RenderPatch {
    public double x0;
    public double y0;
    public double z0;
    public double xu;
    public double yu;
    public double zu;
    public double xv;
    public double yv;
    public double zv;
    public double umin;
    public double umax;
    public double vmin;
    public double vmax;
    public double vmaxatumax;
    public double vminatumax;
    public Vector3D u;
    public Vector3D v;
    public RenderPatchFactory.SideVisible sidevis;
    public int textureindex;
    public BlockStep step;
    public boolean shade;
    private int hc;
    private static final Vector3D offsetCenter = new Vector3D(0.5, 0.5, 0.5);

    PatchDefinition() {
        this.z0 = 0.0;
        this.y0 = 0.0;
        this.x0 = 0.0;
        this.zu = 0.0;
        this.xu = 0.0;
        this.yu = 1.0;
        this.zv = 0.0;
        this.yv = 0.0;
        this.xv = 1.0;
        this.vmin = 0.0;
        this.umin = 0.0;
        this.vmax = 1.0;
        this.umax = 1.0;
        this.vmaxatumax = 1.0;
        this.vminatumax = 0.0;
        this.u = new Vector3D();
        this.v = new Vector3D();
        this.sidevis = RenderPatchFactory.SideVisible.BOTH;
        this.textureindex = 0;
        this.shade = true;
        this.update();
    }

    PatchDefinition(PatchDefinition pd) {
        this.x0 = pd.x0;
        this.y0 = pd.y0;
        this.z0 = pd.z0;
        this.xu = pd.xu;
        this.yu = pd.yu;
        this.zu = pd.zu;
        this.xv = pd.xv;
        this.yv = pd.yv;
        this.zv = pd.zv;
        this.umin = pd.umin;
        this.vmin = pd.vmin;
        this.umax = pd.umax;
        this.vmax = pd.vmax;
        this.vmaxatumax = pd.vmaxatumax;
        this.vminatumax = pd.vminatumax;
        this.u = new Vector3D(pd.u);
        this.v = new Vector3D(pd.v);
        this.sidevis = pd.sidevis;
        this.textureindex = pd.textureindex;
        this.step = pd.step;
        this.shade = pd.shade;
        this.hc = pd.hc;
    }

    PatchDefinition(PatchDefinition orig, double rotatex, double rotatey, double rotatez, int textureindex) {
        this(orig, rotatex, rotatey, rotatez, null, textureindex);
    }

    PatchDefinition(PatchDefinition orig, double rotatex, double rotatey, double rotatez, Vector3D rotorigin, int textureindex) {
        if (rotorigin == null) {
            rotorigin = offsetCenter;
        }
        Vector3D vec = new Vector3D(orig.x0, orig.y0, orig.z0);
        this.rotate(vec, rotatex, rotatey, rotatez, rotorigin);
        this.x0 = vec.x;
        this.y0 = vec.y;
        this.z0 = vec.z;
        vec.x = orig.xu;
        vec.y = orig.yu;
        vec.z = orig.zu;
        this.rotate(vec, rotatex, rotatey, rotatez, rotorigin);
        this.xu = vec.x;
        this.yu = vec.y;
        this.zu = vec.z;
        vec.x = orig.xv;
        vec.y = orig.yv;
        vec.z = orig.zv;
        this.rotate(vec, rotatex, rotatey, rotatez, rotorigin);
        this.xv = vec.x;
        this.yv = vec.y;
        this.zv = vec.z;
        this.umin = orig.umin;
        this.vmin = orig.vmin;
        this.umax = orig.umax;
        this.vmax = orig.vmax;
        this.vmaxatumax = orig.vmaxatumax;
        this.vminatumax = orig.vminatumax;
        this.sidevis = orig.sidevis;
        this.shade = orig.shade;
        this.textureindex = textureindex < 0 ? orig.textureindex : textureindex;
        this.u = new Vector3D();
        this.v = new Vector3D();
        this.update();
    }

    private void rotate(Vector3D vec, double xcnt, double ycnt, double zcnt, Vector3D origin) {
        if (xcnt == 0.0 && ycnt == 0.0 && zcnt == 0.0) {
            return;
        }
        vec.subtract(origin);
        double rot = Math.toRadians(xcnt);
        double nval = vec.z * Math.sin(rot) + vec.y * Math.cos(rot);
        vec.z = vec.z * Math.cos(rot) - vec.y * Math.sin(rot);
        vec.y = nval;
        rot = Math.toRadians(ycnt);
        nval = vec.x * Math.cos(rot) - vec.z * Math.sin(rot);
        vec.z = vec.x * Math.sin(rot) + vec.z * Math.cos(rot);
        vec.x = nval;
        rot = Math.toRadians(zcnt);
        nval = vec.y * Math.sin(rot) + vec.x * Math.cos(rot);
        vec.y = vec.y * Math.cos(rot) - vec.x * Math.sin(rot);
        vec.x = nval;
        vec.add(origin);
    }

    public void update(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, RenderPatchFactory.SideVisible sidevis, int textureids, double vminatumax, double vmaxatumax) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.xu = xu;
        this.yu = yu;
        this.zu = zu;
        this.xv = xv;
        this.yv = yv;
        this.zv = zv;
        this.umin = umin;
        this.umax = umax;
        this.vmin = vmin;
        this.vmax = vmax;
        this.vmaxatumax = vmaxatumax;
        this.vminatumax = vminatumax;
        this.sidevis = sidevis;
        this.textureindex = textureids;
        this.update();
    }

    public void update() {
        this.u.x = this.xu - this.x0;
        this.u.y = this.yu - this.y0;
        this.u.z = this.zu - this.z0;
        this.v.x = this.xv - this.x0;
        this.v.y = this.yv - this.y0;
        this.v.z = this.zv - this.z0;
        this.hc = (int)(Double.doubleToLongBits(this.x0 + this.xu + this.xv) >> 32 ^ Double.doubleToLongBits(this.y0 + this.yu + this.yv) >> 34 ^ Double.doubleToLongBits(this.z0 + this.yu + this.yv) >> 36 ^ Double.doubleToLongBits(this.umin + this.umax + this.vmin + this.vmax + this.vmaxatumax) >> 38) ^ this.sidevis.ordinal() << 8 ^ this.textureindex;
        double crossx = this.u.y * this.v.z - this.u.z * this.v.y;
        double crossy = this.u.z * this.v.x - this.u.x * this.v.z;
        double crossz = this.u.x * this.v.y - this.u.y * this.v.x;
        this.step = Math.abs(crossx) > Math.abs(crossy) * 0.9 ? (Math.abs(crossx) > Math.abs(crossz) ? (crossx > 0.0 ? BlockStep.X_PLUS : BlockStep.X_MINUS) : (crossz > 0.0 ? BlockStep.Z_PLUS : BlockStep.Z_MINUS)) : (Math.abs(crossy) * 0.9 > Math.abs(crossz) ? (crossy > 0.0 ? BlockStep.Y_PLUS : BlockStep.Y_MINUS) : (crossz > 0.0 ? BlockStep.Z_PLUS : BlockStep.Z_MINUS));
    }

    private boolean outOfRange(double v) {
        return v < -1.0 || v > 2.0;
    }

    public boolean validate() {
        boolean good = true;
        double xx0 = this.x0 + (this.xu - this.x0) * this.umin + (this.xv - this.x0) * this.vmin;
        double xx1 = this.x0 + (this.xu - this.x0) * this.vmin + (this.xv - this.x0) * this.vmax;
        double xx2 = this.x0 + (this.xu - this.x0) * this.umax + (this.xv - this.x0) * this.vmin;
        double xx3 = this.x0 + (this.xu - this.x0) * this.vmax + (this.xv - this.x0) * this.vmax;
        if (this.outOfRange(xx0) || this.outOfRange(xx1) || this.outOfRange(xx2) || this.outOfRange(xx3)) {
            Log.verboseinfo(String.format("Invalid visible range xu=[%f:%f], xv=[%f:%f]", xx0, xx2, xx1, xx3));
            good = false;
        }
        double yy0 = this.y0 + (this.yu - this.y0) * this.umin + (this.yv - this.y0) * this.vmin;
        double yy1 = this.y0 + (this.yu - this.y0) * this.vmin + (this.yv - this.y0) * this.vmax;
        double yy2 = this.y0 + (this.yu - this.y0) * this.umax + (this.yv - this.y0) * this.vmin;
        double yy3 = this.y0 + (this.yu - this.y0) * this.vmax + (this.yv - this.y0) * this.vmax;
        if (this.outOfRange(yy0) || this.outOfRange(yy1) || this.outOfRange(yy2) || this.outOfRange(yy3)) {
            Log.verboseinfo(String.format("Invalid visible range yu=[%f:%f], yv=[%f:%f]", yy0, yy2, yy1, yy3));
            good = false;
        }
        double zz0 = this.z0 + (this.zu - this.z0) * this.umin + (this.zv - this.z0) * this.vmin;
        double zz1 = this.z0 + (this.zu - this.z0) * this.vmin + (this.zv - this.z0) * this.vmax;
        double zz2 = this.z0 + (this.zu - this.z0) * this.umax + (this.zv - this.z0) * this.vmin;
        double zz3 = this.z0 + (this.zu - this.z0) * this.vmax + (this.zv - this.z0) * this.vmax;
        if (this.outOfRange(zz0) || this.outOfRange(zz1) || this.outOfRange(zz2) || this.outOfRange(zz3)) {
            Log.verboseinfo(String.format("Invalid visible range zu=[%f:%f], zv=[%f:%f]", zz0, zz2, zz1, zz3));
            good = false;
        }
        if (!good) {
            Log.verboseinfo("Bad patch: " + this);
        }
        return good;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PatchDefinition) {
            PatchDefinition p = (PatchDefinition)o;
            if (this.hc == p.hc && this.textureindex == p.textureindex && this.x0 == p.x0 && this.y0 == p.y0 && this.z0 == p.z0 && this.xu == p.xu && this.yu == p.yu && this.zu == p.zu && this.xv == p.xv && this.yv == p.yv && this.zv == p.zv && this.umin == p.umin && this.umax == p.umax && this.vmin == p.vmin && this.vmax == p.vmax && this.vmaxatumax == p.vmaxatumax && this.vminatumax == p.vminatumax && this.sidevis == p.sidevis && this.shade == p.shade) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hc;
    }

    @Override
    public int getTextureIndex() {
        return this.textureindex;
    }

    public String toString() {
        return String.format("xyz0=%f/%f/%f,xyzU=%f/%f/%f,xyzV=%f/%f/%f,minU=%f,maxU=%f,vMin=%f/%f,vmax=%f/%f,side=%s,txtidx=%d,shade=%b", new Object[]{this.x0, this.y0, this.z0, this.xu, this.yu, this.zu, this.xv, this.yv, this.zv, this.umin, this.umax, this.vmin, this.vminatumax, this.vmax, this.vmaxatumax, this.sidevis, this.textureindex, this.shade});
    }

    public void updateModelFace(double[] from, double[] to, BlockSide face, double[] uv, ModelBlockModel.SideRotation rot, boolean shade, int textureid) {
        Vector3D save;
        Vector3D upright;
        Vector3D upleft;
        Vector3D lowright;
        Vector3D lowleft;
        if (rot == null) {
            rot = ModelBlockModel.SideRotation.DEG0;
        }
        this.shade = shade;
        double[] patchuv = null;
        boolean flipU = false;
        boolean flipV = false;
        if (uv != null) {
            double[] dArray = new double[]{uv[0] / 16.0, 1.0 - uv[3] / 16.0, uv[2] / 16.0, 1.0 - uv[1] / 16.0};
            patchuv = dArray;
            if (patchuv[0] > patchuv[2]) {
                flipU = true;
                patchuv[0] = 1.0 - patchuv[0];
                patchuv[2] = 1.0 - patchuv[2];
            }
            if (patchuv[1] > patchuv[3]) {
                flipV = true;
                patchuv[1] = 1.0 - patchuv[1];
                patchuv[3] = 1.0 - patchuv[3];
            }
        }
        switch (face) {
            case BOTTOM: 
            case FACE_0: 
            case Y_MINUS: {
                lowleft = new Vector3D(from[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                lowright = new Vector3D(to[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                upleft = new Vector3D(from[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                upright = new Vector3D(to[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{from[0] / 16.0, from[2] / 16.0, to[0] / 16.0, to[2] / 16.0};
                break;
            }
            case TOP: 
            case FACE_1: 
            case Y_PLUS: {
                lowleft = new Vector3D(from[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                lowright = new Vector3D(to[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                upleft = new Vector3D(from[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                upright = new Vector3D(to[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{from[0] / 16.0, 1.0 - to[2] / 16.0, to[0] / 16.0, 1.0 - from[2] / 16.0};
                break;
            }
            case NORTH: 
            case FACE_2: 
            case Z_MINUS: {
                lowleft = new Vector3D(to[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                lowright = new Vector3D(from[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                upleft = new Vector3D(to[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                upright = new Vector3D(from[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{1.0 - to[0] / 16.0, from[1] / 16.0, 1.0 - from[0] / 16.0, to[1] / 16.0};
                break;
            }
            case SOUTH: 
            case FACE_3: 
            case Z_PLUS: {
                lowleft = new Vector3D(from[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                lowright = new Vector3D(to[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                upleft = new Vector3D(from[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                upright = new Vector3D(to[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{from[0] / 16.0, from[1] / 16.0, to[0] / 16.0, to[1] / 16.0};
                break;
            }
            case WEST: 
            case FACE_4: 
            case X_MINUS: {
                lowleft = new Vector3D(from[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                lowright = new Vector3D(from[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                upleft = new Vector3D(from[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                upright = new Vector3D(from[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{from[2] / 16.0, from[1] / 16.0, to[2] / 16.0, to[1] / 16.0};
                break;
            }
            case EAST: 
            case FACE_5: 
            case X_PLUS: {
                lowleft = new Vector3D(to[0] / 16.0, from[1] / 16.0, to[2] / 16.0);
                lowright = new Vector3D(to[0] / 16.0, from[1] / 16.0, from[2] / 16.0);
                upleft = new Vector3D(to[0] / 16.0, to[1] / 16.0, to[2] / 16.0);
                upright = new Vector3D(to[0] / 16.0, to[1] / 16.0, from[2] / 16.0);
                if (patchuv != null) break;
                patchuv = new double[]{1.0 - to[2] / 16.0, from[1] / 16.0, 1.0 - from[2] / 16.0, to[1] / 16.0};
                break;
            }
            default: {
                Log.severe("Invalid side: " + (Object)((Object)face));
                return;
            }
        }
        if (patchuv[0] < 0.0) {
            patchuv[2] = patchuv[2] - patchuv[0];
            patchuv[0] = 0.0;
        }
        if (patchuv[1] < 0.0) {
            patchuv[3] = patchuv[3] - patchuv[1];
            patchuv[1] = 0.0;
        }
        if (patchuv[2] > 1.0) {
            patchuv[0] = patchuv[0] - (patchuv[2] - 1.0);
            patchuv[2] = 1.0;
        }
        if (patchuv[3] > 1.0) {
            patchuv[1] = patchuv[1] - (patchuv[3] - 1.0);
            patchuv[3] = 1.0;
        }
        if (rot == ModelBlockModel.SideRotation.DEG270) {
            save = lowleft;
            lowleft = lowright;
            lowright = upright;
            upright = upleft;
            upleft = save;
        } else if (rot == ModelBlockModel.SideRotation.DEG180) {
            save = lowleft;
            lowleft = upright;
            upright = save;
            save = lowright;
            lowright = upleft;
            upleft = save;
        } else if (rot == ModelBlockModel.SideRotation.DEG90) {
            save = lowright;
            lowright = lowleft;
            lowleft = upleft;
            upleft = upright;
            upright = save;
        }
        Vector3D txtorig = new Vector3D();
        Vector3D txtU = new Vector3D();
        Vector3D txtV = new Vector3D();
        Vector3D wrk = new Vector3D();
        if (patchuv[0] != patchuv[2] && patchuv[1] != patchuv[3]) {
            double du = patchuv[2] - patchuv[0];
            txtU.set(lowright).subtract(lowleft);
            double uScale = txtU.length() / du;
            txtU.scale(uScale / txtU.length());
            double dv = patchuv[3] - patchuv[1];
            txtV.set(upleft).subtract(lowleft);
            double vScale = txtV.length() / dv;
            txtV.scale(vScale / txtV.length());
            txtorig.set(txtU).scale(-patchuv[0]).add(lowleft);
            wrk.set(txtV).scale(-patchuv[1]);
            txtorig.add(wrk);
            txtU.add(txtorig);
            txtV.add(txtorig);
        }
        this.update(txtorig.x, txtorig.y, txtorig.z, txtU.x, txtU.y, txtU.z, txtV.x, txtV.y, txtV.z, patchuv[0], patchuv[2], patchuv[1], patchuv[3], flipU ? (flipV ? RenderPatchFactory.SideVisible.TOPFLIPHV : RenderPatchFactory.SideVisible.TOPFLIP) : (flipV ? RenderPatchFactory.SideVisible.TOPFLIPV : RenderPatchFactory.SideVisible.TOP), textureid, patchuv[1], patchuv[3]);
    }
}

