/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.response;

import java.util.Objects;

public class Owner {
    private final String displayName;
    private final String id;

    private Owner(Builder builder) {
        this.displayName = builder.displayName;
        this.id = builder.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Owner that = (Owner)obj;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.displayName, this.id);
    }

    public String toString() {
        return "Owner{displayName='" + this.displayName + '\'' + ", id='" + this.id + '\'' + '}';
    }

    public static class Builder {
        private String displayName;
        private String id;

        private Builder() {
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Owner build() {
            return new Owner(this);
        }
    }
}

