/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.http.apache;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dynmap.s3lite.http.spi.HttpStatus;
import org.dynmap.s3lite.http.spi.IOUtils;
import org.dynmap.s3lite.http.spi.SdkHttpClient;
import org.dynmap.s3lite.http.spi.request.ImmutableRequest;
import org.dynmap.s3lite.http.spi.request.RequestBody;
import org.dynmap.s3lite.http.spi.response.ImmutableResponse;

public class ApacheSdkHttpClient
implements SdkHttpClient {
    private final CloseableHttpClient httpClient;

    private ApacheSdkHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static ApacheSdkHttpClient defaultClient() {
        return new ApacheSdkHttpClient(HttpClients.createDefault());
    }

    public static ApacheSdkHttpClient customClient(CloseableHttpClient httpClient) {
        return new ApacheSdkHttpClient(httpClient);
    }

    @Override
    public ImmutableResponse apply(ImmutableRequest request) {
        switch (request.getHttpMethod()) {
            case GET: {
                return this.doGet(request);
            }
            case PUT: {
                return this.doPut(request);
            }
            case DELETE: {
                return this.doDelete(request);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)request.getHttpMethod()) + " not yet supported");
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private ImmutableResponse doGet(ImmutableRequest request) {
        try {
            URI uri = ApacheSdkHttpClient.getUri(request);
            HttpGet httpGet = new HttpGet(uri);
            ApacheSdkHttpClient.addHeaders(request.getHeaders(), (HttpMessage)httpGet);
            return this.retrieve(httpGet);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableResponse doPut(ImmutableRequest request) {
        try {
            URI uri = ApacheSdkHttpClient.getUri(request);
            HttpPut httpPut = new HttpPut(uri);
            ApacheSdkHttpClient.addHeaders(request.getHeaders(), (HttpMessage)httpPut);
            request.getRequestBody().map(RequestBody::getContentStreamProvider).ifPresent(supplier -> {
                try (InputStream input = (InputStream)supplier.get();){
                    byte[] bytes = IOUtils.toByteArray(input);
                    ByteArrayEntity entity = new ByteArrayEntity(bytes);
                    httpPut.setEntity((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return this.retrieve(httpPut);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableResponse doDelete(ImmutableRequest request) {
        try {
            URI uri = ApacheSdkHttpClient.getUri(request);
            HttpDelete httpDelete = new HttpDelete(uri);
            ApacheSdkHttpClient.addHeaders(request.getHeaders(), (HttpMessage)httpDelete);
            return this.retrieve(httpDelete);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableResponse retrieve(HttpUriRequest request) {
        try {
            CloseableHttpResponse response = this.httpClient.execute(request);
            HttpEntity entity = response.getEntity();
            InputStream responseBody = entity != null ? entity.getContent() : null;
            int statusCode = response.getStatusLine().getStatusCode();
            return ImmutableResponse.builder().status(HttpStatus.fromStatusCode(statusCode)).headers(ApacheSdkHttpClient.fromHeaders(response.getAllHeaders())).responseBody(responseBody).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static URI getUri(ImmutableRequest request) throws URISyntaxException {
        Map<String, List<String>> parameters = request.getParameters();
        URIBuilder builder = new URIBuilder(request.getEndpoint()).setPath(request.getResourcePath());
        if (!parameters.isEmpty()) {
            for (Map.Entry<String, List<String>> p : parameters.entrySet()) {
                for (String v : p.getValue()) {
                    builder.addParameter(p.getKey(), v);
                }
            }
        }
        return builder.build();
    }

    private static void addHeaders(Map<String, List<String>> headers, HttpMessage request) {
        headers.forEach((name, value) -> request.addHeader(name, String.join((CharSequence)",", value)));
    }

    private static Map<String, List<String>> fromHeaders(Header[] headers) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        Stream.of(headers).forEach(header -> ret.computeIfAbsent(header.getName(), x -> new ArrayList()).add(header.getValue()));
        return ret;
    }
}

