/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.unmarshal;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.dynmap.s3lite.api.response.GetObjectResponse;
import org.dynmap.s3lite.core.unmarshal.SdkResponseUnmarshaller;
import org.dynmap.s3lite.core.unmarshal.UnmarshallerUtils;

public class GetObjectResponseUnmarshaller
implements SdkResponseUnmarshaller<GetObjectResponse> {
    @Override
    public GetObjectResponse apply(Map<String, List<String>> headers) {
        String acceptRanges = UnmarshallerUtils.getHeaderOrNull(headers, "Accept-Ranges");
        String cacheControl = UnmarshallerUtils.getHeaderOrNull(headers, "Cache-Control");
        String contentDisposition = UnmarshallerUtils.getHeaderOrNull(headers, "Content-Disposition");
        String contentEncoding = UnmarshallerUtils.getHeaderOrNull(headers, "Content-Encoding");
        String contentLanguage = UnmarshallerUtils.getHeaderOrNull(headers, "Content-Language");
        Long contentLength = UnmarshallerUtils.getHeader(headers, "Content-Length").map(Long::parseLong).orElse(null);
        String contentRange = UnmarshallerUtils.getHeaderOrNull(headers, "Content-Range");
        String contentType = UnmarshallerUtils.getHeaderOrNull(headers, "Content-Type");
        Boolean deleteMarker = UnmarshallerUtils.getHeader(headers, "x-amz-delete-marker").map(Boolean::parseBoolean).orElse(false);
        String eTag = UnmarshallerUtils.getHeaderOrNull(headers, "ETag");
        String expiration = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-expiration");
        Instant expires = UnmarshallerUtils.getHeader(headers, "Expires").map(e -> UnmarshallerUtils.parseDate(e, UnmarshallerUtils.RFC_1123_DATE_TIME_FORMATTER)).orElse(null);
        Instant lastModified = UnmarshallerUtils.getHeader(headers, "Last-Modified").map(e -> UnmarshallerUtils.parseDate(e, UnmarshallerUtils.RFC_1123_DATE_TIME_FORMATTER)).orElse(null);
        Map<String, String> metadata = UnmarshallerUtils.getMetadata(headers);
        Integer missingMeta = UnmarshallerUtils.getHeader(headers, "x-amz-missing-meta").map(Integer::parseInt).orElse(null);
        String objectLockLegalHoldStatus = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-object-lock-legal-hold");
        String objectLockMode = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-object-lock-mode");
        Instant objectLockRetainUntilDate = UnmarshallerUtils.getHeader(headers, "x-amz-object-lock-retain-until-date").map(Instant::parse).orElse(null);
        Integer partsCount = UnmarshallerUtils.getHeader(headers, "x-amz-mp-parts-count").map(Integer::parseInt).orElse(null);
        String replicationStatus = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-replication-status");
        String requestCharged = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-request-charged");
        String restore = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-restore");
        String serverSideEncryption = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-server-side-encryption");
        String sseCustomerAlgorithm = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-server-side-encryption-customer-algorithm");
        String sseCustomerKeyMD5 = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-server-side-encryption-customer-key-MD5");
        String sseKmsId = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-server-side-encryption-aws-kms-key-id");
        String storageClass = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-storage-class");
        Integer tagCount = UnmarshallerUtils.getHeader(headers, "x-amz-tagging-count").map(Integer::parseInt).orElse(null);
        String versionId = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-version-id");
        String websiteRedirectLocation = UnmarshallerUtils.getHeaderOrNull(headers, "x-amz-website-redirect-location");
        return GetObjectResponse.builder().acceptRanges(acceptRanges).cacheControl(cacheControl).contentDisposition(contentDisposition).contentEncoding(contentEncoding).contentLanguage(contentLanguage).contentLength(contentLength).contentRange(contentRange).contentType(contentType).deleteMarker(deleteMarker).eTag(eTag).expiration(expiration).expires(expires).lastModified(lastModified).metadata(metadata).missingMeta(missingMeta).objectLockLegalHoldStatus(objectLockLegalHoldStatus).objectLockMode(objectLockMode).objectLockRetainUntilDate(objectLockRetainUntilDate).partsCount(partsCount).replicationStatus(replicationStatus).requestCharged(requestCharged).restore(restore).serverSideEncryption(serverSideEncryption).sseCustomerAlgorithm(sseCustomerAlgorithm).sseCustomerKeyMD5(sseCustomerKeyMD5).sseKmsKeyId(sseKmsId).storageClass(storageClass).tagCount(tagCount).versionId(versionId).websiteRedirectLocation(websiteRedirectLocation).build();
    }
}

