/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_14_4;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.common.BiomeMap;
import org.dynmap.forge_1_14_4.ChunkSnapshot;
import org.dynmap.forge_1_14_4.DynmapPlugin;
import org.dynmap.forge_1_14_4.ForgeWorld;
import org.dynmap.forge_1_14_4.SnapshotCache;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public class ForgeMapChunkCache
extends MapChunkCache {
    private static boolean init;
    private static Field updateEntityTick;
    private static Field chunksToRemove;
    private static Field chunkCoord;
    private static Field nbtTag;
    private World w;
    private DynmapWorld dw;
    private ServerChunkProvider cps;
    private int nsect;
    private List<DynmapChunk> chunks;
    private ListIterator<DynmapChunk> iterator;
    private int x_min;
    private int x_max;
    private int z_min;
    private int z_max;
    private int x_dim;
    private boolean biome;
    private boolean biomeraw;
    private boolean highesty;
    private boolean blockdata;
    private MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    private List<VisibilityLimit> visible_limits = null;
    private List<VisibilityLimit> hidden_limits = null;
    private boolean isempty = true;
    private int snapcnt;
    private ChunkSnapshot[] snaparray;
    private DynIntHashMap[] snaptile;
    private byte[][] sameneighborbiomecnt;
    private BiomeMap[][] biomemap;
    private boolean[][] isSectionNotEmpty;
    private static final BlockStep[] unstep;
    private static BiomeMap[] biome_to_bmap;
    private static final EmptyChunk EMPTY;
    private static final PlainChunk STONE;
    private static final PlainChunk OCEAN;
    private static boolean didError;

    private static final int getIndexInChunk(int cx, int cy, int cz) {
        return cy << 8 | cz << 4 | cx;
    }

    public static void init() {
        if (!init) {
            int i;
            Field[] f = ServerChunkProvider.class.getDeclaredFields();
            f = ServerWorld.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (updateEntityTick != null || !f[i].getType().isAssignableFrom(Integer.TYPE)) continue;
                updateEntityTick = f[i];
                updateEntityTick.setAccessible(true);
            }
            f = ChunkManager.class.getDeclaredFields();
            for (i = 0; i < f.length; ++i) {
                if (chunksToRemove != null || !f[i].getType().equals(Map.class)) continue;
                chunksToRemove = f[i];
                chunksToRemove.setAccessible(true);
            }
            if (updateEntityTick == null) {
                Log.severe("ERROR: cannot find updateEntityTick - dynmap cannot drive entity cleanup when no players are active");
            }
            init = true;
        }
    }

    public ForgeMapChunkCache() {
        ForgeMapChunkCache.init();
    }

    public void setChunks(ForgeWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.w = dw.getWorld();
        if (dw.isLoaded()) {
            AbstractChunkProvider cp = this.w.func_72863_F();
            if (cp instanceof ServerChunkProvider) {
                this.cps = (ServerChunkProvider)cp;
            } else {
                Log.severe("Error: world " + dw.getName() + " has unsupported chunk provider");
            }
        } else {
            chunks = new ArrayList<DynmapChunk>();
        }
        this.nsect = dw.worldheight >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new ChunkSnapshot[this.snapcnt];
        this.snaptile = new DynIntHashMap[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    public CompoundNBT readChunk(int x, int z) {
        try {
            ChunkManager acl = this.cps.field_217237_a;
            ChunkPos coord = new ChunkPos(x, z);
            CompoundNBT rslt = acl.func_219099_e(coord);
            if (rslt != null) {
                rslt = rslt.func_74775_l("Level");
                String stat = rslt.func_74779_i("Status");
                ChunkStatus cs = ChunkStatus.func_222591_a((String)stat);
                if (stat == null || !cs.func_209003_a(ChunkStatus.field_222614_j)) {
                    rslt = null;
                }
            }
            return rslt;
        }
        catch (Exception exc) {
            Log.severe(String.format("Error reading chunk: %s,%d,%d", this.dw.getName(), x, z), exc);
            return null;
        }
    }

    private Object getNBTValue(INBT v) {
        Object val = null;
        switch (v.func_74732_a()) {
            case 1: {
                val = ((ByteNBT)v).func_150290_f();
                break;
            }
            case 2: {
                val = ((ShortNBT)v).func_150289_e();
                break;
            }
            case 3: {
                val = ((IntNBT)v).func_150287_d();
                break;
            }
            case 4: {
                val = ((LongNBT)v).func_150291_c();
                break;
            }
            case 5: {
                val = Float.valueOf(((FloatNBT)v).func_150288_h());
                break;
            }
            case 6: {
                val = ((DoubleNBT)v).func_150286_g();
                break;
            }
            case 7: {
                val = ((ByteArrayNBT)v).func_150292_c();
                break;
            }
            case 8: {
                val = ((StringNBT)v).func_150285_a_();
                break;
            }
            case 9: {
                ListNBT tl = (ListNBT)v;
                ArrayList<Object> vlist = new ArrayList<Object>();
                int type = tl.func_150303_d();
                block20: for (int i = 0; i < tl.size(); ++i) {
                    switch (type) {
                        case 5: {
                            float fv = tl.func_150308_e(i);
                            vlist.add(Float.valueOf(fv));
                            continue block20;
                        }
                        case 6: {
                            double dv = tl.func_150309_d(i);
                            vlist.add(dv);
                            continue block20;
                        }
                        case 8: {
                            String sv = tl.func_150307_f(i);
                            vlist.add(sv);
                            continue block20;
                        }
                        case 10: {
                            CompoundNBT tc = tl.func_150305_b(i);
                            vlist.add(this.getNBTValue((INBT)tc));
                            continue block20;
                        }
                        case 11: {
                            int[] ia = tl.func_150306_c(i);
                            vlist.add(ia);
                        }
                    }
                }
                val = vlist;
                break;
            }
            case 10: {
                CompoundNBT tc = (CompoundNBT)v;
                HashMap<String, Object> vmap = new HashMap<String, Object>();
                for (Object t : tc.func_150296_c()) {
                    String st = (String)t;
                    INBT tg = tc.func_74781_a(st);
                    vmap.put(st, this.getNBTValue(tg));
                }
                val = vmap;
                break;
            }
            case 11: {
                val = ((IntArrayNBT)v).func_150302_c();
            }
        }
        return val;
    }

    private boolean isChunkVisible(DynmapChunk chunk) {
        boolean vis = true;
        if (this.visible_limits != null) {
            vis = false;
            for (VisibilityLimit limit : this.visible_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = true;
                break;
            }
        }
        if (vis && this.hidden_limits != null) {
            for (VisibilityLimit limit : this.hidden_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = false;
                break;
            }
        }
        return vis;
    }

    private boolean tryChunkCache(DynmapChunk chunk, boolean vis) {
        ChunkSnapshot ss = null;
        SnapshotCache.SnapshotRec ssr = DynmapPlugin.plugin.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
        if (ssr != null) {
            ss = ssr.ss;
            if (!vis) {
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
            }
            int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            this.snaparray[idx] = ss;
            this.snaptile[idx] = ssr.tileData;
        }
        return ssr != null;
    }

    private SnapshotCache.SnapshotRec prepChunkSnapshot(DynmapChunk chunk, CompoundNBT nbt) {
        ChunkSnapshot ss = new ChunkSnapshot(nbt, this.dw.worldheight);
        DynIntHashMap tileData = new DynIntHashMap();
        ListNBT tiles = nbt.func_150295_c("TileEntities", 10);
        if (tiles == null) {
            tiles = new ListNBT();
        }
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int tid = 0; tid < tiles.size(); ++tid) {
            int tz;
            int cz;
            int ty;
            CompoundNBT tc = tiles.func_150305_b(tid);
            int tx = tc.func_74762_e("x");
            int cx = tx & 0xF;
            DynmapBlockState blk = ss.getBlockType(cx, ty = tc.func_74762_e("y"), cz = (tz = tc.func_74762_e("z")) & 0xF);
            String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(blk);
            if (te_fields == null) continue;
            vals.clear();
            for (String id : te_fields) {
                Object val;
                INBT v = tc.func_74781_a(id);
                if (v == null || (val = this.getNBTValue(v)) == null) continue;
                vals.add(id);
                vals.add(val);
            }
            if (vals.size() <= 0) continue;
            Object[] vlist = vals.toArray(new Object[vals.size()]);
            tileData.put(ForgeMapChunkCache.getIndexInChunk(cx, ty, cz), vlist);
        }
        SnapshotCache.SnapshotRec ssr = new SnapshotCache.SnapshotRec();
        ssr.ss = ss;
        ssr.tileData = tileData;
        DynmapPlugin.plugin.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
        return ssr;
    }

    public int getLoadedChunks() {
        int cnt = 0;
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        ListIterator<DynmapChunk> iter = this.chunks.listIterator();
        while (iter.hasNext()) {
            DynIntHashMap tileData;
            ChunkSnapshot ss;
            long startTime = System.nanoTime();
            DynmapChunk chunk = iter.next();
            int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkindex] != null) continue;
            boolean vis = this.isChunkVisible(chunk);
            if (this.tryChunkCache(chunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                ++cnt;
                continue;
            }
            if (!this.cps.func_73149_a(chunk.x, chunk.z)) continue;
            if (vis) {
                CompoundNBT nbt = ChunkSerializer.func_222645_a((ServerWorld)((ServerWorld)this.w), (IChunk)this.cps.func_217205_a(chunk.x, chunk.z, false));
                if (nbt != null) {
                    nbt = nbt.func_74775_l("Level");
                }
                SnapshotCache.SnapshotRec ssr = this.prepChunkSnapshot(chunk, nbt);
                ss = ssr.ss;
                tileData = ssr.tileData;
            } else {
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                tileData = new DynIntHashMap();
            }
            this.snaparray[chunkindex] = ss;
            this.snaptile[chunkindex] = tileData;
            this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int loadChunks(int max_to_load) {
        return this.getLoadedChunks() + this.readChunks(max_to_load);
    }

    public int readChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = this.iterator.next();
            int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkindex] != null) continue;
            boolean vis = this.isChunkVisible(chunk);
            if (this.tryChunkCache(chunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
            } else {
                CompoundNBT nbt = this.readChunk(chunk.x, chunk.z);
                if (nbt != null) {
                    DynIntHashMap tileData;
                    ChunkSnapshot ss;
                    if (!vis) {
                        ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                        tileData = new DynIntHashMap();
                    } else {
                        SnapshotCache.SnapshotRec ssr = this.prepChunkSnapshot(chunk, nbt);
                        ss = ssr.ss;
                        tileData = ssr.tileData;
                    }
                    this.snaparray[chunkindex] = ss;
                    this.snaptile[chunkindex] = tileData;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
                }
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (this.snaparray[idx] != EMPTY) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        if (this.isSectionNotEmpty[idx] == null) {
            this.initSectionData(idx);
        }
        return !this.isSectionNotEmpty[idx][sy];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.dw.getEnvironment().equals("the_end")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new OurMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        this.biome = biome;
        this.biomeraw = rawbiome;
        this.highesty = highestblocky;
        this.blockdata = blockdata;
        return true;
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    static /* synthetic */ byte[][] access$802(ForgeMapChunkCache x0, byte[][] x1) {
        x0.sameneighborbiomecnt = x1;
        return x1;
    }

    static /* synthetic */ BiomeMap[][] access$1002(ForgeMapChunkCache x0, BiomeMap[][] x1) {
        x0.biomemap = x1;
        return x1;
    }

    static {
        int i;
        init = false;
        updateEntityTick = null;
        chunksToRemove = null;
        chunkCoord = null;
        nbtTag = null;
        unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
        EMPTY = new EmptyChunk();
        STONE = new PlainChunk(DynmapBlockState.STONE_BLOCK);
        OCEAN = new PlainChunk(DynmapBlockState.WATER_BLOCK);
        didError = false;
        Biome[] b = DynmapPlugin.getBiomeList();
        BiomeMap[] bm = BiomeMap.values();
        biome_to_bmap = new BiomeMap[256];
        for (i = 0; i < biome_to_bmap.length; ++i) {
            ForgeMapChunkCache.biome_to_bmap[i] = BiomeMap.NULL;
        }
        block1: for (i = 0; i < b.length; ++i) {
            if (b[i] == null) continue;
            String bs = b[i].func_210773_k();
            for (int j = 0; j < bm.length; ++j) {
                if (!bm[j].toString().equals(bs)) continue;
                ForgeMapChunkCache.biome_to_bmap[i] = bm[j];
                continue block1;
            }
        }
    }

    private static class EmptyChunk
    extends ChunkSnapshot {
        public EmptyChunk() {
            super(256, 0, 0, 0L, 0L);
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return true;
        }
    }

    private static class PlainChunk
    extends ChunkSnapshot {
        private DynmapBlockState fill;

        PlainChunk(String fill) {
            super(256, 0, 0, 0L, 0L);
            this.fill = DynmapBlockState.getBaseStateByName(fill);
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getZ() {
            return 0;
        }

        @Override
        public int getBiome(int x, int z) {
            return -1;
        }

        @Override
        public final DynmapBlockState getBlockType(int x, int y, int z) {
            if (y < 64) {
                return this.fill;
            }
            return DynmapBlockState.AIR;
        }

        @Override
        public final int getBlockSkyLight(int x, int y, int z) {
            if (y < 64) {
                return 0;
            }
            return 15;
        }

        @Override
        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public final int getHighestBlockYAt(int x, int z) {
            return 64;
        }

        @Override
        public boolean isSectionEmpty(int sy) {
            return sy < 4;
        }
    }

    private class OurEndMapIterator
    extends OurMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class OurMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private ChunkSnapshot snap;
        private BlockStep laststep;
        private DynmapBlockState blk;
        private final int worldheight;
        private final int x_base;
        private final int z_base;

        OurMapIterator(int x0, int y0, int z0) {
            this.x_base = ForgeMapChunkCache.this.x_min << 4;
            this.z_base = ForgeMapChunkCache.this.z_min << 4;
            if (ForgeMapChunkCache.this.biome) {
                this.biomePrep();
            }
            this.initialize(x0, y0, z0);
            this.worldheight = ForgeMapChunkCache.this.w.func_217301_I();
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - ForgeMapChunkCache.this.x_min + ((this.z >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.snap = this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : ForgeMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            this.blk = this.y >= 0 && this.y < this.worldheight ? null : DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 0;
            }
        }

        @Override
        public final int getBlockLight(BlockStep step) {
            int emit = 0;
            int sky = 15;
            if (step.yoff != 0) {
                int ny = this.y + step.yoff;
                emit = this.snap.getBlockEmittedLight(this.x, ny, this.z);
                sky = this.snap.getBlockSkyLight(this.x, ny, this.z);
            } else {
                int nx = this.x + step.xoff;
                int nz = this.z + step.zoff;
                int nchunkindex = (nx >> 4) - ForgeMapChunkCache.this.x_min + ((nz >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
                if (nchunkindex < ForgeMapChunkCache.this.snapcnt && nchunkindex >= 0) {
                    emit = ForgeMapChunkCache.this.snaparray[nchunkindex].getBlockEmittedLight(nx, this.y, nz);
                    sky = ForgeMapChunkCache.this.snaparray[nchunkindex].getBlockSkyLight(nx, this.y, nz);
                }
            }
            return (emit << 8) + sky;
        }

        @Override
        public final int getBlockLight(int xoff, int yoff, int zoff) {
            int emit = 0;
            int sky = 15;
            int nx = this.x + xoff;
            int ny = this.y + yoff;
            int nz = this.z + zoff;
            int nchunkindex = (nx >> 4) - ForgeMapChunkCache.this.x_min + ((nz >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            if (nchunkindex < ForgeMapChunkCache.this.snapcnt && nchunkindex >= 0) {
                emit = ForgeMapChunkCache.this.snaparray[nchunkindex].getBlockEmittedLight(nx, ny, nz);
                sky = ForgeMapChunkCache.this.snaparray[nchunkindex].getBlockSkyLight(nx, ny, nz);
            }
            return (emit << 8) + sky;
        }

        private void biomePrep() {
            int i;
            if (ForgeMapChunkCache.this.sameneighborbiomecnt != null) {
                return;
            }
            int x_size = ForgeMapChunkCache.this.x_dim << 4;
            int z_size = ForgeMapChunkCache.this.z_max - ForgeMapChunkCache.this.z_min + 1 << 4;
            ForgeMapChunkCache.access$802(ForgeMapChunkCache.this, new byte[x_size][]);
            ForgeMapChunkCache.access$1002(ForgeMapChunkCache.this, new BiomeMap[x_size][]);
            for (i = 0; i < x_size; ++i) {
                ((ForgeMapChunkCache)ForgeMapChunkCache.this).sameneighborbiomecnt[i] = new byte[z_size];
                ((ForgeMapChunkCache)ForgeMapChunkCache.this).biomemap[i] = new BiomeMap[z_size];
            }
            for (i = 0; i < x_size; ++i) {
                for (int j = 0; j < z_size; ++j) {
                    BiomeMap bm;
                    if (j == 0) {
                        this.initialize(i + this.x_base, 64, this.z_base);
                    } else {
                        this.stepPosition(BlockStep.Z_PLUS);
                    }
                    int bb = this.snap.getBiome(this.bx, this.bz);
                    ((ForgeMapChunkCache)ForgeMapChunkCache.this).biomemap[i][j] = bm = BiomeMap.byBiomeID(bb);
                    int cnt = 0;
                    if (i > 0) {
                        if (bm == ForgeMapChunkCache.this.biomemap[i - 1][j]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j > 0 && bm == ForgeMapChunkCache.this.biomemap[i - 1][j - 1]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j - 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j < z_size - 1 && bm == ForgeMapChunkCache.this.biomemap[i - 1][j + 1]) {
                            ++cnt;
                            byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j + 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                    }
                    if (j > 0 && ForgeMapChunkCache.this.biomemap[i][j] == ForgeMapChunkCache.this.biomemap[i][j - 1]) {
                        ++cnt;
                        byte[] byArray = ForgeMapChunkCache.this.sameneighborbiomecnt[i];
                        int n = j - 1;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    ((ForgeMapChunkCache)ForgeMapChunkCache.this).sameneighborbiomecnt[i][j] = (byte)cnt;
                }
            }
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return ForgeMapChunkCache.this.biomemap[this.x - this.x_base][this.z - this.z_base];
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    return bm.getWaterColorMult();
                }
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                for (int xoff = -1; xoff < 2; ++xoff) {
                    for (int zoff = -1; zoff < 2; ++zoff) {
                        bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                        int mult = bm.getWaterColorMult();
                        raccum += mult >> 16 & 0xFF;
                        gaccum += mult >> 8 & 0xFF;
                        baccum += mult & 0xFF;
                    }
                }
                return raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
            }
            catch (Exception x) {
                return 0xFFFFFF;
            }
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = ForgeMapChunkCache.this.biomemap[rx][rz];
                if (ForgeMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = ForgeMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.blk = null;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    ++this.chunkindex;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.chunkindex += ForgeMapChunkCache.this.x_dim;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    --this.chunkindex;
                    if (this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = ForgeMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= 0) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.chunkindex -= ForgeMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= ForgeMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : ForgeMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            this.blk = y < 0 || y >= this.worldheight ? DynmapBlockState.AIR : null;
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final DynmapBlockState getBlockTypeAt(BlockStep s) {
            if (s == BlockStep.Y_MINUS) {
                if (this.y > 0) {
                    return this.snap.getBlockType(this.bx, this.y - 1, this.bz);
                }
            } else if (s == BlockStep.Y_PLUS) {
                if (this.y < this.worldheight - 1) {
                    return this.snap.getBlockType(this.bx, this.y + 1, this.bz);
                }
            } else {
                BlockStep ls = this.laststep;
                this.stepPosition(s);
                DynmapBlockState tid = this.snap.getBlockType(this.bx, this.y, this.bz);
                this.unstepPosition();
                this.laststep = ls;
                return tid;
            }
            return DynmapBlockState.AIR;
        }

        @Override
        public BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public long getBlockKey() {
            return this.chunkindex * this.worldheight + this.y << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public Object getBlockTileEntityField(String fieldId) {
            try {
                int idx = ForgeMapChunkCache.getIndexInChunk(this.bx, this.y, this.bz);
                Object[] vals = (Object[])ForgeMapChunkCache.this.snaptile[this.chunkindex].get(idx);
                for (int i = 0; i < vals.length; i += 2) {
                    if (!vals[i].equals(fieldId)) continue;
                    return vals[i + 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public DynmapBlockState getBlockTypeAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - ForgeMapChunkCache.this.x_min + ((zz >> 4) - ForgeMapChunkCache.this.z_min) * ForgeMapChunkCache.this.x_dim;
            try {
                return ForgeMapChunkCache.this.snaparray[idx].getBlockType(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return DynmapBlockState.AIR;
            }
        }

        @Override
        public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public long getInhabitedTicks() {
            try {
                return this.snap.getInhabitedTicks();
            }
            catch (Exception x) {
                return 0L;
            }
        }

        @Override
        public DynmapBlockState getBlockType() {
            if (this.blk == null) {
                this.blk = this.snap.getBlockType(this.bx, this.y, this.bz);
            }
            return this.blk;
        }
    }
}

