/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.dynmap.s3lite.api.auth.AwsCredentials;
import org.dynmap.s3lite.api.client.S3Client;
import org.dynmap.s3lite.api.exception.ErrorResponse;
import org.dynmap.s3lite.api.exception.NoSuchBucketException;
import org.dynmap.s3lite.api.exception.NoSuchKeyException;
import org.dynmap.s3lite.api.exception.S3Exception;
import org.dynmap.s3lite.api.region.Region;
import org.dynmap.s3lite.api.request.DeleteObjectRequest;
import org.dynmap.s3lite.api.request.GetObjectRequest;
import org.dynmap.s3lite.api.request.ListObjectsV2Request;
import org.dynmap.s3lite.api.request.PutObjectRequest;
import org.dynmap.s3lite.api.response.DeleteObjectResponse;
import org.dynmap.s3lite.api.response.GetObjectResponse;
import org.dynmap.s3lite.api.response.ListObjectsV2Response;
import org.dynmap.s3lite.api.response.PutObjectResponse;
import org.dynmap.s3lite.api.response.ResponseTransformer;
import org.dynmap.s3lite.core.auth.DefaultSignableRequest;
import org.dynmap.s3lite.core.auth.RegionAwareSigner;
import org.dynmap.s3lite.core.mapper.ListObjectsV2ResponseMapper;
import org.dynmap.s3lite.core.marshal.DeleteObjectRequestMarshaller;
import org.dynmap.s3lite.core.marshal.GetObjectRequestMarshaller;
import org.dynmap.s3lite.core.marshal.ListObjectsV2RequestMarshaller;
import org.dynmap.s3lite.core.marshal.PutObjectRequestMarshaller;
import org.dynmap.s3lite.core.unmarshal.DeleteObjectResponseUnmarshaller;
import org.dynmap.s3lite.core.unmarshal.GetObjectResponseUnmarshaller;
import org.dynmap.s3lite.core.unmarshal.PutObjectResponseUnmarshaller;
import org.dynmap.s3lite.http.spi.HttpMethod;
import org.dynmap.s3lite.http.spi.HttpStatus;
import org.dynmap.s3lite.http.spi.IOUtils;
import org.dynmap.s3lite.http.spi.SdkHttpClient;
import org.dynmap.s3lite.http.spi.request.RequestBody;
import org.dynmap.s3lite.http.spi.response.ImmutableResponse;

final class DefaultS3Client
implements S3Client {
    private static final String HOST_FORMAT = "https://%s.%s";
    private final RegionAwareSigner signer = RegionAwareSigner.create();
    private final AwsCredentials credentials;
    private final SdkHttpClient httpClient;
    private final String s3Host;

    DefaultS3Client(AwsCredentials credentials, Region region, SdkHttpClient httpClient) {
        this.credentials = credentials;
        this.httpClient = httpClient;
        this.s3Host = region.getEndpoint().getHost();
        this.signer.setRegion(region);
    }

    @Override
    public ListObjectsV2Response listObjectsV2(ListObjectsV2Request request) {
        URI endpoint = this.getEndpoint(request.getBucketName());
        DefaultSignableRequest signableRequest = new DefaultSignableRequest(HttpMethod.GET, endpoint, "/");
        ListObjectsV2RequestMarshaller marshaller = new ListObjectsV2RequestMarshaller();
        marshaller.accept(signableRequest, request);
        this.signer.sign(signableRequest, this.credentials);
        ImmutableResponse response = (ImmutableResponse)this.httpClient.apply(signableRequest);
        if (response.getStatus().is2xxSuccessful()) {
            return response.getResponseBody().map(inputStream -> {
                try (InputStream input = inputStream;){
                    byte[] byArray = IOUtils.toByteArray(input);
                    return byArray;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).map(bytes -> new ListObjectsV2ResponseMapper().apply((byte[])bytes)).orElseThrow(() -> new RuntimeException("No response body found"));
        }
        throw DefaultS3Client.handleErrorResponse(response);
    }

    @Override
    public <T> T getObject(GetObjectRequest request, ResponseTransformer<GetObjectResponse, T> transformer) {
        URI endpoint = this.getEndpoint(request.getBucketName());
        DefaultSignableRequest signableRequest = new DefaultSignableRequest(HttpMethod.GET, endpoint, "/" + request.getKey());
        GetObjectRequestMarshaller marshaller = new GetObjectRequestMarshaller();
        GetObjectResponseUnmarshaller unmarshaller = new GetObjectResponseUnmarshaller();
        marshaller.accept(signableRequest, request);
        this.signer.sign(signableRequest, this.credentials);
        ImmutableResponse httpResponse = (ImmutableResponse)this.httpClient.apply(signableRequest);
        if (httpResponse.getStatus().is2xxSuccessful()) {
            Map<String, List<String>> headers = httpResponse.getHeaders();
            return (T)httpResponse.getResponseBody().map(inputStream -> {
                try {
                    GetObjectResponse response = (GetObjectResponse)unmarshaller.apply(headers);
                    Object transform = transformer.transform(response, (InputStream)inputStream);
                    if (!transformer.needsConnectionLeftOpen()) {
                        inputStream.close();
                    }
                    return transform;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).orElseThrow(() -> new RuntimeException("No response body found"));
        }
        throw DefaultS3Client.handleErrorResponse(httpResponse);
    }

    @Override
    public DeleteObjectResponse deleteObject(DeleteObjectRequest request) {
        URI endpoint = this.getEndpoint(request.getBucketName());
        DefaultSignableRequest signableRequest = new DefaultSignableRequest(HttpMethod.DELETE, endpoint, "/" + request.getKey());
        DeleteObjectRequestMarshaller marshaller = new DeleteObjectRequestMarshaller();
        DeleteObjectResponseUnmarshaller unmarshaller = new DeleteObjectResponseUnmarshaller();
        marshaller.accept(signableRequest, request);
        this.signer.sign(signableRequest, this.credentials);
        ImmutableResponse httpResponse = (ImmutableResponse)this.httpClient.apply(signableRequest);
        if (httpResponse.getStatus().is2xxSuccessful()) {
            Map<String, List<String>> headers = httpResponse.getHeaders();
            httpResponse.getResponseBody().ifPresent(IOUtils::closeQuietly);
            return (DeleteObjectResponse)unmarshaller.apply(headers);
        }
        throw DefaultS3Client.handleErrorResponse(httpResponse);
    }

    @Override
    public PutObjectResponse putObject(PutObjectRequest request, RequestBody body) {
        URI endpoint = this.getEndpoint(request.getBucketName());
        DefaultSignableRequest signableRequest = new DefaultSignableRequest(HttpMethod.PUT, endpoint, "/" + request.getKey());
        PutObjectRequestMarshaller marshaller = new PutObjectRequestMarshaller();
        PutObjectResponseUnmarshaller unmarshaller = new PutObjectResponseUnmarshaller();
        signableRequest.setRequestBody(body);
        marshaller.accept(signableRequest, request);
        this.signer.sign(signableRequest, this.credentials);
        ImmutableResponse httpResponse = (ImmutableResponse)this.httpClient.apply(signableRequest);
        if (httpResponse.getStatus().is2xxSuccessful()) {
            Map<String, List<String>> headers = httpResponse.getHeaders();
            httpResponse.getResponseBody().ifPresent(IOUtils::closeQuietly);
            return (PutObjectResponse)unmarshaller.apply(headers);
        }
        throw DefaultS3Client.handleErrorResponse(httpResponse);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private URI getEndpoint(String bucketName) {
        return URI.create(String.format(HOST_FORMAT, bucketName, this.s3Host));
    }

    private static S3Exception handleErrorResponse(ImmutableResponse httpResponse) {
        HttpStatus status = httpResponse.getStatus();
        if (status.is3xxRedirection()) {
            httpResponse.getResponseBody().ifPresent(IOUtils::closeQuietly);
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setMessage("Service: S3, Status Code: " + status.getStatusCode());
            return new S3Exception(errorResponse);
        }
        return httpResponse.getResponseBody().map(inputStream -> {
            try (InputStream input = inputStream;){
                XMLInputFactory fact = XMLInputFactory.newInstance();
                XMLEventReader rdr = fact.createXMLEventReader(input);
                ErrorResponse errorResponse = ErrorResponse.parseResponse(rdr);
                switch (errorResponse.getCode()) {
                    case "NoSuchBucket": {
                        NoSuchBucketException noSuchBucketException = new NoSuchBucketException(errorResponse);
                        return noSuchBucketException;
                    }
                    case "NoSuchKey": {
                        NoSuchKeyException noSuchKeyException = new NoSuchKeyException(errorResponse);
                        return noSuchKeyException;
                    }
                }
                S3Exception s3Exception = new S3Exception(errorResponse);
                return s3Exception;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }).orElseThrow(() -> new RuntimeException("Service: S3, Status Code: " + status.getStatusCode()));
    }
}

