/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.permissions;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import me.lucko.luckperms.api.LuckPermsApi;
import me.lucko.luckperms.api.User;
import me.lucko.luckperms.api.caching.PermissionData;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.dynmap.Log;
import org.dynmap.bukkit.permissions.PermissionProvider;

public class LuckPermsPermissions
implements PermissionProvider {
    String name;
    LuckPermsApi luckPerms;

    public static LuckPermsPermissions create(Server server, String name) {
        try {
            Class.forName("me.lucko.luckperms.api.LuckPermsApi");
        }
        catch (ClassNotFoundException cnfx) {
            return null;
        }
        if (!server.getPluginManager().isPluginEnabled("LuckPerms")) {
            return null;
        }
        LuckPermsApi luckPerms = (LuckPermsApi)server.getServicesManager().load(LuckPermsApi.class);
        if (luckPerms == null) {
            return null;
        }
        Log.info("Using LuckPerms " + luckPerms.getPlatformInfo().getVersion() + " for access control");
        return new LuckPermsPermissions(name, luckPerms);
    }

    public LuckPermsPermissions(String name, LuckPermsApi luckPerms) {
        this.name = name;
        this.luckPerms = luckPerms;
    }

    @Override
    public boolean has(CommandSender sender, String permission) {
        return sender.hasPermission(this.name + "." + permission);
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        HashSet<String> result = new HashSet<String>();
        PermissionData user = this.getUser(player);
        if (user != null) {
            for (String p : perms) {
                if (!user.getPermissionValue(this.name + "." + p).asBoolean()) continue;
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        PermissionData user = this.getUser(player);
        if (user == null) {
            return false;
        }
        return user.getPermissionValue(this.name + "." + perm).asBoolean();
    }

    private PermissionData getUser(String username) {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)username);
        UUID uuid = offlinePlayer != null && offlinePlayer.getUniqueId() != null ? offlinePlayer.getUniqueId() : (UUID)LuckPermsPermissions.joinFuture(this.luckPerms.getStorage().getUUID(username));
        if (uuid == null) {
            return null;
        }
        User user = this.luckPerms.getUser(uuid);
        if (user == null) {
            LuckPermsPermissions.joinFuture(this.luckPerms.getStorage().loadUser(uuid));
            user = this.luckPerms.getUser(uuid);
        }
        if (user == null) {
            return null;
        }
        return user.getCachedData().getPermissionData(this.luckPerms.getContextManager().getStaticContexts());
    }

    private static <T> T joinFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

