/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v119;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.dynmap.MapManager;

public class AsyncChunkProvider119 {
    private final Thread ioThread;
    private final Method getChunk;
    private final Predicate<NBTTagCompound> ifFailed;
    private final Method getAsyncSaveData;
    private final Method save;
    private int currTick = MinecraftServer.currentTick;
    private int currChunks = 0;

    AsyncChunkProvider119() {
        try {
            Predicate<NBTTagCompound> ifFailed1 = null;
            Method getChunk1 = null;
            Method getAsyncSaveData1 = null;
            Method save1 = null;
            Thread ioThread1 = null;
            try {
                Class<?> threadClass = Class.forName("com.destroystokyo.paper.io.PaperFileIOThread");
                Class asyncChunkData = Arrays.stream(ChunkRegionLoader.class.getClasses()).filter(c -> c.getSimpleName().equals("AsyncSaveData")).findFirst().orElseThrow(RuntimeException::new);
                getAsyncSaveData1 = ChunkRegionLoader.class.getMethod("getAsyncSaveData", WorldServer.class, IChunkAccess.class);
                save1 = ChunkRegionLoader.class.getMethod("saveChunk", WorldServer.class, IChunkAccess.class, asyncChunkData);
                Class<?>[] classes = threadClass.getClasses();
                Class holder = Arrays.stream(classes).filter(aClass -> aClass.getSimpleName().equals("Holder")).findAny().orElseThrow(RuntimeException::new);
                ioThread1 = (Thread)holder.getField("INSTANCE").get(null);
                getChunk1 = threadClass.getMethod("loadChunkDataAsync", WorldServer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Consumer.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                NBTTagCompound failure = (NBTTagCompound)threadClass.getField("FAILURE_VALUE").get(null);
                ifFailed1 = nbtTagCompound -> nbtTagCompound == failure;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            this.getAsyncSaveData = Objects.requireNonNull(getAsyncSaveData1);
            this.save = Objects.requireNonNull(save1);
            this.ifFailed = Objects.requireNonNull(ifFailed1);
            this.getChunk = Objects.requireNonNull(getChunk1);
            this.ioThread = Objects.requireNonNull(ioThread1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<NBTTagCompound> getChunk(WorldServer world, int x, int y) throws InvocationTargetException, IllegalAccessException {
        CompletableFuture future = new CompletableFuture();
        Object[] objectArray = new Object[8];
        objectArray[0] = world;
        objectArray[1] = x;
        objectArray[2] = y;
        objectArray[3] = 5;
        objectArray[4] = future::complete;
        objectArray[5] = false;
        objectArray[6] = true;
        objectArray[7] = true;
        this.getChunk.invoke((Object)this.ioThread, objectArray);
        return future.thenApply(resultFuture -> {
            if (resultFuture == null) {
                return null;
            }
            try {
                NBTTagCompound compound = (NBTTagCompound)resultFuture.getClass().getField("chunkData").get(resultFuture);
                return this.ifFailed.test(compound) ? null : compound;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public synchronized Supplier<NBTTagCompound> getLoadedChunk(CraftWorld world, int x, int z) {
        if (!world.isChunkLoaded(x, z)) {
            return () -> null;
        }
        Chunk c = world.getHandle().getChunkIfLoaded(x, z);
        if (c == null || !c.o) {
            return () -> null;
        }
        if (this.currTick != MinecraftServer.currentTick) {
            this.currTick = MinecraftServer.currentTick;
            this.currChunks = 0;
        }
        CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> {
            try {
                return this.getAsyncSaveData.invoke(null, world.getHandle(), c);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }, (Executor)((CraftServer)Bukkit.getServer()).getServer());
        if (++this.currChunks > MapManager.mapman.getMaxChunkLoadsPerTick()) {
            try {
                Thread.sleep(25L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return () -> {
            try {
                return (NBTTagCompound)this.save.invoke(null, world.getHandle(), c, future.get());
            }
            catch (InterruptedException | ReflectiveOperationException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        };
    }
}

