/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v118_2;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.bukkit.helper.BukkitVersionHelper;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v118_2.AsyncChunkProvider118_2;
import org.dynmap.bukkit.helper.v118_2.NBT;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;

public class MapChunkCache118_2
extends GenericMapChunkCache {
    private static final AsyncChunkProvider118_2 provider = BukkitVersionHelper.helper.isUnsafeAsync() ? null : new AsyncChunkProvider118_2();
    private World w;

    public MapChunkCache118_2(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        if (!cw.isChunkLoaded(chunk.x, chunk.z)) {
            return null;
        }
        Chunk c = cw.getHandle().getChunkIfLoaded(chunk.x, chunk.z);
        if (c == null || !c.o) {
            return null;
        }
        NBTTagCompound nbt = ChunkRegionLoader.a((WorldServer)cw.getHandle(), (IChunkAccess)c);
        return nbt != null ? this.parseChunkFromNBT(new NBT.NBTCompound(nbt)) : null;
    }

    @Override
    protected Supplier<GenericChunk> getLoadedChunkAsync(DynmapChunk ch) {
        Supplier<NBTTagCompound> nbtSupplier = provider.getLoadedChunk((CraftWorld)this.w, ch.x, ch.z);
        return () -> {
            NBTTagCompound nbt = (NBTTagCompound)nbtSupplier.get();
            return nbt == null ? null : this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        };
    }

    @Override
    protected Supplier<GenericChunk> loadChunkAsync(DynmapChunk chunk) {
        try {
            CompletableFuture<NBTTagCompound> nbt = provider.getChunk(((CraftWorld)this.w).getHandle(), chunk.x, chunk.z);
            return () -> {
                NBTTagCompound compound = (NBTTagCompound)nbt.join();
                return compound == null ? null : this.parseChunkFromNBT(new NBT.NBTCompound(compound));
            };
        }
        catch (IllegalAccessException | InvocationTargetException ignored) {
            return () -> null;
        }
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        ChunkCoordIntPair cc = new ChunkCoordIntPair(chunk.x, chunk.z);
        GenericChunk gc = null;
        try {
            nbt = cw.getHandle().k().a.f(cc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        super.setChunks(dw, chunks);
    }
}

