/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v116_3;

import java.io.IOException;
import java.util.List;
import net.minecraft.server.v1_16_R2.Chunk;
import net.minecraft.server.v1_16_R2.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R2.ChunkRegionLoader;
import net.minecraft.server.v1_16_R2.IChunkAccess;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.bukkit.helper.BukkitWorld;
import org.dynmap.bukkit.helper.v116_3.NBT;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;

public class MapChunkCache116_3
extends GenericMapChunkCache {
    private World w;

    public MapChunkCache116_3(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        GenericChunk gc = null;
        if (cw.isChunkLoaded(chunk.x, chunk.z)) {
            Chunk c = cw.getHandle().getChunkAt(chunk.x, chunk.z);
            if (c != null && c.loaded) {
                nbt = ChunkRegionLoader.saveChunk((WorldServer)cw.getHandle(), (IChunkAccess)c);
            }
            if (nbt != null) {
                gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
            }
        }
        return gc;
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        CraftWorld cw = (CraftWorld)this.w;
        NBTTagCompound nbt = null;
        ChunkCoordIntPair cc = new ChunkCoordIntPair(chunk.x, chunk.z);
        GenericChunk gc = null;
        try {
            nbt = cw.getHandle().getChunkProvider().playerChunkMap.read(cc);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.w = dw.getWorld();
        super.setChunks(dw, chunks);
    }
}

