/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dynmap.utils.IndexedVector3D;
import org.dynmap.utils.Vector3D;

public class IndexedVector3DList {
    private int nextIndex = 1;
    private HashMap<Vector3D, IndexedVector3D> set = new HashMap();
    private ListCallback callback;

    public IndexedVector3DList(ListCallback cb) {
        this.callback = cb;
    }

    public void resetSet() {
        this.set.clear();
    }

    public void resetSet(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        Iterator<Map.Entry<Vector3D, IndexedVector3D>> iter = this.set.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Vector3D, IndexedVector3D> ne = iter.next();
            Vector3D n = ne.getKey();
            if (!(n.x >= minx) || !(n.x < maxx) || !(n.y >= miny) || !(n.y < maxy) || !(n.z >= minz) || !(n.z < maxz)) continue;
            iter.remove();
        }
    }

    public int getVectorIndex(double x, double y, double z) {
        IndexedVector3D v = new IndexedVector3D(x, y, z, this.nextIndex);
        IndexedVector3D existingv = this.set.get(v);
        if (existingv != null) {
            return existingv.index;
        }
        this.set.put(v, v);
        ++this.nextIndex;
        if (this.callback != null) {
            this.callback.elementAdded(this, v);
        }
        return v.index;
    }

    public static interface ListCallback {
        public void elementAdded(IndexedVector3DList var1, IndexedVector3D var2);
    }
}

