/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.util.HashMap;
import java.util.Map;
import org.dynmap.hdmap.TexturePack;
import org.dynmap.modsupport.BlockSide;
import org.dynmap.modsupport.ModelBlockModel;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.PatchDefinition;
import org.dynmap.utils.Vector3D;

public class PatchDefinitionFactory
implements RenderPatchFactory {
    private HashMap<PatchDefinition, PatchDefinition> patches = new HashMap();
    private Object lock = new Object();
    private PatchDefinition lookup = new PatchDefinition();
    private Map<String, PatchDefinition> namemap = null;

    public void setPatchNameMape(Map<String, PatchDefinition> nmap) {
        this.namemap = nmap;
    }

    @Override
    public RenderPatch getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        return this.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, sidevis, textureids, vmin, vmax, true);
    }

    @Override
    public RenderPatch getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double uplusvmax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        return this.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, 0.0, uplusvmax, 0.0, uplusvmax, sidevis, textureids, 0.0, 0.0, true);
    }

    @Override
    public PatchDefinition getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vminatumax, double vmax, double vmaxatumax, RenderPatchFactory.SideVisible sidevis, int textureids) {
        return this.getPatch(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, sidevis, textureids, vminatumax, vmaxatumax, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchDefinition getPatch(double x0, double y0, double z0, double xu, double yu, double zu, double xv, double yv, double zv, double umin, double umax, double vmin, double vmax, RenderPatchFactory.SideVisible sidevis, int textureids, double vminatumax, double vmaxatumax, boolean shade) {
        Object object = this.lock;
        synchronized (object) {
            this.lookup.update(x0, y0, z0, xu, yu, zu, xv, yv, zv, umin, umax, vmin, vmax, sidevis, textureids, vminatumax, vmaxatumax, shade);
            if (!this.lookup.validate()) {
                return null;
            }
            PatchDefinition pd2 = this.patches.get(this.lookup);
            if (pd2 == null) {
                PatchDefinition pd = new PatchDefinition(this.lookup);
                this.patches.put(pd, pd);
                pd2 = pd;
            }
            return pd2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchDefinition getModelFace(double[] from, double[] to, BlockSide face, double[] uv, ModelBlockModel.SideRotation rot, boolean shade, int textureid) {
        Object object = this.lock;
        synchronized (object) {
            this.lookup.updateModelFace(from, to, face, uv, rot, shade, textureid);
            if (!this.lookup.validate()) {
                return null;
            }
            PatchDefinition pd2 = this.patches.get(this.lookup);
            if (pd2 == null) {
                PatchDefinition pd = new PatchDefinition(this.lookup);
                this.patches.put(pd, pd);
                pd2 = pd;
            }
            return pd2;
        }
    }

    @Override
    public RenderPatch getRotatedPatch(RenderPatch patch, double xrot, double yrot, double zrot, int textureindex) {
        return this.getPatch((PatchDefinition)patch, xrot, yrot, zrot, textureindex);
    }

    @Override
    public RenderPatch getRotatedPatch(RenderPatch patch, double xrot, double yrot, double zrot, double rotorigx, double rotorigy, double rotorigz, int textureindex) {
        return this.getPatch((PatchDefinition)patch, xrot, yrot, zrot, new Vector3D(rotorigx, rotorigy, rotorigz), textureindex);
    }

    @Override
    public RenderPatch getRotatedPatch(RenderPatch patch, int xrot, int yrot, int zrot, int textureindex) {
        return this.getPatch((PatchDefinition)patch, xrot, yrot, zrot, textureindex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatchDefinition getPatch(PatchDefinition patch, double xrot, double yrot, double zrot, Vector3D rotorig, int textureindex) {
        PatchDefinition pd = new PatchDefinition(patch, xrot, yrot, zrot, rotorig, textureindex);
        if (!pd.validate()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            PatchDefinition pd2 = this.patches.get(pd);
            if (pd2 == null) {
                this.patches.put(pd, pd);
                pd2 = pd;
            }
            return pd2;
        }
    }

    public PatchDefinition getPatch(PatchDefinition patch, double xrot, double yrot, double zrot, int textureindex) {
        return this.getPatch(patch, xrot, yrot, zrot, null, textureindex);
    }

    @Override
    public RenderPatch getNamedPatch(String name, int textureidx) {
        return this.getPatchByName(name, textureidx);
    }

    public PatchDefinition getPatchByName(String name, int textureidx) {
        PatchDefinition pd = null;
        if (this.namemap != null) {
            pd = this.namemap.get(name);
            if (pd != null && textureidx != pd.textureindex) {
                pd = null;
            }
            if (pd == null) {
                String patchid = name;
                int txt_idx = -1;
                int off = patchid.lastIndexOf(35);
                if (off > 0) {
                    try {
                        txt_idx = Integer.valueOf(patchid.substring(off + 1));
                    }
                    catch (NumberFormatException nfx) {
                        return null;
                    }
                    patchid = patchid.substring(0, off);
                }
                int rotx = 0;
                int roty = 0;
                int rotz = 0;
                off = patchid.indexOf(64);
                if (off > 0) {
                    String[] rv = patchid.substring(off + 1).split("/");
                    if (rv.length == 1) {
                        roty = Integer.parseInt(rv[0]);
                    } else if (rv.length == 2) {
                        rotx = Integer.parseInt(rv[0]);
                        roty = Integer.parseInt(rv[1]);
                    } else if (rv.length == 3) {
                        rotx = Integer.parseInt(rv[0]);
                        roty = Integer.parseInt(rv[1]);
                        rotz = Integer.parseInt(rv[2]);
                    }
                    patchid = patchid.substring(0, off);
                }
                if ((pd = this.namemap.get(patchid)) == null) {
                    return null;
                }
                pd = txt_idx >= 0 ? this.getPatch(pd, rotx, roty, rotz, txt_idx) : this.getPatch(pd, rotx, roty, rotz, textureidx);
                if (pd != null) {
                    this.namemap.put(name, pd);
                }
            }
        }
        return pd;
    }

    @Override
    public int getTextureIndexFromMap(String id, int key) {
        return TexturePack.getTextureIndexFromTextureMap(id, key);
    }

    @Override
    public int getTextureCountFromMap(String id) {
        return TexturePack.getTextureMapLength(id);
    }
}

