/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.storage.filetree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.WebAuthManager;
import org.dynmap.debug.Debug;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageBaseTileEnumCB;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.storage.MapStorageTileEnumCB;
import org.dynmap.storage.MapStorageTileSearchEndCB;
import org.dynmap.storage.filetree.TileHashManager;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class FileTreeMapStorage
extends MapStorage {
    private File baseTileDir;
    private TileHashManager hashmap;
    private static final int MAX_WRITE_RETRIES = 6;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @Override
    public boolean init(DynmapCore core) {
        if (!super.init(core)) {
            return false;
        }
        this.baseTileDir = core.getTilesFolder();
        this.hashmap = new TileHashManager(this.baseTileDir, true);
        return true;
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
        return new StorageTile(world, map, x, y, zoom, var);
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, String uri) {
        String[] suri = uri.split("/");
        if (suri.length < 2) {
            return null;
        }
        String mname = suri[0];
        MapType mt = null;
        MapType.ImageVariant imgvar = null;
        for (int mti = 0; mt == null && mti < world.maps.size(); ++mti) {
            MapType type = world.maps.get(mti);
            MapType.ImageVariant[] var = type.getVariants();
            for (int ivi = 0; imgvar == null && ivi < var.length; ++ivi) {
                if (!mname.equals(type.getPrefix() + var[ivi].variantSuffix)) continue;
                mt = type;
                imgvar = var[ivi];
            }
        }
        if (mt == null) {
            return null;
        }
        String fname = suri[suri.length - 1];
        String[] coord = fname.split("[_\\.]");
        if (coord.length < 3) {
            return null;
        }
        int zoom = 0;
        try {
            int y;
            int x;
            if (coord[0].charAt(0) == 'z') {
                zoom = coord[0].length();
                x = Integer.parseInt(coord[1]);
                y = Integer.parseInt(coord[2]);
            } else {
                x = Integer.parseInt(coord[0]);
                y = Integer.parseInt(coord[1]);
            }
            return this.getTile(world, mt, x, y, zoom, imgvar);
        }
        catch (NumberFormatException nfx) {
            return null;
        }
    }

    private void processEnumMapTiles(DynmapWorld world, MapType map, File base, MapType.ImageVariant var, MapStorageTileEnumCB cb, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        File bdir = new File(base, map.getPrefix() + var.variantSuffix);
        if (!bdir.isDirectory()) {
            if (cbEnd != null) {
                cbEnd.searchEnded();
            }
            return;
        }
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.add(bdir);
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            String[] dirlst = dir.list();
            if (dirlst == null) continue;
            for (String fn : dirlst) {
                String[] coord;
                MapType.ImageEncoding fmt;
                if (fn.equals(".") || fn.equals("..")) continue;
                File f = new File(dir, fn);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                String ext = null;
                int extoff = fn.lastIndexOf(46);
                if (extoff >= 0) {
                    ext = fn.substring(extoff + 1);
                    fn = fn.substring(0, extoff);
                }
                if ((fmt = MapType.ImageEncoding.fromExt(ext)) == null) continue;
                int zoom = 0;
                if (fn.startsWith("z")) {
                    while (fn.startsWith("z")) {
                        fn = fn.substring(1);
                        ++zoom;
                    }
                    if (fn.startsWith("_")) {
                        fn = fn.substring(1);
                    }
                }
                if ((coord = fn.split("_")).length != 2) continue;
                try {
                    int x = Integer.parseInt(coord[0]);
                    int y = Integer.parseInt(coord[1]);
                    StorageTile t = new StorageTile(world, map, x, y, zoom, var);
                    if (cb != null) {
                        cb.tileFound(t, fmt);
                    }
                    if (cbBase != null && t.zoom == 0) {
                        cbBase.tileFound(t, fmt);
                    }
                    ((MapStorageTile)t).cleanup();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (cbEnd != null) {
            cbEnd.searchEnded();
        }
    }

    @Override
    public void enumMapTiles(DynmapWorld world, MapType map, MapStorageTileEnumCB cb) {
        File base = new File(this.baseTileDir, world.getName());
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, base, var, cb, null, null);
            }
        }
    }

    @Override
    public void enumMapBaseTiles(DynmapWorld world, MapType map, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        File base = new File(this.baseTileDir, world.getName());
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, base, var, null, cbBase, cbEnd);
            }
        }
    }

    private void processPurgeMapTiles(DynmapWorld world, MapType map, File base, MapType.ImageVariant var) {
        File bdir;
        String mname = map.getPrefix() + var.variantSuffix;
        String[] hlist = base.list();
        if (hlist != null) {
            for (String h : hlist) {
                if (!h.endsWith(".hash") || h.startsWith(mname + "_")) continue;
                File f = new File(base, h);
                f.delete();
            }
        }
        if (!(bdir = new File(base, mname)).isDirectory()) {
            return;
        }
        LinkedList<File> dirs = new LinkedList<File>();
        LinkedList<File> dirsdone = new LinkedList<File>();
        dirs.add(bdir);
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            dirsdone.add(dir);
            String[] dirlst = dir.list();
            if (dirlst == null) continue;
            for (String fn : dirlst) {
                if (fn.equals(".") || fn.equals("..")) continue;
                File f = new File(dir, fn);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                f.delete();
            }
        }
        int cnt = dirsdone.size();
        for (int i = cnt - 1; i >= 0; --i) {
            File f = (File)dirsdone.get(i);
            f.delete();
        }
    }

    @Override
    public void purgeMapTiles(DynmapWorld world, MapType map) {
        File base = new File(this.baseTileDir, world.getName());
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processPurgeMapTiles(world, mt, base, var);
            }
        }
    }

    @Override
    public boolean setPlayerFaceImage(String playername, PlayerFaces.FaceType facetype, BufferOutputStream encImage) {
        String baseFilename = "faces/" + facetype.id + "/" + playername + ".png";
        File ff = new File(this.baseTileDir, baseFilename);
        File ffpar = ff.getParentFile();
        if (encImage == null) {
            ff.delete();
            return true;
        }
        if (!ffpar.exists()) {
            ffpar.mkdirs();
        }
        this.getWriteLock(baseFilename);
        boolean done = this.replaceFile(ff, encImage.buf, encImage.len);
        this.releaseWriteLock(baseFilename);
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferInputStream getPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        String baseFilename = "faces/" + facetype.id + "/" + playername + ".png";
        File ff = new File(this.baseTileDir, baseFilename);
        if (ff.exists() && this.getReadLock(baseFilename, 5000L)) {
            byte[] buf = new byte[(int)ff.length()];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(ff);
                fis.read(buf, 0, buf.length);
            }
            catch (IOException iox) {
                Log.info("read (" + ff.getPath() + ") failed = " + iox.getMessage());
                BufferInputStream bufferInputStream = null;
                return bufferInputStream;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
                this.releaseReadLock(baseFilename);
            }
            return new BufferInputStream(buf);
        }
        return null;
    }

    @Override
    public boolean hasPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        String baseFilename = "faces/" + facetype.id + "/" + playername + ".png";
        File ff = new File(this.baseTileDir, baseFilename);
        return ff.exists();
    }

    @Override
    public boolean setMarkerImage(String markerid, BufferOutputStream encImage) {
        String baseFilename = "_markers_/" + markerid + ".png";
        File ff = new File(this.baseTileDir, baseFilename);
        File ffpar = ff.getParentFile();
        if (encImage == null) {
            ff.delete();
            return true;
        }
        if (!ffpar.exists()) {
            ffpar.mkdirs();
        }
        this.getWriteLock(baseFilename);
        boolean done = this.replaceFile(ff, encImage.buf, encImage.len);
        this.releaseWriteLock(baseFilename);
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferInputStream getMarkerImage(String markerid) {
        String baseFilename = "_markers_/" + markerid + ".png";
        File ff = new File(this.baseTileDir, baseFilename);
        if (ff.exists() && this.getReadLock(baseFilename, 5000L)) {
            byte[] buf = new byte[(int)ff.length()];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(ff);
                fis.read(buf, 0, buf.length);
            }
            catch (IOException iox) {
                Log.info("read (" + ff.getPath() + ") failed = " + iox.getMessage());
                BufferInputStream bufferInputStream = null;
                return bufferInputStream;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
                this.releaseReadLock(baseFilename);
            }
            return new BufferInputStream(buf);
        }
        return null;
    }

    @Override
    public boolean setMarkerFile(String world, String content) {
        String baseFilename = "_markers_/marker_" + world + ".json";
        File ff = new File(this.baseTileDir, baseFilename);
        File ffpar = ff.getParentFile();
        if (content == null) {
            ff.delete();
            return true;
        }
        if (!ffpar.exists()) {
            ffpar.mkdirs();
        }
        this.getWriteLock(baseFilename);
        byte[] buf = content.getBytes(UTF8);
        boolean done = this.replaceFile(ff, buf, buf.length);
        this.releaseWriteLock(baseFilename);
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMarkerFile(String world) {
        String baseFilename = "_markers_/marker_" + world + ".json";
        File ff = new File(this.baseTileDir, baseFilename);
        if (ff.exists() && this.getReadLock(baseFilename, 5000L)) {
            byte[] buf = new byte[(int)ff.length()];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(ff);
                fis.read(buf, 0, buf.length);
            }
            catch (IOException iox) {
                Log.info("read (" + ff.getPath() + ") failed = " + iox.getMessage());
                String string = null;
                return string;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    fis = null;
                }
                this.releaseReadLock(baseFilename);
            }
            return new String(buf, UTF8);
        }
        return null;
    }

    @Override
    public String getMarkersURI(boolean login_enabled) {
        return login_enabled ? "standalone/markers.php?marker=" : "tiles/";
    }

    @Override
    public String getTilesURI(boolean login_enabled) {
        return login_enabled ? "standalone/tiles.php?tile=" : "tiles/";
    }

    private boolean replaceFile(File f, byte[] b, int len) {
        return this.replaceFile(f, b, len, System.currentTimeMillis());
    }

    private boolean replaceFile(File f, byte[] b, int len, long timestamp) {
        boolean done = false;
        File fold = new File(f.getPath() + ".old");
        File fnew = new File(f.getPath() + ".new");
        int retrycnt = 0;
        while (!done) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(fnew, "rw");
                raf.write(b, 0, len);
                raf.close();
                raf = null;
                if (f.exists()) {
                    f.renameTo(fold);
                    fnew.renameTo(f);
                    fold.delete();
                } else {
                    fnew.renameTo(f);
                }
                f.setLastModified(timestamp);
                done = true;
            }
            catch (IOException iox) {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (retrycnt < 6) {
                    Debug.debug("Image file " + f.getPath() + " - unable to write - retry #" + retrycnt);
                    try {
                        Thread.sleep(50 << retrycnt);
                    }
                    catch (InterruptedException ix) {
                        return false;
                    }
                    ++retrycnt;
                    continue;
                }
                Log.info("Image file " + f.getPath() + " - unable to write - failed");
                return false;
            }
        }
        return true;
    }

    @Override
    public void addPaths(StringBuilder sb, DynmapCore core) {
        String p = core.getTilesFolder().getAbsolutePath();
        if (!p.endsWith("/")) {
            p = p + "/";
        }
        sb.append("$tilespath = '");
        sb.append(WebAuthManager.esc(p));
        sb.append("';\n");
        sb.append("$markerspath = '");
        sb.append(WebAuthManager.esc(p));
        sb.append("';\n");
        super.addPaths(sb, core);
    }

    public class StorageTile
    extends MapStorageTile {
        private final String baseFilename;
        private final String uri;
        private File f;
        private MapType.ImageEncoding f_fmt;

        StorageTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
            super(world, map, x, y, zoom, var);
            String baseURI = zoom > 0 ? map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz".substring(0, zoom) + "_" + x + "_" + y : map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + x + "_" + y;
            this.baseFilename = world.getName() + "/" + baseURI;
            this.uri = baseURI + "." + map.getImageFormat().getFileExt();
        }

        private File getTileFile(MapType.ImageEncoding fmt) {
            if (this.f == null || fmt != this.f_fmt) {
                this.f = new File(FileTreeMapStorage.this.baseTileDir, this.baseFilename + "." + fmt.getFileExt());
                this.f_fmt = fmt;
            }
            return this.f;
        }

        private File getTileFile() {
            MapType.ImageEncoding fmt = this.map.getImageFormat().getEncoding();
            File ff = this.getTileFile(fmt);
            if (!ff.exists()) {
                fmt = fmt == MapType.ImageEncoding.PNG ? MapType.ImageEncoding.JPG : MapType.ImageEncoding.PNG;
                ff = this.getTileFile(fmt);
            }
            return ff;
        }

        private List<File> getTileFilesAltFormats() {
            MapType.ImageEncoding fmt = this.map.getImageFormat().getEncoding();
            ArrayList<File> files = new ArrayList<File>();
            for (MapType.ImageEncoding ie : MapType.ImageEncoding.values()) {
                if (ie == fmt) continue;
                files.add(this.getTileFile(ie));
            }
            return files;
        }

        @Override
        public boolean exists() {
            File ff = this.getTileFile();
            return ff.isFile() && ff.canRead();
        }

        @Override
        public boolean matchesHashCode(long hash) {
            File ff = this.getTileFile(this.map.getImageFormat().getEncoding());
            return ff.isFile() && ff.canRead() && hash == FileTreeMapStorage.this.hashmap.getImageHashCode(this.world.getName() + "." + this.map.getPrefix(), this.x, this.y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MapStorageTile.TileRead read() {
            MapType.ImageEncoding fmt = this.map.getImageFormat().getEncoding();
            File ff = this.getTileFile(fmt);
            if (!ff.exists()) {
                fmt = fmt == MapType.ImageEncoding.PNG ? MapType.ImageEncoding.JPG : MapType.ImageEncoding.PNG;
                ff = this.getTileFile(fmt);
            }
            if (ff.isFile()) {
                MapStorageTile.TileRead tr = new MapStorageTile.TileRead();
                byte[] buf = new byte[(int)ff.length()];
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(ff);
                    fis.read(buf, 0, buf.length);
                }
                catch (IOException iox) {
                    Log.info("read (" + ff.getPath() + ") failed = " + iox.getMessage());
                    MapStorageTile.TileRead tileRead = null;
                    return tileRead;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        fis = null;
                    }
                }
                tr.image = new BufferInputStream(buf);
                tr.format = fmt;
                tr.hashCode = FileTreeMapStorage.this.hashmap.getImageHashCode(this.world.getName() + "." + this.map.getPrefix(), this.x, this.y);
                tr.lastModified = ff.lastModified();
                return tr;
            }
            return null;
        }

        @Override
        public boolean write(long hash, BufferOutputStream encImage, long timestamp) {
            File ff = this.getTileFile(this.map.getImageFormat().getEncoding());
            List<File> ffalt = this.getTileFilesAltFormats();
            File ffpar = ff.getParentFile();
            for (File file : ffalt) {
                if (!file.exists()) continue;
                file.delete();
            }
            if (encImage == null) {
                ff.delete();
                FileTreeMapStorage.this.hashmap.updateHashCode(this.world.getName() + "." + this.map.getPrefix(), this.x, this.y, -1L);
                if (this.zoom == 0) {
                    this.world.enqueueZoomOutUpdate(this);
                }
                return true;
            }
            if (!ffpar.exists()) {
                ffpar.mkdirs();
            }
            if (!FileTreeMapStorage.this.replaceFile(ff, encImage.buf, encImage.len, timestamp)) {
                return false;
            }
            FileTreeMapStorage.this.hashmap.updateHashCode(this.world.getName() + "." + this.map.getPrefix(), this.x, this.y, hash);
            if (this.zoom == 0) {
                this.world.enqueueZoomOutUpdate(this);
            }
            return true;
        }

        @Override
        public boolean getWriteLock() {
            return FileTreeMapStorage.this.getWriteLock(this.baseFilename);
        }

        @Override
        public void releaseWriteLock() {
            FileTreeMapStorage.this.releaseWriteLock(this.baseFilename);
        }

        @Override
        public boolean getReadLock(long timeout) {
            return FileTreeMapStorage.this.getReadLock(this.baseFilename, timeout);
        }

        @Override
        public void releaseReadLock() {
            FileTreeMapStorage.this.releaseReadLock(this.baseFilename);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public void enqueueZoomOutUpdate() {
            this.world.enqueueZoomOutUpdate(this);
        }

        @Override
        public MapStorageTile getZoomOutTile() {
            int step = 1 << this.zoom;
            int xx = this.x >= 0 ? this.x - this.x % (2 * step) : this.x + this.x % (2 * step);
            int yy = -this.y;
            yy = yy >= 0 ? (yy -= yy % (2 * step)) : (yy += yy % (2 * step));
            yy = -yy;
            return new StorageTile(this.world, this.map, xx, yy, this.zoom + 1, this.var);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof StorageTile) {
                StorageTile st = (StorageTile)o;
                return this.baseFilename.equals(st.baseFilename);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseFilename.hashCode();
        }

        public String toString() {
            return this.baseFilename;
        }
    }
}

