/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.io.IOException;
import java.io.InputStream;

public class BufferInputStream
extends InputStream {
    private byte[] buf;
    private int len;
    private int off = 0;
    private int mark = 0;

    public BufferInputStream(byte[] b) {
        this.len = b.length;
        this.buf = b;
    }

    public BufferInputStream(byte[] b, int len) {
        this.len = len;
        this.buf = b;
    }

    public byte[] buffer() {
        return this.buf;
    }

    public int length() {
        return this.len;
    }

    @Override
    public int available() {
        return this.len - this.off;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.off;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.off = this.mark;
    }

    @Override
    public void close() {
    }

    @Override
    public int read() {
        if (this.off < this.len) {
            ++this.off;
            return 0xFF & this.buf[this.off - 1];
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new IOException("No data");
        }
        if (off < 0 || len < 0) {
            throw new IOException("Offset out of bounds");
        }
        if (this.off >= this.len) {
            return -1;
        }
        if (this.off + len > this.len) {
            len = this.len - this.off;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.off, b, off, len);
        this.off += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.off + n > (long)this.len) {
            n = this.len - this.off;
        }
        if (n < 0L) {
            return 0L;
        }
        this.off = (int)((long)this.off + n);
        return n;
    }
}

