/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import org.dynmap.Client;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Event;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.EnterExitMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerDescription;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PlayerSet;
import org.dynmap.markers.PolyLineMarker;
import org.dynmap.markers.impl.AreaMarkerImpl;
import org.dynmap.markers.impl.CircleMarkerImpl;
import org.dynmap.markers.impl.MarkerIconImpl;
import org.dynmap.markers.impl.MarkerImpl;
import org.dynmap.markers.impl.MarkerSetImpl;
import org.dynmap.markers.impl.PlayerSetImpl;
import org.dynmap.markers.impl.PolyLineMarkerImpl;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.web.Json;

public class MarkerAPIImpl
implements MarkerAPI,
Event.Listener<DynmapWorld> {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private File markerpersist;
    private File markerpersist_old;
    private File markerdir;
    private HashMap<String, MarkerIconImpl> markericons = new HashMap();
    private ConcurrentHashMap<String, MarkerSetImpl> markersets = new ConcurrentHashMap();
    private HashMap<String, List<DynmapLocation>> pointaccum = new HashMap();
    private HashMap<String, PlayerSetImpl> playersets = new HashMap();
    private DynmapCore core;
    static MarkerAPIImpl api;
    private Map<String, Map<String, Supplier<String[]>>> tabCompletions = null;
    private static final String[] builtin_icons;
    private boolean stop = false;
    private ConcurrentHashMap<String, String> dirty_worlds = new ConcurrentHashMap();
    private boolean dirty_markers = false;
    private static final Set<String> commands;
    private static final String ARG_LABEL = "label";
    private static final String ARG_MARKUP = "markup";
    private static final String ARG_ID = "id";
    private static final String ARG_TYPE = "type";
    private static final String ARG_NEWLABEL = "newlabel";
    private static final String ARG_FILE = "file";
    private static final String ARG_HIDE = "hide";
    private static final String ARG_ICON = "icon";
    private static final String ARG_DEFICON = "deficon";
    private static final String ARG_SET = "set";
    private static final String ARG_NEWSET = "newset";
    private static final String ARG_PRIO = "prio";
    private static final String ARG_MINZOOM = "minzoom";
    private static final String ARG_MAXZOOM = "maxzoom";
    private static final String ARG_STROKEWEIGHT = "weight";
    private static final String ARG_STROKECOLOR = "color";
    private static final String ARG_STROKEOPACITY = "opacity";
    private static final String ARG_FILLCOLOR = "fillcolor";
    private static final String ARG_FILLOPACITY = "fillopacity";
    private static final String ARG_YTOP = "ytop";
    private static final String ARG_YBOTTOM = "ybottom";
    private static final String ARG_RADIUSX = "radiusx";
    private static final String ARG_RADIUSZ = "radiusz";
    private static final String ARG_RADIUS = "radius";
    private static final String ARG_SHOWLABEL = "showlabels";
    private static final String ARG_X = "x";
    private static final String ARG_Y = "y";
    private static final String ARG_Z = "z";
    private static final String ARG_WORLD = "world";
    private static final String ARG_BOOST = "boost";
    private static final String ARG_DESC = "desc";
    private static final String ARG_GREETING = "greeting";
    private static final String ARG_GREETINGSUB = "greetingsub";
    private static final String ARG_FAREWELL = "farewell";
    private static final String ARG_FAREWELLSUB = "farewellsub";

    public static MarkerAPIImpl initializeMarkerAPI(DynmapCore core) {
        if (api != null) {
            api.cleanup(core);
        }
        api = new MarkerAPIImpl();
        MarkerAPIImpl.api.core = core;
        MarkerAPIImpl.api.markerpersist = new File(core.getDataFolder(), "markers.yml");
        MarkerAPIImpl.api.markerpersist_old = new File(core.getDataFolder(), "markers.yml.old");
        for (int i = 0; i < builtin_icons.length; ++i) {
            String id = builtin_icons[i];
            api.createBuiltinMarkerIcon(id, id);
        }
        api.loadMarkers();
        MarkerSet set = api.getMarkerSet("markers");
        if (set == null) {
            set = api.createMarkerSet("markers", "Markers", null, true);
        }
        MarkerAPIImpl.api.markerdir = new File(core.getDataFolder(), "markers");
        if (!MarkerAPIImpl.api.markerdir.isDirectory() && !MarkerAPIImpl.api.markerdir.mkdirs()) {
            Log.severe("Error creating markers directory - " + MarkerAPIImpl.api.markerdir.getPath());
        }
        return api;
    }

    public static void completeInitializeMarkerAPI(final MarkerAPIImpl api) {
        MapManager.scheduleDelayedJob(new Runnable(){

            @Override
            public void run() {
                for (MarkerIcon ico : api.getMarkerIcons()) {
                    api.publishMarkerIcon(ico);
                }
                api.freshenMarkerFiles();
                ((MarkerAPIImpl)api).core.events.addListener("worldactivated", api);
                api.scheduleWriteJob();
                Log.info("Finish marker initialization");
            }
        }, 0L);
    }

    private void initTabCompletions() {
        String[] emptyValue = new String[]{};
        String[] booleanValue = new String[]{"true", "false"};
        String[] typeValue = new String[]{ARG_ICON, "area", "line", "circle"};
        Supplier<String[]> emptySupplier = () -> emptyValue;
        Supplier<String[]> booleanSupplier = () -> booleanValue;
        Supplier<String[]> iconSupplier = () -> this.markericons.keySet().toArray(new String[0]);
        Supplier<String[]> markerSetSupplier = () -> ((ConcurrentHashMap.CollectionView)((Object)this.markersets.keySet())).toArray(new String[0]);
        Supplier<String[]> worldSupplier = () -> (String[])this.core.mapManager.getWorlds().stream().map(DynmapWorld::getName).toArray(String[]::new);
        Map<String, Supplier<String[]>> labelArg = Collections.singletonMap(ARG_LABEL, emptySupplier);
        Map<String, Supplier<String[]>> idArg = Collections.singletonMap(ARG_ID, emptySupplier);
        Map<String, Supplier<String[]>> newLabelArg = Collections.singletonMap(ARG_NEWLABEL, emptySupplier);
        Map<String, Supplier<String[]>> markerSetArg = Collections.singletonMap(ARG_SET, markerSetSupplier);
        Map<String, Supplier<String[]>> newSetArg = Collections.singletonMap(ARG_NEWSET, markerSetSupplier);
        Map<String, Supplier<String[]>> fileArg = Collections.singletonMap(ARG_FILE, emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> locationArgs = new LinkedHashMap<String, Supplier<String[]>>();
        locationArgs.put(ARG_X, emptySupplier);
        locationArgs.put(ARG_Y, emptySupplier);
        locationArgs.put(ARG_Z, emptySupplier);
        locationArgs.put(ARG_WORLD, worldSupplier);
        LinkedHashMap<String, Supplier<String[]>> sharedArgs = new LinkedHashMap<String, Supplier<String[]>>(labelArg);
        sharedArgs.putAll(idArg);
        LinkedHashMap<String, Supplier<String[]>> mapObjectArgs = new LinkedHashMap<String, Supplier<String[]>>(sharedArgs);
        mapObjectArgs.put(ARG_MINZOOM, emptySupplier);
        mapObjectArgs.put(ARG_MAXZOOM, emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> setArgs = new LinkedHashMap<String, Supplier<String[]>>(mapObjectArgs);
        setArgs.put(ARG_PRIO, emptySupplier);
        setArgs.put(ARG_HIDE, booleanSupplier);
        setArgs.put("showlabel", booleanSupplier);
        setArgs.put(ARG_DEFICON, iconSupplier);
        LinkedHashMap<String, Supplier<String[]>> markerArgs = new LinkedHashMap<String, Supplier<String[]>>(mapObjectArgs);
        markerArgs.putAll(markerSetArg);
        markerArgs.put(ARG_MARKUP, booleanSupplier);
        markerArgs.put(ARG_ICON, iconSupplier);
        markerArgs.putAll(locationArgs);
        LinkedHashMap<String, Supplier<String[]>> shapeArgs = new LinkedHashMap<String, Supplier<String[]>>(mapObjectArgs);
        shapeArgs.putAll(markerSetArg);
        shapeArgs.put(ARG_MARKUP, booleanSupplier);
        shapeArgs.put(ARG_STROKEWEIGHT, emptySupplier);
        shapeArgs.put(ARG_STROKECOLOR, emptySupplier);
        shapeArgs.put(ARG_STROKEOPACITY, emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> filledShapeArgs = new LinkedHashMap<String, Supplier<String[]>>(shapeArgs);
        filledShapeArgs.put(ARG_FILLCOLOR, emptySupplier);
        filledShapeArgs.put(ARG_FILLOPACITY, emptySupplier);
        filledShapeArgs.put(ARG_GREETING, emptySupplier);
        filledShapeArgs.put(ARG_GREETINGSUB, emptySupplier);
        filledShapeArgs.put(ARG_FAREWELL, emptySupplier);
        filledShapeArgs.put(ARG_FAREWELLSUB, emptySupplier);
        filledShapeArgs.put(ARG_BOOST, booleanSupplier);
        filledShapeArgs.putAll(locationArgs);
        LinkedHashMap<String, Supplier<String[]>> areaArgs = new LinkedHashMap<String, Supplier<String[]>>(filledShapeArgs);
        areaArgs.put(ARG_YTOP, emptySupplier);
        areaArgs.put(ARG_YBOTTOM, emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> circleArgs = new LinkedHashMap<String, Supplier<String[]>>(filledShapeArgs);
        circleArgs.put(ARG_RADIUS, emptySupplier);
        circleArgs.put(ARG_RADIUSX, emptySupplier);
        circleArgs.put(ARG_RADIUSZ, emptySupplier);
        LinkedHashMap<String, Supplier<String[]>> iconArgs = new LinkedHashMap<String, Supplier<String[]>>(sharedArgs);
        iconArgs.putAll(fileArg);
        LinkedHashMap<String, Supplier<String[]>> updateSetArgs = new LinkedHashMap<String, Supplier<String[]>>(setArgs);
        updateSetArgs.putAll(newLabelArg);
        LinkedHashMap<String, Supplier<String[]>> updateMarkerArgs = new LinkedHashMap<String, Supplier<String[]>>(markerArgs);
        updateMarkerArgs.putAll(newLabelArg);
        updateMarkerArgs.putAll(newSetArg);
        LinkedHashMap<String, Supplier<String[]>> updateLineArgs = new LinkedHashMap<String, Supplier<String[]>>(shapeArgs);
        updateLineArgs.putAll(newLabelArg);
        updateLineArgs.putAll(newSetArg);
        LinkedHashMap<String, Supplier<String[]>> updateAreaArgs = new LinkedHashMap<String, Supplier<String[]>>(areaArgs);
        updateAreaArgs.putAll(newLabelArg);
        updateAreaArgs.putAll(newSetArg);
        LinkedHashMap<String, Supplier<String[]>> updateCircleArgs = new LinkedHashMap<String, Supplier<String[]>>(circleArgs);
        updateCircleArgs.putAll(newLabelArg);
        updateCircleArgs.putAll(newSetArg);
        LinkedHashMap<String, Supplier<String[]>> updateIconArgs = new LinkedHashMap<String, Supplier<String[]>>(iconArgs);
        updateIconArgs.putAll(newLabelArg);
        LinkedHashMap<String, Supplier<String[]>> moveHereArgs = new LinkedHashMap<String, Supplier<String[]>>(sharedArgs);
        moveHereArgs.putAll(markerSetArg);
        LinkedHashMap<String, Supplier<String[]>> deleteArgs = new LinkedHashMap<String, Supplier<String[]>>(sharedArgs);
        deleteArgs.putAll(markerSetArg);
        LinkedHashMap<String, Supplier<String[]>> descArgs = new LinkedHashMap<String, Supplier<String[]>>(sharedArgs);
        descArgs.putAll(markerSetArg);
        descArgs.put(ARG_TYPE, () -> typeValue);
        LinkedHashMap<String, Supplier<String[]>> importArgs = new LinkedHashMap<String, Supplier<String[]>>(descArgs);
        importArgs.putAll(fileArg);
        LinkedHashMap<String, Supplier<String[]>> appendArgs = new LinkedHashMap<String, Supplier<String[]>>(descArgs);
        appendArgs.put(ARG_DESC, emptySupplier);
        this.tabCompletions = new HashMap<String, Map<String, Supplier<String[]>>>();
        this.tabCompletions.put("add", markerArgs);
        this.tabCompletions.put("addicon", iconArgs);
        this.tabCompletions.put("addarea", areaArgs);
        this.tabCompletions.put("addline", shapeArgs);
        this.tabCompletions.put("addcircle", circleArgs);
        this.tabCompletions.put("addset", setArgs);
        this.tabCompletions.put("update", updateMarkerArgs);
        this.tabCompletions.put("updateicon", updateIconArgs);
        this.tabCompletions.put("updatearea", updateAreaArgs);
        this.tabCompletions.put("updateline", updateLineArgs);
        this.tabCompletions.put("updatecircle", updateCircleArgs);
        this.tabCompletions.put("updateset", updateSetArgs);
        this.tabCompletions.put("movehere", moveHereArgs);
        this.tabCompletions.put("delete", deleteArgs);
        this.tabCompletions.put("deleteicon", sharedArgs);
        this.tabCompletions.put("deletearea", deleteArgs);
        this.tabCompletions.put("deleteline", deleteArgs);
        this.tabCompletions.put("deletecircle", deleteArgs);
        this.tabCompletions.put("deleteset", sharedArgs);
        this.tabCompletions.put("list", markerSetArg);
        this.tabCompletions.put("listareas", markerSetArg);
        this.tabCompletions.put("listlines", markerSetArg);
        this.tabCompletions.put("listcircles", markerSetArg);
        this.tabCompletions.put("getdesc", descArgs);
        this.tabCompletions.put("importdesc", importArgs);
        this.tabCompletions.put("resetdesc", descArgs);
        this.tabCompletions.put("getlabel", descArgs);
        this.tabCompletions.put("importlabel", importArgs);
        this.tabCompletions.put("appenddesc", appendArgs);
    }

    public void scheduleWriteJob() {
        this.core.getServer().scheduleServerTask(new DoFileWrites(), 20L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(DynmapCore plugin) {
        plugin.events.removeListener("worldactivated", api);
        this.stop = true;
        this.lock.readLock().lock();
        try {
            if (this.dirty_markers) {
                this.doSaveMarkers();
                this.dirty_markers = false;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            for (MarkerIconImpl icn : this.markericons.values()) {
                icn.cleanup();
            }
            this.markericons.clear();
            for (MarkerSetImpl set : this.markersets.values()) {
                set.cleanup();
            }
            this.markersets.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private MarkerIcon createBuiltinMarkerIcon(String id, String label) {
        if (this.markericons.containsKey(id)) {
            return null;
        }
        MarkerIconImpl ico = new MarkerIconImpl(id, label, true);
        this.markericons.put(id, ico);
        return ico;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishMarkerIcon(MarkerIcon ico) {
        byte[] buf = new byte[512];
        InputStream in = null;
        File infile = new File(this.markerdir, ico.getMarkerIconID() + ".png");
        BufferedImage im = null;
        if (ico.isBuiltIn()) {
            in = this.getClass().getResourceAsStream("/markers/" + ico.getMarkerIconID() + ".png");
        } else if (infile.canRead()) {
            try {
                im = ImageIO.read(infile);
            }
            catch (IOException iOException) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            if (im != null) {
                MarkerIconImpl icon = (MarkerIconImpl)ico;
                int w = im.getWidth();
                if (w <= 8) {
                    icon.setMarkerIconSize(MarkerIcon.MarkerSize.MARKER_8x8);
                } else if (w > 16) {
                    icon.setMarkerIconSize(MarkerIcon.MarkerSize.MARKER_32x32);
                } else {
                    icon.setMarkerIconSize(MarkerIcon.MarkerSize.MARKER_16x16);
                }
                im.flush();
            }
            try {
                in = new FileInputStream(infile);
            }
            catch (IOException iox) {
                Log.severe("Error opening marker " + infile.getPath() + " - " + iox);
            }
        }
        if (in == null && (in = this.getClass().getResourceAsStream("/markers/marker.png")) == null) {
            return;
        }
        try {
            int len;
            BufferOutputStream bos = new BufferOutputStream();
            while ((len = in.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            this.core.getDefaultMapStorage().setMarkerImage(ico.getMarkerIconID(), bos);
        }
        catch (IOException iox) {
            Log.severe("Error writing marker to tilespath");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public Set<MarkerSet> getMarkerSets() {
        return new HashSet<MarkerSet>(this.markersets.values());
    }

    @Override
    public MarkerSet getMarkerSet(String id) {
        return this.markersets.get(id);
    }

    @Override
    public MarkerSet createMarkerSet(String id, String lbl, Set<MarkerIcon> iconlimit, boolean persistent) {
        if (this.markersets.containsKey(id)) {
            return null;
        }
        MarkerSetImpl set = new MarkerSetImpl(id, lbl, iconlimit, persistent);
        this.markersets.put(id, set);
        if (persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.markerSetUpdated(set, MarkerUpdate.CREATED);
        return set;
    }

    @Override
    public Set<MarkerIcon> getMarkerIcons() {
        return new HashSet<MarkerIcon>(this.markericons.values());
    }

    @Override
    public MarkerIcon getMarkerIcon(String id) {
        return this.markericons.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadMarkerIconStream(String id, InputStream in) {
        File f = new File(this.markerdir, id + ".png");
        FileOutputStream fos = null;
        try {
            int len;
            byte[] buf = new byte[512];
            fos = new FileOutputStream(f);
            while ((len = in.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
        }
        catch (IOException iox) {
            Log.severe("Error copying marker - " + f.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public MarkerIcon createMarkerIcon(String id, String label, InputStream marker_png) {
        if (this.markericons.containsKey(id)) {
            return null;
        }
        MarkerIconImpl ico = new MarkerIconImpl(id, label, false);
        if (!this.loadMarkerIconStream(id, marker_png)) {
            return null;
        }
        this.markericons.put(id, ico);
        this.publishMarkerIcon(ico);
        MarkerAPIImpl.saveMarkers();
        return ico;
    }

    static MarkerIconImpl getMarkerIconImpl(String id) {
        if (api != null) {
            return MarkerAPIImpl.api.markericons.get(id);
        }
        return null;
    }

    @Override
    public Set<PlayerSet> getPlayerSets() {
        return new HashSet<PlayerSet>(this.playersets.values());
    }

    @Override
    public PlayerSet getPlayerSet(String id) {
        return this.playersets.get(id);
    }

    @Override
    public PlayerSet createPlayerSet(String id, boolean symmetric, Set<String> players, boolean persistent) {
        if (this.playersets.containsKey(id)) {
            return null;
        }
        PlayerSetImpl set = new PlayerSetImpl(id, symmetric, players, persistent);
        this.playersets.put(id, set);
        if (persistent) {
            MarkerAPIImpl.saveMarkers();
        }
        MarkerAPIImpl.playerSetUpdated(set, MarkerUpdate.CREATED);
        return set;
    }

    static void saveMarkers() {
        if (api != null) {
            MarkerAPIImpl.api.dirty_markers = true;
        }
    }

    private void doSaveMarkers() {
        if (api != null) {
            final ConfigurationNode conf = new ConfigurationNode(MarkerAPIImpl.api.markerpersist);
            HashMap<String, Map<String, Object>> icons = new HashMap<String, Map<String, Object>>();
            for (String string : MarkerAPIImpl.api.markericons.keySet()) {
                MarkerIconImpl ico = MarkerAPIImpl.api.markericons.get(string);
                Map<String, Object> dat = ico.getPersistentData();
                if (dat == null) continue;
                icons.put(string, dat);
            }
            conf.put("icons", (Object)icons);
            HashMap<String, Map<String, Object>> sets = new HashMap<String, Map<String, Object>>();
            for (String id : MarkerAPIImpl.api.markersets.keySet()) {
                Map<String, Object> dat;
                MarkerSetImpl set = MarkerAPIImpl.api.markersets.get(id);
                if (!set.isMarkerSetPersistent() || (dat = set.getPersistentData()) == null) continue;
                sets.put(id, dat);
            }
            conf.put("sets", (Object)sets);
            HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
            for (String id : MarkerAPIImpl.api.playersets.keySet()) {
                Map<String, Object> dat;
                PlayerSetImpl set = MarkerAPIImpl.api.playersets.get(id);
                if (!set.isPersistentSet() || (dat = set.getPersistentData()) == null) continue;
                hashMap.put(id, dat);
            }
            conf.put("playersets", (Object)hashMap);
            MapManager.scheduleDelayedJob(new Runnable(){

                @Override
                public void run() {
                    if (api.markerpersist_old.exists()) {
                        api.markerpersist_old.delete();
                    }
                    if (api.markerpersist.exists()) {
                        api.markerpersist.renameTo(api.markerpersist_old);
                    }
                    if (!conf.save()) {
                        Log.severe("Error writing markers - " + api.markerpersist.getPath());
                    }
                }
            }, 0L);
            api.freshenMarkerFiles();
        }
    }

    private void freshenMarkerFiles() {
        if (MapManager.mapman != null) {
            for (DynmapWorld w : MapManager.mapman.worlds) {
                this.dirty_worlds.put(w.getName(), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadMarkers() {
        ConfigurationNode conf = new ConfigurationNode(MarkerAPIImpl.api.markerpersist);
        conf.load();
        this.lock.writeLock().lock();
        try {
            ConfigurationNode configurationNode;
            ConfigurationNode icons = conf.getNode("icons");
            if (icons == null) {
                boolean bl = false;
                return bl;
            }
            for (String string : icons.keySet()) {
                MarkerIconImpl ico = new MarkerIconImpl(string);
                if (!ico.loadPersistentData(icons.getNode(string))) continue;
                this.markericons.put(string, ico);
            }
            ConfigurationNode sets = conf.getNode("sets");
            if (sets != null) {
                for (String id : sets.keySet()) {
                    MarkerSetImpl set = new MarkerSetImpl(id);
                    if (!set.loadPersistentData(sets.getNode(id))) continue;
                    this.markersets.put(id, set);
                }
            }
            if ((configurationNode = conf.getNode("playersets")) != null) {
                for (String id : configurationNode.keySet()) {
                    PlayerSetImpl set = new PlayerSetImpl(id);
                    if (!set.loadPersistentData(sets.getNode(id))) continue;
                    this.playersets.put(id, set);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return true;
    }

    static void markerUpdated(MarkerImpl marker, MarkerUpdate update) {
        if (api != null) {
            MarkerAPIImpl.api.dirty_worlds.put(marker.getNormalizedWorld(), "");
        }
        if (MapManager.mapman != null) {
            MapManager.mapman.pushUpdate(marker.getNormalizedWorld(), (Client.Update)new MarkerUpdated(marker, update == MarkerUpdate.DELETED));
        }
    }

    static void areaMarkerUpdated(AreaMarkerImpl marker, MarkerUpdate update) {
        if (api != null) {
            MarkerAPIImpl.api.dirty_worlds.put(marker.getNormalizedWorld(), "");
        }
        if (MapManager.mapman != null) {
            MapManager.mapman.pushUpdate(marker.getNormalizedWorld(), (Client.Update)new AreaMarkerUpdated(marker, update == MarkerUpdate.DELETED));
        }
    }

    static void polyLineMarkerUpdated(PolyLineMarkerImpl marker, MarkerUpdate update) {
        if (api != null) {
            MarkerAPIImpl.api.dirty_worlds.put(marker.getNormalizedWorld(), "");
        }
        if (MapManager.mapman != null) {
            MapManager.mapman.pushUpdate(marker.getNormalizedWorld(), (Client.Update)new PolyLineMarkerUpdated(marker, update == MarkerUpdate.DELETED));
        }
    }

    static void circleMarkerUpdated(CircleMarkerImpl marker, MarkerUpdate update) {
        if (api != null) {
            MarkerAPIImpl.api.dirty_worlds.put(marker.getNormalizedWorld(), "");
        }
        if (MapManager.mapman != null) {
            MapManager.mapman.pushUpdate(marker.getNormalizedWorld(), (Client.Update)new CircleMarkerUpdated(marker, update == MarkerUpdate.DELETED));
        }
    }

    static void markerSetUpdated(MarkerSetImpl markerset, MarkerUpdate update) {
        if (api != null) {
            api.freshenMarkerFiles();
        }
        if (MapManager.mapman != null) {
            MapManager.mapman.pushUpdate(new MarkerSetUpdated(markerset, update == MarkerUpdate.DELETED));
        }
    }

    static void playerSetUpdated(PlayerSetImpl pset, MarkerUpdate update) {
        if (api != null) {
            MarkerAPIImpl.api.core.events.trigger("playersetupdated", null);
        }
    }

    static void removeMarkerSet(MarkerSetImpl markerset) {
        if (api != null) {
            MarkerAPIImpl.api.markersets.remove(markerset.getMarkerSetID());
            if (markerset.isMarkerSetPersistent()) {
                MarkerAPIImpl.saveMarkers();
            }
            MarkerAPIImpl.markerSetUpdated(markerset, MarkerUpdate.DELETED);
        }
    }

    static void removePlayerSet(PlayerSetImpl pset) {
        if (api != null) {
            MarkerAPIImpl.api.playersets.remove(pset.getSetID());
            if (pset.isPersistentSet()) {
                MarkerAPIImpl.saveMarkers();
            }
            MarkerAPIImpl.playerSetUpdated(pset, MarkerUpdate.DELETED);
        }
    }

    private static boolean processAreaArgs(DynmapCommandSender sender, AreaMarker marker, Map<String, String> parms) {
        String val = null;
        String val2 = null;
        try {
            String subtitle;
            String title;
            double ytop = marker.getTopY();
            double ybottom = marker.getBottomY();
            int scolor = marker.getLineColor();
            int fcolor = marker.getFillColor();
            double sopacity = marker.getLineOpacity();
            double fopacity = marker.getFillOpacity();
            int sweight = marker.getLineWeight();
            boolean boost = marker.getBoostFlag();
            int minzoom = marker.getMinZoom();
            int maxzoom = marker.getMaxZoom();
            EnterExitMarker.EnterExitText greet = marker.getGreetingText();
            EnterExitMarker.EnterExitText farew = marker.getFarewellText();
            val = parms.get(ARG_STROKECOLOR);
            if (val != null) {
                scolor = Integer.parseInt(val, 16);
            }
            if ((val = parms.get(ARG_FILLCOLOR)) != null) {
                fcolor = Integer.parseInt(val, 16);
            }
            if ((val = parms.get(ARG_STROKEOPACITY)) != null) {
                sopacity = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_FILLOPACITY)) != null) {
                fopacity = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_STROKEWEIGHT)) != null) {
                sweight = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_YTOP)) != null) {
                ytop = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_YBOTTOM)) != null) {
                ybottom = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_MINZOOM)) != null) {
                minzoom = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_MAXZOOM)) != null) {
                maxzoom = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_BOOST)) != null) {
                if (MarkerAPIImpl.api.core.checkPlayerPermission(sender, "marker.boost")) {
                    boost = val.equals("true");
                } else {
                    sender.sendMessage("No permission to set boost flag");
                    return false;
                }
            }
            marker.setLineStyle(sweight, sopacity, scolor);
            marker.setFillStyle(fopacity, fcolor);
            if (ytop >= ybottom) {
                marker.setRangeY(ytop, ybottom);
            } else {
                marker.setRangeY(ybottom, ytop);
            }
            marker.setBoostFlag(boost);
            marker.setMinZoom(minzoom);
            marker.setMaxZoom(maxzoom);
            val = parms.get(ARG_GREETING);
            val2 = parms.get(ARG_GREETINGSUB);
            if (val != null || val2 != null) {
                String string = val != null ? (val.length() > 0 ? val : null) : (title = greet != null ? greet.title : null);
                subtitle = val2 != null ? (val2.length() > 0 ? val2 : null) : (greet != null ? greet.subtitle : null);
                marker.setGreetingText(title, subtitle);
            }
            val = parms.get(ARG_FAREWELL);
            val2 = parms.get(ARG_FAREWELLSUB);
            if (val != null || val2 != null) {
                String string = val != null ? (val.length() > 0 ? val : null) : (title = farew != null ? farew.title : null);
                subtitle = val2 != null ? (val2.length() > 0 ? val2 : null) : (farew != null ? farew.subtitle : null);
                marker.setFarewellText(title, subtitle);
            }
        }
        catch (NumberFormatException nfx) {
            sender.sendMessage("Invalid parameter format: " + val);
            return false;
        }
        return true;
    }

    private static boolean processPolyArgs(DynmapCommandSender sender, PolyLineMarker marker, Map<String, String> parms) {
        String val = null;
        try {
            int scolor = marker.getLineColor();
            double sopacity = marker.getLineOpacity();
            int sweight = marker.getLineWeight();
            int minzoom = marker.getMinZoom();
            int maxzoom = marker.getMaxZoom();
            val = parms.get(ARG_STROKECOLOR);
            if (val != null) {
                scolor = Integer.parseInt(val, 16);
            }
            if ((val = parms.get(ARG_STROKEOPACITY)) != null) {
                sopacity = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_STROKEWEIGHT)) != null) {
                sweight = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_MINZOOM)) != null) {
                minzoom = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_MAXZOOM)) != null) {
                maxzoom = Integer.parseInt(val);
            }
            marker.setLineStyle(sweight, sopacity, scolor);
            marker.setMinZoom(minzoom);
            marker.setMaxZoom(maxzoom);
        }
        catch (NumberFormatException nfx) {
            sender.sendMessage("Invalid parameter format: " + val);
            return false;
        }
        return true;
    }

    private static boolean processCircleArgs(DynmapCommandSender sender, CircleMarker marker, Map<String, String> parms) {
        String val = null;
        String val2 = null;
        try {
            String subtitle;
            String title;
            int scolor = marker.getLineColor();
            int fcolor = marker.getFillColor();
            double sopacity = marker.getLineOpacity();
            double fopacity = marker.getFillOpacity();
            int sweight = marker.getLineWeight();
            double xr = marker.getRadiusX();
            double zr = marker.getRadiusZ();
            double x = marker.getCenterX();
            double y = marker.getCenterY();
            double z = marker.getCenterZ();
            String world = marker.getWorld();
            boolean boost = marker.getBoostFlag();
            int minzoom = marker.getMinZoom();
            int maxzoom = marker.getMaxZoom();
            EnterExitMarker.EnterExitText greet = marker.getGreetingText();
            EnterExitMarker.EnterExitText farew = marker.getFarewellText();
            val = parms.get(ARG_STROKECOLOR);
            if (val != null) {
                scolor = Integer.parseInt(val, 16);
            }
            if ((val = parms.get(ARG_FILLCOLOR)) != null) {
                fcolor = Integer.parseInt(val, 16);
            }
            if ((val = parms.get(ARG_STROKEOPACITY)) != null) {
                sopacity = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_FILLOPACITY)) != null) {
                fopacity = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_STROKEWEIGHT)) != null) {
                sweight = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_X)) != null) {
                x = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_Y)) != null) {
                y = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_Z)) != null) {
                z = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_WORLD)) != null) {
                world = val;
            }
            if ((val = parms.get(ARG_RADIUSX)) != null) {
                xr = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_RADIUSZ)) != null) {
                zr = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_RADIUS)) != null) {
                xr = zr = Double.parseDouble(val);
            }
            if ((val = parms.get(ARG_BOOST)) != null) {
                if (MarkerAPIImpl.api.core.checkPlayerPermission(sender, "marker.boost")) {
                    boost = val.equals("true");
                } else {
                    sender.sendMessage("No permission to set boost flag");
                    return false;
                }
            }
            if ((val = parms.get(ARG_MINZOOM)) != null) {
                minzoom = Integer.parseInt(val);
            }
            if ((val = parms.get(ARG_MAXZOOM)) != null) {
                maxzoom = Integer.parseInt(val);
            }
            marker.setCenter(world, x, y, z);
            marker.setLineStyle(sweight, sopacity, scolor);
            marker.setFillStyle(fopacity, fcolor);
            marker.setRadius(xr, zr);
            marker.setBoostFlag(boost);
            marker.setMinZoom(minzoom);
            marker.setMaxZoom(maxzoom);
            val = parms.get(ARG_GREETING);
            val2 = parms.get(ARG_GREETINGSUB);
            if (val != null || val2 != null) {
                String string = val != null ? (val.length() > 0 ? val : null) : (title = greet != null ? greet.title : null);
                subtitle = val2 != null ? (val2.length() > 0 ? val2 : null) : (greet != null ? greet.subtitle : null);
                marker.setGreetingText(title, subtitle);
            }
            val = parms.get(ARG_FAREWELL);
            val2 = parms.get(ARG_FAREWELLSUB);
            if (val != null || val2 != null) {
                String string = val != null ? (val.length() > 0 ? val : null) : (title = farew != null ? farew.title : null);
                subtitle = val2 != null ? (val2.length() > 0 ? val2 : null) : (farew != null ? farew.subtitle : null);
                marker.setFarewellText(title, subtitle);
            }
        }
        catch (NumberFormatException nfx) {
            sender.sendMessage("Invalid parameter format: " + val);
            return false;
        }
        return true;
    }

    private static Map<String, String> parseArgs(String[] args, DynmapCommandSender snd) {
        HashMap<String, String> rslt = new HashMap<String, String>();
        String cmdline = "";
        for (int i = 1; i < args.length; ++i) {
            cmdline = cmdline + args[i] + " ";
        }
        boolean inquote = false;
        StringBuilder sb = new StringBuilder();
        String varid = null;
        for (int i = 0; i < cmdline.length(); ++i) {
            char c = cmdline.charAt(i);
            if (inquote) {
                if (c == '\"') {
                    inquote = false;
                    if (varid == null) {
                        rslt.put(ARG_LABEL, sb.toString());
                    } else {
                        rslt.put(varid, sb.toString());
                        varid = null;
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '\"') {
                inquote = true;
                continue;
            }
            if (c == ':') {
                varid = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == ' ') {
                if (varid == null) {
                    if (sb.length() > 0) {
                        rslt.put(ARG_LABEL, sb.toString());
                    }
                } else {
                    rslt.put(varid, sb.toString());
                    varid = null;
                }
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (inquote) {
            snd.sendMessage("Error: unclosed doublequote");
            return null;
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean onCommand(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        String c;
        if (api == null) {
            sender.sendMessage("Markers component is not enabled.");
            return false;
        }
        if (args.length == 0) {
            return false;
        }
        DynmapPlayer player = null;
        if (sender instanceof DynmapPlayer) {
            player = (DynmapPlayer)sender;
        }
        if (!commands.contains(c = args[0])) {
            return false;
        }
        MarkerAPIImpl.api.lock.readLock().lock();
        try {
            if (c.equals("list") && plugin.checkPlayerPermission(sender, "marker.list")) {
                boolean bl = MarkerAPIImpl.processListMarker(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("icons") && plugin.checkPlayerPermission(sender, "marker.icons")) {
                boolean bl = MarkerAPIImpl.processListIcon(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("listsets") && plugin.checkPlayerPermission(sender, "marker.listsets")) {
                boolean bl = MarkerAPIImpl.processListSet(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("listareas") && plugin.checkPlayerPermission(sender, "marker.listareas")) {
                boolean bl = MarkerAPIImpl.processListArea(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("listlines") && plugin.checkPlayerPermission(sender, "marker.listlines")) {
                boolean bl = MarkerAPIImpl.processListLine(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("listcircles") && plugin.checkPlayerPermission(sender, "marker.listcircles")) {
                boolean bl = MarkerAPIImpl.processListCircle(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("getlabel") && plugin.checkPlayerPermission(sender, "marker.getlabel")) {
                boolean bl = MarkerAPIImpl.processGetLabel(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
        }
        finally {
            MarkerAPIImpl.api.lock.readLock().unlock();
        }
        MarkerAPIImpl.api.lock.writeLock().lock();
        try {
            if (c.equals("add") && MarkerAPIImpl.api.core.checkPlayerPermission(sender, "marker.add")) {
                boolean bl = MarkerAPIImpl.processAddMarker(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("movehere") && plugin.checkPlayerPermission(sender, "marker.movehere")) {
                boolean bl = MarkerAPIImpl.processMoveHere(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("update") && plugin.checkPlayerPermission(sender, "marker.update")) {
                boolean bl = MarkerAPIImpl.processUpdateMarker(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("delete") && plugin.checkPlayerPermission(sender, "marker.delete")) {
                boolean bl = MarkerAPIImpl.processDeleteMarker(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("addset") && plugin.checkPlayerPermission(sender, "marker.addset")) {
                boolean bl = MarkerAPIImpl.processAddSet(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("updateset") && plugin.checkPlayerPermission(sender, "marker.updateset")) {
                boolean bl = MarkerAPIImpl.processUpdateSet(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("deleteset") && plugin.checkPlayerPermission(sender, "marker.deleteset")) {
                boolean bl = MarkerAPIImpl.processDeleteSet(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("addicon") && plugin.checkPlayerPermission(sender, "marker.addicon")) {
                boolean bl = MarkerAPIImpl.processAddIcon(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("updateicon") && plugin.checkPlayerPermission(sender, "marker.updateicon")) {
                boolean bl = MarkerAPIImpl.processUpdateIcon(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("deleteicon") && plugin.checkPlayerPermission(sender, "marker.deleteicon")) {
                boolean bl = MarkerAPIImpl.processDeleteIcon(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("addcorner") && plugin.checkPlayerPermission(sender, "marker.addarea")) {
                boolean bl = MarkerAPIImpl.processAddCorner(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("clearcorners") && plugin.checkPlayerPermission(sender, "marker.addarea")) {
                boolean bl = MarkerAPIImpl.processClearCorners(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("addarea") && plugin.checkPlayerPermission(sender, "marker.addarea")) {
                boolean bl = MarkerAPIImpl.processAddArea(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("deletearea") && plugin.checkPlayerPermission(sender, "marker.deletearea")) {
                boolean bl = MarkerAPIImpl.processDeleteArea(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("updatearea") && plugin.checkPlayerPermission(sender, "marker.updatearea")) {
                boolean bl = MarkerAPIImpl.processUpdateArea(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("addline") && plugin.checkPlayerPermission(sender, "marker.addline")) {
                boolean bl = MarkerAPIImpl.processAddLine(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("deleteline") && plugin.checkPlayerPermission(sender, "marker.deleteline")) {
                boolean bl = MarkerAPIImpl.processDeleteLine(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("updateline") && plugin.checkPlayerPermission(sender, "marker.updateline")) {
                boolean bl = MarkerAPIImpl.processUpdateLine(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("addcircle") && plugin.checkPlayerPermission(sender, "marker.addcircle")) {
                boolean bl = MarkerAPIImpl.processAddCircle(plugin, sender, cmd, commandLabel, args, player);
                return bl;
            }
            if (c.equals("deletecircle") && plugin.checkPlayerPermission(sender, "marker.deletecircle")) {
                boolean bl = MarkerAPIImpl.processDeleteCircle(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("updatecircle") && plugin.checkPlayerPermission(sender, "marker.updatecircle")) {
                boolean bl = MarkerAPIImpl.processUpdateCircle(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("getdesc") && plugin.checkPlayerPermission(sender, "marker.getdesc")) {
                boolean bl = MarkerAPIImpl.processGetDesc(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("resetdesc") && plugin.checkPlayerPermission(sender, "marker.resetdesc")) {
                boolean bl = MarkerAPIImpl.processResetDesc(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("appenddesc") && plugin.checkPlayerPermission(sender, "marker.appenddesc")) {
                boolean bl = MarkerAPIImpl.processAppendDesc(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("importdesc") && plugin.checkPlayerPermission(sender, "marker.importdesc")) {
                boolean bl = MarkerAPIImpl.processImportDesc(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            if (c.equals("importlabel") && plugin.checkPlayerPermission(sender, "marker.importlabel")) {
                boolean bl = MarkerAPIImpl.processImportLabel(plugin, sender, cmd, commandLabel, args);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            MarkerAPIImpl.api.lock.writeLock().unlock();
        }
    }

    public List<String> getTabCompletions(DynmapCommandSender sender, String[] args, DynmapCore core) {
        String cmd;
        if ((args = DynmapCore.parseArgs(args, sender, true)) == null || args.length <= 1) {
            return Collections.emptyList();
        }
        if (this.tabCompletions == null) {
            this.initTabCompletions();
        }
        if ((cmd = args[0]).equals("addcorner") && core.checkPlayerPermission(sender, "marker.addarea")) {
            if (args.length == 5) {
                return core.getWorldSuggestions(args[4]);
            }
        } else if (core.checkPlayerPermission(sender, "marker." + cmd) && this.tabCompletions.containsKey(cmd)) {
            return core.getFieldValueSuggestions(args, this.tabCompletions.get(cmd));
        }
        return Collections.emptyList();
    }

    private static boolean processAddMarker(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        if (args.length > 1) {
            boolean isMarkup;
            Marker m;
            MarkerSet set;
            String normalized_world;
            String world;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String iconid = parms.get(ARG_ICON);
            String setid = parms.get(ARG_SET);
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String markup = parms.get(ARG_MARKUP);
            String x = parms.get(ARG_X);
            String y = parms.get(ARG_Y);
            String z = parms.get(ARG_Z);
            String minzoom = parms.get(ARG_MINZOOM);
            int min_zoom = -1;
            if (minzoom != null) {
                try {
                    min_zoom = Integer.parseInt(minzoom);
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid minzoom: " + minzoom);
                    return true;
                }
            }
            String maxzoom = parms.get(ARG_MAXZOOM);
            int max_zoom = -1;
            if (maxzoom != null) {
                try {
                    max_zoom = Integer.parseInt(maxzoom);
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid maxzoom: " + maxzoom);
                    return true;
                }
            }
            if ((world = DynmapWorld.normalizeWorldName(parms.get(ARG_WORLD))) != null && MarkerAPIImpl.api.core.getWorld(normalized_world = DynmapWorld.normalizeWorldName(world)) == null) {
                sender.sendMessage("Invalid world ID: " + world);
                return true;
            }
            DynmapLocation loc = null;
            if (x == null && y == null && z == null && world == null) {
                if (player == null) {
                    sender.sendMessage("Must be issued by player, or x, y, z, and world parameters are required");
                    return true;
                }
                loc = player.getLocation();
            } else if (x != null && y != null && z != null && world != null) {
                try {
                    loc = new DynmapLocation(world, Double.valueOf(x), Double.valueOf(y), Double.valueOf(z));
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Coordinates x, y, and z must be numbers");
                    return true;
                }
            } else {
                sender.sendMessage("Must be issued by player, or x, y, z, and world parameters are required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (!set.isMarkerSetPersistent()) {
                sender.sendMessage("Error: cannot add to non-persistent marker set - set is likely plugin owned");
                return true;
            }
            MarkerIcon ico = null;
            if (iconid == null) {
                ico = set.getDefaultMarkerIcon();
            }
            if (ico == null) {
                if (iconid == null) {
                    iconid = "default";
                }
                ico = api.getMarkerIcon(iconid);
            }
            if (ico == null) {
                sender.sendMessage("Error: invalid icon - " + iconid);
                return true;
            }
            if (minzoom != null) {
                // empty if block
            }
            if ((m = set.createMarker(id, label, isMarkup = "true".equals(markup), loc.world, loc.x, loc.y, loc.z, ico, true)) == null) {
                sender.sendMessage("Error creating marker");
            } else {
                if (min_zoom >= 0) {
                    m.setMinZoom(min_zoom);
                }
                if (max_zoom >= 0) {
                    m.setMaxZoom(max_zoom);
                }
                sender.sendMessage("Added marker id:'" + m.getMarkerID() + "' (" + m.getLabel() + ") to set '" + set.getMarkerSetID() + "'");
            }
        } else {
            sender.sendMessage("Marker label required");
        }
        return true;
    }

    private static boolean processMoveHere(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        if (player == null) {
            sender.sendMessage("Command can only be used by player");
        } else if (args.length > 1) {
            Marker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<marker-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + id);
                    return true;
                }
            } else {
                marker = set.findMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + label);
                    return true;
                }
            }
            DynmapLocation loc = player.getLocation();
            marker.setLocation(loc.world, loc.x, loc.y, loc.z);
            sender.sendMessage("Updated location of marker id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<marker-id> required");
        }
        return true;
    }

    private static boolean processUpdateMarker(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            String newlabel;
            Marker marker;
            MarkerSet set;
            String world;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String markup = parms.get(ARG_MARKUP);
            String setid = parms.get(ARG_SET);
            String newset = parms.get(ARG_NEWSET);
            String x = parms.get(ARG_X);
            String y = parms.get(ARG_Y);
            String z = parms.get(ARG_Z);
            String minzoom = parms.get(ARG_MINZOOM);
            int min_zoom = -1;
            if (minzoom != null) {
                try {
                    min_zoom = Integer.parseInt(minzoom);
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid minzoom: " + minzoom);
                    return true;
                }
            }
            String maxzoom = parms.get(ARG_MAXZOOM);
            int max_zoom = -1;
            if (maxzoom != null) {
                try {
                    max_zoom = Integer.parseInt(maxzoom);
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid maxzoom: " + maxzoom);
                    return true;
                }
            }
            if ((world = parms.get(ARG_WORLD)) != null && MarkerAPIImpl.api.core.getWorld(world) == null) {
                sender.sendMessage("Invalid world ID: " + world);
                return true;
            }
            DynmapLocation loc = null;
            if (x != null && y != null && z != null && world != null) {
                try {
                    loc = new DynmapLocation(world, Double.valueOf(x), Double.valueOf(y), Double.valueOf(z));
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Coordinates x, y, and z must be numbers");
                    return true;
                }
            }
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<marker-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + id);
                    return true;
                }
            } else {
                marker = set.findMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + label);
                    return true;
                }
            }
            if ((newlabel = parms.get(ARG_NEWLABEL)) != null) {
                marker.setLabel(newlabel, "true".equals(markup));
            } else if (markup != null) {
                marker.setLabel(marker.getLabel(), "true".equals(markup));
            }
            String iconid = parms.get(ARG_ICON);
            if (iconid != null) {
                MarkerIcon ico = api.getMarkerIcon(iconid);
                if (ico == null) {
                    sender.sendMessage("Error: invalid icon - " + iconid);
                    return true;
                }
                marker.setMarkerIcon(ico);
            }
            if (loc != null) {
                marker.setLocation(loc.world, loc.x, loc.y, loc.z);
            }
            if (min_zoom >= 0) {
                marker.setMinZoom(min_zoom);
            }
            if (max_zoom >= 0) {
                marker.setMaxZoom(max_zoom);
            }
            if (newset != null) {
                MarkerSet ms = api.getMarkerSet(newset);
                if (ms == null) {
                    sender.sendMessage("Error: invalid new marker set - " + newset);
                    return true;
                }
                marker.setMarkerSet(ms);
            }
            sender.sendMessage("Updated marker id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<marker-id> required");
        }
        return true;
    }

    private static boolean processDeleteMarker(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Marker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<marker-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + id);
                    return true;
                }
            } else {
                marker = set.findMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: marker not found - " + label);
                    return true;
                }
            }
            marker.deleteMarker();
            sender.sendMessage("Deleted marker id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<marker-id> required");
        }
        return true;
    }

    private static boolean processListMarker(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        MarkerSet set;
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        Set<Marker> markers = set.getMarkers();
        TreeMap<String, Marker> sortmarkers = new TreeMap<String, Marker>();
        for (Marker m : markers) {
            sortmarkers.put(m.getMarkerID(), m);
        }
        for (String s : sortmarkers.keySet()) {
            Marker m = (Marker)sortmarkers.get(s);
            String msg = m.getMarkerID() + ": label:\"" + m.getLabel() + "\", set:" + m.getMarkerSet().getMarkerSetID() + ", world:" + m.getWorld() + ", x:" + m.getX() + ", y:" + m.getY() + ", z:" + m.getZ() + ", icon:" + m.getMarkerIcon().getMarkerIconID() + ", markup:" + m.isLabelMarkup();
            if (m.getMinZoom() >= 0) {
                msg = msg + ", minzoom:" + m.getMinZoom();
            }
            if (m.getMaxZoom() >= 0) {
                msg = msg + ", maxzoom:" + m.getMaxZoom();
            }
            sender.sendMessage(msg);
        }
        return true;
    }

    private static boolean processListIcon(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        TreeSet<String> iconids = new TreeSet<String>(MarkerAPIImpl.api.markericons.keySet());
        for (String s : iconids) {
            MarkerIcon ico = MarkerAPIImpl.api.markericons.get(s);
            sender.sendMessage(ico.getMarkerIconID() + ": label:\"" + ico.getMarkerIconLabel() + "\", builtin:" + ico.isBuiltIn());
        }
        return true;
    }

    private static boolean processAddSet(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        if (args.length > 1) {
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String prio = parms.get(ARG_PRIO);
            String minzoom = parms.get(ARG_MINZOOM);
            String maxzoom = parms.get(ARG_MAXZOOM);
            String deficon = parms.get(ARG_DEFICON);
            if (deficon == null) {
                deficon = "default";
            }
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<marker-id> required");
                return true;
            }
            if (label == null) {
                label = id;
            }
            if (id == null) {
                id = label;
            }
            if ((set = api.getMarkerSet(id)) != null) {
                sender.sendMessage("Error: set already exists - id:" + set.getMarkerSetID());
                return true;
            }
            set = api.createMarkerSet(id, label, null, true);
            if (set == null) {
                sender.sendMessage("Error creating set");
            } else {
                MarkerIconImpl mi;
                String showlabels;
                String h = parms.get(ARG_HIDE);
                if (h != null && h.equals("true")) {
                    set.setHideByDefault(true);
                }
                if ((showlabels = parms.get(ARG_SHOWLABEL)) != null) {
                    if (showlabels.equals("true")) {
                        set.setLabelShow(true);
                    } else if (showlabels.equals("false")) {
                        set.setLabelShow(false);
                    }
                }
                if (prio != null) {
                    try {
                        set.setLayerPriority(Integer.valueOf(prio));
                    }
                    catch (NumberFormatException nfx) {
                        sender.sendMessage("Invalid priority: " + prio);
                    }
                }
                if ((mi = MarkerAPIImpl.getMarkerIconImpl(deficon)) != null) {
                    set.setDefaultMarkerIcon(mi);
                } else {
                    sender.sendMessage("Invalid default icon: " + deficon);
                }
                if (minzoom != null) {
                    try {
                        set.setMinZoom(Integer.valueOf(minzoom));
                    }
                    catch (NumberFormatException nfx) {
                        sender.sendMessage("Invalid min zoom: " + minzoom);
                    }
                }
                if (maxzoom != null) {
                    try {
                        set.setMaxZoom(Integer.valueOf(maxzoom));
                    }
                    catch (NumberFormatException nfx) {
                        sender.sendMessage("Invalid max zoom: " + maxzoom);
                    }
                }
                sender.sendMessage("Added set id:'" + set.getMarkerSetID() + "' (" + set.getMarkerSetLabel() + ")");
            }
        } else {
            sender.sendMessage("<label> or id:<set-id> required");
        }
        return true;
    }

    private static boolean processUpdateSet(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            String showlabels;
            String hide;
            String newlabel;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String prio = parms.get(ARG_PRIO);
            String minzoom = parms.get(ARG_MINZOOM);
            String maxzoom = parms.get(ARG_MAXZOOM);
            String deficon = parms.get(ARG_DEFICON);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<set-id> required");
                return true;
            }
            MarkerSet set = null;
            if (id != null) {
                set = api.getMarkerSet(id);
                if (set == null) {
                    sender.sendMessage("Error: set does not exist - id:" + id);
                    return true;
                }
            } else {
                Set<MarkerSet> sets = api.getMarkerSets();
                for (MarkerSet s : sets) {
                    if (!s.getMarkerSetLabel().equals(label)) continue;
                    set = s;
                    break;
                }
                if (set == null) {
                    sender.sendMessage("Error: matching set not found");
                    return true;
                }
            }
            if ((newlabel = parms.get(ARG_NEWLABEL)) != null) {
                set.setMarkerSetLabel(newlabel);
            }
            if ((hide = parms.get(ARG_HIDE)) != null) {
                set.setHideByDefault(hide.equals("true"));
            }
            if ((showlabels = parms.get(ARG_SHOWLABEL)) != null) {
                if (showlabels.equals("true")) {
                    set.setLabelShow(true);
                } else if (showlabels.equals("false")) {
                    set.setLabelShow(false);
                } else {
                    set.setLabelShow(null);
                }
            }
            if (deficon != null) {
                MarkerIconImpl mi = null;
                if (!deficon.equals("") && (mi = MarkerAPIImpl.getMarkerIconImpl(deficon)) == null) {
                    sender.sendMessage("Error: invalid marker icon - " + deficon);
                }
                set.setDefaultMarkerIcon(mi);
            }
            if (prio != null) {
                try {
                    set.setLayerPriority(Integer.valueOf(prio));
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid priority: " + prio);
                }
            }
            if (minzoom != null) {
                try {
                    set.setMinZoom(Integer.valueOf(minzoom));
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid min zoom: " + minzoom);
                }
            }
            if (maxzoom != null) {
                try {
                    set.setMaxZoom(Integer.valueOf(maxzoom));
                }
                catch (NumberFormatException nfx) {
                    sender.sendMessage("Invalid max zoom: " + maxzoom);
                }
            }
            sender.sendMessage("Set '" + set.getMarkerSetID() + "' updated");
        } else {
            sender.sendMessage("<label> or id:<set-id> required");
        }
        return true;
    }

    private static boolean processDeleteSet(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<set-id> required");
                return true;
            }
            if (id != null) {
                MarkerSet set = api.getMarkerSet(id);
                if (set == null) {
                    sender.sendMessage("Error: set does not exist - id:" + id);
                    return true;
                }
                set.deleteMarkerSet();
            } else {
                Set<MarkerSet> sets = api.getMarkerSets();
                MarkerSet set = null;
                for (MarkerSet s : sets) {
                    if (!s.getMarkerSetLabel().equals(label)) continue;
                    set = s;
                    break;
                }
                if (set == null) {
                    sender.sendMessage("Error: matching set not found");
                    return true;
                }
                set.deleteMarkerSet();
            }
            sender.sendMessage("Deleted set");
        } else {
            sender.sendMessage("<label> or id:<set-id> required");
        }
        return true;
    }

    private static boolean processListSet(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        TreeSet setids = new TreeSet(MarkerAPIImpl.api.markersets.keySet());
        for (String s : setids) {
            MarkerSet set = MarkerAPIImpl.api.markersets.get(s);
            Boolean b = set.getLabelShow();
            MarkerIcon defi = set.getDefaultMarkerIcon();
            String msg = set.getMarkerSetID() + ": label:\"" + set.getMarkerSetLabel() + "\", hide:" + set.getHideByDefault() + ", prio:" + set.getLayerPriority();
            if (defi != null) {
                msg = msg + ", deficon:" + defi.getMarkerIconID();
            }
            if (b != null) {
                msg = msg + ", showlabels:" + b;
            }
            if (set.getMinZoom() >= 0) {
                msg = msg + ", minzoom:" + set.getMinZoom();
            }
            if (set.getMaxZoom() >= 0) {
                msg = msg + ", maxzoom:" + set.getMaxZoom();
            }
            if (set.isMarkerSetPersistent()) {
                msg = msg + ", persistent=true";
            }
            sender.sendMessage(msg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean processAddIcon(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            MarkerIconImpl ico;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String file = parms.get(ARG_FILE);
            String label = parms.get(ARG_LABEL);
            if (id == null) {
                sender.sendMessage("id:<icon-id> required");
                return true;
            }
            if (file == null) {
                sender.sendMessage("file:\"filename\" required");
                return true;
            }
            if (label == null) {
                label = id;
            }
            if ((ico = MarkerAPIImpl.getMarkerIconImpl(id)) != null) {
                sender.sendMessage("Icon '" + id + "' already defined.");
                return true;
            }
            File iconf = new File(file);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(iconf);
                MarkerIcon mi = api.createMarkerIcon(id, label, fis);
                if (mi != null) return true;
                sender.sendMessage("Error creating icon");
                boolean bl = true;
                return bl;
            }
            catch (IOException iox) {
                sender.sendMessage("Error loading icon file - " + iox);
                return true;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        sender.sendMessage("id:<icon-id> and file:\"filename\" required");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processUpdateIcon(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String newlabel = parms.get(ARG_NEWLABEL);
            String file = parms.get(ARG_FILE);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<icon-id> required");
                return true;
            }
            MarkerIcon ico = null;
            if (id != null) {
                ico = MarkerAPIImpl.getMarkerIconImpl(id);
                if (ico == null) {
                    sender.sendMessage("Error: icon does not exist - id:" + id);
                    return true;
                }
            } else {
                Set<MarkerIcon> icons = api.getMarkerIcons();
                for (MarkerIcon ic : icons) {
                    if (!ic.getMarkerIconLabel().equals(label)) continue;
                    ico = ic;
                    break;
                }
                if (ico == null) {
                    sender.sendMessage("Error: matching icon not found");
                    return true;
                }
            }
            if (newlabel != null) {
                ico.setMarkerIconLabel(newlabel);
            }
            if (file != null) {
                File iconf = new File(file);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(iconf);
                    ico.setMarkerIconImage(fis);
                }
                catch (IOException iox) {
                    sender.sendMessage("Error loading icon file - " + iox);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            sender.sendMessage("Icon '" + ico.getMarkerIconID() + "' updated");
        } else {
            sender.sendMessage("<label> or id:<icon-id> required");
        }
        return true;
    }

    private static boolean processDeleteIcon(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<icon-id> required");
                return true;
            }
            if (id != null) {
                MarkerIconImpl ico = MarkerAPIImpl.getMarkerIconImpl(id);
                if (ico == null) {
                    sender.sendMessage("Error: icon does not exist - id:" + id);
                    return true;
                }
                ico.deleteIcon();
            } else {
                Set<MarkerIcon> icos = api.getMarkerIcons();
                MarkerIcon ico = null;
                for (MarkerIcon ic : icos) {
                    if (!ic.getMarkerIconLabel().equals(label)) continue;
                    ico = ic;
                    break;
                }
                if (ico == null) {
                    sender.sendMessage("Error: matching icon not found");
                    return true;
                }
                ico.deleteIcon();
            }
            sender.sendMessage("Deleted marker icon");
        } else {
            sender.sendMessage("<label> or id:<icon-id> required");
        }
        return true;
    }

    private static boolean processAddCorner(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        String id;
        DynmapLocation loc = null;
        if (player == null) {
            id = "-console-";
        } else {
            id = player.getName();
            loc = player.getLocation();
        }
        List<DynmapLocation> ll = MarkerAPIImpl.api.pointaccum.get(id);
        if (args.length > 3) {
            String w = null;
            if (args.length == 4) {
                if (ll == null) {
                    sender.sendMessage("First added corner needs world ID after coordinates");
                    return true;
                }
                w = ll.get((int)0).world;
            } else {
                w = args[4];
                if (MarkerAPIImpl.api.core.getWorld(w) == null) {
                    sender.sendMessage("Invalid world ID: " + args[3]);
                    return true;
                }
            }
            try {
                loc = new DynmapLocation(w, Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]));
            }
            catch (NumberFormatException nfx) {
                sender.sendMessage("Bad format: /dmarker addcorner <x> <y> <z> <world>");
                return true;
            }
        }
        if (loc == null) {
            sender.sendMessage("Console must supply corner coordinates: <x> <y> <z> <world>");
            return true;
        }
        if (ll == null) {
            ll = new ArrayList<DynmapLocation>();
            MarkerAPIImpl.api.pointaccum.put(id, ll);
        } else if (!ll.get((int)0).world.equals(loc.world)) {
            ll.clear();
        }
        ll.add(loc);
        sender.sendMessage("Added corner #" + ll.size() + " at {" + loc.x + "," + loc.y + "," + loc.z + "} to list");
        return true;
    }

    private static boolean processClearCorners(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        String id = player == null ? "-console-" : player.getName();
        MarkerAPIImpl.api.pointaccum.remove(id);
        sender.sendMessage("Cleared corner list");
        return true;
    }

    private static boolean processAddArea(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        MarkerSet set;
        String pid = player == null ? "-console-" : player.getName();
        List<DynmapLocation> ll = MarkerAPIImpl.api.pointaccum.get(pid);
        if (ll == null || ll.size() < 2) {
            sender.sendMessage("At least two corners must be added with /dmarker addcorner before an area can be added");
            return true;
        }
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        String id = parms.get(ARG_ID);
        String label = parms.get(ARG_LABEL);
        String markup = parms.get(ARG_MARKUP);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        if (!set.isMarkerSetPersistent()) {
            sender.sendMessage("Error: cannot add to non-persistent marker set - set is likely plugin owned");
            return true;
        }
        double[] xx = new double[ll.size()];
        double[] zz = new double[ll.size()];
        for (int i = 0; i < ll.size(); ++i) {
            DynmapLocation loc = ll.get(i);
            xx[i] = loc.x;
            zz[i] = loc.z;
        }
        AreaMarker m = set.createAreaMarker(id, label, "true".equals(markup), ll.get((int)0).world, xx, zz, true);
        if (m == null) {
            sender.sendMessage("Error creating area");
        } else {
            MarkerAPIImpl.processAreaArgs(sender, m, parms);
            sender.sendMessage("Added area id:'" + m.getMarkerID() + "' (" + m.getLabel() + ") to set '" + set.getMarkerSetID() + "'");
            MarkerAPIImpl.api.pointaccum.remove(pid);
        }
        return true;
    }

    private static boolean processListArea(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        MarkerSet set;
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        Set<AreaMarker> markers = set.getAreaMarkers();
        TreeMap<String, AreaMarker> sortmarkers = new TreeMap<String, AreaMarker>();
        for (AreaMarker m : markers) {
            sortmarkers.put(m.getMarkerID(), m);
        }
        for (String s : sortmarkers.keySet()) {
            EnterExitMarker.EnterExitText t;
            AreaMarker m = (AreaMarker)sortmarkers.get(s);
            String msg = m.getMarkerID() + ": label:\"" + m.getLabel() + "\", set:" + m.getMarkerSet().getMarkerSetID() + ", world:" + m.getWorld() + ", weight:" + m.getLineWeight() + ", color:" + String.format("%06x", m.getLineColor()) + ", opacity:" + m.getLineOpacity() + ", fillcolor:" + String.format("%06x", m.getFillColor()) + ", fillopacity:" + m.getFillOpacity() + ", boost:" + m.getBoostFlag() + ", markup:" + m.isLabelMarkup();
            if (m.getMinZoom() >= 0) {
                msg = msg + ", minzoom:" + m.getMinZoom();
            }
            if (m.getMaxZoom() >= 0) {
                msg = msg + ", maxzoom:" + m.getMaxZoom();
            }
            if ((t = m.getGreetingText()) != null) {
                if (t.title != null) {
                    msg = msg + ", greeting:\"" + t.title + "\"";
                }
                if (t.subtitle != null) {
                    msg = msg + ", greetingsub:\"" + t.subtitle + "\"";
                }
            }
            if ((t = m.getFarewellText()) != null) {
                if (t.title != null) {
                    msg = msg + ", farewell:\"" + t.title + "\"";
                }
                if (t.subtitle != null) {
                    msg = msg + ", farewellsub:\"" + t.subtitle + "\"";
                }
            }
            sender.sendMessage(msg);
        }
        return true;
    }

    private static boolean processDeleteArea(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            AreaMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<area-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findAreaMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: area not found - " + id);
                    return true;
                }
            } else {
                marker = set.findAreaMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: area not found - " + label);
                    return true;
                }
            }
            marker.deleteMarker();
            sender.sendMessage("Deleted area id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<area-id> required");
        }
        return true;
    }

    private static boolean processUpdateArea(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            String newlabel;
            AreaMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String markup = parms.get(ARG_MARKUP);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<area-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findAreaMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: area not found - " + id);
                    return true;
                }
            } else {
                marker = set.findAreaMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: area not found - " + label);
                    return true;
                }
            }
            if ((newlabel = parms.get(ARG_NEWLABEL)) != null) {
                marker.setLabel(newlabel, "true".equals(markup));
            } else if (markup != null) {
                marker.setLabel(marker.getLabel(), "true".equals(markup));
            }
            String newset = parms.get(ARG_NEWSET);
            if (newset != null) {
                MarkerSet ms = api.getMarkerSet(newset);
                if (ms == null) {
                    sender.sendMessage("Error: invalid new marker set - " + newset);
                    return true;
                }
                marker.setMarkerSet(ms);
            }
            if (!MarkerAPIImpl.processAreaArgs(sender, marker, parms)) {
                return true;
            }
            sender.sendMessage("Updated area id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<area-id> required");
        }
        return true;
    }

    private static boolean processAddLine(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        MarkerSet set;
        String pid = player == null ? "-console-" : player.getName();
        List<DynmapLocation> ll = MarkerAPIImpl.api.pointaccum.get(pid);
        if (ll == null || ll.size() < 2) {
            sender.sendMessage("At least two corners must be added with /dmarker addcorner before a line can be added");
            return true;
        }
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        String id = parms.get(ARG_ID);
        String label = parms.get(ARG_LABEL);
        String markup = parms.get(ARG_MARKUP);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        if (!set.isMarkerSetPersistent()) {
            sender.sendMessage("Error: cannot add to non-persistent marker set - set is likely plugin owned");
            return true;
        }
        double[] xx = new double[ll.size()];
        double[] yy = new double[ll.size()];
        double[] zz = new double[ll.size()];
        for (int i = 0; i < ll.size(); ++i) {
            DynmapLocation loc = ll.get(i);
            xx[i] = loc.x;
            yy[i] = loc.y;
            zz[i] = loc.z;
        }
        PolyLineMarker m = set.createPolyLineMarker(id, label, "true".equals(markup), ll.get((int)0).world, xx, yy, zz, true);
        if (m == null) {
            sender.sendMessage("Error creating line");
        } else {
            MarkerAPIImpl.processPolyArgs(sender, m, parms);
            sender.sendMessage("Added line id:'" + m.getMarkerID() + "' (" + m.getLabel() + ") to set '" + set.getMarkerSetID() + "'");
            MarkerAPIImpl.api.pointaccum.remove(pid);
        }
        return true;
    }

    private static boolean processListLine(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        MarkerSet set;
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        Set<PolyLineMarker> markers = set.getPolyLineMarkers();
        TreeMap<String, PolyLineMarker> sortmarkers = new TreeMap<String, PolyLineMarker>();
        for (PolyLineMarker m : markers) {
            sortmarkers.put(m.getMarkerID(), m);
        }
        for (String s : sortmarkers.keySet()) {
            PolyLineMarker m = (PolyLineMarker)sortmarkers.get(s);
            String ptlist = "{ ";
            for (int i = 0; i < m.getCornerCount(); ++i) {
                ptlist = ptlist + "{" + m.getCornerX(i) + "," + m.getCornerY(i) + "," + m.getCornerZ(i) + "} ";
            }
            ptlist = ptlist + "}";
            String msg = m.getMarkerID() + ": label:\"" + m.getLabel() + "\", set:" + m.getMarkerSet().getMarkerSetID() + ", world:" + m.getWorld() + ", corners:" + ptlist + ", weight: " + m.getLineWeight() + ", color:" + String.format("%06x", m.getLineColor()) + ", opacity: " + m.getLineOpacity() + ", markup:" + m.isLabelMarkup();
            if (m.getMinZoom() >= 0) {
                msg = msg + ", minzoom:" + m.getMinZoom();
            }
            if (m.getMaxZoom() >= 0) {
                msg = msg + ", maxzoom:" + m.getMaxZoom();
            }
            sender.sendMessage(msg);
        }
        return true;
    }

    private static boolean processDeleteLine(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            PolyLineMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<line-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findPolyLineMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: line not found - " + id);
                    return true;
                }
            } else {
                marker = set.findPolyLineMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: line not found - " + label);
                    return true;
                }
            }
            marker.deleteMarker();
            sender.sendMessage("Deleted poly-line id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<line-id> required");
        }
        return true;
    }

    private static boolean processUpdateLine(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            String newlabel;
            PolyLineMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String markup = parms.get(ARG_MARKUP);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<line-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findPolyLineMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: line not found - " + id);
                    return true;
                }
            } else {
                marker = set.findPolyLineMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: line not found - " + label);
                    return true;
                }
            }
            if ((newlabel = parms.get(ARG_NEWLABEL)) != null) {
                marker.setLabel(newlabel, "true".equals(markup));
            } else if (markup != null) {
                marker.setLabel(marker.getLabel(), "true".equals(markup));
            }
            String newset = parms.get(ARG_NEWSET);
            if (newset != null) {
                MarkerSet ms = api.getMarkerSet(newset);
                if (ms == null) {
                    sender.sendMessage("Error: invalid new marker set - " + newset);
                    return true;
                }
                marker.setMarkerSet(ms);
            }
            if (!MarkerAPIImpl.processPolyArgs(sender, marker, parms)) {
                return true;
            }
            sender.sendMessage("Updated line id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<line-id> required");
        }
        return true;
    }

    private static boolean processAddCircle(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args, DynmapPlayer player) {
        MarkerSet set;
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        String id = parms.get(ARG_ID);
        String label = parms.get(ARG_LABEL);
        String markup = parms.get(ARG_MARKUP);
        String x = parms.get(ARG_X);
        String y = parms.get(ARG_Y);
        String z = parms.get(ARG_Z);
        String world = parms.get(ARG_WORLD);
        if (world != null && MarkerAPIImpl.api.core.getWorld(world) == null) {
            sender.sendMessage("Invalid world ID: " + world);
            return true;
        }
        DynmapLocation loc = null;
        if (x == null && y == null && z == null && world == null) {
            if (player == null) {
                sender.sendMessage("Must be issued by player, or x, y, z, and world parameters are required");
                return true;
            }
            loc = player.getLocation();
        } else if (x != null && y != null && z != null && world != null) {
            try {
                loc = new DynmapLocation(world, Double.valueOf(x), Double.valueOf(y), Double.valueOf(z));
            }
            catch (NumberFormatException nfx) {
                sender.sendMessage("Coordinates x, y, and z must be numbers");
                return true;
            }
        } else {
            sender.sendMessage("Must be issued by player, or x, y, z, and world parameters are required");
            return true;
        }
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        if (!set.isMarkerSetPersistent()) {
            sender.sendMessage("Error: cannot add to non-persistent marker set - set is likely plugin owned");
            return true;
        }
        CircleMarker m = set.createCircleMarker(id, label, "true".equals(markup), loc.world, loc.x, loc.y, loc.z, 1.0, 1.0, true);
        if (m == null) {
            sender.sendMessage("Error creating circle");
        } else {
            if (!MarkerAPIImpl.processCircleArgs(sender, m, parms)) {
                return true;
            }
            sender.sendMessage("Added circle id:'" + m.getMarkerID() + "' (" + m.getLabel() + ") to set '" + set.getMarkerSetID() + "'");
        }
        return true;
    }

    private static boolean processListCircle(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        MarkerSet set;
        Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
        if (parms == null) {
            return true;
        }
        String setid = parms.get(ARG_SET);
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return true;
        }
        Set<CircleMarker> markers = set.getCircleMarkers();
        TreeMap<String, CircleMarker> sortmarkers = new TreeMap<String, CircleMarker>();
        for (CircleMarker m : markers) {
            sortmarkers.put(m.getMarkerID(), m);
        }
        for (String s : sortmarkers.keySet()) {
            EnterExitMarker.EnterExitText t;
            CircleMarker m = (CircleMarker)sortmarkers.get(s);
            String msg = m.getMarkerID() + ": label:\"" + m.getLabel() + "\", set:" + m.getMarkerSet().getMarkerSetID() + ", world:" + m.getWorld() + ", center:" + m.getCenterX() + "/" + m.getCenterY() + "/" + m.getCenterZ() + ", radiusx:" + m.getRadiusX() + ", radiusz:" + m.getRadiusZ() + ", weight: " + m.getLineWeight() + ", color:" + String.format("%06x", m.getLineColor()) + ", opacity: " + m.getLineOpacity() + ", fillcolor: " + String.format("%06x", m.getFillColor()) + ", fillopacity: " + m.getFillOpacity() + ", boost:" + m.getBoostFlag() + ", markup:" + m.isLabelMarkup();
            if (m.getMinZoom() >= 0) {
                msg = msg + ", minzoom:" + m.getMinZoom();
            }
            if (m.getMaxZoom() >= 0) {
                msg = msg + ", maxzoom:" + m.getMaxZoom();
            }
            if ((t = m.getGreetingText()) != null) {
                if (t.title != null) {
                    msg = msg + ", greeting:\"" + t.title + "\"";
                }
                if (t.subtitle != null) {
                    msg = msg + ", greetingsub:\"" + t.subtitle + "\"";
                }
            }
            if ((t = m.getFarewellText()) != null) {
                if (t.title != null) {
                    msg = msg + ", farewell:\"" + t.title + "\"";
                }
                if (t.subtitle != null) {
                    msg = msg + ", farewellsub:\"" + t.subtitle + "\"";
                }
            }
            sender.sendMessage(msg);
        }
        return true;
    }

    private static boolean processDeleteCircle(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            CircleMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<circle-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findCircleMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: circle not found - " + id);
                    return true;
                }
            } else {
                marker = set.findCircleMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: circle not found - " + label);
                    return true;
                }
            }
            marker.deleteMarker();
            sender.sendMessage("Deleted circle id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<circle-id> required");
        }
        return true;
    }

    private static boolean processUpdateCircle(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            String newlabel;
            CircleMarker marker;
            MarkerSet set;
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            String id = parms.get(ARG_ID);
            String label = parms.get(ARG_LABEL);
            String markup = parms.get(ARG_MARKUP);
            String setid = parms.get(ARG_SET);
            if (id == null && label == null) {
                sender.sendMessage("<label> or id:<area-id> required");
                return true;
            }
            if (setid == null) {
                setid = "markers";
            }
            if ((set = api.getMarkerSet(setid)) == null) {
                sender.sendMessage("Error: invalid set - " + setid);
                return true;
            }
            if (id != null) {
                marker = set.findCircleMarker(id);
                if (marker == null) {
                    sender.sendMessage("Error: circle not found - " + id);
                    return true;
                }
            } else {
                marker = set.findCircleMarkerByLabel(label);
                if (marker == null) {
                    sender.sendMessage("Error: circle not found - " + label);
                    return true;
                }
            }
            if ((newlabel = parms.get(ARG_NEWLABEL)) != null) {
                marker.setLabel(newlabel, "true".equals(markup));
            } else if (markup != null) {
                marker.setLabel(marker.getLabel(), "true".equals(markup));
            }
            String newset = parms.get(ARG_NEWSET);
            if (newset != null) {
                MarkerSet ms = api.getMarkerSet(newset);
                if (ms == null) {
                    sender.sendMessage("Error: invalid new marker set - " + newset);
                    return true;
                }
                marker.setMarkerSet(ms);
            }
            if (!MarkerAPIImpl.processCircleArgs(sender, marker, parms)) {
                return true;
            }
            sender.sendMessage("Updated circle id:" + marker.getMarkerID() + " (" + marker.getLabel() + ")");
        } else {
            sender.sendMessage("<label> or id:<circle-id> required");
        }
        return true;
    }

    private static MarkerDescription findMarkerDescription(DynmapCommandSender sender, Map<String, String> parms) {
        MarkerSet set;
        MarkerDescription md = null;
        String id = parms.get(ARG_ID);
        String label = parms.get(ARG_LABEL);
        String setid = parms.get(ARG_SET);
        if (id == null && label == null) {
            sender.sendMessage("<label> or id:<area-id> required");
            return null;
        }
        String type = parms.get(ARG_TYPE);
        if (type == null) {
            type = ARG_ICON;
        }
        if (setid == null) {
            setid = "markers";
        }
        if ((set = api.getMarkerSet(setid)) == null) {
            sender.sendMessage("Error: invalid set - " + setid);
            return null;
        }
        if (id != null) {
            if (type.equals(ARG_ICON)) {
                md = set.findMarker(id);
            } else if (type.equals("area")) {
                md = set.findAreaMarker(id);
            } else if (type.equals("circle")) {
                md = set.findCircleMarker(id);
            } else if (type.equals("line")) {
                md = set.findPolyLineMarker(id);
            } else {
                sender.sendMessage("Error: invalid type - " + type);
                return null;
            }
            if (md == null) {
                sender.sendMessage("Error: marker not found - " + id);
                return null;
            }
        } else {
            if (type.equals(ARG_ICON)) {
                md = set.findMarkerByLabel(label);
            } else if (type.equals("area")) {
                md = set.findAreaMarkerByLabel(label);
            } else if (type.equals("circle")) {
                md = set.findCircleMarkerByLabel(label);
            } else if (type.equals("line")) {
                md = set.findPolyLineMarkerByLabel(label);
            } else {
                sender.sendMessage("Error: invalid type - " + type);
                return null;
            }
            if (md == null) {
                sender.sendMessage("Error: marker not found - " + label);
                return null;
            }
        }
        return md;
    }

    private static boolean processGetDesc(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            String desc = md.getDescription();
            if (desc == null) {
                sender.sendMessage("<null>");
            } else {
                sender.sendMessage(desc);
            }
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    private static boolean processResetDesc(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            md.setDescription(null);
            sender.sendMessage("Description cleared");
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    private static boolean processAppendDesc(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            String desc = parms.get(ARG_DESC);
            if (desc == null) {
                sender.sendMessage("Error: no 'desc:' parameter");
                return true;
            }
            String d = md.getDescription();
            d = d == null ? desc + "\n" : d + desc + "\n";
            md.setDescription(d);
            sender.sendMessage(md.getDescription());
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    private static boolean processGetLabel(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            String desc = md.getLabel();
            if (desc == null) {
                sender.sendMessage("<null>");
            } else {
                sender.sendMessage(desc);
            }
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processImportDesc(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            String f = parms.get(ARG_FILE);
            if (f == null) {
                sender.sendMessage("Error: no 'file' parameter");
                return true;
            }
            FileReader fr = null;
            String val = null;
            try {
                int len;
                fr = new FileReader(f);
                StringBuilder sb = new StringBuilder();
                char[] buf = new char[512];
                while ((len = fr.read(buf)) > 0) {
                    sb.append(buf, 0, len);
                }
                val = sb.toString();
            }
            catch (FileNotFoundException fnfx) {
                sender.sendMessage("Error: file '" + f + "' not found");
                boolean bl = true;
                return bl;
            }
            catch (IOException iox) {
                sender.sendMessage("Error reading file '" + f + "'");
                boolean bl = true;
                return bl;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            md.setDescription(val);
            sender.sendMessage("Description imported from '" + f + "'");
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processImportLabel(DynmapCore plugin, DynmapCommandSender sender, String cmd, String commandLabel, String[] args) {
        if (args.length > 1) {
            Map<String, String> parms = MarkerAPIImpl.parseArgs(args, sender);
            if (parms == null) {
                return true;
            }
            MarkerDescription md = MarkerAPIImpl.findMarkerDescription(sender, parms);
            if (md == null) {
                return true;
            }
            String f = parms.get(ARG_FILE);
            if (f == null) {
                sender.sendMessage("Error: no 'file' parameter");
                return true;
            }
            FileReader fr = null;
            String val = null;
            try {
                int len;
                fr = new FileReader(f);
                StringBuilder sb = new StringBuilder();
                char[] buf = new char[512];
                while ((len = fr.read(buf)) > 0) {
                    sb.append(buf, 0, len);
                }
                val = sb.toString();
            }
            catch (FileNotFoundException fnfx) {
                sender.sendMessage("Error: file '" + f + "' not found");
                boolean bl = true;
                return bl;
            }
            catch (IOException iox) {
                sender.sendMessage("Error reading file '" + f + "'");
                boolean bl = true;
                return bl;
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            md.setLabel(val, true);
            sender.sendMessage("Label with markup imported from '" + f + "'");
        } else {
            sender.sendMessage("<label> or id:<id> required");
        }
        return true;
    }

    private void writeMarkersFile(final String wname) {
        HashMap markerdata = new HashMap();
        final HashMap<String, Serializable> worlddata = new HashMap<String, Serializable>();
        worlddata.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        for (MarkerSet markerSet : this.markersets.values()) {
            Object m32;
            HashMap<String, Object> msdata = new HashMap<String, Object>();
            msdata.put(ARG_LABEL, markerSet.getMarkerSetLabel());
            msdata.put(ARG_HIDE, markerSet.getHideByDefault());
            msdata.put("layerprio", markerSet.getLayerPriority());
            if (markerSet.getMinZoom() >= 0) {
                msdata.put(ARG_MINZOOM, markerSet.getMinZoom());
            }
            if (markerSet.getMaxZoom() >= 0) {
                msdata.put(ARG_MAXZOOM, markerSet.getMaxZoom());
            }
            if (markerSet.getLabelShow() != null) {
                msdata.put(ARG_SHOWLABEL, markerSet.getLabelShow());
            }
            HashMap markers = new HashMap();
            for (Marker marker : markerSet.getMarkers()) {
                if (!marker.getWorld().equals(wname)) continue;
                HashMap<String, Object> mdata = new HashMap<String, Object>();
                mdata.put(ARG_X, marker.getX());
                mdata.put(ARG_Y, marker.getY());
                mdata.put(ARG_Z, marker.getZ());
                MarkerIcon mi = marker.getMarkerIcon();
                if (mi == null) {
                    mi = MarkerAPIImpl.getMarkerIconImpl("default");
                }
                mdata.put(ARG_ICON, mi.getMarkerIconID());
                mdata.put("dim", mi.getMarkerIconSize().getSize());
                mdata.put(ARG_LABEL, Client.sanitizeHTML(marker.getLabel()));
                mdata.put(ARG_MARKUP, marker.isLabelMarkup());
                if (marker.getDescription() != null) {
                    mdata.put(ARG_DESC, Client.sanitizeHTML(marker.getDescription()));
                }
                if (marker.getMinZoom() >= 0) {
                    mdata.put(ARG_MINZOOM, marker.getMinZoom());
                }
                if (marker.getMaxZoom() >= 0) {
                    mdata.put(ARG_MAXZOOM, marker.getMaxZoom());
                }
                markers.put(marker.getMarkerID(), mdata);
            }
            msdata.put("markers", markers);
            HashMap areas = new HashMap();
            for (Object m32 : markerSet.getAreaMarkers()) {
                if (!m32.getWorld().equals(wname)) continue;
                HashMap<String, Object> mdata = new HashMap<String, Object>();
                int cnt = m32.getCornerCount();
                ArrayList<Double> xx = new ArrayList<Double>();
                ArrayList<Double> zz = new ArrayList<Double>();
                for (int i = 0; i < cnt; ++i) {
                    xx.add(m32.getCornerX(i));
                    zz.add(m32.getCornerZ(i));
                }
                mdata.put(ARG_X, xx);
                mdata.put(ARG_YTOP, m32.getTopY());
                mdata.put(ARG_YBOTTOM, m32.getBottomY());
                mdata.put(ARG_Z, zz);
                mdata.put(ARG_STROKECOLOR, String.format("#%06X", m32.getLineColor()));
                mdata.put(ARG_FILLCOLOR, String.format("#%06X", m32.getFillColor()));
                mdata.put(ARG_STROKEOPACITY, m32.getLineOpacity());
                mdata.put(ARG_FILLOPACITY, m32.getFillOpacity());
                mdata.put(ARG_STROKEWEIGHT, m32.getLineWeight());
                mdata.put(ARG_LABEL, Client.sanitizeHTML(m32.getLabel()));
                mdata.put(ARG_MARKUP, m32.isLabelMarkup());
                if (m32.getDescription() != null) {
                    mdata.put(ARG_DESC, Client.sanitizeHTML(m32.getDescription()));
                }
                if (m32.getMinZoom() >= 0) {
                    mdata.put(ARG_MINZOOM, m32.getMinZoom());
                }
                if (m32.getMaxZoom() >= 0) {
                    mdata.put(ARG_MAXZOOM, m32.getMaxZoom());
                }
                areas.put(m32.getMarkerID(), mdata);
            }
            msdata.put("areas", areas);
            HashMap hashMap = new HashMap();
            m32 = markerSet.getPolyLineMarkers().iterator();
            while (m32.hasNext()) {
                PolyLineMarker m4 = (PolyLineMarker)m32.next();
                if (!m4.getWorld().equals(wname)) continue;
                HashMap<String, Object> mdata = new HashMap<String, Object>();
                int cnt = m4.getCornerCount();
                ArrayList<Double> xx = new ArrayList<Double>();
                ArrayList<Double> yy = new ArrayList<Double>();
                ArrayList<Double> zz = new ArrayList<Double>();
                for (int i = 0; i < cnt; ++i) {
                    xx.add(m4.getCornerX(i));
                    yy.add(m4.getCornerY(i));
                    zz.add(m4.getCornerZ(i));
                }
                mdata.put(ARG_X, xx);
                mdata.put(ARG_Y, yy);
                mdata.put(ARG_Z, zz);
                mdata.put(ARG_STROKECOLOR, String.format("#%06X", m4.getLineColor()));
                mdata.put(ARG_STROKEOPACITY, m4.getLineOpacity());
                mdata.put(ARG_STROKEWEIGHT, m4.getLineWeight());
                mdata.put(ARG_LABEL, Client.sanitizeHTML(m4.getLabel()));
                mdata.put(ARG_MARKUP, m4.isLabelMarkup());
                if (m4.getDescription() != null) {
                    mdata.put(ARG_DESC, Client.sanitizeHTML(m4.getDescription()));
                }
                if (m4.getMinZoom() >= 0) {
                    mdata.put(ARG_MINZOOM, m4.getMinZoom());
                }
                if (m4.getMaxZoom() >= 0) {
                    mdata.put(ARG_MAXZOOM, m4.getMaxZoom());
                }
                hashMap.put(m4.getMarkerID(), mdata);
            }
            msdata.put("lines", hashMap);
            HashMap circles = new HashMap();
            for (CircleMarker m5 : markerSet.getCircleMarkers()) {
                if (!m5.getWorld().equals(wname)) continue;
                HashMap<String, Object> mdata = new HashMap<String, Object>();
                mdata.put(ARG_X, m5.getCenterX());
                mdata.put(ARG_Y, m5.getCenterY());
                mdata.put(ARG_Z, m5.getCenterZ());
                mdata.put("xr", m5.getRadiusX());
                mdata.put("zr", m5.getRadiusZ());
                mdata.put(ARG_STROKECOLOR, String.format("#%06X", m5.getLineColor()));
                mdata.put(ARG_FILLCOLOR, String.format("#%06X", m5.getFillColor()));
                mdata.put(ARG_STROKEOPACITY, m5.getLineOpacity());
                mdata.put(ARG_FILLOPACITY, m5.getFillOpacity());
                mdata.put(ARG_STROKEWEIGHT, m5.getLineWeight());
                mdata.put(ARG_LABEL, Client.sanitizeHTML(m5.getLabel()));
                mdata.put(ARG_MARKUP, m5.isLabelMarkup());
                if (m5.getDescription() != null) {
                    mdata.put(ARG_DESC, Client.sanitizeHTML(m5.getDescription()));
                }
                if (m5.getMinZoom() >= 0) {
                    mdata.put(ARG_MINZOOM, m5.getMinZoom());
                }
                if (m5.getMaxZoom() >= 0) {
                    mdata.put(ARG_MAXZOOM, m5.getMaxZoom());
                }
                circles.put(m5.getMarkerID(), mdata);
            }
            msdata.put("circles", circles);
            markerdata.put(markerSet.getMarkerSetID(), msdata);
        }
        worlddata.put("sets", markerdata);
        MapManager.scheduleDelayedJob(new Runnable(){

            @Override
            public void run() {
                MarkerAPIImpl.this.core.getDefaultMapStorage().setMarkerFile(wname, Json.stringifyJson(worlddata));
            }
        }, 0L);
    }

    @Override
    public void triggered(DynmapWorld t) {
        this.dirty_worlds.put(t.getName(), "");
    }

    static void removeIcon(MarkerIcon ico) {
        MarkerIcon def = api.getMarkerIcon("default");
        for (MarkerSet markerSet : MarkerAPIImpl.api.markersets.values()) {
            for (Marker m : markerSet.getMarkers()) {
                if (m.getMarkerIcon() != ico) continue;
                m.setMarkerIcon(def);
            }
            Set<MarkerIcon> allowed = markerSet.getAllowedMarkerIcons();
            if (allowed == null || !allowed.contains(ico)) continue;
            markerSet.removeAllowedMarkerIcon(ico);
        }
        File f = new File(MarkerAPIImpl.api.markerdir, ico.getMarkerIconID() + ".png");
        f.delete();
        MarkerAPIImpl.api.core.getDefaultMapStorage().setMarkerImage(ico.getMarkerIconID(), null);
        MarkerAPIImpl.api.markericons.remove(ico.getMarkerIconID());
        MarkerAPIImpl.saveMarkers();
    }

    public boolean testIfPlayerVisible(String player, String player_to_see) {
        if (api == null) {
            return false;
        }
        for (Map.Entry<String, PlayerSetImpl> s : this.playersets.entrySet()) {
            PlayerSetImpl ps = s.getValue();
            if (!ps.isPlayerInSet(player_to_see)) continue;
            if (ps.isSymmetricSet() && ps.isPlayerInSet(player)) {
                return true;
            }
            if (!this.core.checkPermission(player, "playerset." + s.getKey())) continue;
            return true;
        }
        return false;
    }

    public Set<String> getPlayersVisibleToPlayer(String player) {
        player = player.toLowerCase();
        HashSet<String> pset = new HashSet<String>();
        pset.add(player);
        for (Map.Entry<String, PlayerSetImpl> s : this.playersets.entrySet()) {
            PlayerSetImpl ps = s.getValue();
            if (ps.isSymmetricSet() && ps.isPlayerInSet(player)) {
                pset.addAll(ps.getPlayers());
                continue;
            }
            if (!this.core.checkPermission(player, "playerset." + s.getKey())) continue;
            pset.addAll(ps.getPlayers());
        }
        return pset;
    }

    public static boolean testTileForBoostMarkers(DynmapWorld w, HDPerspective perspective, double tile_x, double tile_y, double tile_dim) {
        if (api == null) {
            return false;
        }
        for (MarkerSetImpl ms : MarkerAPIImpl.api.markersets.values()) {
            if (!ms.testTileForBoostMarkers(w, perspective, tile_x, tile_y, tile_dim)) continue;
            return true;
        }
        return false;
    }

    public static void getEnteredMarkers(String worldid, double x, double y, double z, Set<EnterExitMarker> entered) {
        if (api == null) {
            return;
        }
        for (MarkerSetImpl ms : MarkerAPIImpl.api.markersets.values()) {
            ms.addEnteredMarkers(entered, worldid, x, y, z);
        }
    }

    public static String escapeForHTMLIfNeeded(String txt, boolean markup) {
        if (markup) {
            return txt;
        }
        if (txt != null) {
            if (txt.indexOf(60) >= 0 || txt.indexOf(62) >= 0 || txt.indexOf(39) >= 0 || txt.indexOf(34) >= 0) {
                return Client.encodeForHTML(txt);
            }
            int idx = txt.lastIndexOf(38);
            if (idx >= 0 && txt.indexOf(59, idx) < 0) {
                return Client.encodeForHTML(txt);
            }
        }
        return txt;
    }

    static {
        builtin_icons = new String[]{"anchor", "bank", "basket", "bed", "beer", "bighouse", "blueflag", "bomb", "bookshelf", "bricks", "bronzemedal", "bronzestar", "building", "cake", "camera", "cart", "caution", "chest", "church", "coins", "comment", "compass", "construction", "cross", "cup", "cutlery", "default", "diamond", "dog", "door", "down", "drink", "exclamation", "factory", "fire", "flower", "gear", "goldmedal", "goldstar", "greenflag", "hammer", "heart", "house", "key", "king", "left", "lightbulb", "lighthouse", "lock", "minecart", "orangeflag", "pin", "pinkflag", "pirateflag", "pointdown", "pointleft", "pointright", "pointup", "portal", "purpleflag", "queen", "redflag", "right", "ruby", "scales", "skull", "shield", "sign", "silvermedal", "silverstar", "star", "sun", "temple", "theater", "tornado", "tower", "tree", "truck", "up", "walk", "warning", ARG_WORLD, "wrench", "yellowflag", "offlineuser"};
        commands = new HashSet<String>(Arrays.asList("add", "movehere", "update", "delete", "list", "icons", "addset", "updateset", "deleteset", "listsets", "addicon", "updateicon", "deleteicon", "addcorner", "clearcorners", "addarea", "listareas", "deletearea", "updatearea", "addline", "listlines", "deleteline", "updateline", "addcircle", "listcircles", "deletecircle", "updatecircle", "getdesc", "resetdesc", "appenddesc", "importdesc", "getlabel", "importlabel"));
    }

    private class DoFileWrites
    implements Runnable {
        private DoFileWrites() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (MarkerAPIImpl.this.stop) {
                return;
            }
            MarkerAPIImpl.this.lock.readLock().lock();
            HashSet dirty = new HashSet(MarkerAPIImpl.this.dirty_worlds.keySet());
            MarkerAPIImpl.this.dirty_worlds.clear();
            try {
                if (MarkerAPIImpl.this.dirty_markers) {
                    MarkerAPIImpl.this.doSaveMarkers();
                    MarkerAPIImpl.this.dirty_markers = false;
                }
                if (!dirty.isEmpty()) {
                    for (String world : dirty) {
                        MarkerAPIImpl.this.writeMarkersFile(world);
                    }
                }
            }
            finally {
                MarkerAPIImpl.this.lock.readLock().unlock();
            }
            MarkerAPIImpl.this.core.getServer().scheduleServerTask(this, 20L);
        }
    }

    static enum MarkerUpdate {
        CREATED,
        UPDATED,
        DELETED;

    }

    public static class MarkerUpdated
    extends MarkerComponentMessage {
        public String msg;
        public double x;
        public double y;
        public double z;
        public String id;
        public String label;
        public String icon;
        public String set;
        public boolean markup;
        public String desc;
        public String dim;
        public int minzoom;
        public int maxzoom;

        public MarkerUpdated(Marker m, boolean deleted) {
            this.id = m.getMarkerID();
            this.label = Client.sanitizeHTML(m.getLabel());
            this.x = m.getX();
            this.y = m.getY();
            this.z = m.getZ();
            this.set = m.getMarkerSet().getMarkerSetID();
            this.icon = m.getMarkerIcon().getMarkerIconID();
            this.markup = true;
            this.desc = Client.sanitizeHTML(m.getDescription());
            this.dim = m.getMarkerIcon().getMarkerIconSize().getSize();
            this.minzoom = m.getMinZoom();
            this.maxzoom = m.getMaxZoom();
            this.msg = deleted ? "markerdeleted" : "markerupdated";
        }

        public boolean equals(Object o) {
            if (o instanceof MarkerUpdated) {
                MarkerUpdated m = (MarkerUpdated)o;
                return m.id.equals(this.id) && m.set.equals(this.set);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.set.hashCode();
        }
    }

    public static class AreaMarkerUpdated
    extends MarkerComponentMessage {
        public String msg;
        public double ytop;
        public double ybottom;
        public double[] x;
        public double[] z;
        public int weight;
        public double opacity;
        public String color;
        public double fillopacity;
        public String fillcolor;
        public String id;
        public String label;
        public String set;
        public String desc;
        public int minzoom;
        public int maxzoom;
        public boolean markup;

        public AreaMarkerUpdated(AreaMarker m, boolean deleted) {
            this.id = m.getMarkerID();
            this.label = Client.sanitizeHTML(m.getLabel());
            this.ytop = m.getTopY();
            this.ybottom = m.getBottomY();
            int cnt = m.getCornerCount();
            this.x = new double[cnt];
            this.z = new double[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.x[i] = m.getCornerX(i);
                this.z[i] = m.getCornerZ(i);
            }
            this.color = String.format("#%06X", m.getLineColor());
            this.weight = m.getLineWeight();
            this.opacity = m.getLineOpacity();
            this.fillcolor = String.format("#%06X", m.getFillColor());
            this.fillopacity = m.getFillOpacity();
            this.desc = Client.sanitizeHTML(m.getDescription());
            this.minzoom = m.getMinZoom();
            this.maxzoom = m.getMaxZoom();
            this.markup = true;
            this.set = m.getMarkerSet().getMarkerSetID();
            this.msg = deleted ? "areadeleted" : "areaupdated";
        }

        public boolean equals(Object o) {
            if (o instanceof AreaMarkerUpdated) {
                AreaMarkerUpdated m = (AreaMarkerUpdated)o;
                return m.id.equals(this.id) && m.set.equals(this.set);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.set.hashCode();
        }
    }

    public static class PolyLineMarkerUpdated
    extends MarkerComponentMessage {
        public String msg;
        public double[] x;
        public double[] y;
        public double[] z;
        public int weight;
        public double opacity;
        public String color;
        public String id;
        public String label;
        public String set;
        public String desc;
        public int minzoom;
        public int maxzoom;
        public boolean markup;

        public PolyLineMarkerUpdated(PolyLineMarker m, boolean deleted) {
            this.id = m.getMarkerID();
            this.label = Client.sanitizeHTML(m.getLabel());
            this.markup = true;
            int cnt = m.getCornerCount();
            this.x = new double[cnt];
            this.y = new double[cnt];
            this.z = new double[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.x[i] = m.getCornerX(i);
                this.y[i] = m.getCornerY(i);
                this.z[i] = m.getCornerZ(i);
            }
            this.color = String.format("#%06X", m.getLineColor());
            this.weight = m.getLineWeight();
            this.opacity = m.getLineOpacity();
            this.desc = Client.sanitizeHTML(m.getDescription());
            this.minzoom = m.getMinZoom();
            this.maxzoom = m.getMaxZoom();
            this.set = m.getMarkerSet().getMarkerSetID();
            this.msg = deleted ? "linedeleted" : "lineupdated";
        }

        public boolean equals(Object o) {
            if (o instanceof PolyLineMarkerUpdated) {
                PolyLineMarkerUpdated m = (PolyLineMarkerUpdated)o;
                return m.id.equals(this.id) && m.set.equals(this.set);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.set.hashCode();
        }
    }

    public static class CircleMarkerUpdated
    extends MarkerComponentMessage {
        public String msg;
        public double x;
        public double y;
        public double z;
        public double xr;
        public double zr;
        public int weight;
        public double opacity;
        public String color;
        public double fillopacity;
        public String fillcolor;
        public String id;
        public String label;
        public String set;
        public String desc;
        public int minzoom;
        public int maxzoom;
        public boolean markup;

        public CircleMarkerUpdated(CircleMarker m, boolean deleted) {
            this.id = m.getMarkerID();
            this.label = Client.sanitizeHTML(m.getLabel());
            this.x = m.getCenterX();
            this.y = m.getCenterY();
            this.z = m.getCenterZ();
            this.xr = m.getRadiusX();
            this.zr = m.getRadiusZ();
            this.markup = true;
            this.color = String.format("#%06X", m.getLineColor());
            this.weight = m.getLineWeight();
            this.opacity = m.getLineOpacity();
            this.fillcolor = String.format("#%06X", m.getFillColor());
            this.fillopacity = m.getFillOpacity();
            this.desc = Client.sanitizeHTML(m.getDescription());
            this.minzoom = m.getMinZoom();
            this.maxzoom = m.getMaxZoom();
            this.set = m.getMarkerSet().getMarkerSetID();
            this.msg = deleted ? "circledeleted" : "circleupdated";
        }

        public boolean equals(Object o) {
            if (o instanceof CircleMarkerUpdated) {
                CircleMarkerUpdated m = (CircleMarkerUpdated)o;
                return m.id.equals(this.id) && m.set.equals(this.set);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode() ^ this.set.hashCode();
        }
    }

    public static class MarkerSetUpdated
    extends MarkerComponentMessage {
        public String msg;
        public String id;
        public String label;
        public int layerprio;
        public int minzoom;
        public int maxzoom;
        public Boolean showlabels;

        public MarkerSetUpdated(MarkerSet markerset, boolean deleted) {
            this.id = markerset.getMarkerSetID();
            this.label = markerset.getMarkerSetLabel();
            this.layerprio = markerset.getLayerPriority();
            this.minzoom = markerset.getMinZoom();
            this.maxzoom = markerset.getMaxZoom();
            this.showlabels = markerset.getLabelShow();
            this.msg = deleted ? "setdeleted" : "setupdated";
        }

        public boolean equals(Object o) {
            if (o instanceof MarkerSetUpdated) {
                MarkerSetUpdated m = (MarkerSetUpdated)o;
                return m.id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class MarkerComponentMessage
    extends Client.ComponentMessage {
        public String ctype = "markers";
    }
}

