/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_13_2;

import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.gen.Heightmap;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.forge_1_13_2.ForgeMapChunkCache;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class ForgeWorld
extends DynmapWorld {
    private IWorld world = null;
    private final boolean skylight;
    private final boolean isnether;
    private final boolean istheend;
    private final String env;
    private DynmapLocation spawnloc = new DynmapLocation();
    private static boolean doMCPCMapping = false;
    private static boolean doSaveFolderMapping = false;
    private static int maxWorldHeight = 256;

    public static void setMCPCMapping() {
        doMCPCMapping = true;
    }

    public static void setSaveFolderMapping() {
        doSaveFolderMapping = true;
    }

    public static int getMaxWorldHeight() {
        return maxWorldHeight;
    }

    public static void setMaxWorldHeight(int h) {
        maxWorldHeight = h;
    }

    public static String getWorldName(IWorld w) {
        String n;
        if (doMCPCMapping) {
            n = w.func_72912_H().func_76065_j();
        } else if (doSaveFolderMapping) {
            n = w.func_201675_m().func_186058_p() == DimensionType.OVERWORLD ? w.func_72912_H().func_76065_j() : "DIM" + w.func_201675_m().func_186058_p().func_186068_a();
        } else {
            n = w.func_72912_H().func_76065_j();
            Dimension wp = w.func_201675_m();
            switch (wp.func_186058_p().func_186068_a()) {
                case 0: {
                    break;
                }
                case -1: {
                    n = n + "_nether";
                    break;
                }
                case 1: {
                    n = n + "_the_end";
                    break;
                }
                default: {
                    n = n + "_" + wp.func_186058_p().func_186068_a();
                }
            }
        }
        return n;
    }

    public ForgeWorld(IWorld w) {
        this(ForgeWorld.getWorldName(w), w.func_201672_e().func_72800_K(), w.func_181545_F(), w.func_201675_m() instanceof NetherDimension, w.func_201675_m() instanceof EndDimension, w.func_72912_H().func_76065_j() + "/" + w.func_201675_m().func_186058_p().toString());
        this.setWorldLoaded(w);
    }

    public ForgeWorld(String name, int height, int sealevel, boolean nether, boolean the_end, String deftitle) {
        super(name, height > maxWorldHeight ? maxWorldHeight : height, sealevel);
        this.setTitle(deftitle);
        this.isnether = nether;
        this.istheend = the_end;
        boolean bl = this.skylight = !this.isnether && !this.istheend;
        this.env = this.isnether ? "nether" : (this.istheend ? "the_end" : "normal");
    }

    @Override
    public boolean isNether() {
        return this.isnether;
    }

    public boolean isTheEnd() {
        return this.istheend;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            BlockPos sloc = this.world.func_175694_M();
            this.spawnloc.x = sloc.func_177958_n();
            this.spawnloc.y = sloc.func_177956_o();
            this.spawnloc.z = sloc.func_177952_p();
            this.spawnloc.world = this.getName();
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.func_201672_e().func_72820_D();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.func_201672_e().func_72896_J();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.func_201672_e().func_72911_I();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    public void setWorldLoaded(IWorld w) {
        this.world = w;
        this.sealevel = w.func_181545_F();
        float[] lt = w.func_201675_m().func_177497_p();
        for (int i = 0; i < 16; ++i) {
            this.setBrightnessTableEntry(i, lt[i]);
        }
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_201696_r(new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.func_201672_e().func_72964_e(x >> 4, z >> 4).func_201608_a(Heightmap.Type.LIGHT_BLOCKING).func_202273_a(x & 0xF, z & 0xF);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.func_175642_b(EnumLightType.SKY, new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.world != null) {
            ForgeMapChunkCache c = new ForgeMapChunkCache();
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public World getWorld() {
        return this.world.func_201672_e();
    }

    @Override
    public Polygon getWorldBorder() {
        WorldBorder wb;
        if (this.world != null && (wb = this.world.func_175723_af()) != null && wb.func_177741_h() < 5.9E7) {
            Polygon p = new Polygon();
            p.addVertex(wb.func_177726_b(), wb.func_177736_c());
            p.addVertex(wb.func_177726_b(), wb.func_177733_e());
            p.addVertex(wb.func_177728_d(), wb.func_177733_e());
            p.addVertex(wb.func_177728_d(), wb.func_177736_c());
            return p;
        }
        return null;
    }
}

