/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.storage.aws_s3;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.MapType;
import org.dynmap.PlayerFaces;
import org.dynmap.WebAuthManager;
import org.dynmap.s3lite.api.client.S3Client;
import org.dynmap.s3lite.api.exception.NoSuchKeyException;
import org.dynmap.s3lite.api.exception.S3Exception;
import org.dynmap.s3lite.api.region.Region;
import org.dynmap.s3lite.api.request.DeleteObjectRequest;
import org.dynmap.s3lite.api.request.GetObjectRequest;
import org.dynmap.s3lite.api.request.ListObjectsV2Request;
import org.dynmap.s3lite.api.request.PutObjectRequest;
import org.dynmap.s3lite.api.response.GetObjectResponse;
import org.dynmap.s3lite.api.response.ListObjectsV2Response;
import org.dynmap.s3lite.api.response.ResponseBytes;
import org.dynmap.s3lite.api.response.S3Object;
import org.dynmap.s3lite.core.auth.AwsBasicCredentials;
import org.dynmap.s3lite.core.client.DefaultS3ClientBuilder;
import org.dynmap.s3lite.http.spi.request.RequestBody;
import org.dynmap.s3lite.http.urlconnection.URLConnectionSdkHttpClient;
import org.dynmap.storage.MapStorage;
import org.dynmap.storage.MapStorageBaseTileEnumCB;
import org.dynmap.storage.MapStorageTile;
import org.dynmap.storage.MapStorageTileEnumCB;
import org.dynmap.storage.MapStorageTileSearchEndCB;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;

public class AWSS3MapStorage
extends MapStorage {
    private String bucketname;
    private String region;
    private String access_key_id;
    private String secret_access_key;
    private String prefix;
    private int POOLSIZE = 4;
    private int cpoolCount = 0;
    private S3Client[] cpool = new S3Client[this.POOLSIZE];
    private ConcurrentHashMap<String, byte[]> standalone_cache = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(DynmapCore core) {
        if (!super.init(core)) {
            return false;
        }
        if (!core.isInternalWebServerDisabled) {
            Log.severe("AWS S3 storage is not supported option with internal web server: set disable-webserver: true in configuration.txt");
            return false;
        }
        if (core.isLoginSupportEnabled()) {
            Log.severe("AWS S3 storage is not supported option with loegin support enabled: set login-enabled: false in configuration.txt");
            return false;
        }
        this.bucketname = core.configuration.getString("storage/bucketname", "dynmap");
        this.region = core.configuration.getString("storage/region", "us-east-1");
        this.access_key_id = core.configuration.getString("storage/aws_access_key_id", System.getenv("AWS_ACCESS_KEY_ID"));
        this.secret_access_key = core.configuration.getString("storage/aws_secret_access_key", System.getenv("AWS_SECRET_ACCESS_KEY"));
        this.prefix = core.configuration.getString("storage/prefix", "");
        if (this.prefix.length() > 0 && this.prefix.charAt(this.prefix.length() - 1) != '/') {
            this.prefix = this.prefix + '/';
        }
        Log.info("Using AWS S3 storage: web site at S3 bucket " + this.bucketname + " in region " + this.region);
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            if (s3 == null) {
                Log.severe("Error creating S3 access client");
                boolean bl = false;
                return bl;
            }
            ListObjectsV2Request listreq = ListObjectsV2Request.builder().bucketName(this.bucketname).maxKeys(1).prefix(this.prefix).build();
            ListObjectsV2Response rslt = s3.listObjectsV2(listreq);
            if (rslt == null) {
                Log.severe("Error: cannot find or access S3 bucket");
                boolean bl = false;
                return bl;
            }
            rslt.getContents();
        }
        catch (S3Exception s3x) {
            Log.severe("AWS Exception", s3x);
            boolean bl = false;
            return bl;
        }
        catch (MapStorage.StorageShutdownException x) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseConnection(s3);
        }
        return true;
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
        return new StorageTile(world, map, x, y, zoom, var);
    }

    @Override
    public MapStorageTile getTile(DynmapWorld world, String uri) {
        String[] suri = uri.split("/");
        if (suri.length < 2) {
            return null;
        }
        String mname = suri[0];
        MapType mt = null;
        MapType.ImageVariant imgvar = null;
        for (int mti = 0; mt == null && mti < world.maps.size(); ++mti) {
            MapType type = world.maps.get(mti);
            MapType.ImageVariant[] var = type.getVariants();
            for (int ivi = 0; imgvar == null && ivi < var.length; ++ivi) {
                if (!mname.equals(type.getPrefix() + var[ivi].variantSuffix)) continue;
                mt = type;
                imgvar = var[ivi];
            }
        }
        if (mt == null) {
            return null;
        }
        String fname = suri[suri.length - 1];
        String[] coord = fname.split("[_\\.]");
        if (coord.length < 3) {
            return null;
        }
        int zoom = 0;
        try {
            int y;
            int x;
            if (coord[0].charAt(0) == 'z') {
                zoom = coord[0].length();
                x = Integer.parseInt(coord[1]);
                y = Integer.parseInt(coord[2]);
            } else {
                x = Integer.parseInt(coord[0]);
                y = Integer.parseInt(coord[1]);
            }
            return this.getTile(world, mt, x, y, zoom, imgvar);
        }
        catch (NumberFormatException nfx) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEnumMapTiles(DynmapWorld world, MapType map, MapType.ImageVariant var, MapStorageTileEnumCB cb, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        String basekey = this.prefix + "tiles/" + world.getName() + "/" + map.getPrefix() + var.variantSuffix + "/";
        ListObjectsV2Request req = ListObjectsV2Request.builder().bucketName(this.bucketname).prefix(basekey).maxKeys(1000).build();
        boolean done = false;
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            while (!done) {
                ListObjectsV2Response result = s3.listObjectsV2(req);
                List<S3Object> objects = result.getContents();
                for (S3Object os : objects) {
                    String[] coord;
                    MapType.ImageEncoding fmt;
                    String key = os.getKey();
                    key = key.substring(basekey.length());
                    String ext = null;
                    int extoff = key.lastIndexOf(46);
                    if (extoff >= 0) {
                        ext = key.substring(extoff + 1);
                        key = key.substring(0, extoff);
                    }
                    if ((fmt = MapType.ImageEncoding.fromExt(ext)) == null) continue;
                    int zoom = 0;
                    if (key.startsWith("z")) {
                        while (key.startsWith("z")) {
                            key = key.substring(1);
                            ++zoom;
                        }
                        if (key.startsWith("_")) {
                            key = key.substring(1);
                        }
                    }
                    if ((coord = key.split("_")).length != 2) continue;
                    try {
                        int x = Integer.parseInt(coord[0]);
                        int y = Integer.parseInt(coord[1]);
                        StorageTile t = new StorageTile(world, map, x, y, zoom, var);
                        if (cb != null) {
                            cb.tileFound(t, fmt);
                        }
                        if (cbBase != null && t.zoom == 0) {
                            cbBase.tileFound(t, fmt);
                        }
                        ((MapStorageTile)t).cleanup();
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (result.isTruncated().booleanValue()) {
                    req = ListObjectsV2Request.builder().bucketName(this.bucketname).prefix(basekey).delimiter("").maxKeys(1000).continuationToken(result.getContinuationToken()).encodingType("url").requestPayer("requester").build();
                    continue;
                }
                done = true;
            }
        }
        catch (S3Exception x) {
            if (!x.getCode().equals("SignatureDoesNotMatch")) {
                Log.severe("AWS Exception", x);
                Log.severe("req=" + req);
            }
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        if (cbEnd != null) {
            cbEnd.searchEnded();
        }
    }

    @Override
    public void enumMapTiles(DynmapWorld world, MapType map, MapStorageTileEnumCB cb) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, var, cb, null, null);
            }
        }
    }

    @Override
    public void enumMapBaseTiles(DynmapWorld world, MapType map, MapStorageBaseTileEnumCB cbBase, MapStorageTileSearchEndCB cbEnd) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processEnumMapTiles(world, mt, var, null, cbBase, cbEnd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPurgeMapTiles(DynmapWorld world, MapType map, MapType.ImageVariant var) {
        String basekey = this.prefix + "tiles/" + world.getName() + "/" + map.getPrefix() + var.variantSuffix + "/";
        ListObjectsV2Request req = ListObjectsV2Request.builder().bucketName(this.bucketname).prefix(basekey).delimiter("").maxKeys(1000).encodingType("url").requestPayer("requester").build();
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            boolean done = false;
            while (!done) {
                ListObjectsV2Response result = s3.listObjectsV2(req);
                List<S3Object> objects = result.getContents();
                for (S3Object os : objects) {
                    String key = os.getKey();
                    DeleteObjectRequest delreq = DeleteObjectRequest.builder().bucketName(this.bucketname).key(key).build();
                    s3.deleteObject(delreq);
                }
                if (result.isTruncated().booleanValue()) {
                    req = ListObjectsV2Request.builder().bucketName(this.bucketname).prefix(basekey).delimiter("").maxKeys(1000).continuationToken(result.getContinuationToken()).encodingType("url").requestPayer("requester").build();
                    continue;
                }
                done = true;
            }
        }
        catch (S3Exception x) {
            if (!x.getCode().equals("SignatureDoesNotMatch")) {
                Log.severe("AWS Exception", x);
                Log.severe("req=" + req);
            }
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
    }

    @Override
    public void purgeMapTiles(DynmapWorld world, MapType map) {
        List<MapType> mtlist = map != null ? Collections.singletonList(map) : new ArrayList<MapType>(world.maps);
        for (MapType mt : mtlist) {
            MapType.ImageVariant[] vars;
            for (MapType.ImageVariant var : vars = mt.getVariants()) {
                this.processPurgeMapTiles(world, mt, var);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPlayerFaceImage(String playername, PlayerFaces.FaceType facetype, BufferOutputStream encImage) {
        boolean done = false;
        String baseKey = this.prefix + "tiles/faces/" + facetype.id + "/" + playername + ".png";
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            if (encImage == null) {
                DeleteObjectRequest delreq = DeleteObjectRequest.builder().bucketName(this.bucketname).key(baseKey).build();
                s3.deleteObject(delreq);
            } else {
                PutObjectRequest req = PutObjectRequest.builder().bucketName(this.bucketname).key(baseKey).contentType("image/png").build();
                s3.putObject(req, RequestBody.fromBytes(encImage.buf, encImage.len));
            }
            done = true;
        }
        catch (S3Exception x) {
            Log.severe("AWS Exception", x);
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        return done;
    }

    @Override
    public BufferInputStream getPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPlayerFaceImage(String playername, PlayerFaces.FaceType facetype) {
        String baseKey = this.prefix + "tiles/faces/" + facetype.id + "/" + playername + ".png";
        boolean exists = false;
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            ListObjectsV2Request req = ListObjectsV2Request.builder().bucketName(this.bucketname).prefix(baseKey).maxKeys(1).build();
            ListObjectsV2Response rslt = s3.listObjectsV2(req);
            if (rslt != null && rslt.getKeyCount() > 0) {
                exists = true;
            }
        }
        catch (S3Exception x) {
            if (!x.getCode().equals("SignatureDoesNotMatch")) {
                Log.severe("AWS Exception", x);
            }
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMarkerImage(String markerid, BufferOutputStream encImage) {
        boolean done = false;
        String baseKey = this.prefix + "tiles/_markers_/" + markerid + ".png";
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            if (encImage == null) {
                DeleteObjectRequest delreq = DeleteObjectRequest.builder().bucketName(this.bucketname).key(baseKey).build();
                s3.deleteObject(delreq);
            } else {
                PutObjectRequest req = PutObjectRequest.builder().bucketName(this.bucketname).key(baseKey).contentType("image/png").build();
                s3.putObject(req, RequestBody.fromBytes(encImage.buf, encImage.len));
            }
            done = true;
        }
        catch (S3Exception x) {
            Log.severe("AWS Exception", x);
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        return done;
    }

    @Override
    public BufferInputStream getMarkerImage(String markerid) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setMarkerFile(String world, String content) {
        boolean done = false;
        String baseKey = this.prefix + "tiles/_markers_/marker_" + world + ".json";
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            if (content == null) {
                DeleteObjectRequest delreq = DeleteObjectRequest.builder().bucketName(this.bucketname).key(baseKey).build();
                s3.deleteObject(delreq);
            } else {
                PutObjectRequest req = PutObjectRequest.builder().bucketName(this.bucketname).key(baseKey).contentType("application/json").build();
                s3.putObject(req, RequestBody.fromBytes(content.getBytes(StandardCharsets.UTF_8)));
            }
            done = true;
        }
        catch (S3Exception x) {
            Log.severe("AWS Exception", x);
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        return done;
    }

    @Override
    public String getMarkerFile(String world) {
        return null;
    }

    @Override
    public String getMarkersURI(boolean login_enabled) {
        return "tiles/";
    }

    @Override
    public String getTilesURI(boolean login_enabled) {
        return "tiles/";
    }

    @Override
    public String getConfigurationJSONURI(boolean login_enabled) {
        return "standalone/dynmap_config.json?_={timestamp}";
    }

    @Override
    public String getUpdateJSONURI(boolean login_enabled) {
        return "standalone/dynmap_{world}.json?_={timestamp}";
    }

    @Override
    public void addPaths(StringBuilder sb, DynmapCore core) {
        String p = core.getTilesFolder().getAbsolutePath();
        if (!p.endsWith("/")) {
            p = p + "/";
        }
        sb.append("$tilespath = '");
        sb.append(WebAuthManager.esc(p));
        sb.append("';\n");
        sb.append("$markerspath = '");
        sb.append(WebAuthManager.esc(p));
        sb.append("';\n");
        super.addPaths(sb, core);
    }

    @Override
    public BufferInputStream getStandaloneFile(String fileid) {
        return null;
    }

    @Override
    public boolean setStandaloneFile(String fileid, BufferOutputStream content) {
        return this.setStaticWebFile("standalone/" + fileid, content);
    }

    @Override
    public boolean needsStaticWebFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStaticWebFile(String fileid, BufferOutputStream content) {
        boolean done = false;
        String baseKey = this.prefix + fileid;
        S3Client s3 = null;
        try {
            s3 = this.getConnection();
            byte[] cacheval = this.standalone_cache.get(fileid);
            if (content == null) {
                if (cacheval != null && cacheval.length == 0) {
                    boolean bl = true;
                    return bl;
                }
                DeleteObjectRequest delreq = DeleteObjectRequest.builder().bucketName(this.bucketname).key(baseKey).build();
                s3.deleteObject(delreq);
                this.standalone_cache.put(fileid, new byte[0]);
            } else {
                byte[] digest = content.buf;
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update(content.buf);
                    digest = md.digest();
                }
                catch (NoSuchAlgorithmException md) {
                    // empty catch block
                }
                if (Arrays.equals(digest, cacheval)) {
                    boolean md = true;
                    return md;
                }
                String ct = "text/plain";
                if (fileid.endsWith(".json")) {
                    ct = "application/json";
                } else if (fileid.endsWith(".php")) {
                    ct = "application/x-httpd-php";
                } else if (fileid.endsWith(".html")) {
                    ct = "text/html";
                } else if (fileid.endsWith(".css")) {
                    ct = "text/css";
                } else if (fileid.endsWith(".js")) {
                    ct = "application/x-javascript";
                }
                PutObjectRequest req = PutObjectRequest.builder().bucketName(this.bucketname).key(baseKey).contentType(ct).build();
                s3.putObject(req, RequestBody.fromBytes(content.buf, content.len));
                this.standalone_cache.put(fileid, digest);
            }
            done = true;
        }
        catch (S3Exception x) {
            Log.severe("AWS Exception", x);
        }
        catch (MapStorage.StorageShutdownException storageShutdownException) {
        }
        finally {
            this.releaseConnection(s3);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S3Client getConnection() throws S3Exception, MapStorage.StorageShutdownException {
        S3Client c = null;
        if (this.isShutdown) {
            throw new MapStorage.StorageShutdownException();
        }
        S3Client[] s3ClientArray = this.cpool;
        synchronized (this.cpool) {
            while (c == null) {
                for (int i = 0; i < this.cpool.length; ++i) {
                    if (this.cpool[i] == null) continue;
                    c = this.cpool[i];
                    this.cpool[i] = null;
                    break;
                }
                if (c != null) continue;
                if (this.cpoolCount < this.POOLSIZE) {
                    c = new DefaultS3ClientBuilder().credentialsProvider(() -> AwsBasicCredentials.create(this.access_key_id, this.secret_access_key)).region(Region.fromString(this.region)).httpClient(URLConnectionSdkHttpClient.create()).build();
                    if (c == null) {
                        Log.severe("Error creating S3 access client");
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                    ++this.cpoolCount;
                    continue;
                }
                try {
                    this.cpool.wait();
                }
                catch (InterruptedException e) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseConnection(S3Client c) {
        if (c == null) {
            return;
        }
        S3Client[] s3ClientArray = this.cpool;
        synchronized (this.cpool) {
            for (int i = 0; i < this.POOLSIZE; ++i) {
                if (this.cpool[i] != null) continue;
                this.cpool[i] = c;
                c = null;
                this.cpool.notifyAll();
                break;
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                --this.cpoolCount;
                this.cpool.notifyAll();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public class StorageTile
    extends MapStorageTile {
        private final String baseKey;
        private final String uri;

        StorageTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
            super(world, map, x, y, zoom, var);
            String baseURI = zoom > 0 ? map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz".substring(0, zoom) + "_" + x + "_" + y : map.getPrefix() + var.variantSuffix + "/" + (x >> 5) + "_" + (y >> 5) + "/" + x + "_" + y;
            this.uri = baseURI + "." + map.getImageFormat().getFileExt();
            this.baseKey = AWSS3MapStorage.this.prefix + "tiles/" + world.getName() + "/" + this.uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean exists() {
            boolean exists = false;
            S3Client s3 = null;
            try {
                s3 = AWSS3MapStorage.this.getConnection();
                ListObjectsV2Request req = ListObjectsV2Request.builder().bucketName(AWSS3MapStorage.this.bucketname).prefix(this.baseKey).maxKeys(1).build();
                ListObjectsV2Response rslt = s3.listObjectsV2(req);
                if (rslt != null && rslt.getKeyCount() > 0) {
                    exists = true;
                }
            }
            catch (S3Exception x) {
                if (!x.getCode().equals("SignatureDoesNotMatch")) {
                    Log.severe("AWS Exception", x);
                }
            }
            catch (MapStorage.StorageShutdownException storageShutdownException) {
            }
            finally {
                AWSS3MapStorage.this.releaseConnection(s3);
            }
            return exists;
        }

        @Override
        public boolean matchesHashCode(long hash) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MapStorageTile.TileRead read() {
            S3Client s3 = null;
            try {
                s3 = AWSS3MapStorage.this.getConnection();
                GetObjectRequest req = GetObjectRequest.builder().bucketName(AWSS3MapStorage.this.bucketname).key(this.baseKey).build();
                ResponseBytes<GetObjectResponse> obj = s3.getObjectAsBytes(req);
                if (obj != null) {
                    GetObjectResponse rsp = obj.getResponse();
                    MapStorageTile.TileRead tr = new MapStorageTile.TileRead();
                    byte[] buf = obj.getBytes();
                    tr.image = new BufferInputStream(buf);
                    tr.format = MapType.ImageEncoding.fromContentType(rsp.getContentType());
                    Map<String, String> meta = rsp.getMetadata();
                    String v = meta.get("x-dynmap-hash");
                    if (v != null) {
                        tr.hashCode = Long.parseLong(v, 16);
                    }
                    if ((v = meta.get("x-dynmap-ts")) != null) {
                        tr.lastModified = Long.parseLong(v);
                    }
                    MapStorageTile.TileRead tileRead = tr;
                    return tileRead;
                }
            }
            catch (NoSuchKeyException nskx) {
                MapStorageTile.TileRead tileRead = null;
                return tileRead;
            }
            catch (S3Exception x) {
                Log.severe("AWS Exception", x);
            }
            catch (MapStorage.StorageShutdownException storageShutdownException) {
            }
            finally {
                AWSS3MapStorage.this.releaseConnection(s3);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean write(long hash, BufferOutputStream encImage, long timestamp) {
            boolean done = false;
            S3Client s3 = null;
            try {
                s3 = AWSS3MapStorage.this.getConnection();
                if (encImage == null) {
                    DeleteObjectRequest req = DeleteObjectRequest.builder().bucketName(AWSS3MapStorage.this.bucketname).key(this.baseKey).build();
                    s3.deleteObject(req);
                } else {
                    PutObjectRequest req = PutObjectRequest.builder().bucketName(AWSS3MapStorage.this.bucketname).key(this.baseKey).contentType(this.map.getImageFormat().getEncoding().getContentType()).addMetadata("x-dynmap-hash", Long.toHexString(hash)).addMetadata("x-dynmap-ts", Long.toString(timestamp)).build();
                    s3.putObject(req, RequestBody.fromBytes(encImage.buf, encImage.len));
                }
                done = true;
            }
            catch (S3Exception x) {
                Log.severe("AWS Exception", x);
            }
            catch (MapStorage.StorageShutdownException storageShutdownException) {
            }
            finally {
                AWSS3MapStorage.this.releaseConnection(s3);
            }
            if (this.zoom == 0) {
                this.world.enqueueZoomOutUpdate(this);
            }
            return done;
        }

        @Override
        public boolean getWriteLock() {
            return true;
        }

        @Override
        public void releaseWriteLock() {
        }

        @Override
        public boolean getReadLock(long timeout) {
            return true;
        }

        @Override
        public void releaseReadLock() {
        }

        @Override
        public void cleanup() {
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public void enqueueZoomOutUpdate() {
            this.world.enqueueZoomOutUpdate(this);
        }

        @Override
        public MapStorageTile getZoomOutTile() {
            int step = 1 << this.zoom;
            int xx = this.x >= 0 ? this.x - this.x % (2 * step) : this.x + this.x % (2 * step);
            int yy = -this.y;
            yy = yy >= 0 ? (yy -= yy % (2 * step)) : (yy += yy % (2 * step));
            yy = -yy;
            return new StorageTile(this.world, this.map, xx, yy, this.zoom + 1, this.var);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof StorageTile) {
                StorageTile st = (StorageTile)o;
                return this.baseKey.equals(st.baseKey);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.baseKey.hashCode();
        }

        public String toString() {
            return this.baseKey;
        }
    }
}

