/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.common.chunk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.chunk.GenericBitStorage;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericChunkSection;
import org.dynmap.common.chunk.GenericNBTCompound;
import org.dynmap.common.chunk.GenericNBTList;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DataBitsPacked;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;

public abstract class GenericMapChunkCache
extends MapChunkCache {
    protected DynmapWorld dw;
    private int nsect;
    private int sectoff;
    private List<DynmapChunk> chunks;
    private ListIterator<DynmapChunk> iterator;
    private int x_min;
    private int x_max;
    private int z_min;
    private int z_max;
    private int x_dim;
    private MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    private List<VisibilityLimit> visible_limits = null;
    private List<VisibilityLimit> hidden_limits = null;
    private boolean isempty = true;
    private int snapcnt;
    private GenericChunk[] snaparray;
    private boolean[][] isSectionNotEmpty;
    private AtomicInteger loadingChunks = new AtomicInteger(0);
    private static final BlockStep[] unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
    private static final GenericChunkSection STONESECTION = new GenericChunkSection.Builder().singleBiome(BiomeMap.PLAINS).singleBlockState(DynmapBlockState.getBaseStateByName(DynmapBlockState.STONE_BLOCK)).build();
    private static final GenericChunkSection WATERSECTION = new GenericChunkSection.Builder().singleBiome(BiomeMap.OCEAN).singleBlockState(DynmapBlockState.getBaseStateByName(DynmapBlockState.WATER_BLOCK)).build();
    private GenericChunkCache cache;
    private GenericChunk empty_chunk;
    private GenericChunk stone_chunk;
    private GenericChunk ocean_chunk;
    private static final String[] litStates = new String[]{"light", "spawn", "heightmaps", "full"};

    private final GenericChunk getEmpty() {
        if (this.empty_chunk == null) {
            this.empty_chunk = new GenericChunk.Builder(this.dw.minY, this.dw.worldheight).build();
        }
        return this.empty_chunk;
    }

    private final GenericChunk getStone() {
        if (this.stone_chunk == null) {
            GenericChunk.Builder bld = new GenericChunk.Builder(this.dw.minY, this.dw.worldheight);
            for (int sy = -this.sectoff; sy < 4; ++sy) {
                bld.addSection(sy, STONESECTION);
            }
            this.stone_chunk = bld.build();
        }
        return this.stone_chunk;
    }

    private final GenericChunk getOcean() {
        if (this.ocean_chunk == null) {
            GenericChunk.Builder bld = new GenericChunk.Builder(this.dw.minY, this.dw.worldheight);
            for (int sy = -this.sectoff; sy < 3; ++sy) {
                bld.addSection(sy, STONESECTION);
            }
            bld.addSection(3, WATERSECTION);
            this.ocean_chunk = bld.build();
        }
        return this.ocean_chunk;
    }

    public GenericMapChunkCache(GenericChunkCache c) {
        this.cache = c;
    }

    public void setChunks(DynmapWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.nsect = dw.worldheight - dw.minY >> 4;
        this.sectoff = -dw.minY >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new GenericChunk[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    private boolean isChunkVisible(DynmapChunk chunk) {
        boolean vis = true;
        if (this.visible_limits != null) {
            vis = false;
            for (VisibilityLimit limit : this.visible_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = true;
                break;
            }
        }
        if (vis && this.hidden_limits != null) {
            for (VisibilityLimit limit : this.hidden_limits) {
                if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                vis = false;
                break;
            }
        }
        return vis;
    }

    private boolean tryChunkCache(DynmapChunk chunk, boolean vis) {
        GenericChunk ss = null;
        GenericChunkCache.ChunkCacheRec ssr = this.cache.getSnapshot(this.dw.getName(), chunk.x, chunk.z);
        if (ssr != null) {
            ss = ssr.ss;
            if (!vis) {
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? this.getStone() : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? this.getOcean() : this.getEmpty());
            }
            int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            this.snaparray[idx] = ss;
        }
        return ssr != null;
    }

    private void prepChunkSnapshot(DynmapChunk chunk, GenericChunk ss) {
        DynIntHashMap tileData = new DynIntHashMap();
        GenericChunkCache.ChunkCacheRec ssr = new GenericChunkCache.ChunkCacheRec();
        ssr.ss = ss;
        ssr.tileData = tileData;
        this.cache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr);
    }

    protected abstract GenericChunk getLoadedChunk(DynmapChunk var1);

    protected abstract GenericChunk loadChunk(DynmapChunk var1);

    protected Supplier<GenericChunk> getLoadedChunkAsync(DynmapChunk ch) {
        throw new IllegalStateException("Not implemeted");
    }

    protected Supplier<GenericChunk> loadChunkAsync(DynmapChunk ch) {
        throw new IllegalStateException("Not implemeted");
    }

    public int getLoadedChunks() {
        int cnt = 0;
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        ListIterator<DynmapChunk> iter = this.chunks.listIterator();
        while (iter.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = iter.next();
            int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkindex] != null) continue;
            boolean vis = this.isChunkVisible(chunk);
            if (this.tryChunkCache(chunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                ++cnt;
                continue;
            }
            GenericChunk ss = this.getLoadedChunk(chunk);
            if (ss == null) continue;
            if (vis) {
                this.prepChunkSnapshot(chunk, ss);
            } else {
                ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? this.getStone() : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? this.getOcean() : this.getEmpty());
            }
            this.snaparray[chunkindex] = ss;
            this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
            ++cnt;
        }
        return cnt;
    }

    public void getLoadedChunksAsync() {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return;
        }
        class SimplePair {
            final Supplier<GenericChunk> supplier;
            final BiConsumer<GenericChunk, Long> consumer;

            SimplePair(Supplier<GenericChunk> supplier, BiConsumer<GenericChunk, Long> consumer) {
                this.supplier = supplier;
                this.consumer = consumer;
            }
        }
        ArrayList<SimplePair> lastApply = new ArrayList<SimplePair>();
        for (DynmapChunk dynmapChunk : this.chunks) {
            long startTime = System.nanoTime();
            int chunkIndex = dynmapChunk.x - this.x_min + (dynmapChunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkIndex] != null) continue;
            boolean vis = this.isChunkVisible(dynmapChunk);
            if (this.tryChunkCache(dynmapChunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                continue;
            }
            Supplier<GenericChunk> supplier = this.getLoadedChunkAsync(dynmapChunk);
            long startPause = System.nanoTime();
            BiConsumer<GenericChunk, Long> consumer = (ss, reloadTime) -> {
                if (ss == null) {
                    return;
                }
                long pause = reloadTime - startPause;
                if (vis) {
                    this.prepChunkSnapshot(dynmapChunk, (GenericChunk)ss);
                } else {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? this.getStone() : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? this.getOcean() : this.getEmpty());
                }
                this.snaparray[chunkIndex] = ss;
                this.endChunkLoad(startTime - pause, MapChunkCache.ChunkStats.LOADED_CHUNKS);
            };
            lastApply.add(new SimplePair(supplier, consumer));
        }
        lastApply.forEach(simplePair -> {
            long reloadWork = System.nanoTime();
            simplePair.consumer.accept(simplePair.supplier.get(), reloadWork);
        });
    }

    @Override
    public int loadChunks(int max_to_load) {
        return this.getLoadedChunks() + this.readChunks(max_to_load);
    }

    public void loadChunksAsync() {
        this.getLoadedChunksAsync();
        this.readChunksAsync();
    }

    public int readChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return 0;
        }
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            long startTime = System.nanoTime();
            DynmapChunk chunk = this.iterator.next();
            int chunkindex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
            if (this.snaparray[chunkindex] != null) continue;
            boolean vis = this.isChunkVisible(chunk);
            if (this.tryChunkCache(chunk, vis)) {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
            } else {
                GenericChunk ss = this.loadChunk(chunk);
                if (ss != null) {
                    if (!vis) {
                        ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? this.getStone() : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? this.getOcean() : this.getEmpty());
                    } else {
                        this.prepChunkSnapshot(chunk, ss);
                    }
                    this.snaparray[chunkindex] = ss;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
                }
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = this.getEmpty();
                    continue;
                }
                if (this.snaparray[i].isEmpty) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readChunksAsync() {
        ArrayList<Object> chunks;
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return;
        }
        if (this.iterator == null) {
            this.iterator = Collections.emptyListIterator();
            chunks = new ArrayList<DynmapChunk>(this.chunks);
        } else {
            chunks = new ArrayList();
            this.iterator.forEachRemaining(chunks::add);
        }
        if (this.loadingChunks.getAndIncrement() == 0) {
            DynmapCore.setIgnoreChunkLoads(true);
        }
        try {
            class SimplePair {
                private final Supplier<GenericChunk> supplier;
                private final DynmapChunk chunk;

                SimplePair(DynmapChunk chunk) {
                    this.chunk = chunk;
                    this.supplier = GenericMapChunkCache.this.loadChunkAsync(chunk);
                }
            }
            ArrayList cached = new ArrayList();
            ArrayList notCached = new ArrayList();
            this.iterator.forEachRemaining(chunks::add);
            chunks.stream().filter(chunk -> this.snaparray[chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim] == null).forEach(chunk -> {
                if (this.cache.getSnapshot(this.dw.getName(), chunk.x, chunk.z) == null) {
                    notCached.add(new SimplePair((DynmapChunk)chunk));
                } else {
                    cached.add(chunk);
                }
            });
            cached.forEach(chunk -> {
                long startTime = System.nanoTime();
                this.tryChunkCache((DynmapChunk)chunk, this.isChunkVisible((DynmapChunk)chunk));
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
            });
            notCached.forEach(chunkSupplier -> {
                long startTime = System.nanoTime();
                GenericChunk chunk = (GenericChunk)((SimplePair)chunkSupplier).supplier.get();
                DynmapChunk dynmapChunk = ((SimplePair)chunkSupplier).chunk;
                if (chunk != null) {
                    if (this.isChunkVisible(dynmapChunk)) {
                        this.prepChunkSnapshot(dynmapChunk, chunk);
                    } else {
                        chunk = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? this.getStone() : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? this.getOcean() : this.getEmpty());
                    }
                    this.snaparray[dynmapChunk.x - this.x_min + (dynmapChunk.z - this.z_min) * this.x_dim] = chunk;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
                }
            });
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = this.getEmpty();
                    continue;
                }
                if (this.snaparray[i].isEmpty) continue;
                this.isempty = false;
            }
        }
        finally {
            if (this.loadingChunks.decrementAndGet() == 0) {
                DynmapCore.setIgnoreChunkLoads(false);
            }
        }
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (!this.snaparray[idx].isEmpty) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i - this.sectoff)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        boolean[] flags = this.isSectionNotEmpty[idx];
        if (flags == null) {
            this.initSectionData(idx);
            flags = this.isSectionNotEmpty[idx];
        }
        return !flags[sy + this.sectoff];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.dw.getEnvironment().equals("the_end")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new OurMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        return true;
    }

    public GenericChunk parseChunkFromNBT(GenericNBTCompound orignbt) {
        int[] bb;
        GenericNBTCompound nbt = orignbt;
        if (nbt != null && nbt.contains("Level", 10)) {
            nbt = nbt.getCompound("Level");
        }
        if (nbt == null) {
            return null;
        }
        String status = nbt.getString("Status");
        int version = orignbt.getInt("DataVersion");
        boolean lit = nbt.getBoolean("isLightOn");
        boolean hasLitState = false;
        if (status != null) {
            for (int i = 0; i < litStates.length; ++i) {
                if (!status.equals(litStates[i])) continue;
                hasLitState = true;
            }
        }
        boolean hasLight = false;
        GenericChunk.Builder bld = new GenericChunk.Builder(this.dw.minY, this.dw.worldheight);
        int x = nbt.getInt("xPos");
        int z = nbt.getInt("zPos");
        bld.coords(x, z).chunkStatus(status).dataVersion(version);
        if (nbt.contains("InhabitedTime")) {
            bld.inhabitedTicks(nbt.getLong("InhabitedTime"));
        }
        ArrayList<BiomeMap[]> old3d = null;
        BiomeMap[] old2d = null;
        if (nbt.contains("Biomes") && (bb = nbt.getIntArray("Biomes")) != null) {
            if (bb.length > 256) {
                old3d = new ArrayList<BiomeMap[]>();
                for (int sect = 0; sect < bb.length / 64; ++sect) {
                    BiomeMap[] smap = new BiomeMap[64];
                    for (int i = 0; i < 64; ++i) {
                        smap[i] = BiomeMap.byBiomeID(bb[sect * 64 + i]);
                    }
                    old3d.add(smap);
                }
            } else {
                old2d = new BiomeMap[256];
                for (int i = 0; i < bb.length; ++i) {
                    old2d[i] = BiomeMap.byBiomeID(bb[i]);
                }
            }
        }
        GenericChunkSection.Builder sbld = new GenericChunkSection.Builder();
        GenericNBTList sect = nbt.contains("sections") ? nbt.getList("sections", 10) : nbt.getList("Sections", 10);
        for (int i = 0; i < sect.size(); ++i) {
            GenericNBTCompound block_states;
            GenericNBTCompound sec = sect.getCompound(i);
            byte secnum = sec.getByte("Y");
            DynmapBlockState[] palette = null;
            if (sec.contains("Palette", 9) && sec.contains("BlockStates", 12)) {
                int j;
                GenericNBTList plist = sec.getList("Palette", 10);
                long[] statelist = sec.getLongArray("BlockStates");
                palette = new DynmapBlockState[plist.size()];
                for (int pi = 0; pi < plist.size(); ++pi) {
                    GenericNBTCompound tc = plist.getCompound(pi);
                    String pname = tc.getString("Name");
                    if (tc.contains("Properties")) {
                        StringBuilder statestr = new StringBuilder();
                        GenericNBTCompound prop = tc.getCompound("Properties");
                        for (String pid : prop.getAllKeys()) {
                            if (statestr.length() > 0) {
                                statestr.append(',');
                            }
                            statestr.append(pid).append('=').append(prop.getAsString(pid));
                        }
                        palette[pi] = DynmapBlockState.getStateByNameAndState(pname, statestr.toString());
                    }
                    if (palette[pi] == null) {
                        palette[pi] = DynmapBlockState.getBaseStateByName(pname);
                    }
                    if (palette[pi] != null) continue;
                    palette[pi] = DynmapBlockState.AIR;
                }
                int recsperblock = (4096 + statelist.length - 1) / statelist.length;
                int bitsperblock = 64 / recsperblock;
                GenericBitStorage db = null;
                DataBitsPacked dbp = null;
                try {
                    db = nbt.makeBitStorage(bitsperblock, 4096, statelist);
                }
                catch (Exception ex) {
                    bitsperblock = statelist.length * 64 / 4096;
                    dbp = new DataBitsPacked(bitsperblock, 4096, statelist);
                }
                if (bitsperblock > 8) {
                    for (j = 0; j < 4096; ++j) {
                        int v = dbp != null ? dbp.getAt(j) : db.get(j);
                        sbld.xyzBlockState(j & 0xF, (j & 0xF00) >> 8, (j & 0xF0) >> 4, DynmapBlockState.getStateByGlobalIndex(v));
                    }
                } else {
                    sbld.xyzBlockStatePalette(palette);
                    for (j = 0; j < 4096; ++j) {
                        int v = db != null ? db.get(j) : dbp.getAt(j);
                        sbld.xyzBlockStateInPalette(j & 0xF, (j & 0xF00) >> 8, (j & 0xF0) >> 4, (short)v);
                    }
                }
            } else if (sec.contains("block_states", 10) && (block_states = sec.getCompound("block_states")).contains("palette", 9)) {
                long[] statelist = block_states.contains("data", 12) ? block_states.getLongArray("data") : new long[64];
                GenericNBTList plist = block_states.getList("palette", 10);
                palette = new DynmapBlockState[plist.size()];
                for (int pi = 0; pi < plist.size(); ++pi) {
                    GenericNBTCompound tc = plist.getCompound(pi);
                    String pname = tc.getString("Name");
                    if (tc.contains("Properties")) {
                        StringBuilder statestr = new StringBuilder();
                        GenericNBTCompound prop = tc.getCompound("Properties");
                        for (String pid : prop.getAllKeys()) {
                            if (statestr.length() > 0) {
                                statestr.append(',');
                            }
                            statestr.append(pid).append('=').append(prop.getAsString(pid));
                        }
                        palette[pi] = DynmapBlockState.getStateByNameAndState(pname, statestr.toString());
                    }
                    if (palette[pi] == null) {
                        palette[pi] = DynmapBlockState.getBaseStateByName(pname);
                    }
                    if (palette[pi] != null) continue;
                    palette[pi] = DynmapBlockState.AIR;
                }
                GenericBitStorage db = null;
                DataBitsPacked dbp = null;
                int bitsperblock = statelist.length * 64 / 4096;
                int expectedStatelistLength = (4096 + 64 / bitsperblock - 1) / (64 / bitsperblock);
                if (statelist.length == expectedStatelistLength) {
                    db = nbt.makeBitStorage(bitsperblock, 4096, statelist);
                } else {
                    bitsperblock = statelist.length * 64 / 4096;
                    dbp = new DataBitsPacked(bitsperblock, 4096, statelist);
                }
                if (bitsperblock > 8) {
                    for (int j = 0; j < 4096; ++j) {
                        int v = db != null ? db.get(j) : dbp.getAt(j);
                        sbld.xyzBlockState(j & 0xF, (j & 0xF00) >> 8, (j & 0xF0) >> 4, DynmapBlockState.getStateByGlobalIndex(v));
                    }
                } else {
                    sbld.xyzBlockStatePalette(palette);
                    for (int j = 0; j < 4096; ++j) {
                        int v = db != null ? db.get(j) : dbp.getAt(j);
                        sbld.xyzBlockStateInPalette(j & 0xF, (j & 0xF00) >> 8, (j & 0xF0) >> 4, (short)v);
                    }
                }
            }
            if (sec.contains("BlockLight")) {
                sbld.emittedLight(sec.getByteArray("BlockLight"));
            }
            if (sec.contains("SkyLight")) {
                sbld.skyLight(sec.getByteArray("SkyLight"));
                hasLight = true;
            }
            if (sec.contains("biomes")) {
                GenericNBTCompound nbtbiomes = sec.getCompound("biomes");
                long[] bdataPacked = nbtbiomes.getLongArray("data");
                GenericNBTList bpalette = nbtbiomes.getList("palette", 8);
                GenericBitStorage bdata = null;
                if (bdataPacked.length > 0) {
                    int valsPerLong = 64 / bdataPacked.length;
                    bdata = nbt.makeBitStorage((64 + valsPerLong - 1) / valsPerLong, 64, bdataPacked);
                }
                for (int j = 0; j < 64; ++j) {
                    int b = bdata != null ? bdata.get(j) : 0;
                    sbld.xyzBiome(j & 3, (j & 0x30) >> 4, (j & 0xC) >> 2, BiomeMap.byBiomeResourceLocation(bpalette.getString(b)));
                }
            } else if (old3d != null) {
                BiomeMap[] m = (BiomeMap[])old3d.get(secnum > 0 ? (secnum < old3d.size() ? (int)secnum : old3d.size() - 1) : 0);
                if (m != null) {
                    for (int j = 0; j < 64; ++j) {
                        sbld.xyzBiome(j & 3, (j & 0x30) >> 4, (j & 0xC) >> 2, m[j]);
                    }
                }
            } else if (old2d != null) {
                for (int j = 0; j < 256; ++j) {
                    sbld.xzBiome(j & 0xF, (j & 0xF0) >> 4, old2d[j]);
                }
            }
            bld.addSection(secnum, sbld.build());
            sbld.reset();
        }
        if (!hasLitState || !lit) {
            hasLight = false;
        }
        if (!hasLight) {
            bld.generateSky();
        }
        return bld.build();
    }

    private class OurEndMapIterator
    extends OurMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class OurMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private GenericChunk snap;
        private BlockStep laststep;
        private DynmapBlockState blk;
        private final int worldheight;
        private final int ymin;

        OurMapIterator(int x0, int y0, int z0) {
            this.initialize(x0, y0, z0);
            this.worldheight = GenericMapChunkCache.this.dw.worldheight;
            this.ymin = GenericMapChunkCache.this.dw.minY;
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - GenericMapChunkCache.this.x_min + ((this.z >> 4) - GenericMapChunkCache.this.z_min) * GenericMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.snap = this.chunkindex >= GenericMapChunkCache.this.snapcnt || this.chunkindex < 0 ? GenericMapChunkCache.this.getEmpty() : GenericMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            this.blk = this.y >= this.ymin && this.y < this.worldheight ? null : DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 0;
            }
        }

        @Override
        public final int getBlockLight(BlockStep step) {
            int emit = 0;
            int sky = 15;
            if (step.yoff != 0) {
                int ny = this.y + step.yoff;
                GenericChunkSection sect = this.snap.getSection(ny);
                emit = sect.emitted.getLight(this.x, ny, this.z);
                sky = sect.sky.getLight(this.x, ny, this.z);
            } else {
                int nx = this.x + step.xoff;
                int nz = this.z + step.zoff;
                int nchunkindex = (nx >> 4) - GenericMapChunkCache.this.x_min + ((nz >> 4) - GenericMapChunkCache.this.z_min) * GenericMapChunkCache.this.x_dim;
                if (nchunkindex < GenericMapChunkCache.this.snapcnt && nchunkindex >= 0) {
                    GenericChunkSection sect = GenericMapChunkCache.this.snaparray[nchunkindex].getSection(this.y);
                    emit = sect.emitted.getLight(nx, this.y, nz);
                    sky = sect.sky.getLight(nx, this.y, nz);
                }
            }
            return (emit << 8) + sky;
        }

        @Override
        public final int getBlockLight(int xoff, int yoff, int zoff) {
            int emit = 0;
            int sky = 15;
            int nx = this.x + xoff;
            int ny = this.y + yoff;
            int nz = this.z + zoff;
            int nchunkindex = (nx >> 4) - GenericMapChunkCache.this.x_min + ((nz >> 4) - GenericMapChunkCache.this.z_min) * GenericMapChunkCache.this.x_dim;
            if (nchunkindex < GenericMapChunkCache.this.snapcnt && nchunkindex >= 0) {
                GenericChunkSection sect = GenericMapChunkCache.this.snaparray[nchunkindex].getSection(ny);
                emit = sect.emitted.getLight(nx, ny, nz);
                sky = sect.sky.getLight(nx, ny, nz);
            }
            return (emit << 8) + sky;
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return this.snap.getBiome(this.bx, this.y, this.bz);
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        private final BiomeMap getBiomeRel(int dx, int dz) {
            int nx = this.x + dx;
            int nz = this.z + dz;
            int nchunkindex = (nx >> 4) - GenericMapChunkCache.this.x_min + ((nz >> 4) - GenericMapChunkCache.this.z_min) * GenericMapChunkCache.this.x_dim;
            if (nchunkindex >= GenericMapChunkCache.this.snapcnt || nchunkindex < 0) {
                return BiomeMap.NULL;
            }
            return GenericMapChunkCache.this.snaparray[nchunkindex].getBiome(nx, this.y, nz);
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                int cnt = 0;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BiomeMap bm = this.getBiomeRel(dx, dz);
                        if (bm == BiomeMap.NULL) continue;
                        int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                        raccum += rmult >> 16 & 0xFF;
                        gaccum += rmult >> 8 & 0xFF;
                        baccum += rmult & 0xFF;
                        ++cnt;
                    }
                }
                cnt = cnt > 0 ? cnt : 1;
                mult = raccum / cnt << 16 | gaccum / cnt << 8 | baccum / cnt;
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                int cnt = 0;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BiomeMap bm = this.getBiomeRel(dx, dz);
                        if (bm == BiomeMap.NULL) continue;
                        int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                        raccum += rmult >> 16 & 0xFF;
                        gaccum += rmult >> 8 & 0xFF;
                        baccum += rmult & 0xFF;
                        ++cnt;
                    }
                }
                cnt = cnt > 0 ? cnt : 1;
                mult = raccum / cnt << 16 | gaccum / cnt << 8 | baccum / cnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                int cnt = 0;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BiomeMap bm = this.getBiomeRel(dx, dz);
                        if (bm == BiomeMap.NULL) continue;
                        int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                        raccum += rmult >> 16 & 0xFF;
                        gaccum += rmult >> 8 & 0xFF;
                        baccum += rmult & 0xFF;
                        ++cnt;
                    }
                }
                cnt = cnt > 0 ? cnt : 1;
                mult = raccum / cnt << 16 | gaccum / cnt << 8 | baccum / cnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            int multv = 0xFFFFFF;
            try {
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                int cnt = 0;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BiomeMap bm = this.getBiomeRel(dx, dz);
                        if (bm == BiomeMap.NULL) continue;
                        int rmult = bm.getWaterColorMult();
                        raccum += rmult >> 16 & 0xFF;
                        gaccum += rmult >> 8 & 0xFF;
                        baccum += rmult & 0xFF;
                        ++cnt;
                    }
                }
                cnt = cnt > 0 ? cnt : 1;
                multv = raccum / cnt << 16 | gaccum / cnt << 8 | baccum / cnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return multv;
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                int cnt = 0;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BiomeMap bm = this.getBiomeRel(dx, dz);
                        if (bm == BiomeMap.NULL) continue;
                        int rmult = colormap[bm.biomeLookup()];
                        raccum += rmult >> 16 & 0xFF;
                        gaccum += rmult >> 8 & 0xFF;
                        baccum += rmult & 0xFF;
                        ++cnt;
                    }
                }
                cnt = cnt > 0 ? cnt : 1;
                mult = raccum / cnt << 16 | gaccum / cnt << 8 | baccum / cnt;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.blk = null;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    ++this.chunkindex;
                    if (this.chunkindex >= GenericMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = GenericMapChunkCache.this.getEmpty();
                        break;
                    }
                    this.snap = GenericMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.chunkindex += GenericMapChunkCache.this.x_dim;
                    if (this.chunkindex >= GenericMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = GenericMapChunkCache.this.getEmpty();
                        break;
                    }
                    this.snap = GenericMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    --this.chunkindex;
                    if (this.chunkindex >= GenericMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = GenericMapChunkCache.this.getEmpty();
                        break;
                    }
                    this.snap = GenericMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= this.ymin) break;
                    this.blk = DynmapBlockState.AIR;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.chunkindex -= GenericMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= GenericMapChunkCache.this.snapcnt || this.chunkindex < 0 ? GenericMapChunkCache.this.getEmpty() : GenericMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public final BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public final void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            this.blk = y < this.ymin || y >= this.worldheight ? DynmapBlockState.AIR : null;
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final DynmapBlockState getBlockTypeAt(BlockStep s) {
            return this.getBlockTypeAt(s.xoff, s.yoff, s.zoff);
        }

        @Override
        public final BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public final int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public final long getBlockKey() {
            return this.chunkindex * (this.worldheight - this.ymin) + (this.y - this.ymin) << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public final RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public final Object getBlockTileEntityField(String fieldId) {
            return null;
        }

        @Override
        public final DynmapBlockState getBlockTypeAt(int xoff, int yoff, int zoff) {
            int nx = this.x + xoff;
            int ny = this.y + yoff;
            int nz = this.z + zoff;
            int nchunkindex = (nx >> 4) - GenericMapChunkCache.this.x_min + ((nz >> 4) - GenericMapChunkCache.this.z_min) * GenericMapChunkCache.this.x_dim;
            if (nchunkindex >= GenericMapChunkCache.this.snapcnt || nchunkindex < 0) {
                return DynmapBlockState.AIR;
            }
            return GenericMapChunkCache.this.snaparray[nchunkindex].getBlockType(nx & 0xF, ny, nz & 0xF);
        }

        @Override
        public final Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public final long getInhabitedTicks() {
            try {
                return this.snap.getInhabitedTicks();
            }
            catch (Exception x) {
                return 0L;
            }
        }

        @Override
        public final DynmapBlockState getBlockType() {
            if (this.blk == null) {
                this.blk = this.snap.getBlockType(this.bx, this.y, this.bz);
            }
            return this.blk;
        }

        @Override
        public int getDataVersion() {
            return this.snap != null ? this.snap.dataVersion : 0;
        }

        @Override
        public String getChunkStatus() {
            return this.snap != null ? this.snap.chunkStatus : null;
        }
    }
}

