/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.api.request;

import java.util.Objects;

public class DeleteObjectRequest {
    private final String bucketName;
    private final Boolean bypassGovernanceRetention;
    private final String key;
    private final String mfa;
    private final String requestPayer;
    private final String versionId;

    private DeleteObjectRequest(Builder builder) {
        this.bucketName = builder.bucketName;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
        this.key = builder.key;
        this.mfa = builder.mfa;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Boolean getBypassGovernanceRetention() {
        return this.bypassGovernanceRetention;
    }

    public String getKey() {
        return this.key;
    }

    public String getMfa() {
        return this.mfa;
    }

    public String getRequestPayer() {
        return this.requestPayer;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeleteObjectRequest that = (DeleteObjectRequest)obj;
        return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.bypassGovernanceRetention, that.bypassGovernanceRetention) && Objects.equals(this.key, that.key) && Objects.equals(this.mfa, that.mfa) && Objects.equals(this.requestPayer, that.requestPayer) && Objects.equals(this.versionId, that.versionId);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.bypassGovernanceRetention, this.key, this.mfa, this.requestPayer, this.versionId);
    }

    public String toString() {
        return "DeleteObjectRequest{bucketName='" + this.bucketName + '\'' + ", bypassGovernanceRetention=" + this.bypassGovernanceRetention + ", key='" + this.key + '\'' + ", mfa='" + this.mfa + '\'' + ", requestPayer='" + this.requestPayer + '\'' + ", versionId='" + this.versionId + '\'' + '}';
    }

    public static class Builder {
        private String bucketName;
        private Boolean bypassGovernanceRetention;
        private String key;
        private String mfa;
        private String requestPayer;
        private String versionId;

        private Builder() {
        }

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder mfa(String mfa) {
            this.mfa = mfa;
            return this;
        }

        public Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        public Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public DeleteObjectRequest build() {
            return new DeleteObjectRequest(this);
        }
    }
}

