/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_19_2;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.forge_1_19_2.DynmapPlugin;
import org.dynmap.forge_1_19_2.ForgeMapChunkCache;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.Polygon;

public class ForgeWorld
extends DynmapWorld {
    private ServerLevelAccessor world = null;
    private final boolean skylight;
    private final boolean isnether;
    private final boolean istheend;
    private final String env;
    private DynmapLocation spawnloc = new DynmapLocation();
    private static int maxWorldHeight = 320;

    public static int getMaxWorldHeight() {
        return maxWorldHeight;
    }

    public static void setMaxWorldHeight(int h) {
        maxWorldHeight = h;
    }

    public static String getWorldName(ServerLevelAccessor w) {
        ResourceKey rk = w.m_6018_().m_46472_();
        String id = rk.m_135782_().m_135827_() + "_" + rk.m_135782_().m_135815_();
        if (id.equals("minecraft_overworld")) {
            return w.m_6018_().f_8549_.m_5462_();
        }
        if (id.equals("minecraft_the_end")) {
            return "DIM1";
        }
        if (id.equals("minecraft_the_nether")) {
            return "DIM-1";
        }
        return id;
    }

    public void updateWorld(ServerLevelAccessor w) {
        this.updateWorldHeights(w.m_6018_().m_141928_(), w.m_6018_().m_6042_().f_156647_(), w.m_6018_().m_5736_());
    }

    public ForgeWorld(ServerLevelAccessor w) {
        this(ForgeWorld.getWorldName(w), w.m_6018_().m_141928_(), w.m_6018_().m_5736_(), w.m_6018_().m_46472_() == Level.f_46429_, w.m_6018_().m_46472_() == Level.f_46430_, ForgeWorld.getWorldName(w), w.m_6018_().m_6042_().f_156647_());
        this.setWorldLoaded(w);
    }

    public ForgeWorld(String name, int height, int sealevel, boolean nether, boolean the_end, String deftitle, int miny) {
        super(name, height > maxWorldHeight ? maxWorldHeight : height, sealevel, miny);
        this.setTitle(deftitle);
        this.isnether = nether;
        this.istheend = the_end;
        boolean bl = this.skylight = !this.isnether && !this.istheend;
        this.env = this.isnether ? "nether" : (this.istheend ? "the_end" : "normal");
    }

    @Override
    public boolean isNether() {
        return this.isnether;
    }

    public boolean isTheEnd() {
        return this.istheend;
    }

    @Override
    public DynmapLocation getSpawnLocation() {
        if (this.world != null) {
            BlockPos p = this.world.m_6018_().m_220360_();
            this.spawnloc.x = p.m_123341_();
            this.spawnloc.y = p.m_123342_();
            this.spawnloc.z = p.m_123343_();
            this.spawnloc.world = this.getName();
        }
        return this.spawnloc;
    }

    @Override
    public long getTime() {
        if (this.world != null) {
            return this.world.m_6018_().m_46468_();
        }
        return -1L;
    }

    @Override
    public boolean hasStorm() {
        if (this.world != null) {
            return this.world.m_6018_().m_46471_();
        }
        return false;
    }

    @Override
    public boolean isThundering() {
        if (this.world != null) {
            return this.world.m_6018_().m_46470_();
        }
        return false;
    }

    @Override
    public boolean isLoaded() {
        return this.world != null;
    }

    @Override
    public void setWorldUnloaded() {
        this.getSpawnLocation();
        this.world = null;
    }

    public void setWorldLoaded(ServerLevelAccessor w) {
        this.world = w;
        this.sealevel = w.m_6018_().m_5736_();
        for (int i = 0; i < 16; ++i) {
            float value = (float)i / 15.0f;
            float brightness = value / (4.0f - 3.0f * value);
            this.setBrightnessTableEntry(i, brightness);
        }
    }

    @Override
    public int getLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.m_6018_().m_5518_().m_75831_(new BlockPos(x, y, z), 0);
        }
        return -1;
    }

    @Override
    public int getHighestBlockYAt(int x, int z) {
        if (this.world != null) {
            return this.world.m_6018_().m_6325_(x >> 4, z >> 4).m_5885_(Heightmap.Types.MOTION_BLOCKING, x & 0xF, z & 0xF);
        }
        return -1;
    }

    @Override
    public boolean canGetSkyLightLevel() {
        return this.skylight;
    }

    @Override
    public int getSkyLightLevel(int x, int y, int z) {
        if (this.world != null) {
            return this.world.m_6018_().m_45517_(LightLayer.SKY, new BlockPos(x, y, z));
        }
        return -1;
    }

    @Override
    public String getEnvironment() {
        return this.env;
    }

    @Override
    public MapChunkCache getChunkCache(List<DynmapChunk> chunks) {
        if (this.world != null) {
            ForgeMapChunkCache c = new ForgeMapChunkCache(DynmapPlugin.plugin.sscache);
            c.setChunks(this, chunks);
            return c;
        }
        return null;
    }

    public ServerLevel getWorld() {
        return this.world.m_6018_();
    }

    @Override
    public Polygon getWorldBorder() {
        WorldBorder wb;
        if (this.world != null && (wb = this.world.m_6857_()) != null && wb.m_61959_() < 5.9E7) {
            Polygon p = new Polygon();
            p.addVertex(wb.m_61955_(), wb.m_61956_());
            p.addVertex(wb.m_61955_(), wb.m_61958_());
            p.addVertex(wb.m_61957_(), wb.m_61958_());
            p.addVertex(wb.m_61957_(), wb.m_61956_());
            return p;
        }
        return null;
    }
}

