/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.dynmap.Color;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.common.BiomeMap;
import org.dynmap.common.DynmapCommandSender;
import org.dynmap.exporter.OBJExport;
import org.dynmap.hdmap.CTMTexturePack;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDBlockStateTextureMap;
import org.dynmap.hdmap.HDPerspectiveState;
import org.dynmap.hdmap.TexturePackHDShader;
import org.dynmap.hdmap.TexturePackLoader;
import org.dynmap.renderer.CustomColorMultiplier;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.MapIterator;

public class TexturePack {
    private static HashMap<String, TexturePack> packs = new HashMap();
    private static Object packlock = new Object();
    private static final String GRASSCOLOR_PNG = "misc/grasscolor.png";
    private static final String GRASSCOLOR_RP_PNG = "assets/minecraft/textures/colormap/grass.png";
    private static final String FOLIAGECOLOR_PNG = "misc/foliagecolor.png";
    private static final String FOLIAGECOLOR_RP_PNG = "assets/minecraft/textures/colormap/foliage.png";
    private static final String WATERCOLORX_PNG = "misc/watercolorX.png";
    private static final String WATERCOLORX_RP_PNG = "assets/minecraft/mcpatcher/colormap/watercolorX.png";
    private static final String WATERCOLORX2_RP_PNG = "assets/minecraft/mcpatcher/colormap/water.png";
    private static final String CUSTOMLAVASTILL_PNG = "custom_lava_still.png";
    private static final String CUSTOMLAVAFLOWING_PNG = "custom_lava_flowing.png";
    private static final String CUSTOMWATERSTILL_PNG = "custom_water_still.png";
    private static final String CUSTOMWATERFLOWING_PNG = "custom_water_flowing.png";
    private static final String SWAMPGRASSCOLOR_PNG = "misc/swampgrasscolor.png";
    private static final String SWAMPGRASSCOLOR_RP_PNG = "assets/minecraft/mcpatcher/colormap/swampgrass.png";
    private static final String SWAMPFOLIAGECOLOR_PNG = "misc/swampfoliagecolor.png";
    private static final String SWAMPFOLIAGECOLOR_RP_PNG = "assets/minecraft/mcpatcher/colormap/swampfoliage.png";
    private static final String PINECOLOR_PNG = "misc/pinecolor.png";
    private static final String PINECOLOR_RP_PNG = "assets/minecraft/mcpatcher/colormap/pine.png";
    private static final String BIRCHCOLOR_PNG = "misc/birchcolor.png";
    private static final String BIRCHCOLOR_RP_PNG = "assets/minecraft/mcpatcher/colormap/birch.png";
    public static final int COLORMOD_GRASSTONED = 1;
    public static final int COLORMOD_FOLIAGETONED = 2;
    public static final int COLORMOD_WATERTONED = 3;
    public static final int COLORMOD_ROT90 = 4;
    public static final int COLORMOD_ROT180 = 5;
    public static final int COLORMOD_ROT270 = 6;
    public static final int COLORMOD_FLIPHORIZ = 7;
    public static final int COLORMOD_SHIFTDOWNHALF = 8;
    public static final int COLORMOD_SHIFTDOWNHALFANDFLIPHORIZ = 9;
    public static final int COLORMOD_INCLINEDTORCH = 10;
    public static final int COLORMOD_GRASSSIDE = 11;
    public static final int COLORMOD_CLEARINSIDE = 12;
    public static final int COLORMOD_PINETONED = 13;
    public static final int COLORMOD_BIRCHTONED = 14;
    public static final int COLORMOD_LILYTONED = 15;
    public static final int COLORMOD_MULTTONED = 17;
    public static final int COLORMOD_GRASSTONED270 = 18;
    public static final int COLORMOD_FOLIAGETONED270 = 19;
    public static final int COLORMOD_WATERTONED270 = 20;
    public static final int COLORMOD_MULTTONED_CLEARINSIDE = 21;
    public static final int COLORMOD_FOLIAGEMULTTONED = 22;
    private static final int COLORMOD_MULT_FILE = 1000;
    private static final int COLORMOD_MULT_INTERNAL = 1000000;
    public static final int TILEINDEX_BLANK = -1;
    private static final int TILEINDEX_GRASS = 0;
    private static final int TILEINDEX_GRASSMASK = 38;
    private static final int TILEINDEX_SNOW = 66;
    private static final int TILEINDEX_SNOWSIDE = 68;
    private static final int TILEINDEX_PISTONSIDE = 108;
    private static final int TILEINDEX_GLASSPANETOP = 148;
    private static final int TILEINDEX_AIRFRAME = 158;
    private static final int TILEINDEX_REDSTONE_NSEW_TONE = 164;
    private static final int TILEINDEX_REDSTONE_EW_TONE = 165;
    private static final int TILEINDEX_EYEOFENDER = 174;
    private static final int TILEINDEX_REDSTONE_NSEW = 180;
    private static final int TILEINDEX_REDSTONE_EW = 181;
    private static final int TILEINDEX_STATIONARYWATER = 257;
    private static final int TILEINDEX_MOVINGWATER = 258;
    private static final int TILEINDEX_STATIONARYLAVA = 259;
    private static final int TILEINDEX_MOVINGLAVA = 260;
    private static final int TILEINDEX_PISTONEXTSIDE = 261;
    private static final int TILEINDEX_PISTONSIDE_EXT = 262;
    private static final int TILEINDEX_PANETOP_X = 263;
    private static final int TILEINDEX_AIRFRAME_EYE = 264;
    private static final int TILEINDEX_WHITE = 267;
    private static final int MAX_TILEINDEX = 267;
    private static final int TILEINDEX_CHEST_TOP = 0;
    private static final int TILEINDEX_CHEST_LEFT = 1;
    private static final int TILEINDEX_CHEST_RIGHT = 2;
    private static final int TILEINDEX_CHEST_FRONT = 3;
    private static final int TILEINDEX_CHEST_BACK = 4;
    private static final int TILEINDEX_CHEST_BOTTOM = 5;
    private static final int TILEINDEX_CHEST_COUNT = 6;
    private static final int TILEINDEX_BIGCHEST_TOPLEFT = 0;
    private static final int TILEINDEX_BIGCHEST_TOPRIGHT = 1;
    private static final int TILEINDEX_BIGCHEST_FRONTLEFT = 2;
    private static final int TILEINDEX_BIGCHEST_FRONTRIGHT = 3;
    private static final int TILEINDEX_BIGCHEST_LEFT = 4;
    private static final int TILEINDEX_BIGCHEST_RIGHT = 5;
    private static final int TILEINDEX_BIGCHEST_BACKLEFT = 6;
    private static final int TILEINDEX_BIGCHEST_BACKRIGHT = 7;
    private static final int TILEINDEX_BIGCHEST_BOTTOMLEFT = 8;
    private static final int TILEINDEX_BIGCHEST_BOTTOMRIGHT = 9;
    private static final int TILEINDEX_BIGCHEST_COUNT = 10;
    private static final int TILEINDEX_SIGN_FRONT = 0;
    private static final int TILEINDEX_SIGN_BACK = 1;
    private static final int TILEINDEX_SIGN_TOP = 2;
    private static final int TILEINDEX_SIGN_BOTTOM = 3;
    private static final int TILEINDEX_SIGN_LEFTSIDE = 4;
    private static final int TILEINDEX_SIGN_RIGHTSIDE = 5;
    private static final int TILEINDEX_SIGN_POSTFRONT = 6;
    private static final int TILEINDEX_SIGN_POSTBACK = 7;
    private static final int TILEINDEX_SIGN_POSTLEFT = 8;
    private static final int TILEINDEX_SIGN_POSTRIGHT = 9;
    private static final int TILEINDEX_SIGN_COUNT = 10;
    private static final int TILEINDEX_SKIN_FACEFRONT = 0;
    private static final int TILEINDEX_SKIN_FACELEFT = 1;
    private static final int TILEINDEX_SKIN_FACERIGHT = 2;
    private static final int TILEINDEX_SKIN_FACEBACK = 3;
    private static final int TILEINDEX_SKIN_FACETOP = 4;
    private static final int TILEINDEX_SKIN_FACEBOTTOM = 5;
    private static final int TILEINDEX_SKIN_COUNT = 6;
    private static final int TILEINDEX_SHULKER_TOP = 0;
    private static final int TILEINDEX_SHULKER_LEFT = 1;
    private static final int TILEINDEX_SHULKER_RIGHT = 2;
    private static final int TILEINDEX_SHULKER_FRONT = 3;
    private static final int TILEINDEX_SHULKER_BACK = 4;
    private static final int TILEINDEX_SHULKER_BOTTOM = 5;
    private static final int TILEINDEX_SHULKER_COUNT = 6;
    private static final int TILEINDEX_BED_COUNT = 18;
    private static final String[] terrain_map = new String[]{"grass_top", "stone", "dirt", "grass_side", "wood", "stoneslab_side", "stoneslab_top", "brick", "tnt_side", "tnt_top", "tnt_bottom", "web", "rose", "flower", "portal", "sapling", "stonebrick", "bedrock", "sand", "gravel", "tree_side", "tree_top", "blockIron", "blockGold", "blockDiamond", "blockEmerald", null, null, "mushroom_red", "mushroom_brown", "sapling_jungle", null, "oreGold", "oreIron", "oreCoal", "bookshelf", "stoneMoss", "obsidian", "grass_side_overlay", "tallgrass", null, "beacon", null, "workbench_top", "furnace_front", "furnace_side", "dispenser_front", null, "sponge", "glass", "oreDiamond", "oreRedstone", "leaves", "leaves_opaque", "stonebricksmooth", "deadbush", "fern", null, null, "workbench_side", "workbench_front", "furnace_front_lit", "furnace_top", "sapling_spruce", "cloth_0", "mobSpawner", "snow", "ice", "snow_side", "cactus_top", "cactus_side", "cactus_bottom", "clay", "reeds", "musicBlock", "jukebox_top", "waterlily", "mycel_side", "mycel_top", "sapling_birch", "torch", "doorWood_upper", "doorIron_upper", "ladder", "trapdoor", "fenceIron", "farmland_wet", "farmland_dry", "crops_0", "crops_1", "crops_2", "crops_3", "crops_4", "crops_5", "crops_6", "crops_7", "lever", "doorWood_lower", "doorIron_lower", "redtorch_lit", "stonebricksmooth_mossy", "stonebricksmooth_cracked", "pumpkin_top", "hellrock", "hellsand", "lightgem", "piston_top_sticky", "piston_top", "piston_side", "piston_bottom", "piston_inner_top", "stem_straight", "rail_turn", "cloth_15", "cloth_7", "redtorch", "tree_spruce", "tree_birch", "pumpkin_side", "pumpkin_face", "pumpkin_jack", "cake_top", "cake_side", "cake_inner", "cake_bottom", "mushroom_skin_red", "mushroom_skin_brown", "stem_bent", "rail", "cloth_14", "cloth_6", "repeater", "leaves_spruce", "leaves_spruce_opaque", "bed_feet_top", "bed_head_top", "melon_side", "melon_top", "cauldron_top", "cauldron_inner", null, "mushroom_skin_stem", "mushroom_inside", "vine", "blockLapis", "cloth_13", "cloth_5", "repeater_lit", "thinglass_top", "bed_feet_end", "bed_feet_side", "bed_head_side", "bed_head_end", "tree_jungle", "cauldron_side", "cauldron_bottom", "brewingStand_base", "brewingStand", "endframe_top", "endframe_side", "oreLapis", "cloth_12", "cloth_4", "goldenRail", "redstoneDust_cross", "redstoneDust_line", "enchantment_top", "dragonEgg", "cocoa_2", "cocoa_1", "cocoa_0", "oreEmerald", "tripWireSource", "tripWire", "endframe_eye", "whiteStone", "sandstone_top", "cloth_11", "cloth_3", "goldenRail_powered", "redstoneDust_cross_overlay", "redstoneDust_line_overlay", "enchantment_side", "enchantment_bottom", "commandBlock", "itemframe_back", "flowerPot", null, null, null, null, null, "sandstone_side", "cloth_10", "cloth_2", "detectorRail", "leaves_jungle", "leaves_jungle_opaque", "wood_spruce", "wood_jungle", "carrots_0", "carrots_1", "carrots_2", "carrots_3", "potatoes_3", null, null, null, "sandstone_bottom", "cloth_9", "cloth_1", "redstoneLight", "redstoneLight_lit", "stonebricksmooth_carved", "wood_birch", "anvil_base", "anvil_top_damaged_1", null, null, null, null, null, null, null, "netherBrick", "cloth_8", "netherStalk_0", "netherStalk_1", "netherStalk_2", "sandstone_carved", "sandstone_smooth", "anvil_top", "anvil_top_damaged_2", null, null, null, null, null, null, null, "destroy_0", "destroy_1", "destroy_2", "destroy_3", "destroy_4", "destroy_5", "destroy_6", "destroy_7", "destroy_8", "destroy_9", null, null, null, null, null, null, null, "water", "water_flow", "lava", "lava_flow", null, null, null, null, "fire_0", "portal"};
    private static final String[] terrain_rp_map = new String[]{"grass_top", "stone", "dirt", "grass_side", "planks_oak", "stone_slab_side", "stone_slab_top", "brick", "tnt_side", "tnt_top", "tnt_bottom", "web", "flower_rose", "flower_dandelion", "portal", "sapling_oak", "cobblestone", "bedrock", "sand", "gravel", "log_oak", "log_oak_top", "iron_block", "gold_block", "diamond_block", "emerald_block", null, null, "mushroom_red", "mushroom_brown", "sapling_jungle", null, "gold_ore", "iron_ore", "coal_ore", "bookshelf", "cobblestone_mossy", "obsidian", "grass_side_overlay", "tallgrass", null, "beacon", null, "crafting_table_top", "furnace_front_off", "furnace_side", "dispenser_front_horizontal", null, "sponge", "glass", "diamond_ore", "redstone_ore", "leaves_oak", "leaves_oak_opaque", "stonebrick", "deadbush", "fern", null, null, "crafting_table_side", "crafting_table_front", "furnace_front_on", "furnace_top", "sapling_spruce", "wool_colored_white", "mob_spawner", "snow", "ice", "grass_side_snowed", "cactus_top", "cactus_side", "cactus_bottom", "clay", "reeds", "jukebox_side", "jukebox_top", "waterlily", "mycelium_side", "mycelium_top", "sapling_birch", "torch_on", "door_wood_upper", "door_iron_upper", "ladder", "trapdoor", "iron_bars", "farmland_wet", "farmland_dry", "wheat_stage_0", "wheat_stage_1", "wheat_stage_2", "wheat_stage_3", "wheat_stage_4", "wheat_stage_5", "wheat_stage_6", "wheat_stage_7", "lever", "door_wood_lower", "door_iron_lower", "redstone_torch_on", "stonebrick_mossy", "stonebrick_cracked", "pumpkin_top", "netherrack", "soul_sand", "glowstone", "piston_top_sticky", "piston_top_normal", "piston_side", "piston_bottom", "piston_inner", "pumpkin_stem_disconnected", "rail_normal_turned", "wool_colored_black", "wool_colored_gray", "redstone_torch_off", "log_spruce", "log_birch", "pumpkin_side", "pumpkin_face_off", "pumpkin_face_on", "cake_top", "cake_side", "cake_inner", "cake_bottom", "mushroom_block_skin_red", "mushroom_block_skin_brown", "pumpkin_stem_connected", "rail_normal", "wool_colored_red", "wool_colored_pink", "repeater_off", "leaves_spruce", "leaves_spruce_opaque", "bed_feet_top", "bed_head_top", "melon_side", "melon_top", "cauldron_top", "cauldron_inner", null, "mushroom_block_skin_stem", "mushroom_block_inside", "vine", "lapis_block", "wool_colored_green", "wool_colored_lime", "repeater_on", "glass_pane_top", "bed_feet_end", "bed_feet_side", "bed_head_side", "bed_head_end", "log_jungle", "cauldron_side", "cauldron_bottom", "brewing_stand_base", "brewing_stand", "endframe_top", "endframe_side", "lapis_ore", "wool_colored_brown", "wool_colored_yellow", "rail_golden", "redstone_dust_cross", "redstone_dust_line", "enchanting_table_top", "dragon_egg", "cocoa_stage_2", "cocoa_stage_1", "cocoa_stage_0", "emerald_ore", "trip_wire_source", "trip_wire", "endframe_eye", "end_stone", "sandstone_top", "wool_colored_blue", "wool_colored_light_blue", "rail_golden_powered", "redstone_dust_cross_overlay", "redstone_dust_line_overlay", "enchanting_table_side", "enchanting_table_bottom", "command_block", "itemframe_background", "flower_pot", null, null, null, null, null, "sandstone_normal", "wool_colored_purple", "wool_colored_magenta", "rail_detector", "leaves_jungle", "leaves_jungle_opaque", "planks_spruce", "planks_jungle", "carrots_stage_0", "carrots_stage_1", "carrots_stage_2", "carrots_stage_3", "potatoes_stage_3", null, null, null, "sandstone_bottom", "wool_colored_cyan", "wool_colored_orange", "redstone_lamp_off", "redstone_lamp_on", "stonebrick_carved", "planks_birch", "anvil_base", "anvil_top_damaged_1", null, null, null, null, null, null, null, "nether_brick", "wool_colored_silver", "nether_wart_stage_0", "nether_wart_stage_1", "nether_wart_stage_2", "sandstone_carved", "sandstone_smooth", "anvil_top_damaged_0", "anvil_top_damaged_2", null, null, null, null, null, null, null, "destroy_stage_0", "destroy_stage_1", "destroy_stage_2", "destroy_stage_3", "destroy_stage_4", "destroy_stage_5", "destroy_stage_6", "destroy_stage_7", "destroy_stage_8", "destroy_stage_9", null, null, null, null, null, null, null, "water_still", "water_flow", "lava_still", "lava_flow", null, null, null, null, "fire_layer_0", "portal"};
    private static int next_dynamic_tile = 268;
    private static ArrayList<DynamicTileFile> addonfiles = new ArrayList();
    private static Map<String, DynamicTileFile> addonfilesbyname = new HashMap<String, DynamicTileFile>();
    private Map<Integer, MaterialType> materialbytileid = new HashMap<Integer, MaterialType>();
    private Map<Integer, String> matIDByTileID = new HashMap<Integer, String>();
    private Map<String, Integer> tileIDByMatID = new HashMap<String, Integer>();
    private static HashSet<String> loadedmods = new HashSet();
    private int[][] tile_argb;
    private int[] blank;
    private int native_scale;
    private CTMTexturePack ctm;
    private ColorizingData blockColoring = HDBlockStateTextureMap.getColorizingData();
    private int colorMultBirch = 8431445;
    private int colorMultPine = 0x619961;
    private int colorMultLily = 2129968;
    private static final int IMG_GRASSCOLOR = 0;
    private static final int IMG_FOLIAGECOLOR = 1;
    private static final int IMG_CUSTOMWATERMOVING = 2;
    private static final int IMG_CUSTOMWATERSTILL = 3;
    private static final int IMG_CUSTOMLAVAMOVING = 4;
    private static final int IMG_CUSTOMLAVASTILL = 5;
    private static final int IMG_WATERCOLORX = 6;
    private static final int IMG_SWAMPGRASSCOLOR = 7;
    private static final int IMG_SWAMPFOLIAGECOLOR = 8;
    private static final int IMG_PINECOLOR = 9;
    private static final int IMG_BIRCHCOLOR = 10;
    private static final int IMG_CNT = 11;
    private LoadedImage[] imgs;
    private HashMap<Integer, TexturePack> scaled_textures;
    private Object scaledlock = new Object();
    private static HashMap<String, TextureMap> textmap_by_id = new HashMap();
    private static List<CustomTileRec> bed_patches = Arrays.asList(new CustomTileRec(6, 6, 16, 16), new CustomTileRec(28, 6, 16, 16), new CustomTileRec(0, 6, 6, 16), new CustomTileRec(22, 6, 6, 16), new CustomTileRec(6, 0, 16, 6), new CustomTileRec(6, 28, 16, 16), new CustomTileRec(28, 28, 16, 16), new CustomTileRec(0, 28, 6, 16), new CustomTileRec(22, 28, 6, 16), new CustomTileRec(22, 22, 16, 6), new CustomTileRec(50, 0, 6, 6), new CustomTileRec(56, 0, 6, 6), new CustomTileRec(50, 6, 6, 6), new CustomTileRec(56, 6, 6, 6), new CustomTileRec(50, 12, 6, 6), new CustomTileRec(56, 12, 6, 6), new CustomTileRec(50, 18, 6, 6), new CustomTileRec(56, 18, 6, 6));
    private static final int TXTID_INVALID = -2;
    private static final int TXTID_TERRAINPNG = -1;
    private static final int[] smooth_water_mult = new int[10];
    private static final String PALETTE_BLOCK_KEY = "palette.block.";
    private static final int[] deftxtidx;

    private static String getBlockFileName(int idx) {
        if (idx >= 0 && idx < terrain_map.length && terrain_map[idx] != null) {
            return "textures/blocks/" + terrain_map[idx] + ".png";
        }
        return null;
    }

    private static String getRPFileName(int idx) {
        if (idx >= 0 && idx < terrain_rp_map.length && terrain_rp_map[idx] != null) {
            return "assets/minecraft/textures/blocks/" + terrain_rp_map[idx] + ".png";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetFiles(DynmapCore core) {
        int idx;
        DynamicTileFile dtf;
        String fn;
        int i;
        Object object = packlock;
        synchronized (object) {
            packs.clear();
        }
        addonfiles.clear();
        addonfilesbyname.clear();
        loadedmods.clear();
        next_dynamic_tile = 268;
        for (i = 0; i < terrain_rp_map.length; ++i) {
            fn = TexturePack.getRPFileName(i);
            if (fn == null || (dtf = addonfiles.get(idx = TexturePack.findOrAddDynamicTileFile(fn, null, 1, 1, TileFileFormat.GRID, new String[0]))) == null) continue;
            dtf.tile_to_dyntile[0] = i;
            dtf.used = true;
        }
        for (i = 0; i < terrain_map.length; ++i) {
            fn = TexturePack.getBlockFileName(i);
            if (fn == null || (dtf = addonfiles.get(idx = TexturePack.findOrAddDynamicTileFile(fn, null, 1, 1, TileFileFormat.GRID, new String[0]))) == null) continue;
            dtf.used = true;
            dtf.tile_to_dyntile[0] = i;
        }
    }

    public final void setTileARGB(int idx, int[] buf) {
        if (idx >= this.tile_argb.length) {
            this.tile_argb = (int[][])Arrays.copyOf(this.tile_argb, 3 * idx / 2);
        }
        this.tile_argb[idx] = buf;
    }

    public final int getTileARGBCount() {
        return this.tile_argb.length;
    }

    public final int[] getTileARGB(int idx) {
        int[] rslt = this.blank;
        if (idx < this.tile_argb.length && (rslt = this.tile_argb[idx]) == null) {
            this.tile_argb[idx] = this.blank;
            rslt = this.blank;
        }
        return rslt;
    }

    private static int addTextureByKey(String id, int key, int textureid) {
        TextureMap idx = textmap_by_id.get(id);
        if (idx == null) {
            idx = new TextureMap();
            textmap_by_id.put(id, idx);
        }
        return idx.addTextureByKey(key, textureid);
    }

    private static void addTextureIndex(String id, Map<DynmapBlockState, BitSet> states, BlockTransparency trans, int colorMult, CustomColorMultiplier custColorMult, String blockset) {
        TextureMap idx = textmap_by_id.get(id);
        if (idx == null) {
            idx = new TextureMap();
            textmap_by_id.put(id, idx);
        }
        idx.states = states;
        idx.trans = trans;
        idx.colorMult = colorMult;
        idx.custColorMult = custColorMult;
    }

    private static void processTextureMaps() {
        for (TextureMap ti : textmap_by_id.values()) {
            if (ti.states.isEmpty()) continue;
            int[] txtids = new int[ti.texture_ids.size()];
            for (int i = 0; i < txtids.length; ++i) {
                txtids[i] = (Integer)ti.texture_ids.get(i);
            }
            HDBlockStateTextureMap map = new HDBlockStateTextureMap(txtids, null, ti.colorMult, ti.custColorMult, ti.blockset, true, null, ti.trans);
            map.addToTable(ti.states);
        }
    }

    public static int getTextureIndexFromTextureMap(String id, int key) {
        Integer txtidx;
        int idx = -1;
        TextureMap map = textmap_by_id.get(id);
        if (map != null && (txtidx = (Integer)map.key_to_index.get(key)) != null) {
            idx = txtidx;
        }
        return idx;
    }

    public static int getTextureMapLength(String id) {
        TextureMap map = textmap_by_id.get(id);
        if (map != null) {
            return map.texture_ids.size();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TexturePack getTexturePack(DynmapCore core, String tpname) {
        Object object = packlock;
        synchronized (object) {
            TexturePack tp = packs.get(tpname);
            if (tp != null) {
                return tp;
            }
            try {
                tp = new TexturePack(core, tpname);
                packs.put(tpname, tp);
                return tp;
            }
            catch (FileNotFoundException fnfx) {
                Log.severe("Error loading texture pack '" + tpname + "' - not found");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TexturePack(DynmapCore core, String tpname) throws FileNotFoundException {
        File texturedir = TexturePack.getTexturePackDirectory(core);
        this.imgs = new LoadedImage[11 + addonfiles.size()];
        File f = new File(texturedir, tpname);
        TexturePackLoader tpl = new TexturePackLoader(f, core);
        InputStream is = null;
        try {
            DynamicTileFile dtf;
            int i;
            String fn;
            boolean is_rp = false;
            is = tpl.openTPResource("pack.mcmeta");
            if (is != null) {
                tpl.closeResource(is);
                is_rp = true;
                Log.info("Loading resource pack " + f.getName());
            } else if (tpname.equals("standard")) {
                is_rp = true;
                Log.info("Loading default resource pack");
            } else {
                Log.info("Loading texture pack " + f.getName());
            }
            if (core.isCTMSupportEnabled()) {
                this.ctm = new CTMTexturePack(tpl, this, core, is_rp);
                if (!this.ctm.isValid()) {
                    this.ctm = null;
                }
            }
            if (core.isCustomColorsSupportEnabled() && (is = tpl.openTPResource(fn = is_rp ? "assets/minecraft/mcpatcher/color.properties" : "color.properties")) != null) {
                Properties p = new Properties();
                try {
                    p.load(is);
                }
                finally {
                    tpl.closeResource(is);
                }
                this.processCustomColors(p);
            }
            for (i = 0; i < addonfiles.size(); ++i) {
                dtf = addonfiles.get(i);
                if (!dtf.used) continue;
                is = tpl.openModTPResource(dtf.filename, dtf.modname);
                try {
                    if (dtf.format == TileFileFormat.BIOME) {
                        this.loadBiomeShadingImage(is, i + 11, dtf.filename, dtf.modname);
                        continue;
                    }
                    this.loadImage(is, i + 11, dtf.filename, dtf.modname);
                    continue;
                }
                finally {
                    tpl.closeResource(is);
                }
            }
            this.loadTerrain(is_rp);
            is = tpl.openTPResource(GRASSCOLOR_PNG, GRASSCOLOR_RP_PNG);
            if (is != null) {
                this.loadBiomeShadingImage(is, 0, GRASSCOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(FOLIAGECOLOR_PNG, FOLIAGECOLOR_RP_PNG)) != null) {
                this.loadBiomeShadingImage(is, 1, FOLIAGECOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(SWAMPGRASSCOLOR_PNG, SWAMPGRASSCOLOR_RP_PNG)) != null) {
                this.loadBiomeShadingImage(is, 7, SWAMPGRASSCOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(SWAMPFOLIAGECOLOR_PNG, SWAMPFOLIAGECOLOR_RP_PNG)) != null) {
                this.loadBiomeShadingImage(is, 8, SWAMPFOLIAGECOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(WATERCOLORX_PNG, WATERCOLORX_RP_PNG)) == null) {
                is = tpl.openTPResource(WATERCOLORX_PNG, WATERCOLORX2_RP_PNG);
            }
            if (is != null) {
                this.loadBiomeShadingImage(is, 6, WATERCOLORX_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(PINECOLOR_PNG, PINECOLOR_RP_PNG)) != null) {
                this.loadBiomeShadingImage(is, 9, PINECOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(BIRCHCOLOR_PNG, BIRCHCOLOR_RP_PNG)) != null) {
                this.loadBiomeShadingImage(is, 10, BIRCHCOLOR_RP_PNG, "minecraft");
                tpl.closeResource(is);
            }
            if ((is = tpl.openTPResource(CUSTOMLAVASTILL_PNG)) == null) {
                is = tpl.openTPResource("anim/custom_lava_still.png");
            }
            if (is != null) {
                this.loadImage(is, 5, CUSTOMLAVASTILL_PNG, "minecraft");
                tpl.closeResource(is);
                this.patchTextureWithImage(5, 259);
                this.patchTextureWithImage(5, 260);
            }
            if ((is = tpl.openTPResource(CUSTOMLAVAFLOWING_PNG)) == null) {
                is = tpl.openTPResource("anim/custom_lava_flowing.png");
            }
            if (is != null) {
                this.loadImage(is, 4, CUSTOMLAVAFLOWING_PNG, "minecraft");
                tpl.closeResource(is);
                this.patchTextureWithImage(4, 260);
            }
            if ((is = tpl.openTPResource(CUSTOMWATERSTILL_PNG)) == null) {
                is = tpl.openTPResource("anim/custom_water_still.png");
            }
            if (is != null) {
                this.loadImage(is, 3, CUSTOMWATERSTILL_PNG, "minecraft");
                tpl.closeResource(is);
                this.patchTextureWithImage(3, 257);
                this.patchTextureWithImage(3, 258);
            }
            if ((is = tpl.openTPResource(CUSTOMWATERFLOWING_PNG)) == null) {
                is = tpl.openTPResource("anim/custom_water_flowing.png");
            }
            if (is != null) {
                this.loadImage(is, 2, CUSTOMWATERSTILL_PNG, "minecraft");
                tpl.closeResource(is);
                this.patchTextureWithImage(2, 258);
            }
            for (i = 0; i < addonfiles.size(); ++i) {
                dtf = addonfiles.get(i);
                this.processDynamicImage(i, dtf.format);
            }
        }
        catch (IOException iox) {
            Log.severe("Error loadling texture pack", iox);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                is = null;
            }
            tpl.close();
        }
    }

    private void copySubimageFromImage(int img_id, int from_x, int from_y, int to_x, int to_y, int width, int height, int[] dest_argb, int dest_width) {
        for (int h = 0; h < height; ++h) {
            try {
                System.arraycopy(this.imgs[img_id].argb, (h + from_y) * this.imgs[img_id].width + from_x, dest_argb, dest_width * (h + to_y) + to_x, width);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException aoobx) {
                Log.warning(String.format("Error copying subimage: img_id=%s, from=%d,%s, to=%d,%d, size=%d,%d, dest=%d,%d", this.imgs[img_id].fname, from_x, from_y, to_x, to_y, width, height, dest_width, dest_argb.length / dest_width));
            }
        }
    }

    private void combineSubimageFromImage(int img_id, int from_x, int from_y, int to_x, int to_y, int width, int height, int[] dest_argb, int dest_width) {
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                int src_argb = this.imgs[img_id].argb[(h + from_y) * this.imgs[img_id].width + (w + from_x)];
                if ((src_argb >> 24 & 0xFF) != 255) continue;
                dest_argb[dest_width * (h + to_y) + (w + to_x)] = src_argb;
            }
        }
    }

    private void makeChestSideImage(int img_id, int dest_idx, int src_x, int width, int dest_x, HandlePos handlepos) {
        if (dest_idx <= 0) {
            return;
        }
        int mult = this.imgs[img_id].height / 64;
        int[] tile = new int[256 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, 14 * mult, dest_x * mult, 2 * mult, width * mult, 5 * mult, tile, 16 * mult);
        this.copySubimageFromImage(img_id, src_x * mult, 34 * mult, dest_x * mult, 7 * mult, width * mult, 9 * mult, tile, 16 * mult);
        if (handlepos == HandlePos.CENTER) {
            this.copySubimageFromImage(img_id, 1 * mult, 1 * mult, 7 * mult, 4 * mult, 2 * mult, 4 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.LEFT) {
            this.copySubimageFromImage(img_id, 3 * mult, 1 * mult, 0 * mult, 4 * mult, 1 * mult, 4 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.LEFTFRONT) {
            this.copySubimageFromImage(img_id, 2 * mult, 1 * mult, 0 * mult, 4 * mult, 1 * mult, 4 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.RIGHT) {
            this.copySubimageFromImage(img_id, 0 * mult, 1 * mult, 15 * mult, 4 * mult, 1 * mult, 4 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.RIGHTFRONT) {
            this.copySubimageFromImage(img_id, 1 * mult, 1 * mult, 15 * mult, 4 * mult, 1 * mult, 4 * mult, tile, 16 * mult);
        }
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(16 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void makeChestTopBottomImage(int img_id, int dest_idx, int src_x, int src_y, int width, int dest_x, HandlePos handlepos) {
        if (dest_idx <= 0) {
            return;
        }
        int mult = this.imgs[img_id].height / 64;
        int[] tile = new int[256 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, src_y * mult, dest_x * mult, 1 * mult, width * mult, 14 * mult, tile, 16 * mult);
        if (handlepos == HandlePos.CENTER) {
            this.copySubimageFromImage(img_id, 1 * mult, 0, 7 * mult, 15 * mult, 2 * mult, 1 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.LEFT) {
            this.copySubimageFromImage(img_id, 2 * mult, 0, 0 * mult, 15 * mult, 1 * mult, 1 * mult, tile, 16 * mult);
        } else if (handlepos == HandlePos.RIGHT) {
            this.copySubimageFromImage(img_id, 1 * mult, 0, 15 * mult, 15 * mult, 1 * mult, 1 * mult, tile, 16 * mult);
        }
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(16 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void patchChestImages(int img_id, int tile_top, int tile_bottom, int tile_front, int tile_back, int tile_left, int tile_right) {
        this.makeChestSideImage(img_id, tile_front, 14, 14, 1, HandlePos.CENTER);
        this.makeChestSideImage(img_id, tile_back, 42, 14, 1, HandlePos.NONE);
        this.makeChestSideImage(img_id, tile_left, 0, 14, 1, HandlePos.RIGHT);
        this.makeChestSideImage(img_id, tile_right, 28, 14, 1, HandlePos.LEFT);
        this.makeChestTopBottomImage(img_id, tile_top, 14, 0, 14, 1, HandlePos.CENTER);
        this.makeChestTopBottomImage(img_id, tile_bottom, 28, 19, 14, 1, HandlePos.CENTER);
    }

    private void patchLargeChestImages(int img_id, int tile_topright, int tile_topleft, int tile_bottomright, int tile_bottomleft, int tile_right, int tile_left, int tile_frontright, int tile_frontleft, int tile_backright, int tile_backleft) {
        this.makeChestSideImage(img_id, tile_frontleft, 14, 15, 1, HandlePos.RIGHTFRONT);
        this.makeChestSideImage(img_id, tile_frontright, 29, 15, 0, HandlePos.LEFTFRONT);
        this.makeChestSideImage(img_id, tile_left, 0, 14, 1, HandlePos.RIGHT);
        this.makeChestSideImage(img_id, tile_right, 44, 14, 1, HandlePos.LEFT);
        this.makeChestSideImage(img_id, tile_backright, 58, 15, 1, HandlePos.NONE);
        this.makeChestSideImage(img_id, tile_backleft, 73, 15, 0, HandlePos.NONE);
        this.makeChestTopBottomImage(img_id, tile_topleft, 14, 0, 15, 1, HandlePos.RIGHT);
        this.makeChestTopBottomImage(img_id, tile_topright, 29, 0, 15, 0, HandlePos.LEFT);
        this.makeChestTopBottomImage(img_id, tile_bottomleft, 34, 19, 15, 1, HandlePos.RIGHT);
        this.makeChestTopBottomImage(img_id, tile_bottomright, 49, 19, 15, 0, HandlePos.LEFT);
    }

    private void makeSignImage(int img_id, int dest_idx, int src_x, int src_y, int width, int height) {
        int mult = this.imgs[img_id].height / 32;
        int[] tile = new int[576 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, src_y * mult, 0, (24 - height) * mult, width * mult, height * mult, tile, 24 * mult);
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(24 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void patchSignImages(int img, int sign_front, int sign_back, int sign_top, int sign_bottom, int sign_left, int sign_right, int post_front, int post_back, int post_left, int post_right) {
        this.makeSignImage(img, sign_front, 2, 2, 24, 12);
        this.makeSignImage(img, sign_back, 28, 2, 24, 12);
        this.makeSignImage(img, sign_top, 2, 0, 24, 2);
        this.makeSignImage(img, sign_left, 0, 2, 2, 12);
        this.makeSignImage(img, sign_right, 26, 2, 2, 12);
        this.makeSignImage(img, sign_bottom, 26, 0, 24, 2);
        this.makeSignImage(img, post_front, 0, 16, 2, 14);
        this.makeSignImage(img, post_right, 2, 16, 2, 14);
        this.makeSignImage(img, post_back, 4, 16, 2, 14);
        this.makeSignImage(img, post_left, 6, 16, 2, 14);
    }

    private void makeFaceImage(int img_id, int dest_idx, int src_x, int src_y) {
        int mult = this.imgs[img_id].width / 64;
        int[] tile = new int[64 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, src_y * mult, 0, 0, 8 * mult, 8 * mult, tile, 8 * mult);
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(8 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void patchSkinImages(int img, int face_front, int face_left, int face_right, int face_back, int face_top, int face_bottom) {
        this.makeFaceImage(img, face_front, 8, 8);
        this.makeFaceImage(img, face_left, 16, 8);
        this.makeFaceImage(img, face_right, 0, 8);
        this.makeFaceImage(img, face_back, 24, 8);
        this.makeFaceImage(img, face_top, 8, 0);
        this.makeFaceImage(img, face_bottom, 16, 0);
    }

    private void makeShulkerSideImage(int img_id, int dest_idx, int src_x) {
        int mult = this.imgs[img_id].width / 64;
        int src_y_top = 16;
        int src_y_btm = 44;
        int[] tile = new int[256 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, src_y_top * mult, 0, 0, 16 * mult, 12 * mult, tile, 16 * mult);
        this.combineSubimageFromImage(img_id, src_x * mult, src_y_btm * mult, 0, 8 * mult, 16 * mult, 8 * mult, tile, 16 * mult);
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(16 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void makeShulkerTopBottomImage(int img_id, int dest_idx, int src_x, int src_y) {
        int mult = this.imgs[img_id].width / 64;
        int[] tile = new int[256 * mult * mult];
        this.copySubimageFromImage(img_id, src_x * mult, src_y * mult, 0, 0, 16 * mult, 16 * mult, tile, 16 * mult);
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(16 * mult, this.native_scale, tile, new_argb);
        this.setTileARGB(dest_idx, new_argb);
    }

    private void patchShulkerImages(int img_id, int tile_top, int tile_bottom, int tile_front, int tile_back, int tile_left, int tile_right) {
        this.makeShulkerSideImage(img_id, tile_front, 0);
        this.makeShulkerSideImage(img_id, tile_back, 16);
        this.makeShulkerSideImage(img_id, tile_left, 32);
        this.makeShulkerSideImage(img_id, tile_right, 48);
        this.makeShulkerTopBottomImage(img_id, tile_top, 16, 0);
        this.makeShulkerTopBottomImage(img_id, tile_bottom, 32, 28);
    }

    private void patchCustomImages(int img_id, int[] imgids, List<CustomTileRec> recs, int xcnt, int ycnt) {
        int mult = this.imgs[img_id].height / (ycnt * 16);
        for (int i = 0; i < imgids.length; ++i) {
            CustomTileRec ctr;
            if (imgids[i] <= 0 || (ctr = recs.get(i)) == null) continue;
            int[] tile = new int[256 * mult * mult];
            this.copySubimageFromImage(img_id, ctr.srcx * mult, ctr.srcy * mult, ctr.targetx * mult, ctr.targety * mult, ctr.width * mult, ctr.height * mult, tile, 16 * mult);
            int[] new_argb = new int[this.native_scale * this.native_scale];
            TexturePack.scaleTerrainPNGSubImage(16 * mult, this.native_scale, tile, new_argb);
            this.setTileARGB(imgids[i], new_argb);
        }
    }

    private void patchBedImages(int img_id, int[] imgids) {
        this.patchCustomImages(img_id, imgids, bed_patches, 64, 64);
    }

    private TexturePack(TexturePack tp) {
        this.tile_argb = (int[][])Arrays.copyOf(tp.tile_argb, tp.tile_argb.length);
        this.native_scale = tp.native_scale;
        this.ctm = tp.ctm;
        this.imgs = tp.imgs;
        this.blockColoring = tp.blockColoring;
    }

    private void loadTerrain(boolean is_rp) throws IOException {
        int j;
        int[] buf;
        LoadedImage li;
        DynamicTileFile dtf;
        String fn;
        int i;
        ImageIO.setUseCache(false);
        this.tile_argb = new int[267][];
        if (is_rp) {
            this.native_scale = 16;
            for (i = 0; i < terrain_rp_map.length; ++i) {
                fn = TexturePack.getRPFileName(i);
                if (fn == null || (dtf = addonfilesbyname.get(fn)) == null || (li = this.imgs[dtf.idx + 11]) == null) continue;
                this.native_scale = li.width;
                break;
            }
            this.blank = new int[this.native_scale * this.native_scale];
            for (i = 0; i < terrain_rp_map.length; ++i) {
                fn = TexturePack.getRPFileName(i);
                if (fn == null || (dtf = addonfilesbyname.get(fn)) == null || (li = this.imgs[dtf.idx + 11]) == null) continue;
                buf = new int[this.native_scale * this.native_scale];
                TexturePack.scaleTerrainPNGSubImage(li.width, this.native_scale, li.argb, buf);
                this.setTileARGB(i, buf);
            }
        } else {
            this.native_scale = 16;
            for (i = 0; i < terrain_map.length; ++i) {
                fn = TexturePack.getBlockFileName(i);
                if (fn == null || (dtf = addonfilesbyname.get(fn)) == null || (li = this.imgs[dtf.idx + 11]) == null || this.native_scale >= li.width) continue;
                this.native_scale = li.width;
            }
            this.blank = new int[this.native_scale * this.native_scale];
            for (i = 0; i < terrain_map.length; ++i) {
                fn = TexturePack.getBlockFileName(i);
                if (fn == null || (dtf = addonfilesbyname.get(fn)) == null || (li = this.imgs[dtf.idx + 11]) == null) continue;
                buf = new int[this.native_scale * this.native_scale];
                TexturePack.scaleTerrainPNGSubImage(li.width, this.native_scale, li.argb, buf);
                this.setTileARGB(i, buf);
            }
        }
        Color tc = new Color();
        int[] red_nsew_tone = this.getTileARGB(164);
        int[] red_nsew = this.getTileARGB(180);
        int[] red_ew_tone = this.getTileARGB(165);
        int[] red_ew = this.getTileARGB(181);
        for (i = 0; i < this.native_scale * this.native_scale; ++i) {
            if (red_nsew_tone[i] != 0) {
                tc.setARGB(red_nsew_tone[i]);
                tc.blendColor(-4194304);
                red_nsew[i] = tc.getARGB();
            }
            if (red_ew_tone[i] == 0) continue;
            tc.setARGB(red_ew_tone[i]);
            tc.blendColor(-4194304);
            red_ew[i] = tc.getARGB();
        }
        int[] buf2 = new int[this.native_scale * this.native_scale];
        this.setTileARGB(261, buf2);
        int[] piston_side = this.getTileARGB(108);
        System.arraycopy(piston_side, 0, buf2, 0, this.native_scale * this.native_scale / 4);
        for (i = 0; i < this.native_scale / 4; ++i) {
            for (j = 0; j < 3 * this.native_scale / 4; ++j) {
                buf2[this.native_scale * (this.native_scale / 4 + j) + (3 * this.native_scale / 8 + i)] = piston_side[this.native_scale * i + j];
            }
        }
        buf2 = new int[this.native_scale * this.native_scale];
        this.setTileARGB(262, buf2);
        System.arraycopy(piston_side, this.native_scale * this.native_scale / 4, buf2, this.native_scale * this.native_scale / 4, 3 * this.native_scale * this.native_scale / 4);
        for (i = 0; i < this.native_scale / 4; ++i) {
            for (j = 3 * this.native_scale / 4; j < this.native_scale; ++j) {
                buf2[this.native_scale * (j - 3 * this.native_scale / 4) + (3 * this.native_scale / 8 + i)] = piston_side[this.native_scale * i + j];
            }
        }
        buf2 = new int[this.native_scale * this.native_scale];
        this.setTileARGB(263, buf2);
        int[] glasspanetop = this.getTileARGB(148);
        System.arraycopy(glasspanetop, 0, buf2, 0, this.native_scale * this.native_scale);
        for (i = this.native_scale * 7 / 16; i < this.native_scale * 9 / 16; ++i) {
            for (j = 0; j < this.native_scale; ++j) {
                buf2[this.native_scale * i + j] = buf2[this.native_scale * j + i];
            }
        }
        buf2 = new int[this.native_scale * this.native_scale];
        this.setTileARGB(264, buf2);
        int[] airframe = this.getTileARGB(158);
        int[] eyeofender = this.getTileARGB(174);
        System.arraycopy(airframe, 0, buf2, 0, this.native_scale * this.native_scale);
        for (i = this.native_scale / 4; i < this.native_scale * 3 / 4; ++i) {
            for (j = this.native_scale / 4; j < this.native_scale * 3 / 4; ++j) {
                buf2[this.native_scale * i + j] = eyeofender[this.native_scale * i + j];
            }
        }
        buf2 = new int[this.native_scale * this.native_scale];
        this.setTileARGB(267, buf2);
        Arrays.fill(buf2, -1);
    }

    private void loadImage(InputStream is, int idx, String fname, String modid) throws IOException {
        BufferedImage img = null;
        if (is != null) {
            ImageIO.setUseCache(false);
            img = ImageIO.read(is);
            if (img == null) {
                throw new FileNotFoundException();
            }
        }
        if (idx >= this.imgs.length) {
            LoadedImage[] newimgs = new LoadedImage[idx + 1];
            System.arraycopy(this.imgs, 0, newimgs, 0, this.imgs.length);
            this.imgs = newimgs;
        }
        this.imgs[idx] = new LoadedImage();
        if (img != null) {
            this.imgs[idx].width = img.getWidth();
            this.imgs[idx].height = img.getHeight();
            this.imgs[idx].argb = new int[this.imgs[idx].width * this.imgs[idx].height];
            img.getRGB(0, 0, this.imgs[idx].width, this.imgs[idx].height, this.imgs[idx].argb, 0, this.imgs[idx].width);
            img.flush();
            this.imgs[idx].isLoaded = true;
        } else {
            this.imgs[idx].width = 16;
            this.imgs[idx].height = 16;
            this.imgs[idx].argb = new int[this.imgs[idx].width * this.imgs[idx].height];
        }
        this.imgs[idx].fname = fname;
        this.imgs[idx].modid = modid;
    }

    private void processDynamicImage(int idx, TileFileFormat format) {
        DynamicTileFile dtf = addonfiles.get(idx);
        LoadedImage li = this.imgs[idx + 11];
        if (li == null) {
            return;
        }
        switch (format) {
            case GRID: {
                int dim = li.width / dtf.tilecnt_x;
                int dim2 = li.height / dtf.tilecnt_y;
                if (dim2 < dim) {
                    dim = dim2;
                }
                int[] old_argb = new int[dim * dim];
                for (int x = 0; x < dtf.tilecnt_x; ++x) {
                    for (int y = 0; y < dtf.tilecnt_y; ++y) {
                        int tileidx = dtf.tile_to_dyntile[y * dtf.tilecnt_x + x];
                        if (tileidx < 0 || tileidx < terrain_map.length && terrain_map[tileidx] != null) continue;
                        for (int j = 0; j < dim; ++j) {
                            System.arraycopy(li.argb, (y * dim + j) * li.width + x * dim, old_argb, j * dim, dim);
                        }
                        int[] new_argb = new int[this.native_scale * this.native_scale];
                        TexturePack.scaleTerrainPNGSubImage(dim, this.native_scale, old_argb, new_argb);
                        this.setTileARGB(tileidx, new_argb);
                    }
                }
                break;
            }
            case CHEST: {
                this.patchChestImages(idx + 11, dtf.tile_to_dyntile[0], dtf.tile_to_dyntile[5], dtf.tile_to_dyntile[3], dtf.tile_to_dyntile[4], dtf.tile_to_dyntile[1], dtf.tile_to_dyntile[2]);
                break;
            }
            case BIGCHEST: {
                this.patchLargeChestImages(idx + 11, dtf.tile_to_dyntile[1], dtf.tile_to_dyntile[0], dtf.tile_to_dyntile[9], dtf.tile_to_dyntile[8], dtf.tile_to_dyntile[5], dtf.tile_to_dyntile[4], dtf.tile_to_dyntile[3], dtf.tile_to_dyntile[2], dtf.tile_to_dyntile[7], dtf.tile_to_dyntile[6]);
                break;
            }
            case SIGN: {
                this.patchSignImages(idx + 11, dtf.tile_to_dyntile[0], dtf.tile_to_dyntile[1], dtf.tile_to_dyntile[2], dtf.tile_to_dyntile[3], dtf.tile_to_dyntile[4], dtf.tile_to_dyntile[5], dtf.tile_to_dyntile[6], dtf.tile_to_dyntile[7], dtf.tile_to_dyntile[8], dtf.tile_to_dyntile[9]);
                break;
            }
            case SKIN: {
                this.patchSkinImages(idx + 11, dtf.tile_to_dyntile[0], dtf.tile_to_dyntile[1], dtf.tile_to_dyntile[2], dtf.tile_to_dyntile[3], dtf.tile_to_dyntile[4], dtf.tile_to_dyntile[5]);
                break;
            }
            case SHULKER: {
                this.patchShulkerImages(idx + 11, dtf.tile_to_dyntile[0], dtf.tile_to_dyntile[5], dtf.tile_to_dyntile[3], dtf.tile_to_dyntile[4], dtf.tile_to_dyntile[1], dtf.tile_to_dyntile[2]);
                break;
            }
            case CUSTOM: {
                this.patchCustomImages(idx + 11, dtf.tile_to_dyntile, dtf.cust, dtf.tilecnt_x, dtf.tilecnt_y);
                break;
            }
            case BED: {
                this.patchBedImages(idx + 11, dtf.tile_to_dyntile);
                break;
            }
            case TILESET: {
                break;
            }
        }
        if (dtf.tile_to_dyntile != null) {
            for (int i = 0; i < dtf.tile_to_dyntile.length; ++i) {
                if (dtf.tile_to_dyntile[i] < 0) continue;
                if (dtf.material != null) {
                    this.materialbytileid.put(dtf.tile_to_dyntile[i], dtf.material);
                }
                this.setMatIDForTileID(dtf.filename, dtf.tile_to_dyntile[i]);
            }
        }
    }

    private void loadBiomeShadingImage(InputStream is, int idx, String fname, String modid) throws IOException {
        this.loadImage(is, idx, fname, modid);
        LoadedImage li = this.imgs[idx];
        if (li.width != 256) {
            int[] scaled = new int[65536];
            TexturePack.scaleTerrainPNGSubImage(li.width, 256, li.argb, scaled);
            li.argb = scaled;
            li.width = 256;
            li.height = 256;
        }
        int clr = li.argb[li.height * li.width * 3 / 4 + li.width / 2];
        boolean same = true;
        for (int j = 0; same && j < li.height; ++j) {
            for (int i = 0; same && i <= j; ++i) {
                if (li.argb[li.width * j + i] == clr) continue;
                same = false;
            }
        }
        if (same) {
            li.trivial_color = clr;
        } else {
            int[] clr_scale = new int[16];
            TexturePack.scaleTerrainPNGSubImage(li.width, 4, li.argb, clr_scale);
            li.trivial_color = clr_scale[9];
        }
        if (!li.isLoaded) {
            this.blockColoring.scrubValues(idx);
        }
    }

    private void patchTextureWithImage(int image_idx, int block_idx) {
        int[] new_argb = new int[this.native_scale * this.native_scale];
        TexturePack.scaleTerrainPNGSubImage(this.imgs[image_idx].width, this.native_scale, this.imgs[image_idx].argb, new_argb);
        this.setTileARGB(block_idx, new_argb);
    }

    private static File getTexturePackDirectory(DynmapCore core) {
        return new File(core.getDataFolder(), "texturepacks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TexturePack resampleTexturePack(int scale) {
        Object object = this.scaledlock;
        synchronized (object) {
            TexturePack stp;
            if (this.scaled_textures == null) {
                this.scaled_textures = new HashMap();
            }
            if ((stp = this.scaled_textures.get(scale)) != null) {
                return stp;
            }
            stp = new TexturePack(this);
            if (stp.native_scale != scale) {
                stp.native_scale = scale;
                this.scaleTerrainPNG(stp);
            }
            this.scaled_textures.put(scale, stp);
            return stp;
        }
    }

    private void scaleTerrainPNG(TexturePack tp) {
        tp.tile_argb = new int[this.tile_argb.length][];
        for (int idx = 0; idx < this.tile_argb.length; ++idx) {
            tp.tile_argb[idx] = new int[tp.native_scale * tp.native_scale];
            TexturePack.scaleTerrainPNGSubImage(this.native_scale, tp.native_scale, this.getTileARGB(idx), tp.tile_argb[idx]);
        }
        TexturePack.makeAlphaPure(tp.tile_argb[38]);
    }

    public static void scaleTerrainPNGSubImage(int srcscale, int destscale, int[] src_argb, int[] dest_argb) {
        int nativeres = srcscale;
        int res = destscale;
        Color c = new Color();
        if (res == nativeres) {
            System.arraycopy(src_argb, 0, dest_argb, 0, dest_argb.length);
        } else if (res > nativeres) {
            int[] weights = new int[res];
            int[] offsets = new int[res];
            int v = 0;
            int idx = 0;
            while (v < res * nativeres) {
                offsets[idx] = v / res;
                weights[idx] = (v + nativeres - 1) / res == offsets[idx] ? nativeres : offsets[idx] * res + res - v;
                v += nativeres;
                ++idx;
            }
            for (int y = 0; y < res; ++y) {
                int ind_y = offsets[y];
                int wgt_y = weights[y];
                for (int x = 0; x < res; ++x) {
                    int ind_x = offsets[x];
                    int wgt_x = weights[x];
                    double accum_red = 0.0;
                    double accum_green = 0.0;
                    double accum_blue = 0.0;
                    double accum_alpha = 0.0;
                    for (int xx = 0; xx < 2; ++xx) {
                        int wx;
                        int n = wx = xx == 0 ? wgt_x : nativeres - wgt_x;
                        if (wx == 0) continue;
                        for (int yy = 0; yy < 2; ++yy) {
                            int wy;
                            int n2 = wy = yy == 0 ? wgt_y : nativeres - wgt_y;
                            if (wy == 0) continue;
                            c.setARGB(src_argb[(ind_y + yy) * nativeres + ind_x + xx]);
                            int w = wx * wy;
                            double a = (double)w * (double)c.getAlpha();
                            accum_red += (double)c.getRed() * a;
                            accum_green += (double)c.getGreen() * a;
                            accum_blue += (double)c.getBlue() * a;
                            accum_alpha += a;
                        }
                    }
                    double newalpha = accum_alpha;
                    if (newalpha == 0.0) {
                        newalpha = 1.0;
                    }
                    c.setRGBA((int)(accum_red / newalpha), (int)(accum_green / newalpha), (int)(accum_blue / newalpha), (int)(accum_alpha / (double)(nativeres * nativeres)));
                    dest_argb[y * res + x] = c.getARGB();
                }
            }
        } else {
            int y;
            int[] weights = new int[nativeres];
            int[] offsets = new int[nativeres];
            int v = 0;
            int idx = 0;
            while (v < res * nativeres) {
                offsets[idx] = v / nativeres;
                weights[idx] = (v + res - 1) / nativeres == offsets[idx] ? res : offsets[idx] * nativeres + nativeres - v;
                v += res;
                ++idx;
            }
            double[] accum_red = new double[res * res];
            double[] accum_green = new double[res * res];
            double[] accum_blue = new double[res * res];
            double[] accum_alpha = new double[res * res];
            for (y = 0; y < nativeres; ++y) {
                int ind_y = offsets[y];
                int wgt_y = weights[y];
                for (int x = 0; x < nativeres; ++x) {
                    int ind_x = offsets[x];
                    int wgt_x = weights[x];
                    c.setARGB(src_argb[y * nativeres + x]);
                    for (int xx = 0; xx < 2; ++xx) {
                        int wx;
                        int n = wx = xx == 0 ? wgt_x : res - wgt_x;
                        if (wx == 0) continue;
                        for (int yy = 0; yy < 2; ++yy) {
                            int wy;
                            int n3 = wy = yy == 0 ? wgt_y : res - wgt_y;
                            if (wy == 0) continue;
                            double w = wx * wy;
                            double a = w * (double)c.getAlpha();
                            int n4 = (ind_y + yy) * res + (ind_x + xx);
                            accum_red[n4] = accum_red[n4] + (double)c.getRed() * a;
                            int n5 = (ind_y + yy) * res + (ind_x + xx);
                            accum_green[n5] = accum_green[n5] + (double)c.getGreen() * a;
                            int n6 = (ind_y + yy) * res + (ind_x + xx);
                            accum_blue[n6] = accum_blue[n6] + (double)c.getBlue() * a;
                            int n7 = (ind_y + yy) * res + (ind_x + xx);
                            accum_alpha[n7] = accum_alpha[n7] + a;
                        }
                    }
                }
            }
            for (y = 0; y < res; ++y) {
                for (int x = 0; x < res; ++x) {
                    int off = y * res + x;
                    double aa = accum_alpha[off];
                    if (aa == 0.0) {
                        aa = 1.0;
                    }
                    c.setRGBA((int)(accum_red[off] / aa), (int)(accum_green[off] / aa), (int)(accum_blue[off] / aa), (int)(accum_alpha[off] / (double)(nativeres * nativeres)));
                    dest_argb[y * res + x] = c.getARGB();
                }
            }
        }
    }

    private static void addFiles(List<String> tsfiles, List<String> txfiles, File dir, String path) {
        File[] listfiles = dir.listFiles();
        if (listfiles == null) {
            return;
        }
        for (File f : listfiles) {
            String fn = f.getName();
            if (fn.equals(".") || fn.equals("..")) continue;
            if (f.isFile()) {
                if (fn.endsWith("-texture.txt")) {
                    txfiles.add(path + fn);
                }
                if (!fn.endsWith("-tilesets.txt")) continue;
                tsfiles.add(path + fn);
                continue;
            }
            if (!f.isDirectory()) continue;
            TexturePack.addFiles(tsfiles, txfiles, f, path + f.getName() + "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadTextureMapping(DynmapCore core, ConfigurationNode config) {
        File custom;
        ZipEntry ze;
        Object zf;
        File datadir = core.getDataFolder();
        TexturePack.resetFiles(core);
        HDBlockStateTextureMap.initializeTable();
        int i = 0;
        boolean done = false;
        InputStream in = null;
        while (!done) {
            block83: {
                block82: {
                    in = TexturePack.class.getResourceAsStream("/texture_" + i + ".txt");
                    if (in == null) break block82;
                    TexturePack.loadTextureFile(in, "texture_" + i + ".txt", config, core, "core");
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        in = null;
                    }
                    break block83;
                }
                done = true;
            }
            ++i;
        }
        for (String modid : core.getServer().getModList()) {
            File f = core.getServer().getModContainerFile(modid);
            if (f == null || !f.isFile()) continue;
            zf = null;
            in = null;
            try {
                zf = new ZipFile(f);
                String fn = "assets/" + modid.toLowerCase() + "/dynmap-texture.txt";
                ze = ((ZipFile)zf).getEntry(fn);
                if (ze == null) continue;
                in = ((ZipFile)zf).getInputStream(ze);
                TexturePack.loadTextureFile(in, fn, config, core, modid);
                loadedmods.add(modid);
            }
            catch (ZipException fn) {
            }
            catch (IOException fn) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException fn) {}
                    in = null;
                }
                if (zf == null) continue;
                try {
                    ((ZipFile)zf).close();
                }
                catch (IOException fn) {}
                zf = null;
            }
        }
        File renderdir = new File(datadir, "renderdata");
        ArrayList<String> tsfiles = new ArrayList<String>();
        ArrayList<String> txfiles = new ArrayList<String>();
        TexturePack.addFiles(tsfiles, txfiles, renderdir, "");
        for (String fname : tsfiles) {
            custom = new File(renderdir, fname);
            if (!custom.canRead()) continue;
            try {
                in = new FileInputStream(custom);
                TexturePack.loadTileSetsFile(in, custom.getPath(), config, core, HDBlockModels.getModIDFromFileName(fname));
            }
            catch (IOException iox) {
                Log.severe("Error loading " + custom.getPath() + " - " + iox);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
        }
        for (String fname : txfiles) {
            custom = new File(renderdir, fname);
            if (!custom.canRead()) continue;
            try {
                in = new FileInputStream(custom);
                TexturePack.loadTextureFile(in, custom.getPath(), config, core, HDBlockModels.getModIDFromFileName(fname));
            }
            catch (IOException iox) {
                Log.severe("Error loading " + custom.getPath() + " - " + iox);
            }
            finally {
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
        }
        zf = null;
        try {
            zf = new ZipFile(core.getPluginJarFile());
            Enumeration<? extends ZipEntry> e = ((ZipFile)zf).entries();
            while (e.hasMoreElements()) {
                ze = e.nextElement();
                String n = ze.getName();
                if (!n.startsWith("renderdata/") || !n.endsWith("-texture.txt") || (in = ((ZipFile)zf).getInputStream(ze)) == null) continue;
                TexturePack.loadTextureFile(in, n, config, core, HDBlockModels.getModIDFromFileName(n));
                try {
                    in.close();
                }
                catch (IOException x) {
                    in = null;
                }
            }
        }
        catch (IOException iox) {
            Log.severe("Error processing texture files");
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iox) {}
                in = null;
            }
            if (zf != null) {
                try {
                    ((ZipFile)zf).close();
                }
                catch (IOException iox) {}
                zf = null;
            }
        }
        TexturePack.processTextureMaps();
        for (int gidx = 0; gidx < DynmapBlockState.getGlobalIndexMax(); ++gidx) {
            int cnt;
            DynmapBlockState blk = DynmapBlockState.getStateByGlobalIndex(gidx);
            if (blk.isAir()) continue;
            HDBlockStateTextureMap tm = HDBlockStateTextureMap.getByBlockState(blk);
            if (tm == HDBlockStateTextureMap.BLANK) {
                Log.verboseinfo("Block " + blk + " - no texture mapping");
            }
            if ((cnt = HDBlockModels.getNeededTextureCount(blk)) <= tm.faces.length) continue;
            Log.severe("Block " + blk + " - not enough textures for faces (" + cnt + " > " + tm.faces.length + ")");
            tm.resizeFaces(cnt);
        }
        if (core.dumpMissingBlocks()) {
            String missing = "";
            for (int gidx = 0; gidx < DynmapBlockState.getGlobalIndexMax(); ++gidx) {
                DynmapBlockState blk = DynmapBlockState.getStateByGlobalIndex(gidx);
                if (!blk.isNotAir() || blk.stateIndex != 0) continue;
                boolean blank = true;
                for (int stateid = 0; blank && stateid < blk.getStateCount(); ++stateid) {
                    DynmapBlockState blk2 = blk.getState(stateid);
                    HDBlockStateTextureMap tm = HDBlockStateTextureMap.getByBlockState(blk2);
                    if (tm == HDBlockStateTextureMap.BLANK) continue;
                    blank = false;
                }
                if (!blank) continue;
                missing = missing + blk.blockName + "\n";
            }
            if (missing.length() > 0) {
                Log.warning("Blocks missing texture definition:\n" + missing);
            }
        }
    }

    private static String getBlockName(String modid, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            int off;
            if (c == '%' || c == '&') {
                val = val.substring(1);
            }
            if ((off = val.indexOf(43)) > 0) {
                val = val.substring(0, off);
            }
            if (val.indexOf(58) < 0) {
                val = modid + ":" + val;
            }
            return val;
        }
        throw new NumberFormatException("invalid ID - " + val);
    }

    private static Integer getIntValue(Map<String, Integer> vars, String val) throws NumberFormatException {
        char c = val.charAt(0);
        if (Character.isLetter(c) || c == '%' || c == '&') {
            Integer v;
            int off = val.indexOf(43);
            int offset = 0;
            if (off > 0) {
                offset = Integer.valueOf(val.substring(off + 1));
                val = val.substring(0, off);
            }
            if ((v = vars.get(val)) == null) {
                if (c == '%' || c == '&') {
                    vars.put(val, 0);
                    v = 0;
                } else {
                    throw new NumberFormatException("invalid ID - " + val);
                }
            }
            if (offset != 0 && v > 0) {
                v = v + offset;
            }
            return v;
        }
        return Integer.valueOf(val);
    }

    private static int parseTextureIndex(HashMap<String, Integer> filetoidx, int srctxtid, String val) throws NumberFormatException {
        int off = val.indexOf(58);
        int txtid = -1;
        if (off > 0) {
            String txt = val.substring(off + 1);
            if (!filetoidx.containsKey(txt)) {
                throw new NumberFormatException("Unknown attribute: " + txt);
            }
            srctxtid = filetoidx.get(txt);
            txtid = Integer.valueOf(val.substring(0, off));
        } else {
            txtid = Integer.valueOf(val);
        }
        int funcid = txtid / 1000;
        if (srctxtid >= 0 && (txtid -= 1000 * funcid) >= 0) {
            txtid = TexturePack.findOrAddDynamicTile(srctxtid, txtid);
        }
        if (srctxtid == -2) {
            throw new NumberFormatException("Invalid texture ID: no default terrain.png: " + val);
        }
        return txtid + 1000000 * funcid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadTileSetsFile(InputStream txtfile, String txtname, ConfigurationNode config, DynmapCore core, String blockset) {
        BufferedReader rdr = null;
        DynamicTileFile tfile = null;
        try {
            block35: {
                String line;
                rdr = new LineNumberReader(new InputStreamReader(txtfile));
                while ((line = ((LineNumberReader)rdr).readLine()) != null) {
                    int n;
                    String[] stringArray;
                    String setdir;
                    String fname;
                    int ydim;
                    int xdim;
                    if (line.startsWith("#")) continue;
                    if (line.startsWith("tileset:")) {
                        String[] toks;
                        line = line.substring(line.indexOf(58) + 1);
                        xdim = 16;
                        ydim = 16;
                        fname = null;
                        setdir = null;
                        stringArray = toks = line.split(",");
                        n = stringArray.length;
                    } else {
                        int split;
                        if (!Character.isDigit(line.charAt(0)) || (split = line.indexOf(45)) < 0) continue;
                        String id = line.substring(0, split).trim();
                        String name = line.substring(split + 1).trim();
                        String[] coord = id.split(",");
                        int idx = -1;
                        if (coord.length == 2) {
                            idx = Integer.parseInt(coord[1]) * tfile.tilecnt_x + Integer.parseInt(coord[0]);
                        } else if (coord.length == 1) {
                            idx = Integer.parseInt(coord[0]);
                        }
                        if (idx >= 0 && idx < tfile.tilenames.length) {
                            tfile.tilenames[idx] = name;
                            continue;
                        }
                        Log.severe("Bad tile index - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + txtname);
                        continue;
                    }
                    for (int i = 0; i < n; ++i) {
                        String tok = stringArray[i];
                        String[] v = tok.split("=");
                        if (v.length < 2) continue;
                        if (v[0].equals("xcount")) {
                            xdim = Integer.parseInt(v[1]);
                            continue;
                        }
                        if (v[0].equals("ycount")) {
                            ydim = Integer.parseInt(v[1]);
                            continue;
                        }
                        if (v[0].equals("setdir")) {
                            setdir = v[1];
                            continue;
                        }
                        if (!v[0].equals("filename")) continue;
                        fname = v[1];
                    }
                    if (fname != null && setdir != null) {
                        int fid = TexturePack.findOrAddDynamicTileFile(fname, null, xdim, ydim, TileFileFormat.TILESET, new String[0]);
                        tfile = addonfiles.get(fid);
                        if (tfile == null) {
                            Log.severe("Error registering tile set " + fname + " at " + ((LineNumberReader)rdr).getLineNumber() + " of " + txtname);
                            return;
                        }
                        tfile.tilenames = new String[tfile.tile_to_dyntile.length];
                        continue;
                    }
                    break block35;
                }
                return;
            }
            Log.severe("Error defining tile set at " + ((LineNumberReader)rdr).getLineNumber() + " of " + txtname);
            return;
        }
        catch (IOException iox) {
            Log.severe("Error reading " + txtname + " - " + iox.toString());
            return;
        }
        catch (NumberFormatException nfx) {
            Log.severe("Format error - line " + ((LineNumberReader)rdr).getLineNumber() + " of " + txtname + ": " + nfx.getMessage());
            return;
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                    rdr = null;
                }
                catch (IOException iox) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void loadTextureFile(InputStream txtfile, String txtname, ConfigurationNode config, DynmapCore core, String blockset) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 146[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void handleBlockAlias() {
        Set<String> aliased = MapManager.mapman.getAliasedBlocks();
        for (String an : aliased) {
            String newid = MapManager.mapman.getBlockAlias(an);
            if (newid.equals(an)) continue;
            HDBlockStateTextureMap.remapTexture(an, newid);
        }
    }

    public final void readColor(HDPerspectiveState ps, MapIterator mapiter, Color rslt, DynmapBlockState blk, DynmapBlockState lastblocktype, TexturePackHDShader.ShaderState ss) {
        int textid;
        HDBlockStateTextureMap map = HDBlockStateTextureMap.getByBlockState(blk);
        BlockStep laststep = ps.getLastBlockStep();
        int patchid = ps.getTextureIndex();
        int faceindex = patchid >= 0 ? patchid : laststep.ordinal();
        try {
            textid = map.faces[faceindex];
        }
        catch (ArrayIndexOutOfBoundsException aioob) {
            textid = -1;
        }
        if (this.ctm != null) {
            int mod = 0;
            if (textid >= 1000000) {
                mod = textid / 1000000 * 1000000;
                textid -= mod;
            }
            textid = mod + this.ctm.mapTexture(mapiter, blk, laststep, textid, ss);
        }
        this.readColor(ps, mapiter, rslt, blk, lastblocktype, ss, map, laststep, patchid, textid, map.stdrotate);
        if (map.layers != null) {
            while (rslt.isTransparent() && map.layers[faceindex] >= 0) {
                faceindex = map.layers[faceindex];
                textid = map.faces[faceindex];
                this.readColor(ps, mapiter, rslt, blk, lastblocktype, ss, map, laststep, patchid, textid, map.stdrotate);
            }
        }
    }

    private final void readColor(HDPerspectiveState ps, MapIterator mapiter, Color rslt, DynmapBlockState blk, DynmapBlockState lastblocktype, TexturePackHDShader.ShaderState ss, HDBlockStateTextureMap map, BlockStep laststep, int patchid, int textid, boolean stdrot) {
        if (textid < 0) {
            rslt.setTransparent();
            return;
        }
        boolean hasblockcoloring = ss.do_biome_shading && this.blockColoring.hasBlkStateValue(blk);
        boolean simplemap = textid < 1000000 && !hasblockcoloring;
        int[] xyz = null;
        if (simplemap) {
            int[] texture = this.getTileARGB(textid);
            int u = 0;
            int v = 0;
            if (patchid < 0) {
                xyz = ps.getSubblockCoord();
                switch (laststep) {
                    case X_MINUS: {
                        u = this.native_scale - xyz[2] - 1;
                        v = this.native_scale - xyz[1] - 1;
                        break;
                    }
                    case X_PLUS: {
                        u = xyz[2];
                        v = this.native_scale - xyz[1] - 1;
                        break;
                    }
                    case Z_MINUS: {
                        u = xyz[0];
                        v = this.native_scale - xyz[1] - 1;
                        break;
                    }
                    case Z_PLUS: {
                        u = this.native_scale - xyz[0] - 1;
                        v = this.native_scale - xyz[1] - 1;
                        break;
                    }
                    case Y_MINUS: {
                        if (stdrot) {
                            u = xyz[0];
                            v = xyz[2];
                            break;
                        }
                        u = this.native_scale - xyz[2] - 1;
                        v = xyz[0];
                        break;
                    }
                    case Y_PLUS: {
                        if (stdrot) {
                            u = this.native_scale - xyz[0] - 1;
                            v = xyz[2];
                            break;
                        }
                        u = xyz[2];
                        v = xyz[0];
                    }
                }
            } else {
                u = TexturePack.fastFloor(ps.getPatchU() * (double)this.native_scale);
                v = this.native_scale - TexturePack.fastFloor(ps.getPatchV() * (double)this.native_scale) - 1;
            }
            try {
                rslt.setARGB(texture[v * this.native_scale + u]);
            }
            catch (ArrayIndexOutOfBoundsException aoobx) {
                int n = u < 0 ? 0 : (u = u >= this.native_scale ? this.native_scale - 1 : u);
                v = v < 0 ? 0 : (v >= this.native_scale ? this.native_scale - 1 : v);
                try {
                    rslt.setARGB(texture[v * this.native_scale + u]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            return;
        }
        int textop = textid / 1000000;
        textid %= 1000000;
        if (textop == 12 || textop == 21) {
            DynmapBlockState lasthit = ss.getLastBlockHit();
            if (blk.matchingBaseState(lasthit) || blk.isWaterFilled() && lasthit.isWaterFilled() && ps.isOnFace()) {
                rslt.setTransparent();
                return;
            }
            if (blk.isWater()) {
                textop = 3;
            } else if (textop == 21) {
                textop = 17;
            }
        }
        int[] texture = this.getTileARGB(textid);
        int u = 0;
        int v = 0;
        if (patchid < 0) {
            if (xyz == null) {
                xyz = ps.getSubblockCoord();
            }
            switch (laststep) {
                case X_MINUS: {
                    u = this.native_scale - xyz[2] - 1;
                    v = this.native_scale - xyz[1] - 1;
                    break;
                }
                case X_PLUS: {
                    u = xyz[2];
                    v = this.native_scale - xyz[1] - 1;
                    break;
                }
                case Z_MINUS: {
                    u = xyz[0];
                    v = this.native_scale - xyz[1] - 1;
                    break;
                }
                case Z_PLUS: {
                    u = this.native_scale - xyz[0] - 1;
                    v = this.native_scale - xyz[1] - 1;
                    break;
                }
                case Y_MINUS: {
                    if (stdrot) {
                        u = xyz[0];
                        v = xyz[2];
                        break;
                    }
                    u = this.native_scale - xyz[2] - 1;
                    v = xyz[0];
                    break;
                }
                case Y_PLUS: {
                    if (stdrot) {
                        u = this.native_scale - xyz[0] - 1;
                        v = xyz[2];
                        break;
                    }
                    u = xyz[2];
                    v = xyz[0];
                }
            }
        } else {
            u = TexturePack.fastFloor(ps.getPatchU() * (double)this.native_scale);
            v = this.native_scale - TexturePack.fastFloor(ps.getPatchV() * (double)this.native_scale) - 1;
        }
        block19 : switch (textop) {
            case 4: {
                int tmp = u;
                u = this.native_scale - v - 1;
                v = tmp;
                break;
            }
            case 5: {
                u = this.native_scale - u - 1;
                v = this.native_scale - v - 1;
                break;
            }
            case 6: 
            case 18: 
            case 19: 
            case 20: {
                int tmp = u;
                u = v;
                v = this.native_scale - tmp - 1;
                break;
            }
            case 7: {
                u = this.native_scale - u - 1;
                break;
            }
            case 8: {
                if (v < this.native_scale / 2) {
                    rslt.setTransparent();
                    return;
                }
                v -= this.native_scale / 2;
                break;
            }
            case 9: {
                if (v < this.native_scale / 2) {
                    rslt.setTransparent();
                    return;
                }
                v -= this.native_scale / 2;
                u = this.native_scale - u - 1;
                break;
            }
            case 10: {
                if (v >= 3 * this.native_scale / 4) {
                    rslt.setTransparent();
                    return;
                }
                v += this.native_scale / 4;
                if (u < this.native_scale / 2) {
                    u = this.native_scale / 2 - 1;
                }
                if (u <= this.native_scale / 2) break;
                u = this.native_scale / 2;
                break;
            }
            case 11: {
                boolean do_grass_side = false;
                boolean do_snow_side = false;
                if (ss.do_better_grass) {
                    mapiter.unstepPosition(laststep);
                    if (mapiter.getBlockType().isSnow()) {
                        do_snow_side = true;
                    }
                    if (mapiter.getBlockTypeAt(BlockStep.Y_MINUS).isGrass()) {
                        do_grass_side = true;
                    }
                    mapiter.stepPosition(laststep);
                }
                if (mapiter.getBlockTypeAt(BlockStep.Y_PLUS).isSnow()) {
                    if (do_snow_side) {
                        texture = this.getTileARGB(66);
                        textid = 66;
                    } else {
                        texture = this.getTileARGB(68);
                        textid = 68;
                    }
                    textop = 0;
                    break;
                }
                if (do_grass_side) {
                    texture = this.getTileARGB(0);
                    textid = 0;
                    textop = 1;
                    break;
                }
                int ovclr = this.getTileARGB(38)[v * this.native_scale + u];
                if ((ovclr & 0xFF000000) == 0) break;
                texture = this.getTileARGB(38);
                textop = 1;
                break;
            }
            case 15: {
                long l1 = (long)(mapiter.getX() * 3129871) ^ (long)mapiter.getZ() * 116129781L ^ (long)mapiter.getY();
                l1 = l1 * l1 * 42317861L + l1 * 11L;
                int orientation = (int)(l1 >> 16 & 3L);
                switch (orientation) {
                    case 0: {
                        int tmp = u;
                        u = this.native_scale - v - 1;
                        v = tmp;
                        break block19;
                    }
                    case 1: {
                        u = this.native_scale - u - 1;
                        v = this.native_scale - v - 1;
                        break block19;
                    }
                    case 2: {
                        int tmp = u;
                        u = v;
                        v = this.native_scale - tmp - 1;
                        break block19;
                    }
                }
            }
        }
        try {
            rslt.setARGB(texture[v * this.native_scale + u]);
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            rslt.setARGB(0);
        }
        int clrmult = -1;
        int clralpha = -16777216;
        int custclrmult = -1;
        if (hasblockcoloring) {
            Integer idx = this.blockColoring.getBlkStateValue(blk);
            LoadedImage img = this.imgs[idx];
            if (img.argb != null) {
                custclrmult = mapiter.getSmoothWaterColorMultiplier(img.argb);
            } else {
                hasblockcoloring = false;
            }
        }
        if (!hasblockcoloring) {
            switch (textop) {
                case 1: 
                case 18: {
                    if (ss.do_biome_shading) {
                        if (this.imgs[7] != null) {
                            clrmult = mapiter.getSmoothColorMultiplier(this.imgs[0].argb, this.imgs[7].argb);
                            break;
                        }
                        clrmult = mapiter.getSmoothGrassColorMultiplier(this.imgs[0].argb);
                        break;
                    }
                    clrmult = this.imgs[0].trivial_color;
                    break;
                }
                case 2: 
                case 19: {
                    if (ss.do_biome_shading) {
                        if (this.imgs[8] != null) {
                            clrmult = mapiter.getSmoothColorMultiplier(this.imgs[1].argb, this.imgs[8].argb);
                            break;
                        }
                        clrmult = mapiter.getSmoothFoliageColorMultiplier(this.imgs[1].argb);
                        break;
                    }
                    clrmult = this.imgs[1].trivial_color;
                    break;
                }
                case 22: {
                    clrmult = ss.do_biome_shading ? (this.imgs[8] != null ? mapiter.getSmoothColorMultiplier(this.imgs[1].argb, this.imgs[8].argb) : mapiter.getSmoothFoliageColorMultiplier(this.imgs[1].argb)) : this.imgs[1].trivial_color;
                    if (map.custColorMult != null) {
                        clrmult = ((clrmult & 0xFEFEFE) + map.custColorMult.getColorMultiplier(mapiter)) / 2;
                        break;
                    }
                    clrmult = ((clrmult & 0xFEFEFE) + map.colorMult) / 2;
                    break;
                }
                case 3: 
                case 20: {
                    if (this.imgs[6] != null) {
                        if (ss.do_biome_shading) {
                            clrmult = mapiter.getSmoothWaterColorMultiplier(this.imgs[6].argb);
                            break;
                        }
                        clrmult = this.imgs[6].trivial_color;
                        break;
                    }
                    if (!ss.do_biome_shading) break;
                    clrmult = mapiter.getSmoothWaterColorMultiplier();
                    break;
                }
                case 14: {
                    if (ss.do_biome_shading) {
                        if (this.imgs[10] != null) {
                            clrmult = mapiter.getSmoothFoliageColorMultiplier(this.imgs[10].argb);
                            break;
                        }
                        clrmult = this.colorMultBirch;
                        break;
                    }
                    clrmult = this.colorMultBirch;
                    break;
                }
                case 13: {
                    if (ss.do_biome_shading) {
                        if (this.imgs[9] != null) {
                            clrmult = mapiter.getSmoothFoliageColorMultiplier(this.imgs[9].argb);
                            break;
                        }
                        clrmult = this.colorMultPine;
                        break;
                    }
                    clrmult = this.colorMultPine;
                    break;
                }
                case 15: {
                    clrmult = this.colorMultLily;
                    break;
                }
                case 17: {
                    clrmult = map.custColorMult != null ? map.custColorMult.getColorMultiplier(mapiter) : map.colorMult;
                    if ((clrmult & 0xFF000000) == 0) break;
                    clralpha = clrmult & 0xFF000000;
                }
            }
        }
        if (clrmult != -1 && clrmult != 0) {
            rslt.blendColor(clrmult | clralpha);
        }
        if (hasblockcoloring && custclrmult != -1) {
            rslt.blendColor(custclrmult | clralpha);
        }
    }

    private static final void makeAlphaPure(int[] argb) {
        for (int i = 0; i < argb.length; ++i) {
            if ((argb[i] & 0xFF000000) == 0) continue;
            int n = i;
            argb[n] = argb[n] | 0xFF000000;
        }
    }

    private static final int fastFloor(double f) {
        return (int)(f + 1.0E9) - 1000000000;
    }

    public static int findDynamicTile(String fname, int idx) {
        DynamicTileFile f = addonfilesbyname.get(fname);
        if (f != null && idx >= 0 && idx < f.tile_to_dyntile.length && f.tile_to_dyntile[idx] >= 0) {
            f.used = true;
            return f.tile_to_dyntile[idx];
        }
        return -1;
    }

    public static int findOrAddDynamicTileFile(String fname, String modname, int xdim, int ydim, TileFileFormat fmt, String[] args) {
        DynamicTileFile f = addonfilesbyname.get(fname);
        if (f != null) {
            return f.idx;
        }
        f = new DynamicTileFile();
        f.filename = fname;
        f.modname = modname;
        f.tilecnt_x = xdim;
        f.tilecnt_y = ydim;
        f.format = fmt;
        f.used = false;
        if (fmt == TileFileFormat.BIOME) {
            f.used = true;
        }
        switch (fmt) {
            case GRID: {
                f.tile_to_dyntile = new int[xdim * ydim];
                break;
            }
            case CHEST: {
                f.tile_to_dyntile = new int[6];
                break;
            }
            case BIGCHEST: {
                f.tile_to_dyntile = new int[10];
                break;
            }
            case SIGN: {
                f.tile_to_dyntile = new int[10];
                break;
            }
            case SHULKER: {
                f.tile_to_dyntile = new int[6];
                break;
            }
            case BED: {
                f.tile_to_dyntile = new int[18];
                break;
            }
            case CUSTOM: {
                ArrayList<CustomTileRec> recs = new ArrayList<CustomTileRec>();
                for (String a : args) {
                    String[] v = a.split("=");
                    if (v.length != 2 || !v[0].startsWith("tile")) continue;
                    int id = 0;
                    try {
                        id = Integer.parseInt(v[0].substring(4));
                    }
                    catch (NumberFormatException nfx) {
                        Log.warning("Bad tile ID: " + v[0]);
                        continue;
                    }
                    while (recs.size() <= id) {
                        recs.add(null);
                    }
                    CustomTileRec rec = new CustomTileRec();
                    try {
                        String[] coords = v[1].split("/");
                        String[] topleft = coords[0].split(":");
                        rec.srcx = Integer.parseInt(topleft[0]);
                        rec.srcy = Integer.parseInt(topleft[1]);
                        String[] size = coords[1].split(":");
                        rec.width = Integer.parseInt(size[0]);
                        rec.height = Integer.parseInt(size[1]);
                        if (coords.length >= 3) {
                            String[] dest = coords[2].split(":");
                            rec.targetx = Integer.parseInt(dest[0]);
                            rec.targety = Integer.parseInt(dest[1]);
                        }
                        recs.set(id, rec);
                    }
                    catch (Exception x) {
                        Log.warning("Bad custom tile coordinate: " + v[1]);
                    }
                }
                f.tile_to_dyntile = new int[recs.size()];
                f.cust = recs;
                break;
            }
            case SKIN: {
                f.tile_to_dyntile = new int[6];
                break;
            }
            case TILESET: {
                f.tile_to_dyntile = new int[xdim * ydim];
                break;
            }
            case BIOME: {
                f.tile_to_dyntile = new int[1];
                break;
            }
            default: {
                f.tile_to_dyntile = new int[xdim * ydim];
            }
        }
        Arrays.fill(f.tile_to_dyntile, -1);
        f.idx = addonfiles.size();
        addonfiles.add(f);
        addonfilesbyname.put(f.filename, f);
        return f.idx;
    }

    public static int findOrAddDynamicTile(int dynfile_idx, int tile_id) {
        DynamicTileFile f = addonfiles.get(dynfile_idx);
        if (f == null) {
            throw new NumberFormatException("Invalid add-on file index: " + dynfile_idx);
        }
        if (tile_id >= f.tile_to_dyntile.length) {
            throw new NumberFormatException("Invalid index " + tile_id + " for texture file " + f.filename + " on mod " + f.modname);
        }
        if (f.tile_to_dyntile[tile_id] < 0) {
            f.tile_to_dyntile[tile_id] = next_dynamic_tile++;
        }
        f.used = true;
        return f.tile_to_dyntile[tile_id];
    }

    public static int getTextureIDAt(MapIterator mapiter, DynmapBlockState blk, BlockStep face) {
        HDBlockStateTextureMap map = HDBlockStateTextureMap.getByBlockState(blk);
        int idx = -1;
        if (map != null) {
            int sideidx = face.ordinal();
            if (map.faces != null) {
                idx = sideidx < map.faces.length ? map.faces[sideidx] : map.faces[0];
            }
        }
        if (idx > 0) {
            idx %= 1000000;
        }
        return idx;
    }

    private void processCustomColorMap(String fname, String ids) {
        int idx = TexturePack.findOrAddDynamicTileFile(fname, null, 1, 1, TileFileFormat.BIOME, new String[0]);
        if (idx < 0) {
            Log.info("Error registering custom color file: " + fname);
            return;
        }
        Integer index = idx + 11;
        for (String id : ids.split("\\s+")) {
            HDBlockStateTextureMap bmap;
            String[] tok = id.split(":");
            int meta = -1;
            DynmapBlockState blk = null;
            String blkname = null;
            if (tok.length == 1) {
                blkname = tok[0];
                blk = DynmapBlockState.getBaseStateByName(blkname);
                if (blk.isAir()) {
                    Log.info("Bad custom color block ID: " + tok[0]);
                }
            } else if (tok.length == 2) {
                blkname = tok[0];
                try {
                    meta = Integer.parseInt(tok[1]);
                }
                catch (NumberFormatException nfx) {
                    Log.info("Bad custom color meta ID: " + tok[1]);
                }
                blk = DynmapBlockState.getStateByNameAndIndex(blkname, meta);
                if (blk.isAir()) {
                    Log.info("Bad custom color block ID: " + tok[0] + ":" + meta);
                }
            }
            if ((bmap = HDBlockStateTextureMap.getByBlockState(blk)) == null) continue;
            if (meta >= 0) {
                if (!blk.isNotAir()) continue;
                this.blockColoring.setBlkStateValue(blk, index);
                continue;
            }
            if (meta != -1) continue;
            for (int v = 0; v < blk.getStateCount(); ++v) {
                DynmapBlockState b = blk.getState(v);
                if (!b.isNotAir()) continue;
                this.blockColoring.setBlkStateValue(b, index);
            }
        }
    }

    private void processCustomColors(Properties p) {
        for (String pname : p.stringPropertyNames()) {
            if (!pname.startsWith(PALETTE_BLOCK_KEY)) continue;
            String v = p.getProperty(pname);
            String fname = pname.substring(PALETTE_BLOCK_KEY.length()).trim();
            if (fname.charAt(0) == '/') {
                fname = fname.substring(1);
            }
            if (fname.charAt(0) == '~') {
                fname = "assets/minecraft/mcpatcher" + fname.substring(1);
            }
            this.processCustomColorMap(fname, v);
        }
    }

    public int getTrivialFoliageMultiplier() {
        return this.imgs[1].argb[BiomeMap.FOREST.biomeLookup()];
    }

    public int getTrivialGrassMultiplier() {
        return this.imgs[0].argb[BiomeMap.FOREST.biomeLookup()];
    }

    public int getTrivialWaterMultiplier() {
        if (this.imgs[6] != null) {
            return this.imgs[6].argb[BiomeMap.FOREST.biomeLookup()];
        }
        return 0xFFFFFF;
    }

    public int getCustomBlockMultiplier(DynmapBlockState blk) {
        Integer idx = this.blockColoring.getBlkStateValue(blk);
        if (idx != null) {
            LoadedImage img = this.imgs[idx];
            if (img.argb != null) {
                return img.argb[BiomeMap.FOREST.biomeLookup()];
            }
        }
        return 0xFFFFFF;
    }

    private void addImageToZip(String idstr, int idx, int colormult, ExportedTexturePack etp) throws IOException {
        int i;
        if (etp.txtids.containsKey(idstr)) {
            return;
        }
        int[] argb = this.getTileARGB(idx);
        if ((colormult &= 0xFFFFFF) != 0xFFFFFF) {
            colormult |= 0xFF000000;
            for (i = 0; i < etp.img.argb_buf.length; ++i) {
                etp.img.argb_buf[i] = Color.blendColor(argb[i], colormult);
            }
        } else {
            for (i = 0; i < etp.img.argb_buf.length; ++i) {
                etp.img.argb_buf[i] = argb[i];
            }
        }
        boolean hasAlpha = false;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double w = 0.0;
        for (int i2 = 0; i2 < etp.img.argb_buf.length; ++i2) {
            int v = etp.img.argb_buf[i2];
            int ww = v >> 24 & 0xFF;
            int rr = v >> 16 & 0xFF;
            int gg = v >> 8 & 0xFF;
            int bb = v & 0xFF;
            r += (double)(ww * rr);
            g += (double)(ww * gg);
            b += (double)(ww * bb);
            w += (double)ww;
            if (ww == 255) continue;
            hasAlpha = true;
        }
        BufferOutputStream baos = new BufferOutputStream();
        ImageIO.setUseCache(false);
        String fname = etp.name + "/" + idstr + ".png";
        etp.exp.startExportedFile(fname);
        ImageIO.write((RenderedImage)etp.img.buf_img, "png", baos);
        etp.exp.addBytesToExportedFile(baos.buf, 0, baos.len);
        etp.exp.finishExportedFile();
        String fname_a = null;
        if (hasAlpha) {
            for (int i3 = 0; i3 < etp.img.argb_buf.length; ++i3) {
                int v = etp.img.argb_buf[i3];
                int ww = v >> 24 & 0xFF;
                etp.img.argb_buf[i3] = ww << 24 | ww << 16 | ww << 8 | ww;
            }
            fname_a = etp.name + "/" + idstr + "_a.png";
            etp.exp.startExportedFile(fname_a);
            baos.reset();
            ImageIO.write((RenderedImage)etp.img.buf_img, "png", baos);
            etp.exp.addBytesToExportedFile(baos.buf, 0, baos.len);
            etp.exp.finishExportedFile();
        }
        ExportedTexture et = new ExportedTexture();
        et.filename = fname;
        et.filename_a = fname_a;
        et.diffuseColor = w > 0.0 ? new Color((int)(r / w), (int)(g / w), (int)(b / w)) : new Color();
        et.material = this.getMaterialTypeByTile(idx);
        etp.txtids.put(idstr, et);
    }

    public void exportAsOBJMaterialLibrary(OBJExport exp, String name) throws IOException {
        ExportedTexturePack etp = new ExportedTexturePack();
        etp.img = DynmapBufferedImage.allocateBufferedImage(this.native_scale, this.native_scale);
        etp.name = name;
        etp.exp = exp;
        Set<String> txtids = exp.getMaterialIDs();
        for (String txt : txtids) {
            int off = txt.lastIndexOf("__");
            int mult = -1;
            String txtbase = txt;
            if (off > 0 && off + 8 == txt.length()) {
                String end = txt.substring(off + 2);
                try {
                    mult = Integer.parseInt(end, 16);
                }
                catch (NumberFormatException x) {
                    Log.warning("Invalid multiplier " + end);
                }
                txtbase = txt.substring(0, off);
            }
            Integer txt_id = this.tileIDByMatID.get(txtbase);
            int id = -1;
            if (txt_id == null) {
                if (!txtbase.startsWith("txt")) continue;
                try {
                    id = Integer.parseInt(txtbase.substring(3));
                }
                catch (NumberFormatException x) {
                    Log.warning("Invalid texture ID " + txtbase);
                }
            } else {
                id = txt_id;
            }
            if (id < 0) continue;
            this.addImageToZip(txt, id, mult, etp);
        }
        exp.startExportedFile(etp.name + ".mtl");
        TreeSet<String> ids = new TreeSet<String>(etp.txtids.keySet());
        for (String id : ids) {
            ExportedTexture et = etp.txtids.get(id);
            String lines = "newmtl " + id + "\n";
            lines = lines + String.format(Locale.US, "Ka %.3f %.3f %.3f\n", (double)et.diffuseColor.getRed() / 256.0, (double)et.diffuseColor.getGreen() / 256.0, (double)et.diffuseColor.getBlue() / 256.0);
            lines = lines + String.format(Locale.US, "Kd %.3f %.3f %.3f\n", (double)et.diffuseColor.getRed() / 256.0, (double)et.diffuseColor.getGreen() / 256.0, (double)et.diffuseColor.getBlue() / 256.0);
            lines = lines + "map_Kd " + et.filename + "\n";
            lines = lines + "map_Ka " + et.filename + "\n";
            if (et.filename_a != null) {
                lines = lines + "map_d " + et.filename_a + "\n";
            }
            if (et.material != null) {
                lines = lines + String.format(Locale.US, "Ni %.3f\n", et.material.Ni);
                lines = lines + String.format(Locale.US, "Ns %.3f\n", et.material.Ns);
                lines = lines + "Ks 0.500 0.500 0.500\n";
                lines = lines + String.format("illum %d\n", et.material.illum);
            } else {
                lines = lines + "Ks 0.000 0.000 0.000\n";
            }
            lines = lines + "\n";
            exp.addStringToExportedFile(lines);
        }
        exp.finishExportedFile();
    }

    public String[] getCurrentBlockMaterials(DynmapBlockState blk, MapIterator mapiter, int[] txtidx, BlockStep[] steps) {
        HDBlockStateTextureMap map = HDBlockStateTextureMap.getByBlockState(blk);
        if (txtidx == null) {
            txtidx = deftxtidx;
        }
        String[] rslt = new String[txtidx.length];
        boolean handlestdrot = steps != null && !map.stdrotate;
        Integer blockcoloring = this.blockColoring.getBlkStateValue(blk);
        int custclrmult = -1;
        if (blockcoloring != null) {
            LoadedImage img = this.imgs[blockcoloring];
            if (img.argb != null) {
                custclrmult = mapiter.getSmoothWaterColorMultiplier(img.argb);
            } else {
                blockcoloring = null;
            }
        }
        block20: for (int patchidx = 0; patchidx < txtidx.length; ++patchidx) {
            int faceindex = txtidx[patchidx];
            int textid = map.faces[faceindex];
            int mod = textid / 1000000;
            textid %= 1000000;
            BlockStep step = steps[patchidx];
            if (mod == 12 || mod == 21) {
                BlockStep dir = step.opposite();
                if (blk.matchingBaseState(mapiter.getBlockTypeAt(dir))) continue;
                if (blk.isWater()) {
                    mod = 3;
                } else if (mod == 21) {
                    mod = 17;
                }
            }
            if (this.ctm != null) {
                textid = this.ctm.mapTexture(mapiter, blk, step, textid, null);
            }
            if (textid < 0) continue;
            rslt[patchidx] = this.getMatIDForTileID(textid);
            int mult = 0xFFFFFF;
            if (blockcoloring == null) {
                switch (mod) {
                    case 1: 
                    case 18: {
                        BiomeMap bio = mapiter.getBiome();
                        if (bio == BiomeMap.SWAMPLAND && this.imgs[7] != null) {
                            mult = this.getBiomeTonedColor(this.imgs[7], -1, bio, blk);
                            break;
                        }
                        mult = this.getBiomeTonedColor(this.imgs[0], -1, bio, blk);
                        break;
                    }
                    case 2: 
                    case 19: 
                    case 22: {
                        mult = this.getBiomeTonedColor(this.imgs[1], -1, mapiter.getBiome(), blk);
                        break;
                    }
                    case 3: 
                    case 20: {
                        mult = this.getBiomeTonedColor(this.imgs[6], -1, mapiter.getBiome(), blk);
                        break;
                    }
                    case 13: {
                        mult = this.getBiomeTonedColor(this.imgs[9], this.colorMultPine, mapiter.getBiome(), blk);
                        break;
                    }
                    case 14: {
                        mult = this.getBiomeTonedColor(this.imgs[10], this.colorMultBirch, mapiter.getBiome(), blk);
                        break;
                    }
                    case 15: {
                        mult = this.getBiomeTonedColor(null, this.colorMultLily, mapiter.getBiome(), blk);
                        break;
                    }
                    case 17: 
                    case 21: {
                        if (map.custColorMult == null) {
                            mult = this.getBiomeTonedColor(null, map.colorMult, mapiter.getBiome(), blk);
                            break;
                        }
                        mult = map.custColorMult.getColorMultiplier(mapiter);
                        break;
                    }
                    default: {
                        mult = this.getBiomeTonedColor(null, -1, mapiter.getBiome(), blk);
                        break;
                    }
                }
            } else {
                mult = custclrmult;
            }
            if ((mult & 0xFFFFFF) != 0xFFFFFF) {
                int n = patchidx;
                rslt[n] = rslt[n] + String.format("__%06X", mult & 0xFFFFFF);
            }
            if (handlestdrot && !map.stdrotate && (step == BlockStep.Y_MINUS || step == BlockStep.Y_PLUS)) {
                switch (mod) {
                    case 4: {
                        mod = 5;
                        break;
                    }
                    case 5: {
                        mod = 6;
                        break;
                    }
                    case 6: 
                    case 18: 
                    case 19: 
                    case 20: {
                        mod = 0;
                        break;
                    }
                    default: {
                        mod = 4;
                    }
                }
            }
            switch (mod) {
                case 4: {
                    int n = patchidx;
                    rslt[n] = rslt[n] + "@1";
                    continue block20;
                }
                case 5: {
                    int n = patchidx;
                    rslt[n] = rslt[n] + "@2";
                    continue block20;
                }
                case 6: 
                case 18: 
                case 19: 
                case 20: {
                    int n = patchidx;
                    rslt[n] = rslt[n] + "@3";
                    continue block20;
                }
                case 7: {
                    int n = patchidx;
                    rslt[n] = rslt[n] + "@4";
                }
            }
        }
        return rslt;
    }

    private int getBiomeTonedColor(LoadedImage tonemap, int defcolormult, BiomeMap biome, DynmapBlockState blk) {
        int mult = tonemap == null ? defcolormult : (tonemap.argb == null ? tonemap.trivial_color : tonemap.argb[biome.biomeLookup()]);
        Integer idx = this.blockColoring.getBlkStateValue(blk);
        if (idx != null) {
            LoadedImage custimg = this.imgs[idx];
            if (custimg.argb != null) {
                mult = Color.blendColor(mult, custimg.argb[biome.biomeLookup()]);
            }
        }
        return mult;
    }

    public MaterialType getMaterialTypeByTile(int tileidx) {
        return this.materialbytileid.get(tileidx);
    }

    private void setMatIDForTileID(String matid, int tileid) {
        String id = this.matIDByTileID.get(tileid);
        if (id != null) {
            return;
        }
        id = matid;
        String[] tok = id.split("/");
        if (tok.length < 5) {
            id = tok[tok.length - 1];
        } else {
            id = tok[4];
            for (int i = 5; i < tok.length; ++i) {
                id = id + "_" + tok[i];
            }
        }
        id = id.replace(' ', '_');
        int off = id.lastIndexOf(46);
        if (off > 0) {
            id = id.substring(0, off);
        }
        int cnt = 2;
        String baseid = id;
        while (true) {
            Integer v;
            if ((v = this.tileIDByMatID.get(id)) == null) {
                this.tileIDByMatID.put(id, tileid);
                this.matIDByTileID.put(tileid, id);
                return;
            }
            if (v != null && v == tileid) {
                return;
            }
            id = baseid + "_" + cnt;
            ++cnt;
        }
    }

    private String getMatIDForTileID(int txtid) {
        String id = this.matIDByTileID.get(txtid);
        if (id == null) {
            id = "txt" + txtid;
            this.matIDByTileID.put(txtid, id);
            this.tileIDByMatID.put(id, txtid);
        }
        return id;
    }

    public static void tallyMemory(DynmapCommandSender sender) {
        long packcount = 0L;
        long packbytecount = 0L;
        for (String packid : packs.keySet()) {
            TexturePack p = packs.get(packid);
            long scaledcount = 0L;
            long scaledbytecount = 0L;
            for (Integer scale : p.scaled_textures.keySet()) {
                TexturePack sp = p.scaled_textures.get(scale);
                long bytecount = 0L;
                long imgcount = 0L;
                for (int i = 0; i < sp.imgs.length; ++i) {
                    if (sp.imgs[i] == null || sp.imgs[i].argb == null) continue;
                    bytecount += (long)(sp.imgs[i].argb.length * 4);
                    ++imgcount;
                }
                sender.sendMessage("pack: " + packid + ", scale: " + scale + ", imagecount=" + imgcount + ", bytecount=" + bytecount);
                scaledcount += imgcount;
                scaledbytecount += bytecount;
            }
            sender.sendMessage("pack: " + packid + ", total: imagecount=" + scaledcount + ", bytecount=" + scaledbytecount);
            packcount += scaledcount;
            packbytecount += scaledbytecount;
        }
        sender.sendMessage("overall total: imagecount=" + packcount + ", bytecount=" + packbytecount + "(" + (double)packbytecount / 1024.0 / 1024.0 + "Mb)");
    }

    static {
        Color c = new Color();
        for (int i = 0; i < 10; ++i) {
            int r = ((9 - i) * 255 + i * 224) / 9;
            int g = 255;
            int b = ((9 - i) * 255 + i * 174) / 9;
            c.setRGBA(r & 0xFE, g & 0xFE, b & 0xFE, 255);
            TexturePack.smooth_water_mult[i] = c.getARGB();
        }
        deftxtidx = new int[]{0, 1, 2, 3, 4, 5};
    }

    public static enum TileFileFormat {
        GRID,
        CHEST,
        BIGCHEST,
        SIGN,
        SKIN,
        SHULKER,
        CUSTOM,
        TILESET,
        BIOME,
        BED;

    }

    private static class DynamicTileFile {
        int idx;
        String filename;
        String modname;
        int tilecnt_x;
        int tilecnt_y;
        int[] tile_to_dyntile;
        TileFileFormat format;
        List<CustomTileRec> cust;
        String[] tilenames;
        boolean used;
        MaterialType material;

        private DynamicTileFile() {
        }
    }

    public static class TextureMap {
        private Map<Integer, Integer> key_to_index = new HashMap<Integer, Integer>();
        private List<Integer> texture_ids = new ArrayList<Integer>();
        private Map<DynmapBlockState, BitSet> states;
        private BlockTransparency trans = BlockTransparency.OPAQUE;
        private int colorMult = 0;
        private CustomColorMultiplier custColorMult = null;
        private String blockset;

        public int addTextureByKey(int key, int textureid) {
            int off = this.texture_ids.size();
            this.texture_ids.add(textureid);
            this.key_to_index.put(key, off);
            return off;
        }
    }

    public static enum BlockTransparency {
        OPAQUE,
        TRANSPARENT,
        SEMITRANSPARENT,
        LEAVES;

    }

    public static class ColorizingData {
        private DynIntHashMap map = new DynIntHashMap();

        public void setBlkStateValue(DynmapBlockState blk, Integer mapidx) {
            int idx = blk.globalStateIndex;
            if (mapidx == null) {
                this.map.remove(idx);
            } else {
                this.map.put(idx, mapidx);
            }
        }

        public Integer getBlkStateValue(DynmapBlockState blk) {
            return (Integer)this.map.get(blk.globalStateIndex);
        }

        public boolean hasBlkStateValue(DynmapBlockState blk) {
            return this.map.containsKey(blk.globalStateIndex);
        }

        public void scrubValues(Integer val) {
            List<Integer> badvals = this.map.keysWithValue(val);
            for (Integer v : badvals) {
                this.map.remove(v);
            }
        }
    }

    private static class LoadedImage {
        int[] argb;
        int width;
        int height;
        int trivial_color;
        boolean isLoaded;
        String fname;
        String modid;

        private LoadedImage() {
        }
    }

    private static enum HandlePos {
        CENTER,
        LEFT,
        RIGHT,
        NONE,
        LEFTFRONT,
        RIGHTFRONT;

    }

    private static class CustomTileRec {
        int srcx;
        int srcy;
        int width;
        int height;
        int targetx;
        int targety;

        public CustomTileRec() {
        }

        public CustomTileRec(int srcx, int srcy, int width, int height, int targetx, int targety) {
            this.srcx = srcx;
            this.srcy = srcy;
            this.width = width;
            this.height = height;
            this.targetx = targetx;
            this.targety = targety;
        }

        public CustomTileRec(int srcx, int srcy, int width, int height) {
            this(srcx, srcy, width, height, 0, 0);
        }
    }

    public static enum MaterialType {
        GLASS(1.5, 200.0, 3),
        WATER(1.33, 100.0, 3);

        public final double Ni;
        public final double Ns;
        public final int illum;

        private MaterialType(double Ni, double Ns, int illum) {
            this.Ni = Ni;
            this.Ns = Ns;
            this.illum = illum;
        }
    }

    private static class ExportedTexturePack {
        Map<String, ExportedTexture> txtids = new HashMap<String, ExportedTexture>();
        DynmapBufferedImage img;
        OBJExport exp;
        String name;

        private ExportedTexturePack() {
        }
    }

    private static class ExportedTexture {
        public String filename;
        public Color diffuseColor;
        public String filename_a;
        public MaterialType material;

        private ExportedTexture() {
        }
    }
}

