/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_16_5;

import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.dynmap.DynmapChunk;
import org.dynmap.Log;
import org.dynmap.common.chunk.GenericChunk;
import org.dynmap.common.chunk.GenericChunkCache;
import org.dynmap.common.chunk.GenericMapChunkCache;
import org.dynmap.forge_1_16_5.ForgeWorld;
import org.dynmap.forge_1_16_5.NBT;

public class ForgeMapChunkCache
extends GenericMapChunkCache {
    private ServerWorld w;
    private ServerChunkProvider cps;

    public ForgeMapChunkCache(GenericChunkCache cc) {
        super(cc);
    }

    @Override
    protected GenericChunk getLoadedChunk(DynmapChunk chunk) {
        CompoundNBT nbt;
        GenericChunk gc = null;
        IChunk ch = this.cps.func_212849_a_(chunk.x, chunk.z, ChunkStatus.field_222617_m, false);
        if (ch != null && (nbt = ChunkSerializer.func_222645_a((ServerWorld)this.w, (IChunk)ch)) != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    @Override
    protected GenericChunk loadChunk(DynmapChunk chunk) {
        GenericChunk gc = null;
        CompoundNBT nbt = this.readChunk(chunk.x, chunk.z);
        if (nbt != null) {
            gc = this.parseChunkFromNBT(new NBT.NBTCompound(nbt));
        }
        return gc;
    }

    public void setChunks(ForgeWorld dw, List<DynmapChunk> chunks) {
        this.w = (ServerWorld)dw.getWorld();
        if (dw.isLoaded()) {
            ServerChunkProvider cp = this.w.func_72863_F();
            if (cp instanceof ServerChunkProvider) {
                this.cps = cp;
            } else {
                Log.severe("Error: world " + dw.getName() + " has unsupported chunk provider");
            }
        }
        super.setChunks(dw, chunks);
    }

    private CompoundNBT readChunk(int x, int z) {
        try {
            return this.cps.field_217237_a.func_227078_e_(new ChunkPos(x, z));
        }
        catch (Exception exc) {
            Log.severe(String.format("Error reading chunk: %s,%d,%d", this.dw.getName(), x, z), exc);
            return null;
        }
    }
}

