/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.storage;

import java.awt.image.BufferedImage;
import org.dynmap.DynmapWorld;
import org.dynmap.MapType;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.utils.ImageIOManager;

public abstract class MapStorageTile {
    public final DynmapWorld world;
    public final MapType map;
    public final int x;
    public final int y;
    public final int zoom;
    public final MapType.ImageVariant var;

    protected MapStorageTile(DynmapWorld world, MapType map, int x, int y, int zoom, MapType.ImageVariant var) {
        this.world = world;
        this.map = map;
        this.x = x;
        this.y = y;
        this.zoom = zoom;
        this.var = var;
    }

    public abstract boolean exists();

    public abstract boolean matchesHashCode(long var1);

    public abstract TileRead read();

    public abstract boolean write(long var1, BufferOutputStream var3, long var4);

    public boolean write(long hash, BufferedImage image, long timestamp) {
        BufferOutputStream bos = ImageIOManager.imageIOEncode(image, this.map.getImageFormat());
        if (bos != null) {
            return this.write(hash, bos, timestamp);
        }
        return false;
    }

    public boolean delete() {
        return this.write(-1L, (BufferOutputStream)null, -1L);
    }

    public abstract boolean getWriteLock();

    public abstract void releaseWriteLock();

    public abstract boolean getReadLock(long var1);

    public boolean getReadLock() {
        return this.getReadLock(-1L);
    }

    public abstract void releaseReadLock();

    public abstract void cleanup();

    public abstract String getURI();

    public abstract void enqueueZoomOutUpdate();

    public abstract MapStorageTile getZoomOutTile();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static class TileRead {
        public BufferInputStream image;
        public MapType.ImageEncoding format;
        public long hashCode;
        public long lastModified;
    }
}

