/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.http.urlconnection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.HttpsURLConnection;
import org.dynmap.s3lite.http.spi.HttpStatus;
import org.dynmap.s3lite.http.spi.IOUtils;
import org.dynmap.s3lite.http.spi.SdkHttpClient;
import org.dynmap.s3lite.http.spi.SdkHttpUtils;
import org.dynmap.s3lite.http.spi.request.ImmutableRequest;
import org.dynmap.s3lite.http.spi.request.RequestBody;
import org.dynmap.s3lite.http.spi.response.ImmutableResponse;

public class URLConnectionSdkHttpClient
implements SdkHttpClient {
    private final Consumer<HttpsURLConnection> customizer;

    private URLConnectionSdkHttpClient(Consumer<HttpsURLConnection> customizer) {
        this.customizer = customizer;
    }

    public static URLConnectionSdkHttpClient create() {
        return new URLConnectionSdkHttpClient(conn -> {});
    }

    public static URLConnectionSdkHttpClient withCustomizer(Consumer<HttpsURLConnection> customizer) {
        return new URLConnectionSdkHttpClient(customizer);
    }

    @Override
    public ImmutableResponse apply(ImmutableRequest request) {
        StringBuilder builder = new StringBuilder().append(request.getEndpoint()).append(request.getResourcePath());
        String queryString = SdkHttpUtils.toQueryString(request.getParameters());
        if (!queryString.isEmpty()) {
            builder.append("?").append(queryString);
        }
        try {
            URL url = new URL(builder.toString());
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            this.customizer.accept(conn);
            conn.setRequestMethod(request.getHttpMethod().name());
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            request.getHeaders().forEach((name, values) -> conn.setRequestProperty((String)name, String.join((CharSequence)",", values)));
            request.getRequestBody().map(RequestBody::getContentStreamProvider).ifPresent(supplier -> {
                byte[] bytes;
                Throwable throwable;
                try {
                    throwable = null;
                    try (InputStream inputStream = (InputStream)supplier.get();){
                        bytes = IOUtils.toByteArray(inputStream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                conn.setDoOutput(true);
                conn.setFixedLengthStreamingMode(bytes.length);
                try {
                    throwable = null;
                    try (OutputStream outputStream = conn.getOutputStream();){
                        outputStream.write(bytes);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            Map<String, List<String>> headers = conn.getHeaderFields();
            int statusCode = conn.getResponseCode();
            HttpStatus httpsStatus = HttpStatus.fromStatusCode(statusCode);
            InputStream inputStream = httpsStatus.is2xxSuccessful() ? conn.getInputStream() : conn.getErrorStream();
            return ImmutableResponse.builder().status(httpsStatus).headers(headers).responseBody(inputStream).build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
    }
}

