/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dynmap.ClientUpdateComponent;
import org.dynmap.ClientUpdateEvent;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.Log;
import org.dynmap.MapManager;
import org.dynmap.json.simple.JSONArray;
import org.dynmap.json.simple.JSONObject;
import org.dynmap.json.simple.parser.JSONParser;
import org.dynmap.json.simple.parser.ParseException;
import org.dynmap.storage.MapStorage;
import org.dynmap.utils.BufferInputStream;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.web.Json;

public class JsonFileClientUpdateComponent
extends ClientUpdateComponent {
    protected long jsonInterval;
    protected long currentTimestamp = 0L;
    protected long lastTimestamp = 0L;
    protected long lastChatTimestamp = 0L;
    protected JSONParser parser = new JSONParser();
    private boolean hidewebchatip;
    private boolean useplayerloginip;
    private boolean requireplayerloginip;
    private boolean trust_client_name;
    private boolean checkuserban;
    private boolean req_login;
    private boolean chat_perms;
    private int lengthlimit;
    private HashMap<String, String> useralias = new HashMap();
    private int aliasindex = 1;
    private long last_confighash;
    private MessageDigest md;
    private MapStorage storage;
    private File baseStandaloneDir;
    private Object lock = new Object();
    private FileProcessor pending;
    private LinkedList<FileToWrite> files_to_write = new LinkedList();
    private static Charset cs_utf8 = Charset.forName("UTF-8");
    private byte[] loginhash = new byte[16];
    private byte[] accesshash = new byte[16];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFileWrite(String filename, byte[] content, boolean phpwrap) {
        FileToWrite ftw = new FileToWrite();
        ftw.filename = filename;
        ftw.content = content;
        ftw.phpwrapper = phpwrap;
        Object object = this.lock;
        synchronized (object) {
            boolean didadd = false;
            if (this.pending == null) {
                didadd = true;
                this.pending = new FileProcessor();
            }
            this.files_to_write.remove(ftw);
            this.files_to_write.add(ftw);
            if (didadd) {
                MapManager.scheduleDelayedJob(new FileProcessor(), 0L);
            }
        }
    }

    public JsonFileClientUpdateComponent(final DynmapCore core, final ConfigurationNode configuration) {
        super(core, configuration);
        if (!core.isInternalWebServerDisabled) {
            Log.severe("Using JsonFileClientUpdateComponent with disable-webserver=false is not supported: there will likely be problems");
        }
        final boolean allowwebchat = configuration.getBoolean("allowwebchat", false);
        this.jsonInterval = (long)(configuration.getFloat("writeinterval", 1.0f) * 1000.0f);
        this.hidewebchatip = configuration.getBoolean("hidewebchatip", false);
        this.useplayerloginip = configuration.getBoolean("use-player-login-ip", true);
        this.requireplayerloginip = configuration.getBoolean("require-player-login-ip", false);
        this.trust_client_name = configuration.getBoolean("trustclientname", false);
        this.checkuserban = configuration.getBoolean("block-banned-player-chat", true);
        this.req_login = configuration.getBoolean("webchat-requires-login", false);
        this.chat_perms = configuration.getBoolean("webchat-permissions", false);
        this.lengthlimit = configuration.getInteger("chatlengthlimit", 256);
        this.storage = core.getDefaultMapStorage();
        this.baseStandaloneDir = new File(core.configuration.getString("webpath", "web"), "standalone");
        if (!this.baseStandaloneDir.isAbsolute()) {
            this.baseStandaloneDir = new File(core.getDataFolder(), this.baseStandaloneDir.toString());
        }
        try {
            this.md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsax) {
            Log.severe("Unable to get message digest SHA-1");
        }
        this.generateConfigJS(core);
        core.getServer().scheduleServerTask(new Runnable(){

            @Override
            public void run() {
                JsonFileClientUpdateComponent.this.currentTimestamp = System.currentTimeMillis();
                if (JsonFileClientUpdateComponent.this.last_confighash != (long)core.getConfigHashcode()) {
                    JsonFileClientUpdateComponent.this.writeConfiguration();
                }
                JsonFileClientUpdateComponent.this.writeUpdates();
                if (allowwebchat) {
                    JsonFileClientUpdateComponent.this.handleWebChat();
                }
                if (core.isLoginSupportEnabled()) {
                    JsonFileClientUpdateComponent.this.handleRegister();
                }
                JsonFileClientUpdateComponent.this.lastTimestamp = JsonFileClientUpdateComponent.this.currentTimestamp;
                core.getServer().scheduleServerTask(this, JsonFileClientUpdateComponent.this.jsonInterval / 50L);
            }
        }, this.jsonInterval / 50L);
        core.events.addListener("buildclientconfiguration", new Event.Listener<JSONObject>(){

            @Override
            public void triggered(JSONObject t) {
                JSONUtils.s(t, "jsonfile", true);
                JSONUtils.s(t, "allowwebchat", allowwebchat);
                JSONUtils.s(t, "webchat-requires-login", JsonFileClientUpdateComponent.this.req_login);
                JSONUtils.s(t, "loginrequired", core.isLoginRequired());
                JSONUtils.s(t, "webchat-interval", Float.valueOf(configuration.getFloat("webchat-interval", 5.0f)));
                JSONUtils.s(t, "chatlengthlimit", JsonFileClientUpdateComponent.this.lengthlimit);
            }
        });
        core.events.addListener("initialized", new Event.Listener<Object>(){

            @Override
            public void triggered(Object t) {
                JsonFileClientUpdateComponent.this.writeConfiguration();
                JsonFileClientUpdateComponent.this.writeUpdates();
                JsonFileClientUpdateComponent.this.writeLogins();
                JsonFileClientUpdateComponent.this.writeAccess();
            }
        });
        core.events.addListener("server-started", new Event.Listener<Object>(){

            @Override
            public void triggered(Object t) {
                JsonFileClientUpdateComponent.this.writeConfiguration();
                JsonFileClientUpdateComponent.this.writeUpdates();
                JsonFileClientUpdateComponent.this.writeLogins();
                JsonFileClientUpdateComponent.this.writeAccess();
            }
        });
        core.events.addListener("worldactivated", new Event.Listener<DynmapWorld>(){

            @Override
            public void triggered(DynmapWorld t) {
                JsonFileClientUpdateComponent.this.writeConfiguration();
                JsonFileClientUpdateComponent.this.writeUpdates();
                JsonFileClientUpdateComponent.this.writeAccess();
            }
        });
        core.events.addListener("loginupdated", new Event.Listener<Object>(){

            @Override
            public void triggered(Object t) {
                JsonFileClientUpdateComponent.this.writeLogins();
                JsonFileClientUpdateComponent.this.writeAccess();
            }
        });
        core.events.addListener("playersetupdated", new Event.Listener<Object>(){

            @Override
            public void triggered(Object t) {
                JsonFileClientUpdateComponent.this.writeAccess();
            }
        });
    }

    private void generateConfigJS(final DynmapCore core) {
        boolean login_enabled = core.isLoginSupportEnabled();
        MapStorage store = core.getDefaultMapStorage();
        StringBuilder sb = new StringBuilder();
        sb.append("var config = {\n");
        sb.append(" url : {\n");
        sb.append("  configuration: '");
        sb.append(core.configuration.getString("url/configuration", store.getConfigurationJSONURI(login_enabled)));
        sb.append("',\n");
        sb.append("  update: '");
        sb.append(core.configuration.getString("url/update", store.getUpdateJSONURI(login_enabled)));
        sb.append("',\n");
        sb.append("  sendmessage: '");
        sb.append(core.configuration.getString("url/sendmessage", store.getSendMessageURI()));
        sb.append("',\n");
        sb.append("  login: '");
        sb.append(core.configuration.getString("url/login", store.getStandaloneLoginURI()));
        sb.append("',\n");
        sb.append("  register: '");
        sb.append(core.configuration.getString("url/register", store.getStandaloneRegisterURI()));
        sb.append("',\n");
        sb.append("  tiles: '");
        sb.append(core.configuration.getString("url/tiles", store.getTilesURI(login_enabled)));
        sb.append("',\n");
        sb.append("  markers: '");
        sb.append(core.configuration.getString("url/markers", store.getMarkersURI(login_enabled)));
        sb.append("'\n }\n};\n");
        final byte[] outputBytes = sb.toString().getBytes(cs_utf8);
        MapManager.scheduleDelayedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (core.getDefaultMapStorage().needsStaticWebFiles()) {
                    BufferOutputStream os = new BufferOutputStream();
                    os.write(outputBytes);
                    core.getDefaultMapStorage().setStaticWebFile("standalone/config.js", os);
                } else {
                    File f = new File(JsonFileClientUpdateComponent.this.baseStandaloneDir, "config.js");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(f);
                        fos.write(outputBytes);
                    }
                    catch (IOException iox) {
                        Log.severe("Exception while writing " + f.getPath(), iox);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                            fos = null;
                        }
                    }
                }
            }
        }, 0L);
    }

    protected void writeConfiguration() {
        JSONObject clientConfiguration = new JSONObject();
        this.core.events.trigger("buildclientconfiguration", clientConfiguration);
        this.last_confighash = this.core.getConfigHashcode();
        byte[] content = clientConfiguration.toJSONString().getBytes(cs_utf8);
        boolean dowrap = this.storage.wrapStandaloneJSON(this.core.isLoginSupportEnabled());
        String outputFile = dowrap ? "dynmap_config.php" : "dynmap_config.json";
        this.enqueueFileWrite(outputFile, content, dowrap);
    }

    protected void writeUpdates() {
        if (this.core.mapManager == null) {
            return;
        }
        ArrayList<DynmapWorld> wlist = new ArrayList<DynmapWorld>(this.core.mapManager.getWorlds());
        for (int windx = 0; windx < wlist.size(); ++windx) {
            DynmapWorld dynmapWorld = wlist.get(windx);
            JSONObject update = new JSONObject();
            update.put("timestamp", this.currentTimestamp);
            ClientUpdateEvent clientUpdate = new ClientUpdateEvent(this.currentTimestamp - 30000L, dynmapWorld, update);
            clientUpdate.include_all_users = true;
            this.core.events.trigger("buildclientupdate", clientUpdate);
            boolean dowrap = this.storage.wrapStandaloneJSON(this.core.isLoginSupportEnabled());
            String outputFile = dowrap ? "updates_" + dynmapWorld.getName() + ".php" : "dynmap_" + dynmapWorld.getName() + ".json";
            byte[] content = Json.stringifyJson(update).getBytes(cs_utf8);
            this.enqueueFileWrite(outputFile, content, dowrap);
        }
    }

    protected void writeLogins() {
        String loginFile = "dynmap_login.php";
        if (this.core.isLoginSupportEnabled()) {
            String s = this.core.getLoginPHP(this.storage.wrapStandalonePHP());
            if (s != null) {
                byte[] bytes = s.getBytes(cs_utf8);
                this.md.reset();
                byte[] hash = this.md.digest(bytes);
                if (Arrays.equals(hash, this.loginhash)) {
                    return;
                }
                this.enqueueFileWrite(loginFile, bytes, false);
                this.loginhash = hash;
            }
        } else {
            this.enqueueFileWrite(loginFile, null, false);
        }
    }

    protected void writeAccess() {
        String accessFile = "dynmap_access.php";
        String s = this.core.getAccessPHP(this.storage.wrapStandalonePHP());
        if (s != null) {
            byte[] bytes = s.getBytes(cs_utf8);
            this.md.reset();
            byte[] hash = this.md.digest(bytes);
            if (Arrays.equals(hash, this.accesshash)) {
                return;
            }
            this.enqueueFileWrite(accessFile, bytes, false);
            this.accesshash = hash;
        }
    }

    private void processWebChat(JSONArray jsonMsgs) {
        boolean init_skip;
        Iterator iter = jsonMsgs.iterator();
        boolean bl = init_skip = this.lastChatTimestamp == 0L;
        while (iter.hasNext()) {
            long cts;
            boolean ok = true;
            JSONObject o = (JSONObject)iter.next();
            String ts = String.valueOf(o.get("timestamp"));
            if (ts.equals("null")) {
                ts = "0";
            }
            try {
                cts = Long.parseLong(ts);
            }
            catch (NumberFormatException nfx) {
                try {
                    cts = (long)Double.parseDouble(ts);
                }
                catch (NumberFormatException nfx2) {
                    cts = 0L;
                }
            }
            if (cts <= this.lastChatTimestamp) continue;
            String name = String.valueOf(o.get("name"));
            String ip = String.valueOf(o.get("ip"));
            String uid = null;
            Object usr = o.get("userid");
            if (usr != null) {
                uid = String.valueOf(usr);
            }
            boolean isip = true;
            this.lastChatTimestamp = cts;
            if (init_skip) continue;
            if (uid == null) {
                if ((!this.trust_client_name || name == null || name.equals("")) && ip != null) {
                    name = ip;
                }
                if (this.useplayerloginip) {
                    List<String> ids = this.core.getIDsForIP(name);
                    if (ids != null && !ids.isEmpty()) {
                        name = ids.get(0);
                        isip = false;
                        if (this.checkuserban && this.core.getServer().isPlayerBanned(name)) {
                            Log.info("Ignore message from '" + ip + "' - banned player (" + name + ")");
                            ok = false;
                        }
                        if (this.chat_perms && !this.core.getServer().checkPlayerPermission(name, "webchat")) {
                            Log.info("Rejected web chat from " + ip + ": not permitted (" + name + ")");
                            ok = false;
                        }
                    } else if (this.requireplayerloginip) {
                        Log.info("Ignore message from '" + name + "' - no matching player login recorded");
                        ok = false;
                    }
                }
                if (this.hidewebchatip && isip) {
                    String n = this.useralias.get(name);
                    if (n == null) {
                        n = String.format("web-%03d", this.aliasindex);
                        ++this.aliasindex;
                        this.useralias.put(name, n);
                    }
                    name = n;
                }
            } else {
                if (this.core.getServer().isPlayerBanned(uid)) {
                    Log.info("Ignore message from '" + uid + "' - banned user");
                    ok = false;
                }
                if (this.chat_perms && !this.core.getServer().checkPlayerPermission(uid, "webchat")) {
                    Log.info("Rejected web chat from " + uid + ": not permitted");
                    ok = false;
                }
                name = uid;
            }
            if (!ok) continue;
            String message = String.valueOf(o.get("message"));
            if (this.lengthlimit > 0 && message.length() > this.lengthlimit) {
                message = message.substring(0, this.lengthlimit);
            }
            this.core.webChat(name, message);
        }
    }

    protected void handleWebChat() {
        MapManager.scheduleDelayedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferInputStream bis = JsonFileClientUpdateComponent.this.storage.getStandaloneFile("dynmap_webchat.json");
                if (bis != null && JsonFileClientUpdateComponent.this.lastTimestamp != 0L) {
                    JSONArray jsonMsgs = null;
                    InputStreamReader inputFileReader = null;
                    try {
                        inputFileReader = new InputStreamReader((InputStream)bis, cs_utf8);
                        jsonMsgs = (JSONArray)JsonFileClientUpdateComponent.this.parser.parse(inputFileReader);
                    }
                    catch (IOException ex) {
                        Log.severe("Exception while reading JSON-file.", ex);
                        JsonFileClientUpdateComponent.this.storage.setStandaloneFile("dynmap_webchat.json", null);
                    }
                    catch (ParseException ex) {
                        Log.severe("Exception while parsing JSON-file.", ex);
                        JsonFileClientUpdateComponent.this.storage.setStandaloneFile("dynmap_webchat.json", null);
                    }
                    finally {
                        if (inputFileReader != null) {
                            try {
                                ((Reader)inputFileReader).close();
                            }
                            catch (IOException ex) {}
                            inputFileReader = null;
                        }
                    }
                    if (jsonMsgs != null) {
                        final JSONArray json = jsonMsgs;
                        JsonFileClientUpdateComponent.this.core.getServer().scheduleServerTask(new Runnable(){

                            @Override
                            public void run() {
                                JsonFileClientUpdateComponent.this.processWebChat(json);
                            }
                        }, 0L);
                    }
                }
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRegister() {
        if (!this.core.pendingRegisters()) {
            return;
        }
        BufferInputStream bis = this.storage.getStandaloneFile("dynmap_reg.php");
        if (bis != null) {
            BufferedReader br = null;
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(bis));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("<?") || line.startsWith("*/")) continue;
                    lines.add(line);
                }
            }
            catch (IOException iox) {
                Log.severe("Exception while reading dynmap_reg.php", iox);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iox) {}
                    br = null;
                }
            }
            for (int i = 0; i < lines.size(); ++i) {
                String[] vals = ((String)lines.get(i)).split("=");
                if (vals.length != 3) continue;
                this.core.processCompletedRegister(vals[0].trim(), vals[1].trim(), vals[2].trim());
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private class FileProcessor
    implements Runnable {
        private FileProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                FileToWrite f = null;
                Object object = JsonFileClientUpdateComponent.this.lock;
                synchronized (object) {
                    if (JsonFileClientUpdateComponent.this.files_to_write.isEmpty()) {
                        JsonFileClientUpdateComponent.this.pending = null;
                        return;
                    }
                    f = (FileToWrite)JsonFileClientUpdateComponent.this.files_to_write.removeFirst();
                }
                BufferOutputStream buf = null;
                if (f.content != null) {
                    buf = new BufferOutputStream();
                    if (f.phpwrapper) {
                        buf.write("<?php /*\n".getBytes(cs_utf8));
                    }
                    buf.write(f.content);
                    if (f.phpwrapper) {
                        buf.write("\n*/ ?>\n".getBytes(cs_utf8));
                    }
                }
                if (JsonFileClientUpdateComponent.this.storage.setStandaloneFile(f.filename, buf)) continue;
                Log.severe("Exception while writing JSON-file - " + f.filename);
            }
        }
    }

    private static class FileToWrite {
        String filename;
        byte[] content;
        boolean phpwrapper;

        private FileToWrite() {
        }

        public boolean equals(Object o) {
            if (o instanceof FileToWrite) {
                return ((FileToWrite)o).filename.equals(this.filename);
            }
            return false;
        }
    }
}

