/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_14_4.permissions;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import org.dynmap.ConfigurationNode;
import org.dynmap.Log;
import org.dynmap.forge_1_14_4.DynmapPlugin;
import org.dynmap.forge_1_14_4.permissions.PermissionProvider;

public class FilePermissions
implements PermissionProvider {
    private HashMap<String, Set<String>> perms = new HashMap();
    private Set<String> defperms;

    public static FilePermissions create() {
        File f = new File("dynmap/permissions.yml");
        if (!f.exists()) {
            return null;
        }
        ConfigurationNode cfg = new ConfigurationNode(f);
        cfg.load();
        Log.info("Using permissions.yml for access control");
        return new FilePermissions(cfg);
    }

    private FilePermissions(ConfigurationNode cfg) {
        for (String k : cfg.keySet()) {
            List<String> p = cfg.getStrings(k, null);
            if (p == null) continue;
            k = k.toLowerCase();
            HashSet<String> pset = new HashSet<String>();
            for (String perm : p) {
                pset.add(perm.toLowerCase());
            }
            this.perms.put(k, pset);
            if (!k.equals("defaultuser")) continue;
            this.defperms = pset;
        }
    }

    private boolean hasPerm(String player, String perm) {
        Set<String> ps = this.perms.get(player);
        if (ps != null && ps.contains(perm)) {
            return true;
        }
        return this.defperms.contains(perm);
    }

    @Override
    public Set<String> hasOfflinePermissions(String player, Set<String> perms) {
        player = player.toLowerCase();
        HashSet<String> rslt = new HashSet<String>();
        if (DynmapPlugin.plugin.isOp(player)) {
            rslt.addAll(perms);
        } else {
            for (String p : perms) {
                if (!this.hasPerm(player, p)) continue;
                rslt.add(p);
            }
        }
        return rslt;
    }

    @Override
    public boolean hasOfflinePermission(String player, String perm) {
        if (DynmapPlugin.plugin.isOp(player = player.toLowerCase())) {
            return true;
        }
        return this.hasPerm(player, perm);
    }

    @Override
    public boolean has(PlayerEntity psender, String permission) {
        if (psender != null) {
            String n = psender.func_200200_C_().getString().toLowerCase();
            return this.hasPerm(n, permission);
        }
        return true;
    }

    @Override
    public boolean hasPermissionNode(PlayerEntity psender, String permission) {
        if (psender != null) {
            String player = psender.func_200200_C_().getString().toLowerCase();
            return DynmapPlugin.plugin.isOp(player);
        }
        return false;
    }
}

