/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.forge_1_14_4;

import java.util.Arrays;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.BitArray;
import org.dynmap.renderer.DynmapBlockState;

public class ChunkSnapshot {
    private final int x;
    private final int z;
    private final Section[] section;
    private final int[] hmap;
    private final int[] biome;
    private final long captureFulltime;
    private final int sectionCnt;
    private final long inhabitedTicks;
    private static final int BLOCKS_PER_SECTION = 4096;
    private static final int COLUMNS_PER_CHUNK = 256;
    private static final byte[] emptyData = new byte[2048];
    private static final byte[] fullData = new byte[2048];
    private static final EmptySection empty_section;

    public ChunkSnapshot(int worldheight, int x, int z, long captime, long inhabitedTime) {
        this.x = x;
        this.z = z;
        this.captureFulltime = captime;
        this.biome = new int[256];
        this.sectionCnt = worldheight / 16;
        this.section = new Section[this.sectionCnt + 1];
        for (int i = 0; i <= this.sectionCnt; ++i) {
            this.section[i] = empty_section;
        }
        this.hmap = new int[256];
        this.inhabitedTicks = inhabitedTime;
    }

    public ChunkSnapshot(CompoundNBT nbt, int worldheight) {
        int[] bb;
        this.x = nbt.func_74762_e("xPos");
        this.z = nbt.func_74762_e("zPos");
        this.captureFulltime = 0L;
        this.hmap = nbt.func_74759_k("HeightMap");
        this.sectionCnt = worldheight / 16;
        this.inhabitedTicks = nbt.func_74764_b("InhabitedTime") ? nbt.func_74763_f("InhabitedTime") : 0L;
        this.section = new Section[this.sectionCnt + 1];
        for (int i = 0; i <= this.sectionCnt; ++i) {
            this.section[i] = empty_section;
        }
        ListNBT sect = nbt.func_150295_c("Sections", 10);
        for (int i = 0; i < sect.size(); ++i) {
            CompoundNBT sec = sect.func_150305_b(i);
            byte secnum = sec.func_74771_c("Y");
            if (secnum >= this.sectionCnt || secnum < 0) continue;
            StdSection cursect = new StdSection();
            this.section[secnum] = cursect;
            DynmapBlockState[] states = cursect.states;
            DynmapBlockState[] palette = null;
            if (sec.func_150297_b("Palette", 9) && sec.func_150297_b("BlockStates", 12)) {
                int j;
                ListNBT plist = sec.func_150295_c("Palette", 10);
                long[] statelist = sec.func_197645_o("BlockStates");
                palette = new DynmapBlockState[plist.size()];
                for (int pi = 0; pi < plist.size(); ++pi) {
                    CompoundNBT tc = plist.func_150305_b(pi);
                    String pname = tc.func_74779_i("Name");
                    if (tc.func_74764_b("Properties")) {
                        StringBuilder statestr = new StringBuilder();
                        CompoundNBT prop = tc.func_74775_l("Properties");
                        for (String pid : prop.func_150296_c()) {
                            if (statestr.length() > 0) {
                                statestr.append(',');
                            }
                            statestr.append(pid).append('=').append(prop.func_74781_a(pid).func_150285_a_());
                        }
                        palette[pi] = DynmapBlockState.getStateByNameAndState(pname, statestr.toString());
                    }
                    if (palette[pi] == null) {
                        palette[pi] = DynmapBlockState.getBaseStateByName(pname);
                    }
                    if (palette[pi] != null) continue;
                    palette[pi] = DynmapBlockState.AIR;
                }
                int bitsperblock = statelist.length * 64 / 4096;
                BitArray db = new BitArray(bitsperblock, 4096, statelist);
                if (bitsperblock > 8) {
                    for (j = 0; j < 4096; ++j) {
                        states[j] = DynmapBlockState.getStateByGlobalIndex(db.func_188142_a(j));
                    }
                } else {
                    for (j = 0; j < 4096; ++j) {
                        int v = db.func_188142_a(j);
                        states[j] = v < palette.length ? palette[v] : DynmapBlockState.AIR;
                    }
                }
            }
            if (sec.func_74764_b("BlockLight")) {
                cursect.emitlight = sec.func_74770_j("BlockLight");
            }
            if (!sec.func_74764_b("SkyLight")) continue;
            cursect.skylight = sec.func_74770_j("SkyLight");
        }
        this.biome = new int[256];
        if (nbt.func_74764_b("Biomes") && (bb = nbt.func_74759_k("Biomes")) != null) {
            for (int i = 0; i < bb.length; ++i) {
                int bv = bb[i];
                this.biome[i] = bv < 0 ? 0 : bv;
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public DynmapBlockState getBlockType(int x, int y, int z) {
        return this.section[y >> 4].getBlockType(x, y, z);
    }

    public int getBlockSkyLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockSkyLight(x, y, z);
    }

    public int getBlockEmittedLight(int x, int y, int z) {
        return this.section[y >> 4].getBlockEmittedLight(x, y, z);
    }

    public int getHighestBlockYAt(int x, int z) {
        return this.hmap[z << 4 | x];
    }

    public int getBiome(int x, int z) {
        return this.biome[z << 4 | x];
    }

    public final long getCaptureFullTime() {
        return this.captureFulltime;
    }

    public boolean isSectionEmpty(int sy) {
        return this.section[sy].isEmpty();
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    static {
        Arrays.fill(fullData, (byte)-1);
        empty_section = new EmptySection();
    }

    private static interface Section {
        public DynmapBlockState getBlockType(int var1, int var2, int var3);

        public int getBlockSkyLight(int var1, int var2, int var3);

        public int getBlockEmittedLight(int var1, int var2, int var3);

        public boolean isEmpty();
    }

    private static class EmptySection
    implements Section {
        private EmptySection() {
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return DynmapBlockState.AIR;
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static class StdSection
    implements Section {
        DynmapBlockState[] states = new DynmapBlockState[4096];
        byte[] skylight;
        byte[] emitlight;

        public StdSection() {
            Arrays.fill(this.states, DynmapBlockState.AIR);
            this.skylight = emptyData;
            this.emitlight = emptyData;
        }

        @Override
        public DynmapBlockState getBlockType(int x, int y, int z) {
            return this.states[(y & 0xF) << 8 | z << 4 | x];
        }

        @Override
        public int getBlockSkyLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.skylight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public int getBlockEmittedLight(int x, int y, int z) {
            int off = (y & 0xF) << 7 | z << 3 | x >> 1;
            return this.emitlight[off] >> 4 * (x & 1) & 0xF;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }
}

