/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import org.dynmap.SkinUrlProvider;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SkinsRestorerSkinUrlProvider
implements SkinUrlProvider {
    private JSONParser mJsonParser = new JSONParser();
    private SkinsRestorerAPI mSkinsRestorerApi = SkinsRestorerAPI.getApi();

    SkinsRestorerSkinUrlProvider() {
    }

    @Override
    public URL getSkinUrl(String playerName) {
        JSONObject skinData;
        String skinDataPropertyValue;
        String skinName = this.mSkinsRestorerApi.getSkinName(playerName);
        IProperty skinDataProperty = this.mSkinsRestorerApi.getSkinData(skinName == null ? playerName : skinName);
        if (skinDataProperty == null) {
            return null;
        }
        try {
            skinDataPropertyValue = (String)ReflectionUtil.invokeMethod((Object)skinDataProperty, (String)"getValue");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        byte[] skinDataBytes = Base64.getDecoder().decode(skinDataPropertyValue);
        try {
            skinData = (JSONObject)this.mJsonParser.parse(new String(skinDataBytes, StandardCharsets.UTF_8));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
        try {
            return new URL((String)((JSONObject)((JSONObject)skinData.get((Object)"textures")).get((Object)"SKIN")).get((Object)"url"));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

