/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit.helper.v118_2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;

public class AsyncChunkProvider118_2 {
    private final Thread ioThread;
    private final Method getChunk;
    private final Predicate<NBTTagCompound> ifFailed;

    AsyncChunkProvider118_2() {
        try {
            Predicate<NBTTagCompound> ifFailed1 = null;
            Method getChunk1 = null;
            Thread ioThread1 = null;
            try {
                Class<?> threadClass = Class.forName("com.destroystokyo.paper.io.PaperFileIOThread");
                Class<?>[] classes = threadClass.getClasses();
                Class holder = Arrays.stream(classes).filter(aClass -> aClass.getSimpleName().equals("Holder")).findAny().orElseThrow(RuntimeException::new);
                ioThread1 = (Thread)holder.getField("INSTANCE").get(null);
                getChunk1 = threadClass.getMethod("loadChunkDataAsync", WorldServer.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Consumer.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                NBTTagCompound failure = (NBTTagCompound)threadClass.getField("FAILURE_VALUE").get(null);
                ifFailed1 = nbtTagCompound -> nbtTagCompound == failure;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
            this.ifFailed = Objects.requireNonNull(ifFailed1);
            this.getChunk = Objects.requireNonNull(getChunk1);
            this.ioThread = Objects.requireNonNull(ioThread1);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<NBTTagCompound> getChunk(WorldServer world, int x, int y) throws InvocationTargetException, IllegalAccessException {
        CompletableFuture future = new CompletableFuture();
        Object[] objectArray = new Object[8];
        objectArray[0] = world;
        objectArray[1] = x;
        objectArray[2] = y;
        objectArray[3] = 5;
        objectArray[4] = future::complete;
        objectArray[5] = false;
        objectArray[6] = true;
        objectArray[7] = true;
        this.getChunk.invoke((Object)this.ioThread, objectArray);
        return future.thenApply(resultFuture -> {
            if (resultFuture == null) {
                return null;
            }
            try {
                NBTTagCompound compound = (NBTTagCompound)resultFuture.getClass().getField("chunkData").get(resultFuture);
                return this.ifFailed.test(compound) ? null : compound;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
                return null;
            }
        });
    }
}

