/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class FenceWallBlockStateRenderer
extends CustomRenderer {
    private static final int TEXTURE_SIDES = 0;
    private static final int TEXTURE_TOP = 1;
    private static final int TEXTURE_BOTTOM = 2;
    private boolean is_wall;
    private boolean is_tall_wall;
    private static final int SIDE_XP = 1;
    private static final int SIDE_XN = 2;
    private static final int SIDE_X = 3;
    private static final int SIDE_ZP = 4;
    private static final int SIDE_ZN = 8;
    private static final int SIDE_Z = 12;
    private static final int SIDE_YP = 16;
    private static final int SIDE_XP_MULT = 1;
    private static final int SIDE_XN_MULT = 3;
    private static final int SIDE_ZP_MULT = 9;
    private static final int SIDE_ZN_MULT = 27;
    private static final int SIDE_UP_MULT = 81;
    private RenderPatch[][] meshes;
    private static final int[] patchlist = new int[]{2, 1, 0, 0, 0, 0};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, String blkname, BitSet blockdatamask, Map<String, String> custparm) {
        if (!super.initializeRenderer(rpf, blkname, blockdatamask, custparm)) {
            return false;
        }
        String type = custparm.get("type");
        if (type != null && type.equals("wall")) {
            this.buildWallMeshes(rpf);
            this.is_wall = true;
        } else if (type != null && type.equals("tallwall")) {
            this.buildTallWallMeshes(rpf);
            this.is_tall_wall = true;
        } else {
            this.buildFenceMeshes(rpf);
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount() {
        return 3;
    }

    private void addBox(RenderPatchFactory rpf, List<RenderPatch> list, double xmin, double xmax, double ymin, double ymax, double zmin, double zmax) {
        FenceWallBlockStateRenderer.addBox(rpf, list, xmin, xmax, ymin, ymax, zmin, zmax, patchlist);
    }

    private void buildFenceMeshes(RenderPatchFactory rpf) {
        this.meshes = new RenderPatch[16][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 16; ++dat) {
            this.addBox(rpf, list, 0.375, 0.625, 0.0, 1.0, 0.375, 0.625);
            switch (dat & 3) {
                case 1: {
                    this.addBox(rpf, list, 0.625, 1.0, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.625, 1.0, 0.75, 0.9275, 0.4375, 0.5625);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.375, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.0, 0.375, 0.75, 0.9275, 0.4375, 0.5625);
                    break;
                }
                case 3: {
                    this.addBox(rpf, list, 0.0, 1.0, 0.375, 0.5625, 0.4375, 0.5625);
                    this.addBox(rpf, list, 0.0, 1.0, 0.75, 0.9275, 0.4375, 0.5625);
                }
            }
            switch (dat & 0xC) {
                case 4: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.625, 1.0);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.625, 1.0);
                    break;
                }
                case 8: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.0, 0.375);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.0, 0.375);
                    break;
                }
                case 12: {
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.375, 0.5625, 0.0, 1.0);
                    this.addBox(rpf, list, 0.4375, 0.5625, 0.75, 0.9275, 0.0, 1.0);
                }
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    private void buildWallMeshes(RenderPatchFactory rpf) {
        this.meshes = new RenderPatch[32][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 32; ++dat) {
            boolean need_post = (dat & 0xF) == 0 || (dat & 0x10) == 16;
            switch (dat & 3) {
                case 1: {
                    this.addBox(rpf, list, 0.75, 1.0, 0.0, 0.8125, 0.3125, 0.6875);
                    need_post = true;
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.25, 0.0, 0.8125, 0.3125, 0.6875);
                    need_post = true;
                    break;
                }
                case 3: {
                    this.addBox(rpf, list, 0.0, 1.0, 0.0, 0.8125, 0.3125, 0.6875);
                }
            }
            switch (dat & 0xC) {
                case 4: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.75, 1.0);
                    need_post = true;
                    break;
                }
                case 8: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.0, 0.25);
                    need_post = true;
                    break;
                }
                case 12: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.0, 1.0);
                }
            }
            if (need_post) {
                this.addBox(rpf, list, 0.25, 0.75, 0.0, 1.0, 0.25, 0.75);
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    private void buildTallWallMeshes(RenderPatchFactory rpf) {
        this.meshes = new RenderPatch[162][];
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        for (int dat = 0; dat < 162; ++dat) {
            switch (dat / 3 % 3) {
                case 1: {
                    this.addBox(rpf, list, 0.0, 0.5, 0.0, 0.8125, 0.3125, 0.6875);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.0, 0.5, 0.0, 1.0, 0.3125, 0.6875);
                }
            }
            switch (dat / 1 % 3) {
                case 1: {
                    this.addBox(rpf, list, 0.5, 1.0, 0.0, 0.8125, 0.3125, 0.6875);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.5, 1.0, 0.0, 1.0, 0.3125, 0.6875);
                }
            }
            switch (dat / 27 % 3) {
                case 1: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.0, 0.5);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 1.0, 0.0, 0.5);
                }
            }
            switch (dat / 9 % 3) {
                case 1: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 0.8125, 0.5, 1.0);
                    break;
                }
                case 2: {
                    this.addBox(rpf, list, 0.3125, 0.6875, 0.0, 1.0, 0.5, 1.0);
                }
            }
            switch (dat / 81 % 2) {
                case 0: {
                    this.addBox(rpf, list, 0.25, 0.75, 0.0, 1.0, 0.25, 0.75);
                }
            }
            this.meshes[dat] = list.toArray(new RenderPatch[list.size()]);
            list.clear();
        }
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int idx = ctx.getBlockType().stateIndex;
        int off = 0;
        if (this.is_wall) {
            if ((idx & 0x20) == 0) {
                ++off;
            }
            if ((idx & 0x10) == 0) {
                off += 8;
            }
            if ((idx & 8) == 0) {
                off += 4;
            }
            if ((idx & 4) == 0) {
                off += 16;
            }
            if ((idx & 1) == 0) {
                off += 2;
            }
        } else if (this.is_tall_wall) {
            off += idx % 3 * 3;
            off += idx / 6 % 2 * 81;
            off += idx / 12 % 3 * 9;
            off += idx / 36 % 3 * 27;
            off += idx / 108 % 3 * 1;
        } else {
            if ((idx & 0x10) == 0) {
                ++off;
            }
            if ((idx & 8) == 0) {
                off += 8;
            }
            if ((idx & 4) == 0) {
                off += 4;
            }
            if ((idx & 1) == 0) {
                off += 2;
            }
        }
        return this.meshes[off];
    }

    @Override
    public boolean isOnlyBlockStateSensitive() {
        return true;
    }
}

