/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.marshal;

import org.dynmap.s3lite.api.request.PutObjectRequest;
import org.dynmap.s3lite.core.auth.SignableRequest;
import org.dynmap.s3lite.core.marshal.MarshallerUtils;
import org.dynmap.s3lite.core.marshal.SdkRequestMarshaller;

public class PutObjectRequestMarshaller
implements SdkRequestMarshaller<PutObjectRequest> {
    @Override
    public void accept(SignableRequest signableRequest, PutObjectRequest request) {
        String responseExpires = MarshallerUtils.formatIfNotNull(request.getExpires(), MarshallerUtils.RFC_1123_DATE_TIME_FORMATTER);
        signableRequest.addHeader("Expect", "100-continue");
        MarshallerUtils.addMetadata(signableRequest, request.getMetadata());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-acl", request.getAcl());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Cache-Control", request.getCacheControl());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-Disposition", request.getContentDisposition());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-Encoding", request.getContentEncoding());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-Language", request.getContentLanguage());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-Length", request.getContentLength());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-MD5", request.getContentMD5());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Content-Type", request.getContentType());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "Expires", responseExpires);
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-grant-full-control", request.getGrantFullControl());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-grant-read", request.getGrantRead());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-grant-read-acp", request.getGrantReadACP());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-grant-write", request.getGrantWrite());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-grant-write-acp", request.getGrantWriteACP());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-object-lock-legal-hold", request.getObjectLockLegalHoldStatus());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-object-lock-mode", request.getObjectLockMode());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-object-lock-retain-until-date", MarshallerUtils.formatIfNotNull(request.getObjectLockRetainUntilDate(), MarshallerUtils.ISO_INSTANT_FORMATTER));
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-request-payer", request.getRequestPayer());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption", request.getServerSideEncryption());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-algorithm", request.getSseCustomerAlgorithm());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-key", request.getSseCustomerKey());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-key-MD5", request.getSseCustomerKeyMD5());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-context", request.getSseEncryptionContext());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-aws-kms-key-id", request.getSseKmsKeyId());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-storage-class", request.getStorageClass());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-tagging", request.getTagging());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-website-redirect-location", request.getWebsiteRedirectLocation());
    }
}

