/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.s3lite.core.marshal;

import org.dynmap.s3lite.api.request.GetObjectRequest;
import org.dynmap.s3lite.core.auth.SignableRequest;
import org.dynmap.s3lite.core.marshal.MarshallerUtils;
import org.dynmap.s3lite.core.marshal.SdkRequestMarshaller;

public class GetObjectRequestMarshaller
implements SdkRequestMarshaller<GetObjectRequest> {
    @Override
    public void accept(SignableRequest signableRequest, GetObjectRequest request) {
        String responseExpires = MarshallerUtils.formatIfNotNull(request.getResponseExpires(), MarshallerUtils.RFC_1123_DATE_TIME_FORMATTER);
        String ifModifiedSince = MarshallerUtils.formatIfNotNull(request.getIfModifiedSince(), MarshallerUtils.RFC_1123_DATE_TIME_FORMATTER);
        String ifUnmodifiedSince = MarshallerUtils.formatIfNotNull(request.getIfUnmodifiedSince(), MarshallerUtils.RFC_1123_DATE_TIME_FORMATTER);
        String range = request.getRange();
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-content-type", request.getResponseContentType());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-content-language", request.getResponseContentLanguage());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-expires", responseExpires);
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-cache-control", request.getResponseCacheControl());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-content-encoding", request.getResponseContentEncoding());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "response-content-disposition", request.getResponseContentDisposition());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "versionId", request.getVersionId());
        MarshallerUtils.addParameterIfNotNull(signableRequest, "partNumber", request.getPartNumber());
        if (range != null) {
            signableRequest.addHeader("Range", "bytes=" + range);
        }
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "If-Modified-Since", ifModifiedSince);
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "If-Unmodified-Since", ifUnmodifiedSince);
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "If-Match", request.getIfMatch());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "If-None-Match", request.getIfNoneMatch());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-algorithm", request.getSseCustomerAlgorithm());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-key", request.getSseCustomerKey());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-server-side-encryption-customer-key-MD5", request.getSseCustomerKeyMD5());
        MarshallerUtils.addHeaderIfNotNull(signableRequest, "x-amz-request-payer", request.getRequestPayer());
    }
}

