/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.dynmap.Log;
import org.dynmap.modsupport.ModSupportAPI;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;
import org.dynmap.modsupport.impl.ModTextureDefinitionImpl;

public class ModSupportImpl
extends ModSupportAPI {
    private LinkedHashMap<String, ModTextureDefinitionImpl> txtDefsByModID = new LinkedHashMap();

    public static void init() {
        if (ModSupportAPI.api != null) {
            return;
        }
        ModSupportAPI.api = new ModSupportImpl();
        Log.info("Mod Support API available");
    }

    public static void complete(File datadir) {
        File[] files;
        File renderdata = new File(datadir, "renderdata");
        File dynamicrenderdata = new File(renderdata, "modsupport");
        dynamicrenderdata.mkdirs();
        for (File f : files = dynamicrenderdata.listFiles()) {
            if (!f.isFile()) continue;
            f.delete();
        }
        if (ModSupportAPI.api == null) {
            return;
        }
        ModSupportImpl api_impl = (ModSupportImpl)ModSupportAPI.api;
        for (ModTextureDefinitionImpl tdi : api_impl.txtDefsByModID.values()) {
            boolean good = false;
            if (tdi.isPublished()) {
                ModModelDefinitionImpl mdi;
                Log.info("Processing mod support from mod " + tdi.getModID() + " version " + tdi.getModVersion());
                try {
                    tdi.writeToFile(dynamicrenderdata);
                    good = true;
                }
                catch (IOException iox) {
                    Log.warning("Error creating texture definition for mod " + tdi.getModID() + " version " + tdi.getModVersion());
                }
                if ((mdi = (ModModelDefinitionImpl)tdi.getModelDefinition()) == null || !mdi.isPublished() || !good) continue;
                try {
                    mdi.writeToFile(dynamicrenderdata);
                }
                catch (IOException iox) {
                    Log.warning("Error creating model definition for mod " + mdi.getModID() + " version " + mdi.getModVersion());
                }
                continue;
            }
            Log.warning("Unpublished mod support from mod " + tdi.getModID() + " version " + tdi.getModVersion() + " skipped");
        }
        Log.info("Mod Support processing completed");
    }

    @Override
    public ModTextureDefinition getModTextureDefinition(String modid, String modver) {
        ModTextureDefinitionImpl mtd = this.txtDefsByModID.get(modid);
        if (mtd == null) {
            mtd = new ModTextureDefinitionImpl(modid, modver);
            this.txtDefsByModID.put(modid, mtd);
        }
        return mtd;
    }
}

